#[doc = "Register `CFG` reader"]
pub struct R(crate::R<CFG_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<CFG_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<CFG_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<CFG_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `CFG` writer"]
pub struct W(crate::W<CFG_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<CFG_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<CFG_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<CFG_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `SFT` reader - Signal Free Time"]
pub struct SFT_R(crate::FieldReader<u8, u8>);
impl SFT_R {
    pub(crate) fn new(bits: u8) -> Self {
        SFT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SFT_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SFT` writer - Signal Free Time"]
pub struct SFT_W<'a> {
    w: &'a mut W,
}
impl<'a> SFT_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x07) | (value as u32 & 0x07);
        self.w
    }
}
#[doc = "Field `RTOL` reader - Reception bit timing tolerance"]
pub struct RTOL_R(crate::FieldReader<bool, bool>);
impl RTOL_R {
    pub(crate) fn new(bits: bool) -> Self {
        RTOL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RTOL_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RTOL` writer - Reception bit timing tolerance"]
pub struct RTOL_W<'a> {
    w: &'a mut W,
}
impl<'a> RTOL_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u32 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `RBRESTP` reader - Whether stop receive message when detected RBRE"]
pub struct RBRESTP_R(crate::FieldReader<bool, bool>);
impl RBRESTP_R {
    pub(crate) fn new(bits: bool) -> Self {
        RBRESTP_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RBRESTP_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RBRESTP` writer - Whether stop receive message when detected RBRE"]
pub struct RBRESTP_W<'a> {
    w: &'a mut W,
}
impl<'a> RBRESTP_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u32 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `RBREGEN` reader - Generate Error-bit when detected RBRE in singlecast"]
pub struct RBREGEN_R(crate::FieldReader<bool, bool>);
impl RBREGEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        RBREGEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RBREGEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RBREGEN` writer - Generate Error-bit when detected RBRE in singlecast"]
pub struct RBREGEN_W<'a> {
    w: &'a mut W,
}
impl<'a> RBREGEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u32 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `RLBPEGEN` reader - Generate Error-bit when detected RLBPE in singlecast"]
pub struct RLBPEGEN_R(crate::FieldReader<bool, bool>);
impl RLBPEGEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        RLBPEGEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RLBPEGEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RLBPEGEN` writer - Generate Error-bit when detected RLBPE in singlecast"]
pub struct RLBPEGEN_W<'a> {
    w: &'a mut W,
}
impl<'a> RLBPEGEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u32 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `BCNG` reader - Do not generate Error-bit in broadcast message"]
pub struct BCNG_R(crate::FieldReader<bool, bool>);
impl BCNG_R {
    pub(crate) fn new(bits: bool) -> Self {
        BCNG_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for BCNG_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `BCNG` writer - Do not generate Error-bit in broadcast message"]
pub struct BCNG_W<'a> {
    w: &'a mut W,
}
impl<'a> BCNG_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u32 & 0x01) << 7);
        self.w
    }
}
#[doc = "Field `SFTOPT` reader - The SFT start option"]
pub struct SFTOPT_R(crate::FieldReader<bool, bool>);
impl SFTOPT_R {
    pub(crate) fn new(bits: bool) -> Self {
        SFTOPT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SFTOPT_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SFTOPT` writer - The SFT start option"]
pub struct SFTOPT_W<'a> {
    w: &'a mut W,
}
impl<'a> SFTOPT_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 8)) | ((value as u32 & 0x01) << 8);
        self.w
    }
}
#[doc = "Field `OADR` reader - Own Address"]
pub struct OADR_R(crate::FieldReader<u16, u16>);
impl OADR_R {
    pub(crate) fn new(bits: u16) -> Self {
        OADR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for OADR_R {
    type Target = crate::FieldReader<u16, u16>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OADR` writer - Own Address"]
pub struct OADR_W<'a> {
    w: &'a mut W,
}
impl<'a> OADR_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u16) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x7fff << 16)) | ((value as u32 & 0x7fff) << 16);
        self.w
    }
}
#[doc = "Field `LMEN` reader - Listen mode enable"]
pub struct LMEN_R(crate::FieldReader<bool, bool>);
impl LMEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        LMEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LMEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LMEN` writer - Listen mode enable"]
pub struct LMEN_W<'a> {
    w: &'a mut W,
}
impl<'a> LMEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 31)) | ((value as u32 & 0x01) << 31);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:2 - Signal Free Time"]
    #[inline(always)]
    pub fn sft(&self) -> SFT_R {
        SFT_R::new((self.bits & 0x07) as u8)
    }
    #[doc = "Bit 3 - Reception bit timing tolerance"]
    #[inline(always)]
    pub fn rtol(&self) -> RTOL_R {
        RTOL_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Whether stop receive message when detected RBRE"]
    #[inline(always)]
    pub fn rbrestp(&self) -> RBRESTP_R {
        RBRESTP_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Generate Error-bit when detected RBRE in singlecast"]
    #[inline(always)]
    pub fn rbregen(&self) -> RBREGEN_R {
        RBREGEN_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Generate Error-bit when detected RLBPE in singlecast"]
    #[inline(always)]
    pub fn rlbpegen(&self) -> RLBPEGEN_R {
        RLBPEGEN_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Do not generate Error-bit in broadcast message"]
    #[inline(always)]
    pub fn bcng(&self) -> BCNG_R {
        BCNG_R::new(((self.bits >> 7) & 0x01) != 0)
    }
    #[doc = "Bit 8 - The SFT start option"]
    #[inline(always)]
    pub fn sftopt(&self) -> SFTOPT_R {
        SFTOPT_R::new(((self.bits >> 8) & 0x01) != 0)
    }
    #[doc = "Bits 16:30 - Own Address"]
    #[inline(always)]
    pub fn oadr(&self) -> OADR_R {
        OADR_R::new(((self.bits >> 16) & 0x7fff) as u16)
    }
    #[doc = "Bit 31 - Listen mode enable"]
    #[inline(always)]
    pub fn lmen(&self) -> LMEN_R {
        LMEN_R::new(((self.bits >> 31) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:2 - Signal Free Time"]
    #[inline(always)]
    pub fn sft(&mut self) -> SFT_W {
        SFT_W { w: self }
    }
    #[doc = "Bit 3 - Reception bit timing tolerance"]
    #[inline(always)]
    pub fn rtol(&mut self) -> RTOL_W {
        RTOL_W { w: self }
    }
    #[doc = "Bit 4 - Whether stop receive message when detected RBRE"]
    #[inline(always)]
    pub fn rbrestp(&mut self) -> RBRESTP_W {
        RBRESTP_W { w: self }
    }
    #[doc = "Bit 5 - Generate Error-bit when detected RBRE in singlecast"]
    #[inline(always)]
    pub fn rbregen(&mut self) -> RBREGEN_W {
        RBREGEN_W { w: self }
    }
    #[doc = "Bit 6 - Generate Error-bit when detected RLBPE in singlecast"]
    #[inline(always)]
    pub fn rlbpegen(&mut self) -> RLBPEGEN_W {
        RLBPEGEN_W { w: self }
    }
    #[doc = "Bit 7 - Do not generate Error-bit in broadcast message"]
    #[inline(always)]
    pub fn bcng(&mut self) -> BCNG_W {
        BCNG_W { w: self }
    }
    #[doc = "Bit 8 - The SFT start option"]
    #[inline(always)]
    pub fn sftopt(&mut self) -> SFTOPT_W {
        SFTOPT_W { w: self }
    }
    #[doc = "Bits 16:30 - Own Address"]
    #[inline(always)]
    pub fn oadr(&mut self) -> OADR_W {
        OADR_W { w: self }
    }
    #[doc = "Bit 31 - Listen mode enable"]
    #[inline(always)]
    pub fn lmen(&mut self) -> LMEN_W {
        LMEN_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Configuration register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api)."]
pub struct CFG_SPEC;
impl crate::RegisterSpec for CFG_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [cfg::R](R) reader structure"]
impl crate::Readable for CFG_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [cfg::W](W) writer structure"]
impl crate::Writable for CFG_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets CFG to value 0"]
impl crate::Resettable for CFG_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
