#[doc = "Register `FW` reader"]
pub struct R(crate::R<FW_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<FW_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<FW_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<FW_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `FW` writer"]
pub struct W(crate::W<FW_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<FW_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<FW_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<FW_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Filter working\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum FW0_A {
    #[doc = "0: Filter working disabled"]
    DISABLED = 0,
    #[doc = "1: Filter working enabled"]
    ENABLED = 1,
}
impl From<FW0_A> for bool {
    #[inline(always)]
    fn from(variant: FW0_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `FW0` reader - Filter working"]
pub struct FW0_R(crate::FieldReader<bool, FW0_A>);
impl FW0_R {
    pub(crate) fn new(bits: bool) -> Self {
        FW0_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> FW0_A {
        match self.bits {
            false => FW0_A::DISABLED,
            true => FW0_A::ENABLED,
        }
    }
    #[doc = "Checks if the value of the field is `DISABLED`"]
    #[inline(always)]
    pub fn is_disabled(&self) -> bool {
        **self == FW0_A::DISABLED
    }
    #[doc = "Checks if the value of the field is `ENABLED`"]
    #[inline(always)]
    pub fn is_enabled(&self) -> bool {
        **self == FW0_A::ENABLED
    }
}
impl core::ops::Deref for FW0_R {
    type Target = crate::FieldReader<bool, FW0_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FW0` writer - Filter working"]
pub struct FW0_W<'a> {
    w: &'a mut W,
}
impl<'a> FW0_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FW0_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter working disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(FW0_A::DISABLED)
    }
    #[doc = "Filter working enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(FW0_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
#[doc = "Filter working"]
pub type FW1_A = FW0_A;
#[doc = "Field `FW1` reader - Filter working"]
pub type FW1_R = FW0_R;
#[doc = "Field `FW1` writer - Filter working"]
pub struct FW1_W<'a> {
    w: &'a mut W,
}
impl<'a> FW1_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FW1_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter working disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(FW1_A::DISABLED)
    }
    #[doc = "Filter working enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(FW1_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "Filter working"]
pub type FW2_A = FW0_A;
#[doc = "Field `FW2` reader - Filter working"]
pub type FW2_R = FW0_R;
#[doc = "Field `FW2` writer - Filter working"]
pub struct FW2_W<'a> {
    w: &'a mut W,
}
impl<'a> FW2_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FW2_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter working disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(FW2_A::DISABLED)
    }
    #[doc = "Filter working enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(FW2_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u32 & 0x01) << 2);
        self.w
    }
}
#[doc = "Filter working"]
pub type FW3_A = FW0_A;
#[doc = "Field `FW3` reader - Filter working"]
pub type FW3_R = FW0_R;
#[doc = "Field `FW3` writer - Filter working"]
pub struct FW3_W<'a> {
    w: &'a mut W,
}
impl<'a> FW3_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FW3_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter working disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(FW3_A::DISABLED)
    }
    #[doc = "Filter working enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(FW3_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u32 & 0x01) << 3);
        self.w
    }
}
#[doc = "Filter working"]
pub type FW4_A = FW0_A;
#[doc = "Field `FW4` reader - Filter working"]
pub type FW4_R = FW0_R;
#[doc = "Field `FW4` writer - Filter working"]
pub struct FW4_W<'a> {
    w: &'a mut W,
}
impl<'a> FW4_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FW4_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter working disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(FW4_A::DISABLED)
    }
    #[doc = "Filter working enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(FW4_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u32 & 0x01) << 4);
        self.w
    }
}
#[doc = "Filter working"]
pub type FW5_A = FW0_A;
#[doc = "Field `FW5` reader - Filter working"]
pub type FW5_R = FW0_R;
#[doc = "Field `FW5` writer - Filter working"]
pub struct FW5_W<'a> {
    w: &'a mut W,
}
impl<'a> FW5_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FW5_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter working disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(FW5_A::DISABLED)
    }
    #[doc = "Filter working enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(FW5_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u32 & 0x01) << 5);
        self.w
    }
}
#[doc = "Filter working"]
pub type FW6_A = FW0_A;
#[doc = "Field `FW6` reader - Filter working"]
pub type FW6_R = FW0_R;
#[doc = "Field `FW6` writer - Filter working"]
pub struct FW6_W<'a> {
    w: &'a mut W,
}
impl<'a> FW6_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FW6_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter working disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(FW6_A::DISABLED)
    }
    #[doc = "Filter working enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(FW6_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u32 & 0x01) << 6);
        self.w
    }
}
#[doc = "Filter working"]
pub type FW7_A = FW0_A;
#[doc = "Field `FW7` reader - Filter working"]
pub type FW7_R = FW0_R;
#[doc = "Field `FW7` writer - Filter working"]
pub struct FW7_W<'a> {
    w: &'a mut W,
}
impl<'a> FW7_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FW7_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter working disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(FW7_A::DISABLED)
    }
    #[doc = "Filter working enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(FW7_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u32 & 0x01) << 7);
        self.w
    }
}
#[doc = "Filter working"]
pub type FW8_A = FW0_A;
#[doc = "Field `FW8` reader - Filter working"]
pub type FW8_R = FW0_R;
#[doc = "Field `FW8` writer - Filter working"]
pub struct FW8_W<'a> {
    w: &'a mut W,
}
impl<'a> FW8_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FW8_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter working disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(FW8_A::DISABLED)
    }
    #[doc = "Filter working enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(FW8_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 8)) | ((value as u32 & 0x01) << 8);
        self.w
    }
}
#[doc = "Filter working"]
pub type FW9_A = FW0_A;
#[doc = "Field `FW9` reader - Filter working"]
pub type FW9_R = FW0_R;
#[doc = "Field `FW9` writer - Filter working"]
pub struct FW9_W<'a> {
    w: &'a mut W,
}
impl<'a> FW9_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FW9_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter working disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(FW9_A::DISABLED)
    }
    #[doc = "Filter working enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(FW9_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 9)) | ((value as u32 & 0x01) << 9);
        self.w
    }
}
#[doc = "Filter working"]
pub type FW10_A = FW0_A;
#[doc = "Field `FW10` reader - Filter working"]
pub type FW10_R = FW0_R;
#[doc = "Field `FW10` writer - Filter working"]
pub struct FW10_W<'a> {
    w: &'a mut W,
}
impl<'a> FW10_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FW10_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter working disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(FW10_A::DISABLED)
    }
    #[doc = "Filter working enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(FW10_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 10)) | ((value as u32 & 0x01) << 10);
        self.w
    }
}
#[doc = "Filter working"]
pub type FW11_A = FW0_A;
#[doc = "Field `FW11` reader - Filter working"]
pub type FW11_R = FW0_R;
#[doc = "Field `FW11` writer - Filter working"]
pub struct FW11_W<'a> {
    w: &'a mut W,
}
impl<'a> FW11_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FW11_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter working disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(FW11_A::DISABLED)
    }
    #[doc = "Filter working enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(FW11_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 11)) | ((value as u32 & 0x01) << 11);
        self.w
    }
}
#[doc = "Filter working"]
pub type FW12_A = FW0_A;
#[doc = "Field `FW12` reader - Filter working"]
pub type FW12_R = FW0_R;
#[doc = "Field `FW12` writer - Filter working"]
pub struct FW12_W<'a> {
    w: &'a mut W,
}
impl<'a> FW12_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FW12_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter working disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(FW12_A::DISABLED)
    }
    #[doc = "Filter working enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(FW12_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 12)) | ((value as u32 & 0x01) << 12);
        self.w
    }
}
#[doc = "Filter working"]
pub type FW13_A = FW0_A;
#[doc = "Field `FW13` reader - Filter working"]
pub type FW13_R = FW0_R;
#[doc = "Field `FW13` writer - Filter working"]
pub struct FW13_W<'a> {
    w: &'a mut W,
}
impl<'a> FW13_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FW13_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter working disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(FW13_A::DISABLED)
    }
    #[doc = "Filter working enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(FW13_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 13)) | ((value as u32 & 0x01) << 13);
        self.w
    }
}
#[doc = "Filter working"]
pub type FW14_A = FW0_A;
#[doc = "Field `FW14` reader - Filter working"]
pub type FW14_R = FW0_R;
#[doc = "Field `FW14` writer - Filter working"]
pub struct FW14_W<'a> {
    w: &'a mut W,
}
impl<'a> FW14_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FW14_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter working disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(FW14_A::DISABLED)
    }
    #[doc = "Filter working enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(FW14_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 14)) | ((value as u32 & 0x01) << 14);
        self.w
    }
}
#[doc = "Filter working"]
pub type FW15_A = FW0_A;
#[doc = "Field `FW15` reader - Filter working"]
pub type FW15_R = FW0_R;
#[doc = "Field `FW15` writer - Filter working"]
pub struct FW15_W<'a> {
    w: &'a mut W,
}
impl<'a> FW15_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FW15_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter working disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(FW15_A::DISABLED)
    }
    #[doc = "Filter working enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(FW15_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 15)) | ((value as u32 & 0x01) << 15);
        self.w
    }
}
#[doc = "Filter working"]
pub type FW16_A = FW0_A;
#[doc = "Field `FW16` reader - Filter working"]
pub type FW16_R = FW0_R;
#[doc = "Field `FW16` writer - Filter working"]
pub struct FW16_W<'a> {
    w: &'a mut W,
}
impl<'a> FW16_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FW16_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter working disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(FW16_A::DISABLED)
    }
    #[doc = "Filter working enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(FW16_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 16)) | ((value as u32 & 0x01) << 16);
        self.w
    }
}
#[doc = "Filter working"]
pub type FW17_A = FW0_A;
#[doc = "Field `FW17` reader - Filter working"]
pub type FW17_R = FW0_R;
#[doc = "Field `FW17` writer - Filter working"]
pub struct FW17_W<'a> {
    w: &'a mut W,
}
impl<'a> FW17_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FW17_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter working disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(FW17_A::DISABLED)
    }
    #[doc = "Filter working enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(FW17_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 17)) | ((value as u32 & 0x01) << 17);
        self.w
    }
}
#[doc = "Filter working"]
pub type FW18_A = FW0_A;
#[doc = "Field `FW18` reader - Filter working"]
pub type FW18_R = FW0_R;
#[doc = "Field `FW18` writer - Filter working"]
pub struct FW18_W<'a> {
    w: &'a mut W,
}
impl<'a> FW18_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FW18_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter working disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(FW18_A::DISABLED)
    }
    #[doc = "Filter working enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(FW18_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 18)) | ((value as u32 & 0x01) << 18);
        self.w
    }
}
#[doc = "Filter working"]
pub type FW19_A = FW0_A;
#[doc = "Field `FW19` reader - Filter working"]
pub type FW19_R = FW0_R;
#[doc = "Field `FW19` writer - Filter working"]
pub struct FW19_W<'a> {
    w: &'a mut W,
}
impl<'a> FW19_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FW19_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter working disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(FW19_A::DISABLED)
    }
    #[doc = "Filter working enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(FW19_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 19)) | ((value as u32 & 0x01) << 19);
        self.w
    }
}
#[doc = "Filter working"]
pub type FW20_A = FW0_A;
#[doc = "Field `FW20` reader - Filter working"]
pub type FW20_R = FW0_R;
#[doc = "Field `FW20` writer - Filter working"]
pub struct FW20_W<'a> {
    w: &'a mut W,
}
impl<'a> FW20_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FW20_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter working disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(FW20_A::DISABLED)
    }
    #[doc = "Filter working enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(FW20_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 20)) | ((value as u32 & 0x01) << 20);
        self.w
    }
}
#[doc = "Filter working"]
pub type FW21_A = FW0_A;
#[doc = "Field `FW21` reader - Filter working"]
pub type FW21_R = FW0_R;
#[doc = "Field `FW21` writer - Filter working"]
pub struct FW21_W<'a> {
    w: &'a mut W,
}
impl<'a> FW21_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FW21_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter working disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(FW21_A::DISABLED)
    }
    #[doc = "Filter working enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(FW21_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 21)) | ((value as u32 & 0x01) << 21);
        self.w
    }
}
#[doc = "Filter working"]
pub type FW22_A = FW0_A;
#[doc = "Field `FW22` reader - Filter working"]
pub type FW22_R = FW0_R;
#[doc = "Field `FW22` writer - Filter working"]
pub struct FW22_W<'a> {
    w: &'a mut W,
}
impl<'a> FW22_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FW22_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter working disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(FW22_A::DISABLED)
    }
    #[doc = "Filter working enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(FW22_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 22)) | ((value as u32 & 0x01) << 22);
        self.w
    }
}
#[doc = "Filter working"]
pub type FW23_A = FW0_A;
#[doc = "Field `FW23` reader - Filter working"]
pub type FW23_R = FW0_R;
#[doc = "Field `FW23` writer - Filter working"]
pub struct FW23_W<'a> {
    w: &'a mut W,
}
impl<'a> FW23_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FW23_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter working disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(FW23_A::DISABLED)
    }
    #[doc = "Filter working enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(FW23_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 23)) | ((value as u32 & 0x01) << 23);
        self.w
    }
}
#[doc = "Filter working"]
pub type FW24_A = FW0_A;
#[doc = "Field `FW24` reader - Filter working"]
pub type FW24_R = FW0_R;
#[doc = "Field `FW24` writer - Filter working"]
pub struct FW24_W<'a> {
    w: &'a mut W,
}
impl<'a> FW24_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FW24_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter working disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(FW24_A::DISABLED)
    }
    #[doc = "Filter working enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(FW24_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 24)) | ((value as u32 & 0x01) << 24);
        self.w
    }
}
#[doc = "Filter working"]
pub type FW25_A = FW0_A;
#[doc = "Field `FW25` reader - Filter working"]
pub type FW25_R = FW0_R;
#[doc = "Field `FW25` writer - Filter working"]
pub struct FW25_W<'a> {
    w: &'a mut W,
}
impl<'a> FW25_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FW25_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter working disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(FW25_A::DISABLED)
    }
    #[doc = "Filter working enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(FW25_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 25)) | ((value as u32 & 0x01) << 25);
        self.w
    }
}
#[doc = "Filter working"]
pub type FW26_A = FW0_A;
#[doc = "Field `FW26` reader - Filter working"]
pub type FW26_R = FW0_R;
#[doc = "Field `FW26` writer - Filter working"]
pub struct FW26_W<'a> {
    w: &'a mut W,
}
impl<'a> FW26_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FW26_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter working disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(FW26_A::DISABLED)
    }
    #[doc = "Filter working enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(FW26_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 26)) | ((value as u32 & 0x01) << 26);
        self.w
    }
}
#[doc = "Filter working"]
pub type FW27_A = FW0_A;
#[doc = "Field `FW27` reader - Filter working"]
pub type FW27_R = FW0_R;
#[doc = "Field `FW27` writer - Filter working"]
pub struct FW27_W<'a> {
    w: &'a mut W,
}
impl<'a> FW27_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FW27_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter working disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(FW27_A::DISABLED)
    }
    #[doc = "Filter working enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(FW27_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 27)) | ((value as u32 & 0x01) << 27);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Filter working"]
    #[inline(always)]
    pub fn fw0(&self) -> FW0_R {
        FW0_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Filter working"]
    #[inline(always)]
    pub fn fw1(&self) -> FW1_R {
        FW1_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Filter working"]
    #[inline(always)]
    pub fn fw2(&self) -> FW2_R {
        FW2_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Filter working"]
    #[inline(always)]
    pub fn fw3(&self) -> FW3_R {
        FW3_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Filter working"]
    #[inline(always)]
    pub fn fw4(&self) -> FW4_R {
        FW4_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Filter working"]
    #[inline(always)]
    pub fn fw5(&self) -> FW5_R {
        FW5_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Filter working"]
    #[inline(always)]
    pub fn fw6(&self) -> FW6_R {
        FW6_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Filter working"]
    #[inline(always)]
    pub fn fw7(&self) -> FW7_R {
        FW7_R::new(((self.bits >> 7) & 0x01) != 0)
    }
    #[doc = "Bit 8 - Filter working"]
    #[inline(always)]
    pub fn fw8(&self) -> FW8_R {
        FW8_R::new(((self.bits >> 8) & 0x01) != 0)
    }
    #[doc = "Bit 9 - Filter working"]
    #[inline(always)]
    pub fn fw9(&self) -> FW9_R {
        FW9_R::new(((self.bits >> 9) & 0x01) != 0)
    }
    #[doc = "Bit 10 - Filter working"]
    #[inline(always)]
    pub fn fw10(&self) -> FW10_R {
        FW10_R::new(((self.bits >> 10) & 0x01) != 0)
    }
    #[doc = "Bit 11 - Filter working"]
    #[inline(always)]
    pub fn fw11(&self) -> FW11_R {
        FW11_R::new(((self.bits >> 11) & 0x01) != 0)
    }
    #[doc = "Bit 12 - Filter working"]
    #[inline(always)]
    pub fn fw12(&self) -> FW12_R {
        FW12_R::new(((self.bits >> 12) & 0x01) != 0)
    }
    #[doc = "Bit 13 - Filter working"]
    #[inline(always)]
    pub fn fw13(&self) -> FW13_R {
        FW13_R::new(((self.bits >> 13) & 0x01) != 0)
    }
    #[doc = "Bit 14 - Filter working"]
    #[inline(always)]
    pub fn fw14(&self) -> FW14_R {
        FW14_R::new(((self.bits >> 14) & 0x01) != 0)
    }
    #[doc = "Bit 15 - Filter working"]
    #[inline(always)]
    pub fn fw15(&self) -> FW15_R {
        FW15_R::new(((self.bits >> 15) & 0x01) != 0)
    }
    #[doc = "Bit 16 - Filter working"]
    #[inline(always)]
    pub fn fw16(&self) -> FW16_R {
        FW16_R::new(((self.bits >> 16) & 0x01) != 0)
    }
    #[doc = "Bit 17 - Filter working"]
    #[inline(always)]
    pub fn fw17(&self) -> FW17_R {
        FW17_R::new(((self.bits >> 17) & 0x01) != 0)
    }
    #[doc = "Bit 18 - Filter working"]
    #[inline(always)]
    pub fn fw18(&self) -> FW18_R {
        FW18_R::new(((self.bits >> 18) & 0x01) != 0)
    }
    #[doc = "Bit 19 - Filter working"]
    #[inline(always)]
    pub fn fw19(&self) -> FW19_R {
        FW19_R::new(((self.bits >> 19) & 0x01) != 0)
    }
    #[doc = "Bit 20 - Filter working"]
    #[inline(always)]
    pub fn fw20(&self) -> FW20_R {
        FW20_R::new(((self.bits >> 20) & 0x01) != 0)
    }
    #[doc = "Bit 21 - Filter working"]
    #[inline(always)]
    pub fn fw21(&self) -> FW21_R {
        FW21_R::new(((self.bits >> 21) & 0x01) != 0)
    }
    #[doc = "Bit 22 - Filter working"]
    #[inline(always)]
    pub fn fw22(&self) -> FW22_R {
        FW22_R::new(((self.bits >> 22) & 0x01) != 0)
    }
    #[doc = "Bit 23 - Filter working"]
    #[inline(always)]
    pub fn fw23(&self) -> FW23_R {
        FW23_R::new(((self.bits >> 23) & 0x01) != 0)
    }
    #[doc = "Bit 24 - Filter working"]
    #[inline(always)]
    pub fn fw24(&self) -> FW24_R {
        FW24_R::new(((self.bits >> 24) & 0x01) != 0)
    }
    #[doc = "Bit 25 - Filter working"]
    #[inline(always)]
    pub fn fw25(&self) -> FW25_R {
        FW25_R::new(((self.bits >> 25) & 0x01) != 0)
    }
    #[doc = "Bit 26 - Filter working"]
    #[inline(always)]
    pub fn fw26(&self) -> FW26_R {
        FW26_R::new(((self.bits >> 26) & 0x01) != 0)
    }
    #[doc = "Bit 27 - Filter working"]
    #[inline(always)]
    pub fn fw27(&self) -> FW27_R {
        FW27_R::new(((self.bits >> 27) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Filter working"]
    #[inline(always)]
    pub fn fw0(&mut self) -> FW0_W {
        FW0_W { w: self }
    }
    #[doc = "Bit 1 - Filter working"]
    #[inline(always)]
    pub fn fw1(&mut self) -> FW1_W {
        FW1_W { w: self }
    }
    #[doc = "Bit 2 - Filter working"]
    #[inline(always)]
    pub fn fw2(&mut self) -> FW2_W {
        FW2_W { w: self }
    }
    #[doc = "Bit 3 - Filter working"]
    #[inline(always)]
    pub fn fw3(&mut self) -> FW3_W {
        FW3_W { w: self }
    }
    #[doc = "Bit 4 - Filter working"]
    #[inline(always)]
    pub fn fw4(&mut self) -> FW4_W {
        FW4_W { w: self }
    }
    #[doc = "Bit 5 - Filter working"]
    #[inline(always)]
    pub fn fw5(&mut self) -> FW5_W {
        FW5_W { w: self }
    }
    #[doc = "Bit 6 - Filter working"]
    #[inline(always)]
    pub fn fw6(&mut self) -> FW6_W {
        FW6_W { w: self }
    }
    #[doc = "Bit 7 - Filter working"]
    #[inline(always)]
    pub fn fw7(&mut self) -> FW7_W {
        FW7_W { w: self }
    }
    #[doc = "Bit 8 - Filter working"]
    #[inline(always)]
    pub fn fw8(&mut self) -> FW8_W {
        FW8_W { w: self }
    }
    #[doc = "Bit 9 - Filter working"]
    #[inline(always)]
    pub fn fw9(&mut self) -> FW9_W {
        FW9_W { w: self }
    }
    #[doc = "Bit 10 - Filter working"]
    #[inline(always)]
    pub fn fw10(&mut self) -> FW10_W {
        FW10_W { w: self }
    }
    #[doc = "Bit 11 - Filter working"]
    #[inline(always)]
    pub fn fw11(&mut self) -> FW11_W {
        FW11_W { w: self }
    }
    #[doc = "Bit 12 - Filter working"]
    #[inline(always)]
    pub fn fw12(&mut self) -> FW12_W {
        FW12_W { w: self }
    }
    #[doc = "Bit 13 - Filter working"]
    #[inline(always)]
    pub fn fw13(&mut self) -> FW13_W {
        FW13_W { w: self }
    }
    #[doc = "Bit 14 - Filter working"]
    #[inline(always)]
    pub fn fw14(&mut self) -> FW14_W {
        FW14_W { w: self }
    }
    #[doc = "Bit 15 - Filter working"]
    #[inline(always)]
    pub fn fw15(&mut self) -> FW15_W {
        FW15_W { w: self }
    }
    #[doc = "Bit 16 - Filter working"]
    #[inline(always)]
    pub fn fw16(&mut self) -> FW16_W {
        FW16_W { w: self }
    }
    #[doc = "Bit 17 - Filter working"]
    #[inline(always)]
    pub fn fw17(&mut self) -> FW17_W {
        FW17_W { w: self }
    }
    #[doc = "Bit 18 - Filter working"]
    #[inline(always)]
    pub fn fw18(&mut self) -> FW18_W {
        FW18_W { w: self }
    }
    #[doc = "Bit 19 - Filter working"]
    #[inline(always)]
    pub fn fw19(&mut self) -> FW19_W {
        FW19_W { w: self }
    }
    #[doc = "Bit 20 - Filter working"]
    #[inline(always)]
    pub fn fw20(&mut self) -> FW20_W {
        FW20_W { w: self }
    }
    #[doc = "Bit 21 - Filter working"]
    #[inline(always)]
    pub fn fw21(&mut self) -> FW21_W {
        FW21_W { w: self }
    }
    #[doc = "Bit 22 - Filter working"]
    #[inline(always)]
    pub fn fw22(&mut self) -> FW22_W {
        FW22_W { w: self }
    }
    #[doc = "Bit 23 - Filter working"]
    #[inline(always)]
    pub fn fw23(&mut self) -> FW23_W {
        FW23_W { w: self }
    }
    #[doc = "Bit 24 - Filter working"]
    #[inline(always)]
    pub fn fw24(&mut self) -> FW24_W {
        FW24_W { w: self }
    }
    #[doc = "Bit 25 - Filter working"]
    #[inline(always)]
    pub fn fw25(&mut self) -> FW25_W {
        FW25_W { w: self }
    }
    #[doc = "Bit 26 - Filter working"]
    #[inline(always)]
    pub fn fw26(&mut self) -> FW26_W {
        FW26_W { w: self }
    }
    #[doc = "Bit 27 - Filter working"]
    #[inline(always)]
    pub fn fw27(&mut self) -> FW27_W {
        FW27_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Filter working register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [fw](index.html) module"]
pub struct FW_SPEC;
impl crate::RegisterSpec for FW_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [fw::R](R) reader structure"]
impl crate::Readable for FW_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [fw::W](W) writer structure"]
impl crate::Writable for FW_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets FW to value 0"]
impl crate::Resettable for FW_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
