#[doc = "Register `EP4CS` reader"]
pub struct R(crate::R<EP4CS_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<EP4CS_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<EP4CS_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<EP4CS_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `EP4CS` writer"]
pub struct W(crate::W<EP4CS_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<EP4CS_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<EP4CS_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<EP4CS_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `EP_AR` reader - Endpoint address"]
pub struct EP_AR_R(crate::FieldReader<u8, u8>);
impl EP_AR_R {
    pub(crate) fn new(bits: u8) -> Self {
        EP_AR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EP_AR_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EP_AR` writer - Endpoint address"]
pub struct EP_AR_W<'a> {
    w: &'a mut W,
}
impl<'a> EP_AR_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x0f) | (value as u16 & 0x0f);
        self.w
    }
}
#[doc = "Field `TX_STA` reader - Status bits, for transmission transfers"]
pub struct TX_STA_R(crate::FieldReader<u8, u8>);
impl TX_STA_R {
    pub(crate) fn new(bits: u8) -> Self {
        TX_STA_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TX_STA_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TX_STA` writer - Status bits, for transmission transfers"]
pub struct TX_STA_W<'a> {
    w: &'a mut W,
}
impl<'a> TX_STA_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 4)) | ((value as u16 & 0x03) << 4);
        self.w
    }
}
#[doc = "Field `TX_DTG` reader - Transmission Data PID Toggle"]
pub struct TX_DTG_R(crate::FieldReader<bool, bool>);
impl TX_DTG_R {
    pub(crate) fn new(bits: bool) -> Self {
        TX_DTG_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TX_DTG_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TX_DTG` writer - Transmission Data PID Toggle"]
pub struct TX_DTG_W<'a> {
    w: &'a mut W,
}
impl<'a> TX_DTG_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u16 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `TX_ST` reader - Transmission Successful Transfer"]
pub struct TX_ST_R(crate::FieldReader<bool, bool>);
impl TX_ST_R {
    pub(crate) fn new(bits: bool) -> Self {
        TX_ST_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TX_ST_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TX_ST` writer - Transmission Successful Transfer"]
pub struct TX_ST_W<'a> {
    w: &'a mut W,
}
impl<'a> TX_ST_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u16 & 0x01) << 7);
        self.w
    }
}
#[doc = "Field `EP_KCTL` reader - Endpoint kind control"]
pub struct EP_KCTL_R(crate::FieldReader<bool, bool>);
impl EP_KCTL_R {
    pub(crate) fn new(bits: bool) -> Self {
        EP_KCTL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EP_KCTL_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EP_KCTL` writer - Endpoint kind control"]
pub struct EP_KCTL_W<'a> {
    w: &'a mut W,
}
impl<'a> EP_KCTL_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 8)) | ((value as u16 & 0x01) << 8);
        self.w
    }
}
#[doc = "Field `EP_CTL` reader - Endpoint type control"]
pub struct EP_CTL_R(crate::FieldReader<u8, u8>);
impl EP_CTL_R {
    pub(crate) fn new(bits: u8) -> Self {
        EP_CTL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EP_CTL_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EP_CTL` writer - Endpoint type control"]
pub struct EP_CTL_W<'a> {
    w: &'a mut W,
}
impl<'a> EP_CTL_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 9)) | ((value as u16 & 0x03) << 9);
        self.w
    }
}
#[doc = "Field `SETUP` reader - Setup transaction completed"]
pub struct SETUP_R(crate::FieldReader<bool, bool>);
impl SETUP_R {
    pub(crate) fn new(bits: bool) -> Self {
        SETUP_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SETUP_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SETUP` writer - Setup transaction completed"]
pub struct SETUP_W<'a> {
    w: &'a mut W,
}
impl<'a> SETUP_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 11)) | ((value as u16 & 0x01) << 11);
        self.w
    }
}
#[doc = "Field `RX_STA` reader - Reception status bits"]
pub struct RX_STA_R(crate::FieldReader<u8, u8>);
impl RX_STA_R {
    pub(crate) fn new(bits: u8) -> Self {
        RX_STA_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RX_STA_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RX_STA` writer - Reception status bits"]
pub struct RX_STA_W<'a> {
    w: &'a mut W,
}
impl<'a> RX_STA_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 12)) | ((value as u16 & 0x03) << 12);
        self.w
    }
}
#[doc = "Field `RX_DTG` reader - Reception Data PID Toggle"]
pub struct RX_DTG_R(crate::FieldReader<bool, bool>);
impl RX_DTG_R {
    pub(crate) fn new(bits: bool) -> Self {
        RX_DTG_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RX_DTG_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RX_DTG` writer - Reception Data PID Toggle"]
pub struct RX_DTG_W<'a> {
    w: &'a mut W,
}
impl<'a> RX_DTG_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 14)) | ((value as u16 & 0x01) << 14);
        self.w
    }
}
#[doc = "Field `RX_ST` reader - Reception Successful Transferred"]
pub struct RX_ST_R(crate::FieldReader<bool, bool>);
impl RX_ST_R {
    pub(crate) fn new(bits: bool) -> Self {
        RX_ST_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RX_ST_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RX_ST` writer - Reception Successful Transferred"]
pub struct RX_ST_W<'a> {
    w: &'a mut W,
}
impl<'a> RX_ST_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 15)) | ((value as u16 & 0x01) << 15);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:3 - Endpoint address"]
    #[inline(always)]
    pub fn ep_ar(&self) -> EP_AR_R {
        EP_AR_R::new((self.bits & 0x0f) as u8)
    }
    #[doc = "Bits 4:5 - Status bits, for transmission transfers"]
    #[inline(always)]
    pub fn tx_sta(&self) -> TX_STA_R {
        TX_STA_R::new(((self.bits >> 4) & 0x03) as u8)
    }
    #[doc = "Bit 6 - Transmission Data PID Toggle"]
    #[inline(always)]
    pub fn tx_dtg(&self) -> TX_DTG_R {
        TX_DTG_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Transmission Successful Transfer"]
    #[inline(always)]
    pub fn tx_st(&self) -> TX_ST_R {
        TX_ST_R::new(((self.bits >> 7) & 0x01) != 0)
    }
    #[doc = "Bit 8 - Endpoint kind control"]
    #[inline(always)]
    pub fn ep_kctl(&self) -> EP_KCTL_R {
        EP_KCTL_R::new(((self.bits >> 8) & 0x01) != 0)
    }
    #[doc = "Bits 9:10 - Endpoint type control"]
    #[inline(always)]
    pub fn ep_ctl(&self) -> EP_CTL_R {
        EP_CTL_R::new(((self.bits >> 9) & 0x03) as u8)
    }
    #[doc = "Bit 11 - Setup transaction completed"]
    #[inline(always)]
    pub fn setup(&self) -> SETUP_R {
        SETUP_R::new(((self.bits >> 11) & 0x01) != 0)
    }
    #[doc = "Bits 12:13 - Reception status bits"]
    #[inline(always)]
    pub fn rx_sta(&self) -> RX_STA_R {
        RX_STA_R::new(((self.bits >> 12) & 0x03) as u8)
    }
    #[doc = "Bit 14 - Reception Data PID Toggle"]
    #[inline(always)]
    pub fn rx_dtg(&self) -> RX_DTG_R {
        RX_DTG_R::new(((self.bits >> 14) & 0x01) != 0)
    }
    #[doc = "Bit 15 - Reception Successful Transferred"]
    #[inline(always)]
    pub fn rx_st(&self) -> RX_ST_R {
        RX_ST_R::new(((self.bits >> 15) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:3 - Endpoint address"]
    #[inline(always)]
    pub fn ep_ar(&mut self) -> EP_AR_W {
        EP_AR_W { w: self }
    }
    #[doc = "Bits 4:5 - Status bits, for transmission transfers"]
    #[inline(always)]
    pub fn tx_sta(&mut self) -> TX_STA_W {
        TX_STA_W { w: self }
    }
    #[doc = "Bit 6 - Transmission Data PID Toggle"]
    #[inline(always)]
    pub fn tx_dtg(&mut self) -> TX_DTG_W {
        TX_DTG_W { w: self }
    }
    #[doc = "Bit 7 - Transmission Successful Transfer"]
    #[inline(always)]
    pub fn tx_st(&mut self) -> TX_ST_W {
        TX_ST_W { w: self }
    }
    #[doc = "Bit 8 - Endpoint kind control"]
    #[inline(always)]
    pub fn ep_kctl(&mut self) -> EP_KCTL_W {
        EP_KCTL_W { w: self }
    }
    #[doc = "Bits 9:10 - Endpoint type control"]
    #[inline(always)]
    pub fn ep_ctl(&mut self) -> EP_CTL_W {
        EP_CTL_W { w: self }
    }
    #[doc = "Bit 11 - Setup transaction completed"]
    #[inline(always)]
    pub fn setup(&mut self) -> SETUP_W {
        SETUP_W { w: self }
    }
    #[doc = "Bits 12:13 - Reception status bits"]
    #[inline(always)]
    pub fn rx_sta(&mut self) -> RX_STA_W {
        RX_STA_W { w: self }
    }
    #[doc = "Bit 14 - Reception Data PID Toggle"]
    #[inline(always)]
    pub fn rx_dtg(&mut self) -> RX_DTG_W {
        RX_DTG_W { w: self }
    }
    #[doc = "Bit 15 - Reception Successful Transferred"]
    #[inline(always)]
    pub fn rx_st(&mut self) -> RX_ST_W {
        RX_ST_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u16) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "endpoint 4 register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ep4cs](index.html) module"]
pub struct EP4CS_SPEC;
impl crate::RegisterSpec for EP4CS_SPEC {
    type Ux = u16;
}
#[doc = "`read()` method returns [ep4cs::R](R) reader structure"]
impl crate::Readable for EP4CS_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [ep4cs::W](W) writer structure"]
impl crate::Writable for EP4CS_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets EP4CS to value 0"]
impl crate::Resettable for EP4CS_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
