#[doc = "Register `PUD` reader"]
pub struct R(crate::R<PUD_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<PUD_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<PUD_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<PUD_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `PUD` writer"]
pub struct W(crate::W<PUD_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<PUD_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<PUD_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<PUD_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Pin 15 pull-up or pull-down bits"]
pub type PUD15_A = PUD0_A;
#[doc = "Field `PUD15` reader - Pin 15 pull-up or pull-down bits"]
pub type PUD15_R = PUD0_R;
#[doc = "Field `PUD15` writer - Pin 15 pull-up or pull-down bits"]
pub struct PUD15_W<'a> {
    w: &'a mut W,
}
impl<'a> PUD15_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: PUD15_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "No pull-up, pull-down (reset state)"]
    #[inline(always)]
    pub fn floating(self) -> &'a mut W {
        self.variant(PUD15_A::FLOATING)
    }
    #[doc = "Pull-up"]
    #[inline(always)]
    pub fn pull_up(self) -> &'a mut W {
        self.variant(PUD15_A::PULLUP)
    }
    #[doc = "Pull-down"]
    #[inline(always)]
    pub fn pull_down(self) -> &'a mut W {
        self.variant(PUD15_A::PULLDOWN)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 30)) | ((value as u32 & 0x03) << 30);
        self.w
    }
}
#[doc = "Pin 14 pull-up or pull-down bits"]
pub type PUD14_A = PUD0_A;
#[doc = "Field `PUD14` reader - Pin 14 pull-up or pull-down bits"]
pub type PUD14_R = PUD0_R;
#[doc = "Field `PUD14` writer - Pin 14 pull-up or pull-down bits"]
pub struct PUD14_W<'a> {
    w: &'a mut W,
}
impl<'a> PUD14_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: PUD14_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "No pull-up, pull-down (reset state)"]
    #[inline(always)]
    pub fn floating(self) -> &'a mut W {
        self.variant(PUD14_A::FLOATING)
    }
    #[doc = "Pull-up"]
    #[inline(always)]
    pub fn pull_up(self) -> &'a mut W {
        self.variant(PUD14_A::PULLUP)
    }
    #[doc = "Pull-down"]
    #[inline(always)]
    pub fn pull_down(self) -> &'a mut W {
        self.variant(PUD14_A::PULLDOWN)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 28)) | ((value as u32 & 0x03) << 28);
        self.w
    }
}
#[doc = "Pin 13 pull-up or pull-down bits"]
pub type PUD13_A = PUD0_A;
#[doc = "Field `PUD13` reader - Pin 13 pull-up or pull-down bits"]
pub type PUD13_R = PUD0_R;
#[doc = "Field `PUD13` writer - Pin 13 pull-up or pull-down bits"]
pub struct PUD13_W<'a> {
    w: &'a mut W,
}
impl<'a> PUD13_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: PUD13_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "No pull-up, pull-down (reset state)"]
    #[inline(always)]
    pub fn floating(self) -> &'a mut W {
        self.variant(PUD13_A::FLOATING)
    }
    #[doc = "Pull-up"]
    #[inline(always)]
    pub fn pull_up(self) -> &'a mut W {
        self.variant(PUD13_A::PULLUP)
    }
    #[doc = "Pull-down"]
    #[inline(always)]
    pub fn pull_down(self) -> &'a mut W {
        self.variant(PUD13_A::PULLDOWN)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 26)) | ((value as u32 & 0x03) << 26);
        self.w
    }
}
#[doc = "Pin 12 pull-up or pull-down bits"]
pub type PUD12_A = PUD0_A;
#[doc = "Field `PUD12` reader - Pin 12 pull-up or pull-down bits"]
pub type PUD12_R = PUD0_R;
#[doc = "Field `PUD12` writer - Pin 12 pull-up or pull-down bits"]
pub struct PUD12_W<'a> {
    w: &'a mut W,
}
impl<'a> PUD12_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: PUD12_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "No pull-up, pull-down (reset state)"]
    #[inline(always)]
    pub fn floating(self) -> &'a mut W {
        self.variant(PUD12_A::FLOATING)
    }
    #[doc = "Pull-up"]
    #[inline(always)]
    pub fn pull_up(self) -> &'a mut W {
        self.variant(PUD12_A::PULLUP)
    }
    #[doc = "Pull-down"]
    #[inline(always)]
    pub fn pull_down(self) -> &'a mut W {
        self.variant(PUD12_A::PULLDOWN)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 24)) | ((value as u32 & 0x03) << 24);
        self.w
    }
}
#[doc = "Pin 11 pull-up or pull-down bits"]
pub type PUD11_A = PUD0_A;
#[doc = "Field `PUD11` reader - Pin 11 pull-up or pull-down bits"]
pub type PUD11_R = PUD0_R;
#[doc = "Field `PUD11` writer - Pin 11 pull-up or pull-down bits"]
pub struct PUD11_W<'a> {
    w: &'a mut W,
}
impl<'a> PUD11_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: PUD11_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "No pull-up, pull-down (reset state)"]
    #[inline(always)]
    pub fn floating(self) -> &'a mut W {
        self.variant(PUD11_A::FLOATING)
    }
    #[doc = "Pull-up"]
    #[inline(always)]
    pub fn pull_up(self) -> &'a mut W {
        self.variant(PUD11_A::PULLUP)
    }
    #[doc = "Pull-down"]
    #[inline(always)]
    pub fn pull_down(self) -> &'a mut W {
        self.variant(PUD11_A::PULLDOWN)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 22)) | ((value as u32 & 0x03) << 22);
        self.w
    }
}
#[doc = "Pin 10 pull-up or pull-down bits"]
pub type PUD10_A = PUD0_A;
#[doc = "Field `PUD10` reader - Pin 10 pull-up or pull-down bits"]
pub type PUD10_R = PUD0_R;
#[doc = "Field `PUD10` writer - Pin 10 pull-up or pull-down bits"]
pub struct PUD10_W<'a> {
    w: &'a mut W,
}
impl<'a> PUD10_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: PUD10_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "No pull-up, pull-down (reset state)"]
    #[inline(always)]
    pub fn floating(self) -> &'a mut W {
        self.variant(PUD10_A::FLOATING)
    }
    #[doc = "Pull-up"]
    #[inline(always)]
    pub fn pull_up(self) -> &'a mut W {
        self.variant(PUD10_A::PULLUP)
    }
    #[doc = "Pull-down"]
    #[inline(always)]
    pub fn pull_down(self) -> &'a mut W {
        self.variant(PUD10_A::PULLDOWN)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 20)) | ((value as u32 & 0x03) << 20);
        self.w
    }
}
#[doc = "Pin 9 pull-up or pull-down bits"]
pub type PUD9_A = PUD0_A;
#[doc = "Field `PUD9` reader - Pin 9 pull-up or pull-down bits"]
pub type PUD9_R = PUD0_R;
#[doc = "Field `PUD9` writer - Pin 9 pull-up or pull-down bits"]
pub struct PUD9_W<'a> {
    w: &'a mut W,
}
impl<'a> PUD9_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: PUD9_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "No pull-up, pull-down (reset state)"]
    #[inline(always)]
    pub fn floating(self) -> &'a mut W {
        self.variant(PUD9_A::FLOATING)
    }
    #[doc = "Pull-up"]
    #[inline(always)]
    pub fn pull_up(self) -> &'a mut W {
        self.variant(PUD9_A::PULLUP)
    }
    #[doc = "Pull-down"]
    #[inline(always)]
    pub fn pull_down(self) -> &'a mut W {
        self.variant(PUD9_A::PULLDOWN)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 18)) | ((value as u32 & 0x03) << 18);
        self.w
    }
}
#[doc = "Pin 8 pull-up or pull-down bits"]
pub type PUD8_A = PUD0_A;
#[doc = "Field `PUD8` reader - Pin 8 pull-up or pull-down bits"]
pub type PUD8_R = PUD0_R;
#[doc = "Field `PUD8` writer - Pin 8 pull-up or pull-down bits"]
pub struct PUD8_W<'a> {
    w: &'a mut W,
}
impl<'a> PUD8_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: PUD8_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "No pull-up, pull-down (reset state)"]
    #[inline(always)]
    pub fn floating(self) -> &'a mut W {
        self.variant(PUD8_A::FLOATING)
    }
    #[doc = "Pull-up"]
    #[inline(always)]
    pub fn pull_up(self) -> &'a mut W {
        self.variant(PUD8_A::PULLUP)
    }
    #[doc = "Pull-down"]
    #[inline(always)]
    pub fn pull_down(self) -> &'a mut W {
        self.variant(PUD8_A::PULLDOWN)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 16)) | ((value as u32 & 0x03) << 16);
        self.w
    }
}
#[doc = "Pin 7 pull-up or pull-down bits"]
pub type PUD7_A = PUD0_A;
#[doc = "Field `PUD7` reader - Pin 7 pull-up or pull-down bits"]
pub type PUD7_R = PUD0_R;
#[doc = "Field `PUD7` writer - Pin 7 pull-up or pull-down bits"]
pub struct PUD7_W<'a> {
    w: &'a mut W,
}
impl<'a> PUD7_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: PUD7_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "No pull-up, pull-down (reset state)"]
    #[inline(always)]
    pub fn floating(self) -> &'a mut W {
        self.variant(PUD7_A::FLOATING)
    }
    #[doc = "Pull-up"]
    #[inline(always)]
    pub fn pull_up(self) -> &'a mut W {
        self.variant(PUD7_A::PULLUP)
    }
    #[doc = "Pull-down"]
    #[inline(always)]
    pub fn pull_down(self) -> &'a mut W {
        self.variant(PUD7_A::PULLDOWN)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 14)) | ((value as u32 & 0x03) << 14);
        self.w
    }
}
#[doc = "Pin 6 pull-up or pull-down bits"]
pub type PUD6_A = PUD0_A;
#[doc = "Field `PUD6` reader - Pin 6 pull-up or pull-down bits"]
pub type PUD6_R = PUD0_R;
#[doc = "Field `PUD6` writer - Pin 6 pull-up or pull-down bits"]
pub struct PUD6_W<'a> {
    w: &'a mut W,
}
impl<'a> PUD6_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: PUD6_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "No pull-up, pull-down (reset state)"]
    #[inline(always)]
    pub fn floating(self) -> &'a mut W {
        self.variant(PUD6_A::FLOATING)
    }
    #[doc = "Pull-up"]
    #[inline(always)]
    pub fn pull_up(self) -> &'a mut W {
        self.variant(PUD6_A::PULLUP)
    }
    #[doc = "Pull-down"]
    #[inline(always)]
    pub fn pull_down(self) -> &'a mut W {
        self.variant(PUD6_A::PULLDOWN)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 12)) | ((value as u32 & 0x03) << 12);
        self.w
    }
}
#[doc = "Pin 5 pull-up or pull-down bits"]
pub type PUD5_A = PUD0_A;
#[doc = "Field `PUD5` reader - Pin 5 pull-up or pull-down bits"]
pub type PUD5_R = PUD0_R;
#[doc = "Field `PUD5` writer - Pin 5 pull-up or pull-down bits"]
pub struct PUD5_W<'a> {
    w: &'a mut W,
}
impl<'a> PUD5_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: PUD5_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "No pull-up, pull-down (reset state)"]
    #[inline(always)]
    pub fn floating(self) -> &'a mut W {
        self.variant(PUD5_A::FLOATING)
    }
    #[doc = "Pull-up"]
    #[inline(always)]
    pub fn pull_up(self) -> &'a mut W {
        self.variant(PUD5_A::PULLUP)
    }
    #[doc = "Pull-down"]
    #[inline(always)]
    pub fn pull_down(self) -> &'a mut W {
        self.variant(PUD5_A::PULLDOWN)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 10)) | ((value as u32 & 0x03) << 10);
        self.w
    }
}
#[doc = "Pin 4 pull-up or pull-down bits"]
pub type PUD4_A = PUD0_A;
#[doc = "Field `PUD4` reader - Pin 4 pull-up or pull-down bits"]
pub type PUD4_R = PUD0_R;
#[doc = "Field `PUD4` writer - Pin 4 pull-up or pull-down bits"]
pub struct PUD4_W<'a> {
    w: &'a mut W,
}
impl<'a> PUD4_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: PUD4_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "No pull-up, pull-down (reset state)"]
    #[inline(always)]
    pub fn floating(self) -> &'a mut W {
        self.variant(PUD4_A::FLOATING)
    }
    #[doc = "Pull-up"]
    #[inline(always)]
    pub fn pull_up(self) -> &'a mut W {
        self.variant(PUD4_A::PULLUP)
    }
    #[doc = "Pull-down"]
    #[inline(always)]
    pub fn pull_down(self) -> &'a mut W {
        self.variant(PUD4_A::PULLDOWN)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 8)) | ((value as u32 & 0x03) << 8);
        self.w
    }
}
#[doc = "Pin 3 pull-up or pull-down bits"]
pub type PUD3_A = PUD0_A;
#[doc = "Field `PUD3` reader - Pin 3 pull-up or pull-down bits"]
pub type PUD3_R = PUD0_R;
#[doc = "Field `PUD3` writer - Pin 3 pull-up or pull-down bits"]
pub struct PUD3_W<'a> {
    w: &'a mut W,
}
impl<'a> PUD3_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: PUD3_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "No pull-up, pull-down (reset state)"]
    #[inline(always)]
    pub fn floating(self) -> &'a mut W {
        self.variant(PUD3_A::FLOATING)
    }
    #[doc = "Pull-up"]
    #[inline(always)]
    pub fn pull_up(self) -> &'a mut W {
        self.variant(PUD3_A::PULLUP)
    }
    #[doc = "Pull-down"]
    #[inline(always)]
    pub fn pull_down(self) -> &'a mut W {
        self.variant(PUD3_A::PULLDOWN)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 6)) | ((value as u32 & 0x03) << 6);
        self.w
    }
}
#[doc = "Pin 2 pull-up or pull-down bits"]
pub type PUD2_A = PUD0_A;
#[doc = "Field `PUD2` reader - Pin 2 pull-up or pull-down bits"]
pub type PUD2_R = PUD0_R;
#[doc = "Field `PUD2` writer - Pin 2 pull-up or pull-down bits"]
pub struct PUD2_W<'a> {
    w: &'a mut W,
}
impl<'a> PUD2_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: PUD2_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "No pull-up, pull-down (reset state)"]
    #[inline(always)]
    pub fn floating(self) -> &'a mut W {
        self.variant(PUD2_A::FLOATING)
    }
    #[doc = "Pull-up"]
    #[inline(always)]
    pub fn pull_up(self) -> &'a mut W {
        self.variant(PUD2_A::PULLUP)
    }
    #[doc = "Pull-down"]
    #[inline(always)]
    pub fn pull_down(self) -> &'a mut W {
        self.variant(PUD2_A::PULLDOWN)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 4)) | ((value as u32 & 0x03) << 4);
        self.w
    }
}
#[doc = "Pin 1 pull-up or pull-down bits"]
pub type PUD1_A = PUD0_A;
#[doc = "Field `PUD1` reader - Pin 1 pull-up or pull-down bits"]
pub type PUD1_R = PUD0_R;
#[doc = "Field `PUD1` writer - Pin 1 pull-up or pull-down bits"]
pub struct PUD1_W<'a> {
    w: &'a mut W,
}
impl<'a> PUD1_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: PUD1_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "No pull-up, pull-down (reset state)"]
    #[inline(always)]
    pub fn floating(self) -> &'a mut W {
        self.variant(PUD1_A::FLOATING)
    }
    #[doc = "Pull-up"]
    #[inline(always)]
    pub fn pull_up(self) -> &'a mut W {
        self.variant(PUD1_A::PULLUP)
    }
    #[doc = "Pull-down"]
    #[inline(always)]
    pub fn pull_down(self) -> &'a mut W {
        self.variant(PUD1_A::PULLDOWN)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 2)) | ((value as u32 & 0x03) << 2);
        self.w
    }
}
#[doc = "Pin 0 pull-up or pull-down bits\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum PUD0_A {
    #[doc = "0: No pull-up, pull-down (reset state)"]
    FLOATING = 0,
    #[doc = "1: Pull-up"]
    PULLUP = 1,
    #[doc = "2: Pull-down"]
    PULLDOWN = 2,
}
impl From<PUD0_A> for u8 {
    #[inline(always)]
    fn from(variant: PUD0_A) -> Self {
        variant as _
    }
}
#[doc = "Field `PUD0` reader - Pin 0 pull-up or pull-down bits"]
pub struct PUD0_R(crate::FieldReader<u8, PUD0_A>);
impl PUD0_R {
    pub(crate) fn new(bits: u8) -> Self {
        PUD0_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<PUD0_A> {
        match self.bits {
            0 => Some(PUD0_A::FLOATING),
            1 => Some(PUD0_A::PULLUP),
            2 => Some(PUD0_A::PULLDOWN),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `FLOATING`"]
    #[inline(always)]
    pub fn is_floating(&self) -> bool {
        **self == PUD0_A::FLOATING
    }
    #[doc = "Checks if the value of the field is `PULLUP`"]
    #[inline(always)]
    pub fn is_pull_up(&self) -> bool {
        **self == PUD0_A::PULLUP
    }
    #[doc = "Checks if the value of the field is `PULLDOWN`"]
    #[inline(always)]
    pub fn is_pull_down(&self) -> bool {
        **self == PUD0_A::PULLDOWN
    }
}
impl core::ops::Deref for PUD0_R {
    type Target = crate::FieldReader<u8, PUD0_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PUD0` writer - Pin 0 pull-up or pull-down bits"]
pub struct PUD0_W<'a> {
    w: &'a mut W,
}
impl<'a> PUD0_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: PUD0_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "No pull-up, pull-down (reset state)"]
    #[inline(always)]
    pub fn floating(self) -> &'a mut W {
        self.variant(PUD0_A::FLOATING)
    }
    #[doc = "Pull-up"]
    #[inline(always)]
    pub fn pull_up(self) -> &'a mut W {
        self.variant(PUD0_A::PULLUP)
    }
    #[doc = "Pull-down"]
    #[inline(always)]
    pub fn pull_down(self) -> &'a mut W {
        self.variant(PUD0_A::PULLDOWN)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x03) | (value as u32 & 0x03);
        self.w
    }
}
impl R {
    #[doc = "Bits 30:31 - Pin 15 pull-up or pull-down bits"]
    #[inline(always)]
    pub fn pud15(&self) -> PUD15_R {
        PUD15_R::new(((self.bits >> 30) & 0x03) as u8)
    }
    #[doc = "Bits 28:29 - Pin 14 pull-up or pull-down bits"]
    #[inline(always)]
    pub fn pud14(&self) -> PUD14_R {
        PUD14_R::new(((self.bits >> 28) & 0x03) as u8)
    }
    #[doc = "Bits 26:27 - Pin 13 pull-up or pull-down bits"]
    #[inline(always)]
    pub fn pud13(&self) -> PUD13_R {
        PUD13_R::new(((self.bits >> 26) & 0x03) as u8)
    }
    #[doc = "Bits 24:25 - Pin 12 pull-up or pull-down bits"]
    #[inline(always)]
    pub fn pud12(&self) -> PUD12_R {
        PUD12_R::new(((self.bits >> 24) & 0x03) as u8)
    }
    #[doc = "Bits 22:23 - Pin 11 pull-up or pull-down bits"]
    #[inline(always)]
    pub fn pud11(&self) -> PUD11_R {
        PUD11_R::new(((self.bits >> 22) & 0x03) as u8)
    }
    #[doc = "Bits 20:21 - Pin 10 pull-up or pull-down bits"]
    #[inline(always)]
    pub fn pud10(&self) -> PUD10_R {
        PUD10_R::new(((self.bits >> 20) & 0x03) as u8)
    }
    #[doc = "Bits 18:19 - Pin 9 pull-up or pull-down bits"]
    #[inline(always)]
    pub fn pud9(&self) -> PUD9_R {
        PUD9_R::new(((self.bits >> 18) & 0x03) as u8)
    }
    #[doc = "Bits 16:17 - Pin 8 pull-up or pull-down bits"]
    #[inline(always)]
    pub fn pud8(&self) -> PUD8_R {
        PUD8_R::new(((self.bits >> 16) & 0x03) as u8)
    }
    #[doc = "Bits 14:15 - Pin 7 pull-up or pull-down bits"]
    #[inline(always)]
    pub fn pud7(&self) -> PUD7_R {
        PUD7_R::new(((self.bits >> 14) & 0x03) as u8)
    }
    #[doc = "Bits 12:13 - Pin 6 pull-up or pull-down bits"]
    #[inline(always)]
    pub fn pud6(&self) -> PUD6_R {
        PUD6_R::new(((self.bits >> 12) & 0x03) as u8)
    }
    #[doc = "Bits 10:11 - Pin 5 pull-up or pull-down bits"]
    #[inline(always)]
    pub fn pud5(&self) -> PUD5_R {
        PUD5_R::new(((self.bits >> 10) & 0x03) as u8)
    }
    #[doc = "Bits 8:9 - Pin 4 pull-up or pull-down bits"]
    #[inline(always)]
    pub fn pud4(&self) -> PUD4_R {
        PUD4_R::new(((self.bits >> 8) & 0x03) as u8)
    }
    #[doc = "Bits 6:7 - Pin 3 pull-up or pull-down bits"]
    #[inline(always)]
    pub fn pud3(&self) -> PUD3_R {
        PUD3_R::new(((self.bits >> 6) & 0x03) as u8)
    }
    #[doc = "Bits 4:5 - Pin 2 pull-up or pull-down bits"]
    #[inline(always)]
    pub fn pud2(&self) -> PUD2_R {
        PUD2_R::new(((self.bits >> 4) & 0x03) as u8)
    }
    #[doc = "Bits 2:3 - Pin 1 pull-up or pull-down bits"]
    #[inline(always)]
    pub fn pud1(&self) -> PUD1_R {
        PUD1_R::new(((self.bits >> 2) & 0x03) as u8)
    }
    #[doc = "Bits 0:1 - Pin 0 pull-up or pull-down bits"]
    #[inline(always)]
    pub fn pud0(&self) -> PUD0_R {
        PUD0_R::new((self.bits & 0x03) as u8)
    }
}
impl W {
    #[doc = "Bits 30:31 - Pin 15 pull-up or pull-down bits"]
    #[inline(always)]
    pub fn pud15(&mut self) -> PUD15_W {
        PUD15_W { w: self }
    }
    #[doc = "Bits 28:29 - Pin 14 pull-up or pull-down bits"]
    #[inline(always)]
    pub fn pud14(&mut self) -> PUD14_W {
        PUD14_W { w: self }
    }
    #[doc = "Bits 26:27 - Pin 13 pull-up or pull-down bits"]
    #[inline(always)]
    pub fn pud13(&mut self) -> PUD13_W {
        PUD13_W { w: self }
    }
    #[doc = "Bits 24:25 - Pin 12 pull-up or pull-down bits"]
    #[inline(always)]
    pub fn pud12(&mut self) -> PUD12_W {
        PUD12_W { w: self }
    }
    #[doc = "Bits 22:23 - Pin 11 pull-up or pull-down bits"]
    #[inline(always)]
    pub fn pud11(&mut self) -> PUD11_W {
        PUD11_W { w: self }
    }
    #[doc = "Bits 20:21 - Pin 10 pull-up or pull-down bits"]
    #[inline(always)]
    pub fn pud10(&mut self) -> PUD10_W {
        PUD10_W { w: self }
    }
    #[doc = "Bits 18:19 - Pin 9 pull-up or pull-down bits"]
    #[inline(always)]
    pub fn pud9(&mut self) -> PUD9_W {
        PUD9_W { w: self }
    }
    #[doc = "Bits 16:17 - Pin 8 pull-up or pull-down bits"]
    #[inline(always)]
    pub fn pud8(&mut self) -> PUD8_W {
        PUD8_W { w: self }
    }
    #[doc = "Bits 14:15 - Pin 7 pull-up or pull-down bits"]
    #[inline(always)]
    pub fn pud7(&mut self) -> PUD7_W {
        PUD7_W { w: self }
    }
    #[doc = "Bits 12:13 - Pin 6 pull-up or pull-down bits"]
    #[inline(always)]
    pub fn pud6(&mut self) -> PUD6_W {
        PUD6_W { w: self }
    }
    #[doc = "Bits 10:11 - Pin 5 pull-up or pull-down bits"]
    #[inline(always)]
    pub fn pud5(&mut self) -> PUD5_W {
        PUD5_W { w: self }
    }
    #[doc = "Bits 8:9 - Pin 4 pull-up or pull-down bits"]
    #[inline(always)]
    pub fn pud4(&mut self) -> PUD4_W {
        PUD4_W { w: self }
    }
    #[doc = "Bits 6:7 - Pin 3 pull-up or pull-down bits"]
    #[inline(always)]
    pub fn pud3(&mut self) -> PUD3_W {
        PUD3_W { w: self }
    }
    #[doc = "Bits 4:5 - Pin 2 pull-up or pull-down bits"]
    #[inline(always)]
    pub fn pud2(&mut self) -> PUD2_W {
        PUD2_W { w: self }
    }
    #[doc = "Bits 2:3 - Pin 1 pull-up or pull-down bits"]
    #[inline(always)]
    pub fn pud1(&mut self) -> PUD1_W {
        PUD1_W { w: self }
    }
    #[doc = "Bits 0:1 - Pin 0 pull-up or pull-down bits"]
    #[inline(always)]
    pub fn pud0(&mut self) -> PUD0_W {
        PUD0_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "GPIO port pull-up/pull-down register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [pud](index.html) module"]
pub struct PUD_SPEC;
impl crate::RegisterSpec for PUD_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [pud::R](R) reader structure"]
impl crate::Readable for PUD_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [pud::W](W) writer structure"]
impl crate::Writable for PUD_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets PUD to value 0x2400_0000"]
impl crate::Resettable for PUD_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0x2400_0000
    }
}
