#[doc = "Register `RSQ2` reader"]
pub struct R(crate::R<RSQ2_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<RSQ2_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<RSQ2_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<RSQ2_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `RSQ2` writer"]
pub struct W(crate::W<RSQ2_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<RSQ2_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<RSQ2_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<RSQ2_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `RSQ6` reader - 6th conversion in regular sequence"]
pub struct RSQ6_R(crate::FieldReader<u8, u8>);
impl RSQ6_R {
    pub(crate) fn new(bits: u8) -> Self {
        RSQ6_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RSQ6_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RSQ6` writer - 6th conversion in regular sequence"]
pub struct RSQ6_W<'a> {
    w: &'a mut W,
}
impl<'a> RSQ6_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x1f << 25)) | ((value as u32 & 0x1f) << 25);
        self.w
    }
}
#[doc = "Field `RSQ5` reader - 5th conversion in regular sequence"]
pub struct RSQ5_R(crate::FieldReader<u8, u8>);
impl RSQ5_R {
    pub(crate) fn new(bits: u8) -> Self {
        RSQ5_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RSQ5_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RSQ5` writer - 5th conversion in regular sequence"]
pub struct RSQ5_W<'a> {
    w: &'a mut W,
}
impl<'a> RSQ5_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x1f << 20)) | ((value as u32 & 0x1f) << 20);
        self.w
    }
}
#[doc = "Field `RSQ4` reader - 4th conversion in regular sequence"]
pub struct RSQ4_R(crate::FieldReader<u8, u8>);
impl RSQ4_R {
    pub(crate) fn new(bits: u8) -> Self {
        RSQ4_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RSQ4_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RSQ4` writer - 4th conversion in regular sequence"]
pub struct RSQ4_W<'a> {
    w: &'a mut W,
}
impl<'a> RSQ4_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x1f << 15)) | ((value as u32 & 0x1f) << 15);
        self.w
    }
}
#[doc = "Field `RSQ3` reader - 3rd conversion in regular sequence"]
pub struct RSQ3_R(crate::FieldReader<u8, u8>);
impl RSQ3_R {
    pub(crate) fn new(bits: u8) -> Self {
        RSQ3_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RSQ3_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RSQ3` writer - 3rd conversion in regular sequence"]
pub struct RSQ3_W<'a> {
    w: &'a mut W,
}
impl<'a> RSQ3_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x1f << 10)) | ((value as u32 & 0x1f) << 10);
        self.w
    }
}
#[doc = "Field `RSQ2` reader - 2nd conversion in regular sequence"]
pub struct RSQ2_R(crate::FieldReader<u8, u8>);
impl RSQ2_R {
    pub(crate) fn new(bits: u8) -> Self {
        RSQ2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RSQ2_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RSQ2` writer - 2nd conversion in regular sequence"]
pub struct RSQ2_W<'a> {
    w: &'a mut W,
}
impl<'a> RSQ2_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x1f << 5)) | ((value as u32 & 0x1f) << 5);
        self.w
    }
}
#[doc = "Field `RSQ1` reader - 1st conversion in regular sequence"]
pub struct RSQ1_R(crate::FieldReader<u8, u8>);
impl RSQ1_R {
    pub(crate) fn new(bits: u8) -> Self {
        RSQ1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RSQ1_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RSQ1` writer - 1st conversion in regular sequence"]
pub struct RSQ1_W<'a> {
    w: &'a mut W,
}
impl<'a> RSQ1_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x1f) | (value as u32 & 0x1f);
        self.w
    }
}
impl R {
    #[doc = "Bits 25:29 - 6th conversion in regular sequence"]
    #[inline(always)]
    pub fn rsq6(&self) -> RSQ6_R {
        RSQ6_R::new(((self.bits >> 25) & 0x1f) as u8)
    }
    #[doc = "Bits 20:24 - 5th conversion in regular sequence"]
    #[inline(always)]
    pub fn rsq5(&self) -> RSQ5_R {
        RSQ5_R::new(((self.bits >> 20) & 0x1f) as u8)
    }
    #[doc = "Bits 15:19 - 4th conversion in regular sequence"]
    #[inline(always)]
    pub fn rsq4(&self) -> RSQ4_R {
        RSQ4_R::new(((self.bits >> 15) & 0x1f) as u8)
    }
    #[doc = "Bits 10:14 - 3rd conversion in regular sequence"]
    #[inline(always)]
    pub fn rsq3(&self) -> RSQ3_R {
        RSQ3_R::new(((self.bits >> 10) & 0x1f) as u8)
    }
    #[doc = "Bits 5:9 - 2nd conversion in regular sequence"]
    #[inline(always)]
    pub fn rsq2(&self) -> RSQ2_R {
        RSQ2_R::new(((self.bits >> 5) & 0x1f) as u8)
    }
    #[doc = "Bits 0:4 - 1st conversion in regular sequence"]
    #[inline(always)]
    pub fn rsq1(&self) -> RSQ1_R {
        RSQ1_R::new((self.bits & 0x1f) as u8)
    }
}
impl W {
    #[doc = "Bits 25:29 - 6th conversion in regular sequence"]
    #[inline(always)]
    pub fn rsq6(&mut self) -> RSQ6_W {
        RSQ6_W { w: self }
    }
    #[doc = "Bits 20:24 - 5th conversion in regular sequence"]
    #[inline(always)]
    pub fn rsq5(&mut self) -> RSQ5_W {
        RSQ5_W { w: self }
    }
    #[doc = "Bits 15:19 - 4th conversion in regular sequence"]
    #[inline(always)]
    pub fn rsq4(&mut self) -> RSQ4_W {
        RSQ4_W { w: self }
    }
    #[doc = "Bits 10:14 - 3rd conversion in regular sequence"]
    #[inline(always)]
    pub fn rsq3(&mut self) -> RSQ3_W {
        RSQ3_W { w: self }
    }
    #[doc = "Bits 5:9 - 2nd conversion in regular sequence"]
    #[inline(always)]
    pub fn rsq2(&mut self) -> RSQ2_W {
        RSQ2_W { w: self }
    }
    #[doc = "Bits 0:4 - 1st conversion in regular sequence"]
    #[inline(always)]
    pub fn rsq1(&mut self) -> RSQ1_W {
        RSQ1_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "regular sequence register 2\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [rsq2](index.html) module"]
pub struct RSQ2_SPEC;
impl crate::RegisterSpec for RSQ2_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [rsq2::R](R) reader structure"]
impl crate::Readable for RSQ2_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [rsq2::W](W) writer structure"]
impl crate::Writable for RSQ2_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets RSQ2 to value 0"]
impl crate::Resettable for RSQ2_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
