#[doc = "Register `CTL` reader"]
pub struct R(crate::R<CTL_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<CTL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<CTL_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<CTL_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `CTL` writer"]
pub struct W(crate::W<CTL_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<CTL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<CTL_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<CTL_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `CDT` reader - Charge State Duration Time"]
pub struct CDT_R(crate::FieldReader<u8, u8>);
impl CDT_R {
    pub(crate) fn new(bits: u8) -> Self {
        CDT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CDT_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CDT` writer - Charge State Duration Time"]
pub struct CDT_W<'a> {
    w: &'a mut W,
}
impl<'a> CDT_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 28)) | ((value as u32 & 0x0f) << 28);
        self.w
    }
}
#[doc = "Field `CTDT` reader - Charge Transfer State Duration Time"]
pub struct CTDT_R(crate::FieldReader<u8, u8>);
impl CTDT_R {
    pub(crate) fn new(bits: u8) -> Self {
        CTDT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CTDT_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CTDT` writer - Charge Transfer State Duration Time"]
pub struct CTDT_W<'a> {
    w: &'a mut W,
}
impl<'a> CTDT_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 24)) | ((value as u32 & 0x0f) << 24);
        self.w
    }
}
#[doc = "Field `ECDT` reader - Extend Charge State Maximum Duration Time"]
pub struct ECDT_R(crate::FieldReader<u8, u8>);
impl ECDT_R {
    pub(crate) fn new(bits: u8) -> Self {
        ECDT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ECDT_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ECDT` writer - Extend Charge State Maximum Duration Time"]
pub struct ECDT_W<'a> {
    w: &'a mut W,
}
impl<'a> ECDT_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x7f << 17)) | ((value as u32 & 0x7f) << 17);
        self.w
    }
}
#[doc = "Field `ECEN` reader - Extend Charge State Enable"]
pub struct ECEN_R(crate::FieldReader<bool, bool>);
impl ECEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        ECEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ECEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ECEN` writer - Extend Charge State Enable"]
pub struct ECEN_W<'a> {
    w: &'a mut W,
}
impl<'a> ECEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 16)) | ((value as u32 & 0x01) << 16);
        self.w
    }
}
#[doc = "Field `ECDIV` reader - ECCLK clock division factor"]
pub struct ECDIV_R(crate::FieldReader<bool, bool>);
impl ECDIV_R {
    pub(crate) fn new(bits: bool) -> Self {
        ECDIV_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ECDIV_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ECDIV` writer - ECCLK clock division factor"]
pub struct ECDIV_W<'a> {
    w: &'a mut W,
}
impl<'a> ECDIV_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 15)) | ((value as u32 & 0x01) << 15);
        self.w
    }
}
#[doc = "Field `CTCDIV` reader - CTCLK clock division factor"]
pub struct CTCDIV_R(crate::FieldReader<u8, u8>);
impl CTCDIV_R {
    pub(crate) fn new(bits: u8) -> Self {
        CTCDIV_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CTCDIV_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CTCDIV` writer - CTCLK clock division factor"]
pub struct CTCDIV_W<'a> {
    w: &'a mut W,
}
impl<'a> CTCDIV_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 12)) | ((value as u32 & 0x07) << 12);
        self.w
    }
}
#[doc = "Field `MCN` reader - Max cycle number of a sequence"]
pub struct MCN_R(crate::FieldReader<u8, u8>);
impl MCN_R {
    pub(crate) fn new(bits: u8) -> Self {
        MCN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for MCN_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `MCN` writer - Max cycle number of a sequence"]
pub struct MCN_W<'a> {
    w: &'a mut W,
}
impl<'a> MCN_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 5)) | ((value as u32 & 0x07) << 5);
        self.w
    }
}
#[doc = "Field `PINMOD` reader - Pin mode"]
pub struct PINMOD_R(crate::FieldReader<bool, bool>);
impl PINMOD_R {
    pub(crate) fn new(bits: bool) -> Self {
        PINMOD_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PINMOD_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PINMOD` writer - Pin mode"]
pub struct PINMOD_W<'a> {
    w: &'a mut W,
}
impl<'a> PINMOD_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u32 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `EGSEL` reader - Edge selection"]
pub struct EGSEL_R(crate::FieldReader<bool, bool>);
impl EGSEL_R {
    pub(crate) fn new(bits: bool) -> Self {
        EGSEL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for EGSEL_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EGSEL` writer - Edge selection"]
pub struct EGSEL_W<'a> {
    w: &'a mut W,
}
impl<'a> EGSEL_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u32 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `TRGMOD` reader - Trigger mode selection"]
pub struct TRGMOD_R(crate::FieldReader<bool, bool>);
impl TRGMOD_R {
    pub(crate) fn new(bits: bool) -> Self {
        TRGMOD_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TRGMOD_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TRGMOD` writer - Trigger mode selection"]
pub struct TRGMOD_W<'a> {
    w: &'a mut W,
}
impl<'a> TRGMOD_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u32 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `TSIS` reader - TSI start"]
pub struct TSIS_R(crate::FieldReader<bool, bool>);
impl TSIS_R {
    pub(crate) fn new(bits: bool) -> Self {
        TSIS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TSIS_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TSIS` writer - TSI start"]
pub struct TSIS_W<'a> {
    w: &'a mut W,
}
impl<'a> TSIS_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `TSIEN` reader - TSI enable"]
pub struct TSIEN_R(crate::FieldReader<bool, bool>);
impl TSIEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        TSIEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TSIEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TSIEN` writer - TSI enable"]
pub struct TSIEN_W<'a> {
    w: &'a mut W,
}
impl<'a> TSIEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
impl R {
    #[doc = "Bits 28:31 - Charge State Duration Time"]
    #[inline(always)]
    pub fn cdt(&self) -> CDT_R {
        CDT_R::new(((self.bits >> 28) & 0x0f) as u8)
    }
    #[doc = "Bits 24:27 - Charge Transfer State Duration Time"]
    #[inline(always)]
    pub fn ctdt(&self) -> CTDT_R {
        CTDT_R::new(((self.bits >> 24) & 0x0f) as u8)
    }
    #[doc = "Bits 17:23 - Extend Charge State Maximum Duration Time"]
    #[inline(always)]
    pub fn ecdt(&self) -> ECDT_R {
        ECDT_R::new(((self.bits >> 17) & 0x7f) as u8)
    }
    #[doc = "Bit 16 - Extend Charge State Enable"]
    #[inline(always)]
    pub fn ecen(&self) -> ECEN_R {
        ECEN_R::new(((self.bits >> 16) & 0x01) != 0)
    }
    #[doc = "Bit 15 - ECCLK clock division factor"]
    #[inline(always)]
    pub fn ecdiv(&self) -> ECDIV_R {
        ECDIV_R::new(((self.bits >> 15) & 0x01) != 0)
    }
    #[doc = "Bits 12:14 - CTCLK clock division factor"]
    #[inline(always)]
    pub fn ctcdiv(&self) -> CTCDIV_R {
        CTCDIV_R::new(((self.bits >> 12) & 0x07) as u8)
    }
    #[doc = "Bits 5:7 - Max cycle number of a sequence"]
    #[inline(always)]
    pub fn mcn(&self) -> MCN_R {
        MCN_R::new(((self.bits >> 5) & 0x07) as u8)
    }
    #[doc = "Bit 4 - Pin mode"]
    #[inline(always)]
    pub fn pinmod(&self) -> PINMOD_R {
        PINMOD_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Edge selection"]
    #[inline(always)]
    pub fn egsel(&self) -> EGSEL_R {
        EGSEL_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Trigger mode selection"]
    #[inline(always)]
    pub fn trgmod(&self) -> TRGMOD_R {
        TRGMOD_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 1 - TSI start"]
    #[inline(always)]
    pub fn tsis(&self) -> TSIS_R {
        TSIS_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 0 - TSI enable"]
    #[inline(always)]
    pub fn tsien(&self) -> TSIEN_R {
        TSIEN_R::new((self.bits & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 28:31 - Charge State Duration Time"]
    #[inline(always)]
    pub fn cdt(&mut self) -> CDT_W {
        CDT_W { w: self }
    }
    #[doc = "Bits 24:27 - Charge Transfer State Duration Time"]
    #[inline(always)]
    pub fn ctdt(&mut self) -> CTDT_W {
        CTDT_W { w: self }
    }
    #[doc = "Bits 17:23 - Extend Charge State Maximum Duration Time"]
    #[inline(always)]
    pub fn ecdt(&mut self) -> ECDT_W {
        ECDT_W { w: self }
    }
    #[doc = "Bit 16 - Extend Charge State Enable"]
    #[inline(always)]
    pub fn ecen(&mut self) -> ECEN_W {
        ECEN_W { w: self }
    }
    #[doc = "Bit 15 - ECCLK clock division factor"]
    #[inline(always)]
    pub fn ecdiv(&mut self) -> ECDIV_W {
        ECDIV_W { w: self }
    }
    #[doc = "Bits 12:14 - CTCLK clock division factor"]
    #[inline(always)]
    pub fn ctcdiv(&mut self) -> CTCDIV_W {
        CTCDIV_W { w: self }
    }
    #[doc = "Bits 5:7 - Max cycle number of a sequence"]
    #[inline(always)]
    pub fn mcn(&mut self) -> MCN_W {
        MCN_W { w: self }
    }
    #[doc = "Bit 4 - Pin mode"]
    #[inline(always)]
    pub fn pinmod(&mut self) -> PINMOD_W {
        PINMOD_W { w: self }
    }
    #[doc = "Bit 3 - Edge selection"]
    #[inline(always)]
    pub fn egsel(&mut self) -> EGSEL_W {
        EGSEL_W { w: self }
    }
    #[doc = "Bit 2 - Trigger mode selection"]
    #[inline(always)]
    pub fn trgmod(&mut self) -> TRGMOD_W {
        TRGMOD_W { w: self }
    }
    #[doc = "Bit 1 - TSI start"]
    #[inline(always)]
    pub fn tsis(&mut self) -> TSIS_W {
        TSIS_W { w: self }
    }
    #[doc = "Bit 0 - TSI enable"]
    #[inline(always)]
    pub fn tsien(&mut self) -> TSIEN_W {
        TSIEN_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "control register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ctl](index.html) module"]
pub struct CTL_SPEC;
impl crate::RegisterSpec for CTL_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [ctl::R](R) reader structure"]
impl crate::Readable for CTL_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [ctl::W](W) writer structure"]
impl crate::Writable for CTL_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets CTL to value 0"]
impl crate::Resettable for CTL_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
