#[doc = "Register `INT` reader"]
pub struct R(crate::R<INT_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<INT_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<INT_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<INT_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `INT` writer"]
pub struct W(crate::W<INT_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<INT_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<INT_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<INT_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "IRC40K stabilization interrupt flag\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum IRC40KSTBIF_A {
    #[doc = "0: No interrupt generated"]
    NOTINTERRUPTED = 0,
    #[doc = "1: IRC40K stabilisation interrupt generated"]
    INTERRUPTED = 1,
}
impl From<IRC40KSTBIF_A> for bool {
    #[inline(always)]
    fn from(variant: IRC40KSTBIF_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `IRC40KSTBIF` reader - IRC40K stabilization interrupt flag"]
pub struct IRC40KSTBIF_R(crate::FieldReader<bool, IRC40KSTBIF_A>);
impl IRC40KSTBIF_R {
    pub(crate) fn new(bits: bool) -> Self {
        IRC40KSTBIF_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> IRC40KSTBIF_A {
        match self.bits {
            false => IRC40KSTBIF_A::NOTINTERRUPTED,
            true => IRC40KSTBIF_A::INTERRUPTED,
        }
    }
    #[doc = "Checks if the value of the field is `NOTINTERRUPTED`"]
    #[inline(always)]
    pub fn is_not_interrupted(&self) -> bool {
        **self == IRC40KSTBIF_A::NOTINTERRUPTED
    }
    #[doc = "Checks if the value of the field is `INTERRUPTED`"]
    #[inline(always)]
    pub fn is_interrupted(&self) -> bool {
        **self == IRC40KSTBIF_A::INTERRUPTED
    }
}
impl core::ops::Deref for IRC40KSTBIF_R {
    type Target = crate::FieldReader<bool, IRC40KSTBIF_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "LXTAL stabilization interrupt flag\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum LXTALSTBIF_A {
    #[doc = "0: No interrupt generated"]
    NOTINTERRUPTED = 0,
    #[doc = "1: LXTAL stabilisation interrupt generated"]
    INTERRUPTED = 1,
}
impl From<LXTALSTBIF_A> for bool {
    #[inline(always)]
    fn from(variant: LXTALSTBIF_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `LXTALSTBIF` reader - LXTAL stabilization interrupt flag"]
pub struct LXTALSTBIF_R(crate::FieldReader<bool, LXTALSTBIF_A>);
impl LXTALSTBIF_R {
    pub(crate) fn new(bits: bool) -> Self {
        LXTALSTBIF_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> LXTALSTBIF_A {
        match self.bits {
            false => LXTALSTBIF_A::NOTINTERRUPTED,
            true => LXTALSTBIF_A::INTERRUPTED,
        }
    }
    #[doc = "Checks if the value of the field is `NOTINTERRUPTED`"]
    #[inline(always)]
    pub fn is_not_interrupted(&self) -> bool {
        **self == LXTALSTBIF_A::NOTINTERRUPTED
    }
    #[doc = "Checks if the value of the field is `INTERRUPTED`"]
    #[inline(always)]
    pub fn is_interrupted(&self) -> bool {
        **self == LXTALSTBIF_A::INTERRUPTED
    }
}
impl core::ops::Deref for LXTALSTBIF_R {
    type Target = crate::FieldReader<bool, LXTALSTBIF_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "IRC8M stabilization interrupt flag\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum IRC8MSTBIF_A {
    #[doc = "0: No interrupt generated"]
    NOTINTERRUPTED = 0,
    #[doc = "1: IRC8M stabilisation interrupt generated"]
    INTERRUPTED = 1,
}
impl From<IRC8MSTBIF_A> for bool {
    #[inline(always)]
    fn from(variant: IRC8MSTBIF_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `IRC8MSTBIF` reader - IRC8M stabilization interrupt flag"]
pub struct IRC8MSTBIF_R(crate::FieldReader<bool, IRC8MSTBIF_A>);
impl IRC8MSTBIF_R {
    pub(crate) fn new(bits: bool) -> Self {
        IRC8MSTBIF_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> IRC8MSTBIF_A {
        match self.bits {
            false => IRC8MSTBIF_A::NOTINTERRUPTED,
            true => IRC8MSTBIF_A::INTERRUPTED,
        }
    }
    #[doc = "Checks if the value of the field is `NOTINTERRUPTED`"]
    #[inline(always)]
    pub fn is_not_interrupted(&self) -> bool {
        **self == IRC8MSTBIF_A::NOTINTERRUPTED
    }
    #[doc = "Checks if the value of the field is `INTERRUPTED`"]
    #[inline(always)]
    pub fn is_interrupted(&self) -> bool {
        **self == IRC8MSTBIF_A::INTERRUPTED
    }
}
impl core::ops::Deref for IRC8MSTBIF_R {
    type Target = crate::FieldReader<bool, IRC8MSTBIF_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "HXTAL stabilization interrupt flag\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum HXTALSTBIF_A {
    #[doc = "0: No interrupt generated"]
    NOTINTERRUPTED = 0,
    #[doc = "1: HXTAL stabilisation interrupt generated"]
    INTERRUPTED = 1,
}
impl From<HXTALSTBIF_A> for bool {
    #[inline(always)]
    fn from(variant: HXTALSTBIF_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `HXTALSTBIF` reader - HXTAL stabilization interrupt flag"]
pub struct HXTALSTBIF_R(crate::FieldReader<bool, HXTALSTBIF_A>);
impl HXTALSTBIF_R {
    pub(crate) fn new(bits: bool) -> Self {
        HXTALSTBIF_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> HXTALSTBIF_A {
        match self.bits {
            false => HXTALSTBIF_A::NOTINTERRUPTED,
            true => HXTALSTBIF_A::INTERRUPTED,
        }
    }
    #[doc = "Checks if the value of the field is `NOTINTERRUPTED`"]
    #[inline(always)]
    pub fn is_not_interrupted(&self) -> bool {
        **self == HXTALSTBIF_A::NOTINTERRUPTED
    }
    #[doc = "Checks if the value of the field is `INTERRUPTED`"]
    #[inline(always)]
    pub fn is_interrupted(&self) -> bool {
        **self == HXTALSTBIF_A::INTERRUPTED
    }
}
impl core::ops::Deref for HXTALSTBIF_R {
    type Target = crate::FieldReader<bool, HXTALSTBIF_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "PLL stabilization interrupt flag\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum PLLSTBIF_A {
    #[doc = "0: No interrupt generated"]
    NOTINTERRUPTED = 0,
    #[doc = "1: PLL stabilisation interrupt generated"]
    INTERRUPTED = 1,
}
impl From<PLLSTBIF_A> for bool {
    #[inline(always)]
    fn from(variant: PLLSTBIF_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `PLLSTBIF` reader - PLL stabilization interrupt flag"]
pub struct PLLSTBIF_R(crate::FieldReader<bool, PLLSTBIF_A>);
impl PLLSTBIF_R {
    pub(crate) fn new(bits: bool) -> Self {
        PLLSTBIF_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> PLLSTBIF_A {
        match self.bits {
            false => PLLSTBIF_A::NOTINTERRUPTED,
            true => PLLSTBIF_A::INTERRUPTED,
        }
    }
    #[doc = "Checks if the value of the field is `NOTINTERRUPTED`"]
    #[inline(always)]
    pub fn is_not_interrupted(&self) -> bool {
        **self == PLLSTBIF_A::NOTINTERRUPTED
    }
    #[doc = "Checks if the value of the field is `INTERRUPTED`"]
    #[inline(always)]
    pub fn is_interrupted(&self) -> bool {
        **self == PLLSTBIF_A::INTERRUPTED
    }
}
impl core::ops::Deref for PLLSTBIF_R {
    type Target = crate::FieldReader<bool, PLLSTBIF_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "IRC14M stabilization interrupt flag\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum IRC14MSTBIF_A {
    #[doc = "0: No interrupt generated"]
    NOTINTERRUPTED = 0,
    #[doc = "1: IRC14M stabilisation interrupt generated"]
    INTERRUPTED = 1,
}
impl From<IRC14MSTBIF_A> for bool {
    #[inline(always)]
    fn from(variant: IRC14MSTBIF_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `IRC14MSTBIF` reader - IRC14M stabilization interrupt flag"]
pub struct IRC14MSTBIF_R(crate::FieldReader<bool, IRC14MSTBIF_A>);
impl IRC14MSTBIF_R {
    pub(crate) fn new(bits: bool) -> Self {
        IRC14MSTBIF_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> IRC14MSTBIF_A {
        match self.bits {
            false => IRC14MSTBIF_A::NOTINTERRUPTED,
            true => IRC14MSTBIF_A::INTERRUPTED,
        }
    }
    #[doc = "Checks if the value of the field is `NOTINTERRUPTED`"]
    #[inline(always)]
    pub fn is_not_interrupted(&self) -> bool {
        **self == IRC14MSTBIF_A::NOTINTERRUPTED
    }
    #[doc = "Checks if the value of the field is `INTERRUPTED`"]
    #[inline(always)]
    pub fn is_interrupted(&self) -> bool {
        **self == IRC14MSTBIF_A::INTERRUPTED
    }
}
impl core::ops::Deref for IRC14MSTBIF_R {
    type Target = crate::FieldReader<bool, IRC14MSTBIF_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "HXTAL Clock Stuck Interrupt Flag\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum CKMIF_A {
    #[doc = "0: Clock operating normally"]
    NOTINTERRUPTED = 0,
    #[doc = "1: HXTAL clock stuck"]
    INTERRUPTED = 1,
}
impl From<CKMIF_A> for bool {
    #[inline(always)]
    fn from(variant: CKMIF_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `CKMIF` reader - HXTAL Clock Stuck Interrupt Flag"]
pub struct CKMIF_R(crate::FieldReader<bool, CKMIF_A>);
impl CKMIF_R {
    pub(crate) fn new(bits: bool) -> Self {
        CKMIF_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> CKMIF_A {
        match self.bits {
            false => CKMIF_A::NOTINTERRUPTED,
            true => CKMIF_A::INTERRUPTED,
        }
    }
    #[doc = "Checks if the value of the field is `NOTINTERRUPTED`"]
    #[inline(always)]
    pub fn is_not_interrupted(&self) -> bool {
        **self == CKMIF_A::NOTINTERRUPTED
    }
    #[doc = "Checks if the value of the field is `INTERRUPTED`"]
    #[inline(always)]
    pub fn is_interrupted(&self) -> bool {
        **self == CKMIF_A::INTERRUPTED
    }
}
impl core::ops::Deref for CKMIF_R {
    type Target = crate::FieldReader<bool, CKMIF_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "IRC40K Stabilization interrupt enable\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum IRC40KSTBIE_A {
    #[doc = "0: Interrupt disabled"]
    DISABLED = 0,
    #[doc = "1: Interrupt enabled"]
    ENABLED = 1,
}
impl From<IRC40KSTBIE_A> for bool {
    #[inline(always)]
    fn from(variant: IRC40KSTBIE_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `IRC40KSTBIE` reader - IRC40K Stabilization interrupt enable"]
pub struct IRC40KSTBIE_R(crate::FieldReader<bool, IRC40KSTBIE_A>);
impl IRC40KSTBIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        IRC40KSTBIE_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> IRC40KSTBIE_A {
        match self.bits {
            false => IRC40KSTBIE_A::DISABLED,
            true => IRC40KSTBIE_A::ENABLED,
        }
    }
    #[doc = "Checks if the value of the field is `DISABLED`"]
    #[inline(always)]
    pub fn is_disabled(&self) -> bool {
        **self == IRC40KSTBIE_A::DISABLED
    }
    #[doc = "Checks if the value of the field is `ENABLED`"]
    #[inline(always)]
    pub fn is_enabled(&self) -> bool {
        **self == IRC40KSTBIE_A::ENABLED
    }
}
impl core::ops::Deref for IRC40KSTBIE_R {
    type Target = crate::FieldReader<bool, IRC40KSTBIE_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `IRC40KSTBIE` writer - IRC40K Stabilization interrupt enable"]
pub struct IRC40KSTBIE_W<'a> {
    w: &'a mut W,
}
impl<'a> IRC40KSTBIE_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: IRC40KSTBIE_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Interrupt disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(IRC40KSTBIE_A::DISABLED)
    }
    #[doc = "Interrupt enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(IRC40KSTBIE_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 8)) | ((value as u32 & 0x01) << 8);
        self.w
    }
}
#[doc = "LXTAL Stabilization Interrupt Enable\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum LXTALSTBIE_A {
    #[doc = "0: Interrupt disabled"]
    DISABLED = 0,
    #[doc = "1: Interrupt enabled"]
    ENABLED = 1,
}
impl From<LXTALSTBIE_A> for bool {
    #[inline(always)]
    fn from(variant: LXTALSTBIE_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `LXTALSTBIE` reader - LXTAL Stabilization Interrupt Enable"]
pub struct LXTALSTBIE_R(crate::FieldReader<bool, LXTALSTBIE_A>);
impl LXTALSTBIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        LXTALSTBIE_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> LXTALSTBIE_A {
        match self.bits {
            false => LXTALSTBIE_A::DISABLED,
            true => LXTALSTBIE_A::ENABLED,
        }
    }
    #[doc = "Checks if the value of the field is `DISABLED`"]
    #[inline(always)]
    pub fn is_disabled(&self) -> bool {
        **self == LXTALSTBIE_A::DISABLED
    }
    #[doc = "Checks if the value of the field is `ENABLED`"]
    #[inline(always)]
    pub fn is_enabled(&self) -> bool {
        **self == LXTALSTBIE_A::ENABLED
    }
}
impl core::ops::Deref for LXTALSTBIE_R {
    type Target = crate::FieldReader<bool, LXTALSTBIE_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LXTALSTBIE` writer - LXTAL Stabilization Interrupt Enable"]
pub struct LXTALSTBIE_W<'a> {
    w: &'a mut W,
}
impl<'a> LXTALSTBIE_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: LXTALSTBIE_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Interrupt disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(LXTALSTBIE_A::DISABLED)
    }
    #[doc = "Interrupt enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(LXTALSTBIE_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 9)) | ((value as u32 & 0x01) << 9);
        self.w
    }
}
#[doc = "IRC8M Stabilization Interrupt Enable\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum IRC8MSTBIE_A {
    #[doc = "0: Interrupt disabled"]
    DISABLED = 0,
    #[doc = "1: Interrupt enabled"]
    ENABLED = 1,
}
impl From<IRC8MSTBIE_A> for bool {
    #[inline(always)]
    fn from(variant: IRC8MSTBIE_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `IRC8MSTBIE` reader - IRC8M Stabilization Interrupt Enable"]
pub struct IRC8MSTBIE_R(crate::FieldReader<bool, IRC8MSTBIE_A>);
impl IRC8MSTBIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        IRC8MSTBIE_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> IRC8MSTBIE_A {
        match self.bits {
            false => IRC8MSTBIE_A::DISABLED,
            true => IRC8MSTBIE_A::ENABLED,
        }
    }
    #[doc = "Checks if the value of the field is `DISABLED`"]
    #[inline(always)]
    pub fn is_disabled(&self) -> bool {
        **self == IRC8MSTBIE_A::DISABLED
    }
    #[doc = "Checks if the value of the field is `ENABLED`"]
    #[inline(always)]
    pub fn is_enabled(&self) -> bool {
        **self == IRC8MSTBIE_A::ENABLED
    }
}
impl core::ops::Deref for IRC8MSTBIE_R {
    type Target = crate::FieldReader<bool, IRC8MSTBIE_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `IRC8MSTBIE` writer - IRC8M Stabilization Interrupt Enable"]
pub struct IRC8MSTBIE_W<'a> {
    w: &'a mut W,
}
impl<'a> IRC8MSTBIE_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: IRC8MSTBIE_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Interrupt disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(IRC8MSTBIE_A::DISABLED)
    }
    #[doc = "Interrupt enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(IRC8MSTBIE_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 10)) | ((value as u32 & 0x01) << 10);
        self.w
    }
}
#[doc = "HXTAL Stabilization Interrupt Enable\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum HXTALSTBIE_A {
    #[doc = "0: Interrupt disabled"]
    DISABLED = 0,
    #[doc = "1: Interrupt enabled"]
    ENABLED = 1,
}
impl From<HXTALSTBIE_A> for bool {
    #[inline(always)]
    fn from(variant: HXTALSTBIE_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `HXTALSTBIE` reader - HXTAL Stabilization Interrupt Enable"]
pub struct HXTALSTBIE_R(crate::FieldReader<bool, HXTALSTBIE_A>);
impl HXTALSTBIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        HXTALSTBIE_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> HXTALSTBIE_A {
        match self.bits {
            false => HXTALSTBIE_A::DISABLED,
            true => HXTALSTBIE_A::ENABLED,
        }
    }
    #[doc = "Checks if the value of the field is `DISABLED`"]
    #[inline(always)]
    pub fn is_disabled(&self) -> bool {
        **self == HXTALSTBIE_A::DISABLED
    }
    #[doc = "Checks if the value of the field is `ENABLED`"]
    #[inline(always)]
    pub fn is_enabled(&self) -> bool {
        **self == HXTALSTBIE_A::ENABLED
    }
}
impl core::ops::Deref for HXTALSTBIE_R {
    type Target = crate::FieldReader<bool, HXTALSTBIE_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `HXTALSTBIE` writer - HXTAL Stabilization Interrupt Enable"]
pub struct HXTALSTBIE_W<'a> {
    w: &'a mut W,
}
impl<'a> HXTALSTBIE_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: HXTALSTBIE_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Interrupt disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(HXTALSTBIE_A::DISABLED)
    }
    #[doc = "Interrupt enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(HXTALSTBIE_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 11)) | ((value as u32 & 0x01) << 11);
        self.w
    }
}
#[doc = "PLL Stabilization Interrupt Enable\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum PLLSTBIE_A {
    #[doc = "0: Interrupt disabled"]
    DISABLED = 0,
    #[doc = "1: Interrupt enabled"]
    ENABLED = 1,
}
impl From<PLLSTBIE_A> for bool {
    #[inline(always)]
    fn from(variant: PLLSTBIE_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `PLLSTBIE` reader - PLL Stabilization Interrupt Enable"]
pub struct PLLSTBIE_R(crate::FieldReader<bool, PLLSTBIE_A>);
impl PLLSTBIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        PLLSTBIE_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> PLLSTBIE_A {
        match self.bits {
            false => PLLSTBIE_A::DISABLED,
            true => PLLSTBIE_A::ENABLED,
        }
    }
    #[doc = "Checks if the value of the field is `DISABLED`"]
    #[inline(always)]
    pub fn is_disabled(&self) -> bool {
        **self == PLLSTBIE_A::DISABLED
    }
    #[doc = "Checks if the value of the field is `ENABLED`"]
    #[inline(always)]
    pub fn is_enabled(&self) -> bool {
        **self == PLLSTBIE_A::ENABLED
    }
}
impl core::ops::Deref for PLLSTBIE_R {
    type Target = crate::FieldReader<bool, PLLSTBIE_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PLLSTBIE` writer - PLL Stabilization Interrupt Enable"]
pub struct PLLSTBIE_W<'a> {
    w: &'a mut W,
}
impl<'a> PLLSTBIE_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: PLLSTBIE_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Interrupt disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(PLLSTBIE_A::DISABLED)
    }
    #[doc = "Interrupt enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(PLLSTBIE_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 12)) | ((value as u32 & 0x01) << 12);
        self.w
    }
}
#[doc = "IRC14M Stabilization Interrupt Enable\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum IRC14MSTBIE_A {
    #[doc = "0: Interrupt disabled"]
    DISABLED = 0,
    #[doc = "1: Interrupt enabled"]
    ENABLED = 1,
}
impl From<IRC14MSTBIE_A> for bool {
    #[inline(always)]
    fn from(variant: IRC14MSTBIE_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `IRC14MSTBIE` reader - IRC14M Stabilization Interrupt Enable"]
pub struct IRC14MSTBIE_R(crate::FieldReader<bool, IRC14MSTBIE_A>);
impl IRC14MSTBIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        IRC14MSTBIE_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> IRC14MSTBIE_A {
        match self.bits {
            false => IRC14MSTBIE_A::DISABLED,
            true => IRC14MSTBIE_A::ENABLED,
        }
    }
    #[doc = "Checks if the value of the field is `DISABLED`"]
    #[inline(always)]
    pub fn is_disabled(&self) -> bool {
        **self == IRC14MSTBIE_A::DISABLED
    }
    #[doc = "Checks if the value of the field is `ENABLED`"]
    #[inline(always)]
    pub fn is_enabled(&self) -> bool {
        **self == IRC14MSTBIE_A::ENABLED
    }
}
impl core::ops::Deref for IRC14MSTBIE_R {
    type Target = crate::FieldReader<bool, IRC14MSTBIE_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `IRC14MSTBIE` writer - IRC14M Stabilization Interrupt Enable"]
pub struct IRC14MSTBIE_W<'a> {
    w: &'a mut W,
}
impl<'a> IRC14MSTBIE_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: IRC14MSTBIE_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Interrupt disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(IRC14MSTBIE_A::DISABLED)
    }
    #[doc = "Interrupt enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(IRC14MSTBIE_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 13)) | ((value as u32 & 0x01) << 13);
        self.w
    }
}
#[doc = "IRC40K Stabilization Interrupt Clear\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum IRC40KSTBIC_AW {
    #[doc = "1: Clear IRC40KSTBIF flag"]
    CLEAR = 1,
}
impl From<IRC40KSTBIC_AW> for bool {
    #[inline(always)]
    fn from(variant: IRC40KSTBIC_AW) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `IRC40KSTBIC` writer - IRC40K Stabilization Interrupt Clear"]
pub struct IRC40KSTBIC_W<'a> {
    w: &'a mut W,
}
impl<'a> IRC40KSTBIC_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: IRC40KSTBIC_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Clear IRC40KSTBIF flag"]
    #[inline(always)]
    pub fn clear(self) -> &'a mut W {
        self.variant(IRC40KSTBIC_AW::CLEAR)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 16)) | ((value as u32 & 0x01) << 16);
        self.w
    }
}
#[doc = "LXTAL Stabilization Interrupt Clear\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum LXTALSTBIC_AW {
    #[doc = "1: Clear LXTALSTBIF flag"]
    CLEAR = 1,
}
impl From<LXTALSTBIC_AW> for bool {
    #[inline(always)]
    fn from(variant: LXTALSTBIC_AW) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `LXTALSTBIC` writer - LXTAL Stabilization Interrupt Clear"]
pub struct LXTALSTBIC_W<'a> {
    w: &'a mut W,
}
impl<'a> LXTALSTBIC_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: LXTALSTBIC_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Clear LXTALSTBIF flag"]
    #[inline(always)]
    pub fn clear(self) -> &'a mut W {
        self.variant(LXTALSTBIC_AW::CLEAR)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 17)) | ((value as u32 & 0x01) << 17);
        self.w
    }
}
#[doc = "IRC8M Stabilization Interrupt Clear\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum IRC8MSTBIC_AW {
    #[doc = "1: Clear IRC8MSTBIF flag"]
    CLEAR = 1,
}
impl From<IRC8MSTBIC_AW> for bool {
    #[inline(always)]
    fn from(variant: IRC8MSTBIC_AW) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `IRC8MSTBIC` writer - IRC8M Stabilization Interrupt Clear"]
pub struct IRC8MSTBIC_W<'a> {
    w: &'a mut W,
}
impl<'a> IRC8MSTBIC_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: IRC8MSTBIC_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Clear IRC8MSTBIF flag"]
    #[inline(always)]
    pub fn clear(self) -> &'a mut W {
        self.variant(IRC8MSTBIC_AW::CLEAR)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 18)) | ((value as u32 & 0x01) << 18);
        self.w
    }
}
#[doc = "HXTAL Stabilization Interrupt Clear\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum HXTALSTBIC_AW {
    #[doc = "1: Clear HXTALSTBIF flag"]
    CLEAR = 1,
}
impl From<HXTALSTBIC_AW> for bool {
    #[inline(always)]
    fn from(variant: HXTALSTBIC_AW) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `HXTALSTBIC` writer - HXTAL Stabilization Interrupt Clear"]
pub struct HXTALSTBIC_W<'a> {
    w: &'a mut W,
}
impl<'a> HXTALSTBIC_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: HXTALSTBIC_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Clear HXTALSTBIF flag"]
    #[inline(always)]
    pub fn clear(self) -> &'a mut W {
        self.variant(HXTALSTBIC_AW::CLEAR)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 19)) | ((value as u32 & 0x01) << 19);
        self.w
    }
}
#[doc = "PLL stabilization Interrupt Clear\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum PLLSTBIC_AW {
    #[doc = "1: Clear PLLSTBIF flag"]
    CLEAR = 1,
}
impl From<PLLSTBIC_AW> for bool {
    #[inline(always)]
    fn from(variant: PLLSTBIC_AW) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `PLLSTBIC` writer - PLL stabilization Interrupt Clear"]
pub struct PLLSTBIC_W<'a> {
    w: &'a mut W,
}
impl<'a> PLLSTBIC_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: PLLSTBIC_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Clear PLLSTBIF flag"]
    #[inline(always)]
    pub fn clear(self) -> &'a mut W {
        self.variant(PLLSTBIC_AW::CLEAR)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 20)) | ((value as u32 & 0x01) << 20);
        self.w
    }
}
#[doc = "IRC14M stabilization Interrupt Clear\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum IRC14MSTBIC_AW {
    #[doc = "1: Clear IRC14MSTBIF flag"]
    CLEAR = 1,
}
impl From<IRC14MSTBIC_AW> for bool {
    #[inline(always)]
    fn from(variant: IRC14MSTBIC_AW) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `IRC14MSTBIC` writer - IRC14M stabilization Interrupt Clear"]
pub struct IRC14MSTBIC_W<'a> {
    w: &'a mut W,
}
impl<'a> IRC14MSTBIC_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: IRC14MSTBIC_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Clear IRC14MSTBIF flag"]
    #[inline(always)]
    pub fn clear(self) -> &'a mut W {
        self.variant(IRC14MSTBIC_AW::CLEAR)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 21)) | ((value as u32 & 0x01) << 21);
        self.w
    }
}
#[doc = "HXTAL Clock Stuck Interrupt Clear\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum CKMIC_AW {
    #[doc = "1: Clear CKMIF flag"]
    CLEAR = 1,
}
impl From<CKMIC_AW> for bool {
    #[inline(always)]
    fn from(variant: CKMIC_AW) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `CKMIC` writer - HXTAL Clock Stuck Interrupt Clear"]
pub struct CKMIC_W<'a> {
    w: &'a mut W,
}
impl<'a> CKMIC_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CKMIC_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Clear CKMIF flag"]
    #[inline(always)]
    pub fn clear(self) -> &'a mut W {
        self.variant(CKMIC_AW::CLEAR)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 23)) | ((value as u32 & 0x01) << 23);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - IRC40K stabilization interrupt flag"]
    #[inline(always)]
    pub fn irc40kstbif(&self) -> IRC40KSTBIF_R {
        IRC40KSTBIF_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - LXTAL stabilization interrupt flag"]
    #[inline(always)]
    pub fn lxtalstbif(&self) -> LXTALSTBIF_R {
        LXTALSTBIF_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - IRC8M stabilization interrupt flag"]
    #[inline(always)]
    pub fn irc8mstbif(&self) -> IRC8MSTBIF_R {
        IRC8MSTBIF_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - HXTAL stabilization interrupt flag"]
    #[inline(always)]
    pub fn hxtalstbif(&self) -> HXTALSTBIF_R {
        HXTALSTBIF_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - PLL stabilization interrupt flag"]
    #[inline(always)]
    pub fn pllstbif(&self) -> PLLSTBIF_R {
        PLLSTBIF_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - IRC14M stabilization interrupt flag"]
    #[inline(always)]
    pub fn irc14mstbif(&self) -> IRC14MSTBIF_R {
        IRC14MSTBIF_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 7 - HXTAL Clock Stuck Interrupt Flag"]
    #[inline(always)]
    pub fn ckmif(&self) -> CKMIF_R {
        CKMIF_R::new(((self.bits >> 7) & 0x01) != 0)
    }
    #[doc = "Bit 8 - IRC40K Stabilization interrupt enable"]
    #[inline(always)]
    pub fn irc40kstbie(&self) -> IRC40KSTBIE_R {
        IRC40KSTBIE_R::new(((self.bits >> 8) & 0x01) != 0)
    }
    #[doc = "Bit 9 - LXTAL Stabilization Interrupt Enable"]
    #[inline(always)]
    pub fn lxtalstbie(&self) -> LXTALSTBIE_R {
        LXTALSTBIE_R::new(((self.bits >> 9) & 0x01) != 0)
    }
    #[doc = "Bit 10 - IRC8M Stabilization Interrupt Enable"]
    #[inline(always)]
    pub fn irc8mstbie(&self) -> IRC8MSTBIE_R {
        IRC8MSTBIE_R::new(((self.bits >> 10) & 0x01) != 0)
    }
    #[doc = "Bit 11 - HXTAL Stabilization Interrupt Enable"]
    #[inline(always)]
    pub fn hxtalstbie(&self) -> HXTALSTBIE_R {
        HXTALSTBIE_R::new(((self.bits >> 11) & 0x01) != 0)
    }
    #[doc = "Bit 12 - PLL Stabilization Interrupt Enable"]
    #[inline(always)]
    pub fn pllstbie(&self) -> PLLSTBIE_R {
        PLLSTBIE_R::new(((self.bits >> 12) & 0x01) != 0)
    }
    #[doc = "Bit 13 - IRC14M Stabilization Interrupt Enable"]
    #[inline(always)]
    pub fn irc14mstbie(&self) -> IRC14MSTBIE_R {
        IRC14MSTBIE_R::new(((self.bits >> 13) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 8 - IRC40K Stabilization interrupt enable"]
    #[inline(always)]
    pub fn irc40kstbie(&mut self) -> IRC40KSTBIE_W {
        IRC40KSTBIE_W { w: self }
    }
    #[doc = "Bit 9 - LXTAL Stabilization Interrupt Enable"]
    #[inline(always)]
    pub fn lxtalstbie(&mut self) -> LXTALSTBIE_W {
        LXTALSTBIE_W { w: self }
    }
    #[doc = "Bit 10 - IRC8M Stabilization Interrupt Enable"]
    #[inline(always)]
    pub fn irc8mstbie(&mut self) -> IRC8MSTBIE_W {
        IRC8MSTBIE_W { w: self }
    }
    #[doc = "Bit 11 - HXTAL Stabilization Interrupt Enable"]
    #[inline(always)]
    pub fn hxtalstbie(&mut self) -> HXTALSTBIE_W {
        HXTALSTBIE_W { w: self }
    }
    #[doc = "Bit 12 - PLL Stabilization Interrupt Enable"]
    #[inline(always)]
    pub fn pllstbie(&mut self) -> PLLSTBIE_W {
        PLLSTBIE_W { w: self }
    }
    #[doc = "Bit 13 - IRC14M Stabilization Interrupt Enable"]
    #[inline(always)]
    pub fn irc14mstbie(&mut self) -> IRC14MSTBIE_W {
        IRC14MSTBIE_W { w: self }
    }
    #[doc = "Bit 16 - IRC40K Stabilization Interrupt Clear"]
    #[inline(always)]
    pub fn irc40kstbic(&mut self) -> IRC40KSTBIC_W {
        IRC40KSTBIC_W { w: self }
    }
    #[doc = "Bit 17 - LXTAL Stabilization Interrupt Clear"]
    #[inline(always)]
    pub fn lxtalstbic(&mut self) -> LXTALSTBIC_W {
        LXTALSTBIC_W { w: self }
    }
    #[doc = "Bit 18 - IRC8M Stabilization Interrupt Clear"]
    #[inline(always)]
    pub fn irc8mstbic(&mut self) -> IRC8MSTBIC_W {
        IRC8MSTBIC_W { w: self }
    }
    #[doc = "Bit 19 - HXTAL Stabilization Interrupt Clear"]
    #[inline(always)]
    pub fn hxtalstbic(&mut self) -> HXTALSTBIC_W {
        HXTALSTBIC_W { w: self }
    }
    #[doc = "Bit 20 - PLL stabilization Interrupt Clear"]
    #[inline(always)]
    pub fn pllstbic(&mut self) -> PLLSTBIC_W {
        PLLSTBIC_W { w: self }
    }
    #[doc = "Bit 21 - IRC14M stabilization Interrupt Clear"]
    #[inline(always)]
    pub fn irc14mstbic(&mut self) -> IRC14MSTBIC_W {
        IRC14MSTBIC_W { w: self }
    }
    #[doc = "Bit 23 - HXTAL Clock Stuck Interrupt Clear"]
    #[inline(always)]
    pub fn ckmic(&mut self) -> CKMIC_W {
        CKMIC_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Clock interrupt register (RCU_INT)\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [int](index.html) module"]
pub struct INT_SPEC;
impl crate::RegisterSpec for INT_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [int::R](R) reader structure"]
impl crate::Readable for INT_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [int::W](W) writer structure"]
impl crate::Writable for INT_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets INT to value 0"]
impl crate::Resettable for INT_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
