#[doc = "Register `STAT` reader"]
pub struct R(crate::R<STAT_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<STAT_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::convert::From<crate::R<STAT_SPEC>> for R {
    fn from(reader: crate::R<STAT_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `STAT` writer"]
pub struct W(crate::W<STAT_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<STAT_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl core::convert::From<crate::W<STAT_SPEC>> for W {
    fn from(writer: crate::W<STAT_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "DAC0 DMA underrun flag\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum DDUDR0_A {
    #[doc = "0: No DMA underrun error condition occurred"]
    NOUNDERRUN = 0,
    #[doc = "1: DMA underrun error condition occurred"]
    UNDERRUN = 1,
}
impl From<DDUDR0_A> for bool {
    #[inline(always)]
    fn from(variant: DDUDR0_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `DDUDR0` reader - DAC0 DMA underrun flag"]
pub struct DDUDR0_R(crate::FieldReader<bool, DDUDR0_A>);
impl DDUDR0_R {
    pub(crate) fn new(bits: bool) -> Self {
        DDUDR0_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> DDUDR0_A {
        match self.bits {
            false => DDUDR0_A::NOUNDERRUN,
            true => DDUDR0_A::UNDERRUN,
        }
    }
    #[doc = "Checks if the value of the field is `NOUNDERRUN`"]
    #[inline(always)]
    pub fn is_no_underrun(&self) -> bool {
        **self == DDUDR0_A::NOUNDERRUN
    }
    #[doc = "Checks if the value of the field is `UNDERRUN`"]
    #[inline(always)]
    pub fn is_underrun(&self) -> bool {
        **self == DDUDR0_A::UNDERRUN
    }
}
impl core::ops::Deref for DDUDR0_R {
    type Target = crate::FieldReader<bool, DDUDR0_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DDUDR0` writer - DAC0 DMA underrun flag"]
pub struct DDUDR0_W<'a> {
    w: &'a mut W,
}
impl<'a> DDUDR0_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: DDUDR0_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "No DMA underrun error condition occurred"]
    #[inline(always)]
    pub fn no_underrun(self) -> &'a mut W {
        self.variant(DDUDR0_A::NOUNDERRUN)
    }
    #[doc = "DMA underrun error condition occurred"]
    #[inline(always)]
    pub fn underrun(self) -> &'a mut W {
        self.variant(DDUDR0_A::UNDERRUN)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 13)) | ((value as u32 & 0x01) << 13);
        self.w
    }
}
#[doc = "DAC1 DMA underrun flag"]
pub type DDUDR1_A = DDUDR0_A;
#[doc = "Field `DDUDR1` reader - DAC1 DMA underrun flag"]
pub type DDUDR1_R = DDUDR0_R;
#[doc = "Field `DDUDR1` writer - DAC1 DMA underrun flag"]
pub struct DDUDR1_W<'a> {
    w: &'a mut W,
}
impl<'a> DDUDR1_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: DDUDR1_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "No DMA underrun error condition occurred"]
    #[inline(always)]
    pub fn no_underrun(self) -> &'a mut W {
        self.variant(DDUDR1_A::NOUNDERRUN)
    }
    #[doc = "DMA underrun error condition occurred"]
    #[inline(always)]
    pub fn underrun(self) -> &'a mut W {
        self.variant(DDUDR1_A::UNDERRUN)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 29)) | ((value as u32 & 0x01) << 29);
        self.w
    }
}
impl R {
    #[doc = "Bit 13 - DAC0 DMA underrun flag"]
    #[inline(always)]
    pub fn ddudr0(&self) -> DDUDR0_R {
        DDUDR0_R::new(((self.bits >> 13) & 0x01) != 0)
    }
    #[doc = "Bit 29 - DAC1 DMA underrun flag"]
    #[inline(always)]
    pub fn ddudr1(&self) -> DDUDR1_R {
        DDUDR1_R::new(((self.bits >> 29) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 13 - DAC0 DMA underrun flag"]
    #[inline(always)]
    pub fn ddudr0(&mut self) -> DDUDR0_W {
        DDUDR0_W { w: self }
    }
    #[doc = "Bit 29 - DAC1 DMA underrun flag"]
    #[inline(always)]
    pub fn ddudr1(&mut self) -> DDUDR1_W {
        DDUDR1_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "status register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [stat](index.html) module"]
pub struct STAT_SPEC;
impl crate::RegisterSpec for STAT_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [stat::R](R) reader structure"]
impl crate::Readable for STAT_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [stat::W](W) writer structure"]
impl crate::Writable for STAT_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets STAT to value 0"]
impl crate::Resettable for STAT_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
