#[doc = "Register `INTF` reader"]
pub struct R(crate::R<INTF_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<INTF_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::convert::From<crate::R<INTF_SPEC>> for R {
    fn from(reader: crate::R<INTF_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `INTF` writer"]
pub struct W(crate::W<INTF_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<INTF_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl core::convert::From<crate::W<INTF_SPEC>> for W {
    fn from(writer: crate::W<INTF_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `TAERR` reader - Tx ACK Error flag"]
pub struct TAERR_R(crate::FieldReader<bool, bool>);
impl TAERR_R {
    pub(crate) fn new(bits: bool) -> Self {
        TAERR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TAERR_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TAERR` writer - Tx ACK Error flag"]
pub struct TAERR_W<'a> {
    w: &'a mut W,
}
impl<'a> TAERR_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 12)) | ((value as u32 & 0x01) << 12);
        self.w
    }
}
#[doc = "Field `TERR` reader - Tx-Error"]
pub struct TERR_R(crate::FieldReader<bool, bool>);
impl TERR_R {
    pub(crate) fn new(bits: bool) -> Self {
        TERR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TERR_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TERR` writer - Tx-Error"]
pub struct TERR_W<'a> {
    w: &'a mut W,
}
impl<'a> TERR_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 11)) | ((value as u32 & 0x01) << 11);
        self.w
    }
}
#[doc = "Field `TU` reader - Tx data buffer underrun"]
pub struct TU_R(crate::FieldReader<bool, bool>);
impl TU_R {
    pub(crate) fn new(bits: bool) -> Self {
        TU_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TU_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TU` writer - Tx data buffer underrun"]
pub struct TU_W<'a> {
    w: &'a mut W,
}
impl<'a> TU_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 10)) | ((value as u32 & 0x01) << 10);
        self.w
    }
}
#[doc = "Field `TEND` reader - Transmission successfully end"]
pub struct TEND_R(crate::FieldReader<bool, bool>);
impl TEND_R {
    pub(crate) fn new(bits: bool) -> Self {
        TEND_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TEND_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TEND` writer - Transmission successfully end"]
pub struct TEND_W<'a> {
    w: &'a mut W,
}
impl<'a> TEND_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 9)) | ((value as u32 & 0x01) << 9);
        self.w
    }
}
#[doc = "Field `TBR` reader - Tx-Byte data request"]
pub struct TBR_R(crate::FieldReader<bool, bool>);
impl TBR_R {
    pub(crate) fn new(bits: bool) -> Self {
        TBR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TBR_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TBR` writer - Tx-Byte data request"]
pub struct TBR_W<'a> {
    w: &'a mut W,
}
impl<'a> TBR_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 8)) | ((value as u32 & 0x01) << 8);
        self.w
    }
}
#[doc = "Field `LSTARB` reader - Arbitration lost"]
pub struct LSTARB_R(crate::FieldReader<bool, bool>);
impl LSTARB_R {
    pub(crate) fn new(bits: bool) -> Self {
        LSTARB_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LSTARB_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LSTARB` writer - Arbitration lost"]
pub struct LSTARB_W<'a> {
    w: &'a mut W,
}
impl<'a> LSTARB_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u32 & 0x01) << 7);
        self.w
    }
}
#[doc = "Field `RAE` reader - Rx ACK Error"]
pub struct RAE_R(crate::FieldReader<bool, bool>);
impl RAE_R {
    pub(crate) fn new(bits: bool) -> Self {
        RAE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RAE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RAE` writer - Rx ACK Error"]
pub struct RAE_W<'a> {
    w: &'a mut W,
}
impl<'a> RAE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u32 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `RLBPE` reader - Long Bit Period Error"]
pub struct RLBPE_R(crate::FieldReader<bool, bool>);
impl RLBPE_R {
    pub(crate) fn new(bits: bool) -> Self {
        RLBPE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RLBPE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RLBPE` writer - Long Bit Period Error"]
pub struct RLBPE_W<'a> {
    w: &'a mut W,
}
impl<'a> RLBPE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u32 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `RSBPE` reader - Short Bit Period Error"]
pub struct RSBPE_R(crate::FieldReader<bool, bool>);
impl RSBPE_R {
    pub(crate) fn new(bits: bool) -> Self {
        RSBPE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RSBPE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RSBPE` writer - Short Bit Period Error"]
pub struct RSBPE_W<'a> {
    w: &'a mut W,
}
impl<'a> RSBPE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u32 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `RBRE` reader - Bit Rising Error"]
pub struct RBRE_R(crate::FieldReader<bool, bool>);
impl RBRE_R {
    pub(crate) fn new(bits: bool) -> Self {
        RBRE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RBRE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RBRE` writer - Bit Rising Error"]
pub struct RBRE_W<'a> {
    w: &'a mut W,
}
impl<'a> RBRE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u32 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `RO` reader - RX Overrun"]
pub struct RO_R(crate::FieldReader<bool, bool>);
impl RO_R {
    pub(crate) fn new(bits: bool) -> Self {
        RO_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RO_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RO` writer - RX Overrun"]
pub struct RO_W<'a> {
    w: &'a mut W,
}
impl<'a> RO_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u32 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `REND` reader - End of Reception"]
pub struct REND_R(crate::FieldReader<bool, bool>);
impl REND_R {
    pub(crate) fn new(bits: bool) -> Self {
        REND_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for REND_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `REND` writer - End of Reception"]
pub struct REND_W<'a> {
    w: &'a mut W,
}
impl<'a> REND_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `RBR` reader - Rx-Byte data received"]
pub struct RBR_R(crate::FieldReader<bool, bool>);
impl RBR_R {
    pub(crate) fn new(bits: bool) -> Self {
        RBR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RBR_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RBR` writer - Rx-Byte data received"]
pub struct RBR_W<'a> {
    w: &'a mut W,
}
impl<'a> RBR_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
impl R {
    #[doc = "Bit 12 - Tx ACK Error flag"]
    #[inline(always)]
    pub fn taerr(&self) -> TAERR_R {
        TAERR_R::new(((self.bits >> 12) & 0x01) != 0)
    }
    #[doc = "Bit 11 - Tx-Error"]
    #[inline(always)]
    pub fn terr(&self) -> TERR_R {
        TERR_R::new(((self.bits >> 11) & 0x01) != 0)
    }
    #[doc = "Bit 10 - Tx data buffer underrun"]
    #[inline(always)]
    pub fn tu(&self) -> TU_R {
        TU_R::new(((self.bits >> 10) & 0x01) != 0)
    }
    #[doc = "Bit 9 - Transmission successfully end"]
    #[inline(always)]
    pub fn tend(&self) -> TEND_R {
        TEND_R::new(((self.bits >> 9) & 0x01) != 0)
    }
    #[doc = "Bit 8 - Tx-Byte data request"]
    #[inline(always)]
    pub fn tbr(&self) -> TBR_R {
        TBR_R::new(((self.bits >> 8) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Arbitration lost"]
    #[inline(always)]
    pub fn lstarb(&self) -> LSTARB_R {
        LSTARB_R::new(((self.bits >> 7) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Rx ACK Error"]
    #[inline(always)]
    pub fn rae(&self) -> RAE_R {
        RAE_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Long Bit Period Error"]
    #[inline(always)]
    pub fn rlbpe(&self) -> RLBPE_R {
        RLBPE_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Short Bit Period Error"]
    #[inline(always)]
    pub fn rsbpe(&self) -> RSBPE_R {
        RSBPE_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Bit Rising Error"]
    #[inline(always)]
    pub fn rbre(&self) -> RBRE_R {
        RBRE_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 2 - RX Overrun"]
    #[inline(always)]
    pub fn ro(&self) -> RO_R {
        RO_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 1 - End of Reception"]
    #[inline(always)]
    pub fn rend(&self) -> REND_R {
        REND_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 0 - Rx-Byte data received"]
    #[inline(always)]
    pub fn rbr(&self) -> RBR_R {
        RBR_R::new((self.bits & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 12 - Tx ACK Error flag"]
    #[inline(always)]
    pub fn taerr(&mut self) -> TAERR_W {
        TAERR_W { w: self }
    }
    #[doc = "Bit 11 - Tx-Error"]
    #[inline(always)]
    pub fn terr(&mut self) -> TERR_W {
        TERR_W { w: self }
    }
    #[doc = "Bit 10 - Tx data buffer underrun"]
    #[inline(always)]
    pub fn tu(&mut self) -> TU_W {
        TU_W { w: self }
    }
    #[doc = "Bit 9 - Transmission successfully end"]
    #[inline(always)]
    pub fn tend(&mut self) -> TEND_W {
        TEND_W { w: self }
    }
    #[doc = "Bit 8 - Tx-Byte data request"]
    #[inline(always)]
    pub fn tbr(&mut self) -> TBR_W {
        TBR_W { w: self }
    }
    #[doc = "Bit 7 - Arbitration lost"]
    #[inline(always)]
    pub fn lstarb(&mut self) -> LSTARB_W {
        LSTARB_W { w: self }
    }
    #[doc = "Bit 6 - Rx ACK Error"]
    #[inline(always)]
    pub fn rae(&mut self) -> RAE_W {
        RAE_W { w: self }
    }
    #[doc = "Bit 5 - Long Bit Period Error"]
    #[inline(always)]
    pub fn rlbpe(&mut self) -> RLBPE_W {
        RLBPE_W { w: self }
    }
    #[doc = "Bit 4 - Short Bit Period Error"]
    #[inline(always)]
    pub fn rsbpe(&mut self) -> RSBPE_W {
        RSBPE_W { w: self }
    }
    #[doc = "Bit 3 - Bit Rising Error"]
    #[inline(always)]
    pub fn rbre(&mut self) -> RBRE_W {
        RBRE_W { w: self }
    }
    #[doc = "Bit 2 - RX Overrun"]
    #[inline(always)]
    pub fn ro(&mut self) -> RO_W {
        RO_W { w: self }
    }
    #[doc = "Bit 1 - End of Reception"]
    #[inline(always)]
    pub fn rend(&mut self) -> REND_W {
        REND_W { w: self }
    }
    #[doc = "Bit 0 - Rx-Byte data received"]
    #[inline(always)]
    pub fn rbr(&mut self) -> RBR_W {
        RBR_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Interrupt Flag Register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [intf](index.html) module"]
pub struct INTF_SPEC;
impl crate::RegisterSpec for INTF_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [intf::R](R) reader structure"]
impl crate::Readable for INTF_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [intf::W](W) writer structure"]
impl crate::Writable for INTF_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets INTF to value 0"]
impl crate::Resettable for INTF_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
