#[doc = "Register `FMCFG` reader"]
pub struct R(crate::R<FMCFG_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<FMCFG_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::convert::From<crate::R<FMCFG_SPEC>> for R {
    fn from(reader: crate::R<FMCFG_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `FMCFG` writer"]
pub struct W(crate::W<FMCFG_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<FMCFG_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl core::convert::From<crate::W<FMCFG_SPEC>> for W {
    fn from(writer: crate::W<FMCFG_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Filter mode\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum FMOD27_A {
    #[doc = "0: Mask mode"]
    MASK = 0,
    #[doc = "1: List mode"]
    LIST = 1,
}
impl From<FMOD27_A> for bool {
    #[inline(always)]
    fn from(variant: FMOD27_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `FMOD27` reader - Filter mode"]
pub struct FMOD27_R(crate::FieldReader<bool, FMOD27_A>);
impl FMOD27_R {
    pub(crate) fn new(bits: bool) -> Self {
        FMOD27_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> FMOD27_A {
        match self.bits {
            false => FMOD27_A::MASK,
            true => FMOD27_A::LIST,
        }
    }
    #[doc = "Checks if the value of the field is `MASK`"]
    #[inline(always)]
    pub fn is_mask(&self) -> bool {
        **self == FMOD27_A::MASK
    }
    #[doc = "Checks if the value of the field is `LIST`"]
    #[inline(always)]
    pub fn is_list(&self) -> bool {
        **self == FMOD27_A::LIST
    }
}
impl core::ops::Deref for FMOD27_R {
    type Target = crate::FieldReader<bool, FMOD27_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FMOD27` writer - Filter mode"]
pub struct FMOD27_W<'a> {
    w: &'a mut W,
}
impl<'a> FMOD27_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FMOD27_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Mask mode"]
    #[inline(always)]
    pub fn mask(self) -> &'a mut W {
        self.variant(FMOD27_A::MASK)
    }
    #[doc = "List mode"]
    #[inline(always)]
    pub fn list(self) -> &'a mut W {
        self.variant(FMOD27_A::LIST)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 27)) | ((value as u32 & 0x01) << 27);
        self.w
    }
}
#[doc = "Filter mode"]
pub type FMOD26_A = FMOD27_A;
#[doc = "Field `FMOD26` reader - Filter mode"]
pub type FMOD26_R = FMOD27_R;
#[doc = "Field `FMOD26` writer - Filter mode"]
pub struct FMOD26_W<'a> {
    w: &'a mut W,
}
impl<'a> FMOD26_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FMOD26_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Mask mode"]
    #[inline(always)]
    pub fn mask(self) -> &'a mut W {
        self.variant(FMOD26_A::MASK)
    }
    #[doc = "List mode"]
    #[inline(always)]
    pub fn list(self) -> &'a mut W {
        self.variant(FMOD26_A::LIST)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 26)) | ((value as u32 & 0x01) << 26);
        self.w
    }
}
#[doc = "Filter mode"]
pub type FMOD25_A = FMOD27_A;
#[doc = "Field `FMOD25` reader - Filter mode"]
pub type FMOD25_R = FMOD27_R;
#[doc = "Field `FMOD25` writer - Filter mode"]
pub struct FMOD25_W<'a> {
    w: &'a mut W,
}
impl<'a> FMOD25_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FMOD25_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Mask mode"]
    #[inline(always)]
    pub fn mask(self) -> &'a mut W {
        self.variant(FMOD25_A::MASK)
    }
    #[doc = "List mode"]
    #[inline(always)]
    pub fn list(self) -> &'a mut W {
        self.variant(FMOD25_A::LIST)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 25)) | ((value as u32 & 0x01) << 25);
        self.w
    }
}
#[doc = "Filter mode"]
pub type FMOD24_A = FMOD27_A;
#[doc = "Field `FMOD24` reader - Filter mode"]
pub type FMOD24_R = FMOD27_R;
#[doc = "Field `FMOD24` writer - Filter mode"]
pub struct FMOD24_W<'a> {
    w: &'a mut W,
}
impl<'a> FMOD24_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FMOD24_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Mask mode"]
    #[inline(always)]
    pub fn mask(self) -> &'a mut W {
        self.variant(FMOD24_A::MASK)
    }
    #[doc = "List mode"]
    #[inline(always)]
    pub fn list(self) -> &'a mut W {
        self.variant(FMOD24_A::LIST)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 24)) | ((value as u32 & 0x01) << 24);
        self.w
    }
}
#[doc = "Filter mode"]
pub type FMOD23_A = FMOD27_A;
#[doc = "Field `FMOD23` reader - Filter mode"]
pub type FMOD23_R = FMOD27_R;
#[doc = "Field `FMOD23` writer - Filter mode"]
pub struct FMOD23_W<'a> {
    w: &'a mut W,
}
impl<'a> FMOD23_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FMOD23_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Mask mode"]
    #[inline(always)]
    pub fn mask(self) -> &'a mut W {
        self.variant(FMOD23_A::MASK)
    }
    #[doc = "List mode"]
    #[inline(always)]
    pub fn list(self) -> &'a mut W {
        self.variant(FMOD23_A::LIST)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 23)) | ((value as u32 & 0x01) << 23);
        self.w
    }
}
#[doc = "Filter mode"]
pub type FMOD22_A = FMOD27_A;
#[doc = "Field `FMOD22` reader - Filter mode"]
pub type FMOD22_R = FMOD27_R;
#[doc = "Field `FMOD22` writer - Filter mode"]
pub struct FMOD22_W<'a> {
    w: &'a mut W,
}
impl<'a> FMOD22_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FMOD22_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Mask mode"]
    #[inline(always)]
    pub fn mask(self) -> &'a mut W {
        self.variant(FMOD22_A::MASK)
    }
    #[doc = "List mode"]
    #[inline(always)]
    pub fn list(self) -> &'a mut W {
        self.variant(FMOD22_A::LIST)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 22)) | ((value as u32 & 0x01) << 22);
        self.w
    }
}
#[doc = "Filter mode"]
pub type FMOD21_A = FMOD27_A;
#[doc = "Field `FMOD21` reader - Filter mode"]
pub type FMOD21_R = FMOD27_R;
#[doc = "Field `FMOD21` writer - Filter mode"]
pub struct FMOD21_W<'a> {
    w: &'a mut W,
}
impl<'a> FMOD21_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FMOD21_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Mask mode"]
    #[inline(always)]
    pub fn mask(self) -> &'a mut W {
        self.variant(FMOD21_A::MASK)
    }
    #[doc = "List mode"]
    #[inline(always)]
    pub fn list(self) -> &'a mut W {
        self.variant(FMOD21_A::LIST)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 21)) | ((value as u32 & 0x01) << 21);
        self.w
    }
}
#[doc = "Filter mode"]
pub type FMOD20_A = FMOD27_A;
#[doc = "Field `FMOD20` reader - Filter mode"]
pub type FMOD20_R = FMOD27_R;
#[doc = "Field `FMOD20` writer - Filter mode"]
pub struct FMOD20_W<'a> {
    w: &'a mut W,
}
impl<'a> FMOD20_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FMOD20_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Mask mode"]
    #[inline(always)]
    pub fn mask(self) -> &'a mut W {
        self.variant(FMOD20_A::MASK)
    }
    #[doc = "List mode"]
    #[inline(always)]
    pub fn list(self) -> &'a mut W {
        self.variant(FMOD20_A::LIST)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 20)) | ((value as u32 & 0x01) << 20);
        self.w
    }
}
#[doc = "Filter mode"]
pub type FMOD19_A = FMOD27_A;
#[doc = "Field `FMOD19` reader - Filter mode"]
pub type FMOD19_R = FMOD27_R;
#[doc = "Field `FMOD19` writer - Filter mode"]
pub struct FMOD19_W<'a> {
    w: &'a mut W,
}
impl<'a> FMOD19_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FMOD19_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Mask mode"]
    #[inline(always)]
    pub fn mask(self) -> &'a mut W {
        self.variant(FMOD19_A::MASK)
    }
    #[doc = "List mode"]
    #[inline(always)]
    pub fn list(self) -> &'a mut W {
        self.variant(FMOD19_A::LIST)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 19)) | ((value as u32 & 0x01) << 19);
        self.w
    }
}
#[doc = "Filter mode"]
pub type FMOD18_A = FMOD27_A;
#[doc = "Field `FMOD18` reader - Filter mode"]
pub type FMOD18_R = FMOD27_R;
#[doc = "Field `FMOD18` writer - Filter mode"]
pub struct FMOD18_W<'a> {
    w: &'a mut W,
}
impl<'a> FMOD18_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FMOD18_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Mask mode"]
    #[inline(always)]
    pub fn mask(self) -> &'a mut W {
        self.variant(FMOD18_A::MASK)
    }
    #[doc = "List mode"]
    #[inline(always)]
    pub fn list(self) -> &'a mut W {
        self.variant(FMOD18_A::LIST)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 18)) | ((value as u32 & 0x01) << 18);
        self.w
    }
}
#[doc = "Filter mode"]
pub type FMOD17_A = FMOD27_A;
#[doc = "Field `FMOD17` reader - Filter mode"]
pub type FMOD17_R = FMOD27_R;
#[doc = "Field `FMOD17` writer - Filter mode"]
pub struct FMOD17_W<'a> {
    w: &'a mut W,
}
impl<'a> FMOD17_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FMOD17_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Mask mode"]
    #[inline(always)]
    pub fn mask(self) -> &'a mut W {
        self.variant(FMOD17_A::MASK)
    }
    #[doc = "List mode"]
    #[inline(always)]
    pub fn list(self) -> &'a mut W {
        self.variant(FMOD17_A::LIST)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 17)) | ((value as u32 & 0x01) << 17);
        self.w
    }
}
#[doc = "Filter mode"]
pub type FMOD16_A = FMOD27_A;
#[doc = "Field `FMOD16` reader - Filter mode"]
pub type FMOD16_R = FMOD27_R;
#[doc = "Field `FMOD16` writer - Filter mode"]
pub struct FMOD16_W<'a> {
    w: &'a mut W,
}
impl<'a> FMOD16_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FMOD16_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Mask mode"]
    #[inline(always)]
    pub fn mask(self) -> &'a mut W {
        self.variant(FMOD16_A::MASK)
    }
    #[doc = "List mode"]
    #[inline(always)]
    pub fn list(self) -> &'a mut W {
        self.variant(FMOD16_A::LIST)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 16)) | ((value as u32 & 0x01) << 16);
        self.w
    }
}
#[doc = "Filter mode"]
pub type FMOD15_A = FMOD27_A;
#[doc = "Field `FMOD15` reader - Filter mode"]
pub type FMOD15_R = FMOD27_R;
#[doc = "Field `FMOD15` writer - Filter mode"]
pub struct FMOD15_W<'a> {
    w: &'a mut W,
}
impl<'a> FMOD15_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FMOD15_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Mask mode"]
    #[inline(always)]
    pub fn mask(self) -> &'a mut W {
        self.variant(FMOD15_A::MASK)
    }
    #[doc = "List mode"]
    #[inline(always)]
    pub fn list(self) -> &'a mut W {
        self.variant(FMOD15_A::LIST)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 15)) | ((value as u32 & 0x01) << 15);
        self.w
    }
}
#[doc = "Filter mode"]
pub type FMOD14_A = FMOD27_A;
#[doc = "Field `FMOD14` reader - Filter mode"]
pub type FMOD14_R = FMOD27_R;
#[doc = "Field `FMOD14` writer - Filter mode"]
pub struct FMOD14_W<'a> {
    w: &'a mut W,
}
impl<'a> FMOD14_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FMOD14_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Mask mode"]
    #[inline(always)]
    pub fn mask(self) -> &'a mut W {
        self.variant(FMOD14_A::MASK)
    }
    #[doc = "List mode"]
    #[inline(always)]
    pub fn list(self) -> &'a mut W {
        self.variant(FMOD14_A::LIST)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 14)) | ((value as u32 & 0x01) << 14);
        self.w
    }
}
#[doc = "Filter mode"]
pub type FMOD13_A = FMOD27_A;
#[doc = "Field `FMOD13` reader - Filter mode"]
pub type FMOD13_R = FMOD27_R;
#[doc = "Field `FMOD13` writer - Filter mode"]
pub struct FMOD13_W<'a> {
    w: &'a mut W,
}
impl<'a> FMOD13_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FMOD13_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Mask mode"]
    #[inline(always)]
    pub fn mask(self) -> &'a mut W {
        self.variant(FMOD13_A::MASK)
    }
    #[doc = "List mode"]
    #[inline(always)]
    pub fn list(self) -> &'a mut W {
        self.variant(FMOD13_A::LIST)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 13)) | ((value as u32 & 0x01) << 13);
        self.w
    }
}
#[doc = "Filter mode"]
pub type FMOD12_A = FMOD27_A;
#[doc = "Field `FMOD12` reader - Filter mode"]
pub type FMOD12_R = FMOD27_R;
#[doc = "Field `FMOD12` writer - Filter mode"]
pub struct FMOD12_W<'a> {
    w: &'a mut W,
}
impl<'a> FMOD12_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FMOD12_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Mask mode"]
    #[inline(always)]
    pub fn mask(self) -> &'a mut W {
        self.variant(FMOD12_A::MASK)
    }
    #[doc = "List mode"]
    #[inline(always)]
    pub fn list(self) -> &'a mut W {
        self.variant(FMOD12_A::LIST)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 12)) | ((value as u32 & 0x01) << 12);
        self.w
    }
}
#[doc = "Filter mode"]
pub type FMOD11_A = FMOD27_A;
#[doc = "Field `FMOD11` reader - Filter mode"]
pub type FMOD11_R = FMOD27_R;
#[doc = "Field `FMOD11` writer - Filter mode"]
pub struct FMOD11_W<'a> {
    w: &'a mut W,
}
impl<'a> FMOD11_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FMOD11_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Mask mode"]
    #[inline(always)]
    pub fn mask(self) -> &'a mut W {
        self.variant(FMOD11_A::MASK)
    }
    #[doc = "List mode"]
    #[inline(always)]
    pub fn list(self) -> &'a mut W {
        self.variant(FMOD11_A::LIST)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 11)) | ((value as u32 & 0x01) << 11);
        self.w
    }
}
#[doc = "Filter mode"]
pub type FMOD10_A = FMOD27_A;
#[doc = "Field `FMOD10` reader - Filter mode"]
pub type FMOD10_R = FMOD27_R;
#[doc = "Field `FMOD10` writer - Filter mode"]
pub struct FMOD10_W<'a> {
    w: &'a mut W,
}
impl<'a> FMOD10_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FMOD10_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Mask mode"]
    #[inline(always)]
    pub fn mask(self) -> &'a mut W {
        self.variant(FMOD10_A::MASK)
    }
    #[doc = "List mode"]
    #[inline(always)]
    pub fn list(self) -> &'a mut W {
        self.variant(FMOD10_A::LIST)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 10)) | ((value as u32 & 0x01) << 10);
        self.w
    }
}
#[doc = "Filter mode"]
pub type FMOD9_A = FMOD27_A;
#[doc = "Field `FMOD9` reader - Filter mode"]
pub type FMOD9_R = FMOD27_R;
#[doc = "Field `FMOD9` writer - Filter mode"]
pub struct FMOD9_W<'a> {
    w: &'a mut W,
}
impl<'a> FMOD9_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FMOD9_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Mask mode"]
    #[inline(always)]
    pub fn mask(self) -> &'a mut W {
        self.variant(FMOD9_A::MASK)
    }
    #[doc = "List mode"]
    #[inline(always)]
    pub fn list(self) -> &'a mut W {
        self.variant(FMOD9_A::LIST)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 9)) | ((value as u32 & 0x01) << 9);
        self.w
    }
}
#[doc = "Filter mode"]
pub type FMOD8_A = FMOD27_A;
#[doc = "Field `FMOD8` reader - Filter mode"]
pub type FMOD8_R = FMOD27_R;
#[doc = "Field `FMOD8` writer - Filter mode"]
pub struct FMOD8_W<'a> {
    w: &'a mut W,
}
impl<'a> FMOD8_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FMOD8_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Mask mode"]
    #[inline(always)]
    pub fn mask(self) -> &'a mut W {
        self.variant(FMOD8_A::MASK)
    }
    #[doc = "List mode"]
    #[inline(always)]
    pub fn list(self) -> &'a mut W {
        self.variant(FMOD8_A::LIST)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 8)) | ((value as u32 & 0x01) << 8);
        self.w
    }
}
#[doc = "Filter mode"]
pub type FMOD7_A = FMOD27_A;
#[doc = "Field `FMOD7` reader - Filter mode"]
pub type FMOD7_R = FMOD27_R;
#[doc = "Field `FMOD7` writer - Filter mode"]
pub struct FMOD7_W<'a> {
    w: &'a mut W,
}
impl<'a> FMOD7_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FMOD7_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Mask mode"]
    #[inline(always)]
    pub fn mask(self) -> &'a mut W {
        self.variant(FMOD7_A::MASK)
    }
    #[doc = "List mode"]
    #[inline(always)]
    pub fn list(self) -> &'a mut W {
        self.variant(FMOD7_A::LIST)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u32 & 0x01) << 7);
        self.w
    }
}
#[doc = "Filter mode"]
pub type FMOD6_A = FMOD27_A;
#[doc = "Field `FMOD6` reader - Filter mode"]
pub type FMOD6_R = FMOD27_R;
#[doc = "Field `FMOD6` writer - Filter mode"]
pub struct FMOD6_W<'a> {
    w: &'a mut W,
}
impl<'a> FMOD6_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FMOD6_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Mask mode"]
    #[inline(always)]
    pub fn mask(self) -> &'a mut W {
        self.variant(FMOD6_A::MASK)
    }
    #[doc = "List mode"]
    #[inline(always)]
    pub fn list(self) -> &'a mut W {
        self.variant(FMOD6_A::LIST)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u32 & 0x01) << 6);
        self.w
    }
}
#[doc = "Filter mode"]
pub type FMOD5_A = FMOD27_A;
#[doc = "Field `FMOD5` reader - Filter mode"]
pub type FMOD5_R = FMOD27_R;
#[doc = "Field `FMOD5` writer - Filter mode"]
pub struct FMOD5_W<'a> {
    w: &'a mut W,
}
impl<'a> FMOD5_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FMOD5_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Mask mode"]
    #[inline(always)]
    pub fn mask(self) -> &'a mut W {
        self.variant(FMOD5_A::MASK)
    }
    #[doc = "List mode"]
    #[inline(always)]
    pub fn list(self) -> &'a mut W {
        self.variant(FMOD5_A::LIST)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u32 & 0x01) << 5);
        self.w
    }
}
#[doc = "Filter mode"]
pub type FMOD4_A = FMOD27_A;
#[doc = "Field `FMOD4` reader - Filter mode"]
pub type FMOD4_R = FMOD27_R;
#[doc = "Field `FMOD4` writer - Filter mode"]
pub struct FMOD4_W<'a> {
    w: &'a mut W,
}
impl<'a> FMOD4_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FMOD4_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Mask mode"]
    #[inline(always)]
    pub fn mask(self) -> &'a mut W {
        self.variant(FMOD4_A::MASK)
    }
    #[doc = "List mode"]
    #[inline(always)]
    pub fn list(self) -> &'a mut W {
        self.variant(FMOD4_A::LIST)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u32 & 0x01) << 4);
        self.w
    }
}
#[doc = "Filter mode"]
pub type FMOD3_A = FMOD27_A;
#[doc = "Field `FMOD3` reader - Filter mode"]
pub type FMOD3_R = FMOD27_R;
#[doc = "Field `FMOD3` writer - Filter mode"]
pub struct FMOD3_W<'a> {
    w: &'a mut W,
}
impl<'a> FMOD3_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FMOD3_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Mask mode"]
    #[inline(always)]
    pub fn mask(self) -> &'a mut W {
        self.variant(FMOD3_A::MASK)
    }
    #[doc = "List mode"]
    #[inline(always)]
    pub fn list(self) -> &'a mut W {
        self.variant(FMOD3_A::LIST)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u32 & 0x01) << 3);
        self.w
    }
}
#[doc = "Filter mode"]
pub type FMOD2_A = FMOD27_A;
#[doc = "Field `FMOD2` reader - Filter mode"]
pub type FMOD2_R = FMOD27_R;
#[doc = "Field `FMOD2` writer - Filter mode"]
pub struct FMOD2_W<'a> {
    w: &'a mut W,
}
impl<'a> FMOD2_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FMOD2_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Mask mode"]
    #[inline(always)]
    pub fn mask(self) -> &'a mut W {
        self.variant(FMOD2_A::MASK)
    }
    #[doc = "List mode"]
    #[inline(always)]
    pub fn list(self) -> &'a mut W {
        self.variant(FMOD2_A::LIST)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u32 & 0x01) << 2);
        self.w
    }
}
#[doc = "Filter mode"]
pub type FMOD1_A = FMOD27_A;
#[doc = "Field `FMOD1` reader - Filter mode"]
pub type FMOD1_R = FMOD27_R;
#[doc = "Field `FMOD1` writer - Filter mode"]
pub struct FMOD1_W<'a> {
    w: &'a mut W,
}
impl<'a> FMOD1_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FMOD1_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Mask mode"]
    #[inline(always)]
    pub fn mask(self) -> &'a mut W {
        self.variant(FMOD1_A::MASK)
    }
    #[doc = "List mode"]
    #[inline(always)]
    pub fn list(self) -> &'a mut W {
        self.variant(FMOD1_A::LIST)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "Filter mode"]
pub type FMOD0_A = FMOD27_A;
#[doc = "Field `FMOD0` reader - Filter mode"]
pub type FMOD0_R = FMOD27_R;
#[doc = "Field `FMOD0` writer - Filter mode"]
pub struct FMOD0_W<'a> {
    w: &'a mut W,
}
impl<'a> FMOD0_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FMOD0_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Mask mode"]
    #[inline(always)]
    pub fn mask(self) -> &'a mut W {
        self.variant(FMOD0_A::MASK)
    }
    #[doc = "List mode"]
    #[inline(always)]
    pub fn list(self) -> &'a mut W {
        self.variant(FMOD0_A::LIST)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
impl R {
    #[doc = "Bit 27 - Filter mode"]
    #[inline(always)]
    pub fn fmod27(&self) -> FMOD27_R {
        FMOD27_R::new(((self.bits >> 27) & 0x01) != 0)
    }
    #[doc = "Bit 26 - Filter mode"]
    #[inline(always)]
    pub fn fmod26(&self) -> FMOD26_R {
        FMOD26_R::new(((self.bits >> 26) & 0x01) != 0)
    }
    #[doc = "Bit 25 - Filter mode"]
    #[inline(always)]
    pub fn fmod25(&self) -> FMOD25_R {
        FMOD25_R::new(((self.bits >> 25) & 0x01) != 0)
    }
    #[doc = "Bit 24 - Filter mode"]
    #[inline(always)]
    pub fn fmod24(&self) -> FMOD24_R {
        FMOD24_R::new(((self.bits >> 24) & 0x01) != 0)
    }
    #[doc = "Bit 23 - Filter mode"]
    #[inline(always)]
    pub fn fmod23(&self) -> FMOD23_R {
        FMOD23_R::new(((self.bits >> 23) & 0x01) != 0)
    }
    #[doc = "Bit 22 - Filter mode"]
    #[inline(always)]
    pub fn fmod22(&self) -> FMOD22_R {
        FMOD22_R::new(((self.bits >> 22) & 0x01) != 0)
    }
    #[doc = "Bit 21 - Filter mode"]
    #[inline(always)]
    pub fn fmod21(&self) -> FMOD21_R {
        FMOD21_R::new(((self.bits >> 21) & 0x01) != 0)
    }
    #[doc = "Bit 20 - Filter mode"]
    #[inline(always)]
    pub fn fmod20(&self) -> FMOD20_R {
        FMOD20_R::new(((self.bits >> 20) & 0x01) != 0)
    }
    #[doc = "Bit 19 - Filter mode"]
    #[inline(always)]
    pub fn fmod19(&self) -> FMOD19_R {
        FMOD19_R::new(((self.bits >> 19) & 0x01) != 0)
    }
    #[doc = "Bit 18 - Filter mode"]
    #[inline(always)]
    pub fn fmod18(&self) -> FMOD18_R {
        FMOD18_R::new(((self.bits >> 18) & 0x01) != 0)
    }
    #[doc = "Bit 17 - Filter mode"]
    #[inline(always)]
    pub fn fmod17(&self) -> FMOD17_R {
        FMOD17_R::new(((self.bits >> 17) & 0x01) != 0)
    }
    #[doc = "Bit 16 - Filter mode"]
    #[inline(always)]
    pub fn fmod16(&self) -> FMOD16_R {
        FMOD16_R::new(((self.bits >> 16) & 0x01) != 0)
    }
    #[doc = "Bit 15 - Filter mode"]
    #[inline(always)]
    pub fn fmod15(&self) -> FMOD15_R {
        FMOD15_R::new(((self.bits >> 15) & 0x01) != 0)
    }
    #[doc = "Bit 14 - Filter mode"]
    #[inline(always)]
    pub fn fmod14(&self) -> FMOD14_R {
        FMOD14_R::new(((self.bits >> 14) & 0x01) != 0)
    }
    #[doc = "Bit 13 - Filter mode"]
    #[inline(always)]
    pub fn fmod13(&self) -> FMOD13_R {
        FMOD13_R::new(((self.bits >> 13) & 0x01) != 0)
    }
    #[doc = "Bit 12 - Filter mode"]
    #[inline(always)]
    pub fn fmod12(&self) -> FMOD12_R {
        FMOD12_R::new(((self.bits >> 12) & 0x01) != 0)
    }
    #[doc = "Bit 11 - Filter mode"]
    #[inline(always)]
    pub fn fmod11(&self) -> FMOD11_R {
        FMOD11_R::new(((self.bits >> 11) & 0x01) != 0)
    }
    #[doc = "Bit 10 - Filter mode"]
    #[inline(always)]
    pub fn fmod10(&self) -> FMOD10_R {
        FMOD10_R::new(((self.bits >> 10) & 0x01) != 0)
    }
    #[doc = "Bit 9 - Filter mode"]
    #[inline(always)]
    pub fn fmod9(&self) -> FMOD9_R {
        FMOD9_R::new(((self.bits >> 9) & 0x01) != 0)
    }
    #[doc = "Bit 8 - Filter mode"]
    #[inline(always)]
    pub fn fmod8(&self) -> FMOD8_R {
        FMOD8_R::new(((self.bits >> 8) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Filter mode"]
    #[inline(always)]
    pub fn fmod7(&self) -> FMOD7_R {
        FMOD7_R::new(((self.bits >> 7) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Filter mode"]
    #[inline(always)]
    pub fn fmod6(&self) -> FMOD6_R {
        FMOD6_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Filter mode"]
    #[inline(always)]
    pub fn fmod5(&self) -> FMOD5_R {
        FMOD5_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Filter mode"]
    #[inline(always)]
    pub fn fmod4(&self) -> FMOD4_R {
        FMOD4_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Filter mode"]
    #[inline(always)]
    pub fn fmod3(&self) -> FMOD3_R {
        FMOD3_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Filter mode"]
    #[inline(always)]
    pub fn fmod2(&self) -> FMOD2_R {
        FMOD2_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 1 - Filter mode"]
    #[inline(always)]
    pub fn fmod1(&self) -> FMOD1_R {
        FMOD1_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 0 - Filter mode"]
    #[inline(always)]
    pub fn fmod0(&self) -> FMOD0_R {
        FMOD0_R::new((self.bits & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 27 - Filter mode"]
    #[inline(always)]
    pub fn fmod27(&mut self) -> FMOD27_W {
        FMOD27_W { w: self }
    }
    #[doc = "Bit 26 - Filter mode"]
    #[inline(always)]
    pub fn fmod26(&mut self) -> FMOD26_W {
        FMOD26_W { w: self }
    }
    #[doc = "Bit 25 - Filter mode"]
    #[inline(always)]
    pub fn fmod25(&mut self) -> FMOD25_W {
        FMOD25_W { w: self }
    }
    #[doc = "Bit 24 - Filter mode"]
    #[inline(always)]
    pub fn fmod24(&mut self) -> FMOD24_W {
        FMOD24_W { w: self }
    }
    #[doc = "Bit 23 - Filter mode"]
    #[inline(always)]
    pub fn fmod23(&mut self) -> FMOD23_W {
        FMOD23_W { w: self }
    }
    #[doc = "Bit 22 - Filter mode"]
    #[inline(always)]
    pub fn fmod22(&mut self) -> FMOD22_W {
        FMOD22_W { w: self }
    }
    #[doc = "Bit 21 - Filter mode"]
    #[inline(always)]
    pub fn fmod21(&mut self) -> FMOD21_W {
        FMOD21_W { w: self }
    }
    #[doc = "Bit 20 - Filter mode"]
    #[inline(always)]
    pub fn fmod20(&mut self) -> FMOD20_W {
        FMOD20_W { w: self }
    }
    #[doc = "Bit 19 - Filter mode"]
    #[inline(always)]
    pub fn fmod19(&mut self) -> FMOD19_W {
        FMOD19_W { w: self }
    }
    #[doc = "Bit 18 - Filter mode"]
    #[inline(always)]
    pub fn fmod18(&mut self) -> FMOD18_W {
        FMOD18_W { w: self }
    }
    #[doc = "Bit 17 - Filter mode"]
    #[inline(always)]
    pub fn fmod17(&mut self) -> FMOD17_W {
        FMOD17_W { w: self }
    }
    #[doc = "Bit 16 - Filter mode"]
    #[inline(always)]
    pub fn fmod16(&mut self) -> FMOD16_W {
        FMOD16_W { w: self }
    }
    #[doc = "Bit 15 - Filter mode"]
    #[inline(always)]
    pub fn fmod15(&mut self) -> FMOD15_W {
        FMOD15_W { w: self }
    }
    #[doc = "Bit 14 - Filter mode"]
    #[inline(always)]
    pub fn fmod14(&mut self) -> FMOD14_W {
        FMOD14_W { w: self }
    }
    #[doc = "Bit 13 - Filter mode"]
    #[inline(always)]
    pub fn fmod13(&mut self) -> FMOD13_W {
        FMOD13_W { w: self }
    }
    #[doc = "Bit 12 - Filter mode"]
    #[inline(always)]
    pub fn fmod12(&mut self) -> FMOD12_W {
        FMOD12_W { w: self }
    }
    #[doc = "Bit 11 - Filter mode"]
    #[inline(always)]
    pub fn fmod11(&mut self) -> FMOD11_W {
        FMOD11_W { w: self }
    }
    #[doc = "Bit 10 - Filter mode"]
    #[inline(always)]
    pub fn fmod10(&mut self) -> FMOD10_W {
        FMOD10_W { w: self }
    }
    #[doc = "Bit 9 - Filter mode"]
    #[inline(always)]
    pub fn fmod9(&mut self) -> FMOD9_W {
        FMOD9_W { w: self }
    }
    #[doc = "Bit 8 - Filter mode"]
    #[inline(always)]
    pub fn fmod8(&mut self) -> FMOD8_W {
        FMOD8_W { w: self }
    }
    #[doc = "Bit 7 - Filter mode"]
    #[inline(always)]
    pub fn fmod7(&mut self) -> FMOD7_W {
        FMOD7_W { w: self }
    }
    #[doc = "Bit 6 - Filter mode"]
    #[inline(always)]
    pub fn fmod6(&mut self) -> FMOD6_W {
        FMOD6_W { w: self }
    }
    #[doc = "Bit 5 - Filter mode"]
    #[inline(always)]
    pub fn fmod5(&mut self) -> FMOD5_W {
        FMOD5_W { w: self }
    }
    #[doc = "Bit 4 - Filter mode"]
    #[inline(always)]
    pub fn fmod4(&mut self) -> FMOD4_W {
        FMOD4_W { w: self }
    }
    #[doc = "Bit 3 - Filter mode"]
    #[inline(always)]
    pub fn fmod3(&mut self) -> FMOD3_W {
        FMOD3_W { w: self }
    }
    #[doc = "Bit 2 - Filter mode"]
    #[inline(always)]
    pub fn fmod2(&mut self) -> FMOD2_W {
        FMOD2_W { w: self }
    }
    #[doc = "Bit 1 - Filter mode"]
    #[inline(always)]
    pub fn fmod1(&mut self) -> FMOD1_W {
        FMOD1_W { w: self }
    }
    #[doc = "Bit 0 - Filter mode"]
    #[inline(always)]
    pub fn fmod0(&mut self) -> FMOD0_W {
        FMOD0_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Filter mode configuration register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [fmcfg](index.html) module"]
pub struct FMCFG_SPEC;
impl crate::RegisterSpec for FMCFG_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [fmcfg::R](R) reader structure"]
impl crate::Readable for FMCFG_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [fmcfg::W](W) writer structure"]
impl crate::Writable for FMCFG_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets FMCFG to value 0"]
impl crate::Resettable for FMCFG_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
