#[doc = "Register `CCHP` reader"]
pub struct R(crate::R<CCHP_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<CCHP_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::convert::From<crate::R<CCHP_SPEC>> for R {
    fn from(reader: crate::R<CCHP_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `CCHP` writer"]
pub struct W(crate::W<CCHP_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<CCHP_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl core::convert::From<crate::W<CCHP_SPEC>> for W {
    fn from(writer: crate::W<CCHP_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Primary output enable"]
pub type POEN_A = crate::gd32f170::timer0::cchp::POEN_A;
#[doc = "Field `POEN` reader - Primary output enable"]
pub type POEN_R = crate::gd32f170::timer0::cchp::POEN_R;
#[doc = "Field `POEN` writer - Primary output enable"]
pub struct POEN_W<'a> {
    w: &'a mut W,
}
impl<'a> POEN_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: POEN_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Channel outputs are disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(POEN_A::DISABLED)
    }
    #[doc = "Channel outputs are enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(POEN_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 15)) | ((value as u16 & 0x01) << 15);
        self.w
    }
}
#[doc = "Output automatic enable"]
pub type OAEN_A = crate::gd32f170::timer0::cchp::OAEN_A;
#[doc = "Field `OAEN` reader - Output automatic enable"]
pub type OAEN_R = crate::gd32f170::timer0::cchp::OAEN_R;
#[doc = "Field `OAEN` writer - Output automatic enable"]
pub struct OAEN_W<'a> {
    w: &'a mut W,
}
impl<'a> OAEN_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OAEN_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "POEN cannot be set by hardware"]
    #[inline(always)]
    pub fn manual(self) -> &'a mut W {
        self.variant(OAEN_A::MANUAL)
    }
    #[doc = "POEN can be set by hardware automatically at the next update event"]
    #[inline(always)]
    pub fn automatic(self) -> &'a mut W {
        self.variant(OAEN_A::AUTOMATIC)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 14)) | ((value as u16 & 0x01) << 14);
        self.w
    }
}
#[doc = "Break polarity"]
pub type BRKP_A = crate::gd32f170::timer0::cchp::BRKP_A;
#[doc = "Field `BRKP` reader - Break polarity"]
pub type BRKP_R = crate::gd32f170::timer0::cchp::BRKP_R;
#[doc = "Field `BRKP` writer - Break polarity"]
pub struct BRKP_W<'a> {
    w: &'a mut W,
}
impl<'a> BRKP_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: BRKP_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "BRKIN is active low"]
    #[inline(always)]
    pub fn inverted(self) -> &'a mut W {
        self.variant(BRKP_A::INVERTED)
    }
    #[doc = "BRKIN is active high"]
    #[inline(always)]
    pub fn not_inverted(self) -> &'a mut W {
        self.variant(BRKP_A::NOTINVERTED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 13)) | ((value as u16 & 0x01) << 13);
        self.w
    }
}
#[doc = "Break enable"]
pub type BRKEN_A = crate::gd32f170::timer0::cchp::BRKEN_A;
#[doc = "Field `BRKEN` reader - Break enable"]
pub type BRKEN_R = crate::gd32f170::timer0::cchp::BRKEN_R;
#[doc = "Field `BRKEN` writer - Break enable"]
pub struct BRKEN_W<'a> {
    w: &'a mut W,
}
impl<'a> BRKEN_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: BRKEN_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Break inputs disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(BRKEN_A::DISABLED)
    }
    #[doc = "Break inputs enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(BRKEN_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 12)) | ((value as u16 & 0x01) << 12);
        self.w
    }
}
#[doc = "Run mode off-state configure"]
pub type ROS_A = crate::gd32f170::timer0::cchp::ROS_A;
#[doc = "Field `ROS` reader - Run mode off-state configure"]
pub type ROS_R = crate::gd32f170::timer0::cchp::ROS_R;
#[doc = "Field `ROS` writer - Run mode off-state configure"]
pub struct ROS_W<'a> {
    w: &'a mut W,
}
impl<'a> ROS_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: ROS_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "When POEN is set, the channel output signals are disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(ROS_A::DISABLED)
    }
    #[doc = "When POEN is set, the channel output signals are enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(ROS_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 11)) | ((value as u16 & 0x01) << 11);
        self.w
    }
}
#[doc = "Idle mode off-state configure"]
pub type IOS_A = crate::gd32f170::timer0::cchp::IOS_A;
#[doc = "Field `IOS` reader - Idle mode off-state configure"]
pub type IOS_R = crate::gd32f170::timer0::cchp::IOS_R;
#[doc = "Field `IOS` writer - Idle mode off-state configure"]
pub struct IOS_W<'a> {
    w: &'a mut W,
}
impl<'a> IOS_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: IOS_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "When POEN is reset, the channel output signals are disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(IOS_A::DISABLED)
    }
    #[doc = "When POEN is reset, the channel output signals are enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(IOS_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 10)) | ((value as u16 & 0x01) << 10);
        self.w
    }
}
#[doc = "Complementary register protect control"]
pub type PROT_A = crate::gd32f170::timer0::cchp::PROT_A;
#[doc = "Field `PROT` reader - Complementary register protect control"]
pub type PROT_R = crate::gd32f170::timer0::cchp::PROT_R;
#[doc = "Field `PROT` writer - Complementary register protect control"]
pub struct PROT_W<'a> {
    w: &'a mut W,
}
impl<'a> PROT_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: PROT_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "Write protection disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(PROT_A::DISABLED)
    }
    #[doc = "Protection mode 0"]
    #[inline(always)]
    pub fn mode0(self) -> &'a mut W {
        self.variant(PROT_A::MODE0)
    }
    #[doc = "Protection mode 1"]
    #[inline(always)]
    pub fn mode1(self) -> &'a mut W {
        self.variant(PROT_A::MODE1)
    }
    #[doc = "Protection mode 2"]
    #[inline(always)]
    pub fn mode2(self) -> &'a mut W {
        self.variant(PROT_A::MODE2)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 8)) | ((value as u16 & 0x03) << 8);
        self.w
    }
}
#[doc = "Field `DTCFG` reader - Dead time configure"]
pub struct DTCFG_R(crate::FieldReader<u8, u8>);
impl DTCFG_R {
    pub(crate) fn new(bits: u8) -> Self {
        DTCFG_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DTCFG_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DTCFG` writer - Dead time configure"]
pub struct DTCFG_W<'a> {
    w: &'a mut W,
}
impl<'a> DTCFG_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0xff) | (value as u16 & 0xff);
        self.w
    }
}
impl R {
    #[doc = "Bit 15 - Primary output enable"]
    #[inline(always)]
    pub fn poen(&self) -> POEN_R {
        POEN_R::new(((self.bits >> 15) & 0x01) != 0)
    }
    #[doc = "Bit 14 - Output automatic enable"]
    #[inline(always)]
    pub fn oaen(&self) -> OAEN_R {
        OAEN_R::new(((self.bits >> 14) & 0x01) != 0)
    }
    #[doc = "Bit 13 - Break polarity"]
    #[inline(always)]
    pub fn brkp(&self) -> BRKP_R {
        BRKP_R::new(((self.bits >> 13) & 0x01) != 0)
    }
    #[doc = "Bit 12 - Break enable"]
    #[inline(always)]
    pub fn brken(&self) -> BRKEN_R {
        BRKEN_R::new(((self.bits >> 12) & 0x01) != 0)
    }
    #[doc = "Bit 11 - Run mode off-state configure"]
    #[inline(always)]
    pub fn ros(&self) -> ROS_R {
        ROS_R::new(((self.bits >> 11) & 0x01) != 0)
    }
    #[doc = "Bit 10 - Idle mode off-state configure"]
    #[inline(always)]
    pub fn ios(&self) -> IOS_R {
        IOS_R::new(((self.bits >> 10) & 0x01) != 0)
    }
    #[doc = "Bits 8:9 - Complementary register protect control"]
    #[inline(always)]
    pub fn prot(&self) -> PROT_R {
        PROT_R::new(((self.bits >> 8) & 0x03) as u8)
    }
    #[doc = "Bits 0:7 - Dead time configure"]
    #[inline(always)]
    pub fn dtcfg(&self) -> DTCFG_R {
        DTCFG_R::new((self.bits & 0xff) as u8)
    }
}
impl W {
    #[doc = "Bit 15 - Primary output enable"]
    #[inline(always)]
    pub fn poen(&mut self) -> POEN_W {
        POEN_W { w: self }
    }
    #[doc = "Bit 14 - Output automatic enable"]
    #[inline(always)]
    pub fn oaen(&mut self) -> OAEN_W {
        OAEN_W { w: self }
    }
    #[doc = "Bit 13 - Break polarity"]
    #[inline(always)]
    pub fn brkp(&mut self) -> BRKP_W {
        BRKP_W { w: self }
    }
    #[doc = "Bit 12 - Break enable"]
    #[inline(always)]
    pub fn brken(&mut self) -> BRKEN_W {
        BRKEN_W { w: self }
    }
    #[doc = "Bit 11 - Run mode off-state configure"]
    #[inline(always)]
    pub fn ros(&mut self) -> ROS_W {
        ROS_W { w: self }
    }
    #[doc = "Bit 10 - Idle mode off-state configure"]
    #[inline(always)]
    pub fn ios(&mut self) -> IOS_W {
        IOS_W { w: self }
    }
    #[doc = "Bits 8:9 - Complementary register protect control"]
    #[inline(always)]
    pub fn prot(&mut self) -> PROT_W {
        PROT_W { w: self }
    }
    #[doc = "Bits 0:7 - Dead time configure"]
    #[inline(always)]
    pub fn dtcfg(&mut self) -> DTCFG_W {
        DTCFG_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    pub unsafe fn bits(&mut self, bits: u16) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Channel Complementary Protection register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [cchp](index.html) module"]
pub struct CCHP_SPEC;
impl crate::RegisterSpec for CCHP_SPEC {
    type Ux = u16;
}
#[doc = "`read()` method returns [cchp::R](R) reader structure"]
impl crate::Readable for CCHP_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [cchp::W](W) writer structure"]
impl crate::Writable for CCHP_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets CCHP to value 0"]
impl crate::Resettable for CCHP_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
