#[doc = "Register `INTC` reader"]
pub struct R(crate::R<INTC_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<INTC_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::convert::From<crate::R<INTC_SPEC>> for R {
    fn from(reader: crate::R<INTC_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `INTC` writer"]
pub struct W(crate::W<INTC_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<INTC_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl core::convert::From<crate::W<INTC_SPEC>> for W {
    fn from(writer: crate::W<INTC_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `CMNERR` reader - Clear max cycle number error"]
pub struct CMNERR_R(crate::FieldReader<bool, bool>);
impl CMNERR_R {
    pub(crate) fn new(bits: bool) -> Self {
        CMNERR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CMNERR_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CMNERR` writer - Clear max cycle number error"]
pub struct CMNERR_W<'a> {
    w: &'a mut W,
}
impl<'a> CMNERR_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `CCTCF` reader - Clear charge-transfer complete flag"]
pub struct CCTCF_R(crate::FieldReader<bool, bool>);
impl CCTCF_R {
    pub(crate) fn new(bits: bool) -> Self {
        CCTCF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CCTCF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CCTCF` writer - Clear charge-transfer complete flag"]
pub struct CCTCF_W<'a> {
    w: &'a mut W,
}
impl<'a> CCTCF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
impl R {
    #[doc = "Bit 1 - Clear max cycle number error"]
    #[inline(always)]
    pub fn cmnerr(&self) -> CMNERR_R {
        CMNERR_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 0 - Clear charge-transfer complete flag"]
    #[inline(always)]
    pub fn cctcf(&self) -> CCTCF_R {
        CCTCF_R::new((self.bits & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 1 - Clear max cycle number error"]
    #[inline(always)]
    pub fn cmnerr(&mut self) -> CMNERR_W {
        CMNERR_W { w: self }
    }
    #[doc = "Bit 0 - Clear charge-transfer complete flag"]
    #[inline(always)]
    pub fn cctcf(&mut self) -> CCTCF_W {
        CCTCF_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "interrupt flag clear register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [intc](index.html) module"]
pub struct INTC_SPEC;
impl crate::RegisterSpec for INTC_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [intc::R](R) reader structure"]
impl crate::Readable for INTC_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [intc::W](W) writer structure"]
impl crate::Writable for INTC_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets INTC to value 0"]
impl crate::Resettable for INTC_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
