#[doc = "Register `INTEN` reader"]
pub struct R(crate::R<INTEN_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<INTEN_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::convert::From<crate::R<INTEN_SPEC>> for R {
    fn from(reader: crate::R<INTEN_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `INTEN` writer"]
pub struct W(crate::W<INTEN_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<INTEN_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl core::convert::From<crate::W<INTEN_SPEC>> for W {
    fn from(writer: crate::W<INTEN_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `TAERRIE` reader - TAERR Interrupt Enable"]
pub struct TAERRIE_R(crate::FieldReader<bool, bool>);
impl TAERRIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        TAERRIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TAERRIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TAERRIE` writer - TAERR Interrupt Enable"]
pub struct TAERRIE_W<'a> {
    w: &'a mut W,
}
impl<'a> TAERRIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 12)) | ((value as u32 & 0x01) << 12);
        self.w
    }
}
#[doc = "Field `TERRIE` reader - TERR Interrupt Enable"]
pub struct TERRIE_R(crate::FieldReader<bool, bool>);
impl TERRIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        TERRIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TERRIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TERRIE` writer - TERR Interrupt Enable"]
pub struct TERRIE_W<'a> {
    w: &'a mut W,
}
impl<'a> TERRIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 11)) | ((value as u32 & 0x01) << 11);
        self.w
    }
}
#[doc = "Field `TUIE` reader - TU Interrupt Enable"]
pub struct TUIE_R(crate::FieldReader<bool, bool>);
impl TUIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        TUIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TUIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TUIE` writer - TU Interrupt Enable"]
pub struct TUIE_W<'a> {
    w: &'a mut W,
}
impl<'a> TUIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 10)) | ((value as u32 & 0x01) << 10);
        self.w
    }
}
#[doc = "Field `TXENDIE` reader - TEND Interrupt Enable"]
pub struct TXENDIE_R(crate::FieldReader<bool, bool>);
impl TXENDIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        TXENDIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TXENDIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TXENDIE` writer - TEND Interrupt Enable"]
pub struct TXENDIE_W<'a> {
    w: &'a mut W,
}
impl<'a> TXENDIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 9)) | ((value as u32 & 0x01) << 9);
        self.w
    }
}
#[doc = "Field `TBRIE` reader - TBR Interrupt Enable"]
pub struct TBRIE_R(crate::FieldReader<bool, bool>);
impl TBRIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        TBRIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TBRIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TBRIE` writer - TBR Interrupt Enable"]
pub struct TBRIE_W<'a> {
    w: &'a mut W,
}
impl<'a> TBRIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 8)) | ((value as u32 & 0x01) << 8);
        self.w
    }
}
#[doc = "Field `LSTARBIE` reader - ALRLST Interrupt Enable"]
pub struct LSTARBIE_R(crate::FieldReader<bool, bool>);
impl LSTARBIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        LSTARBIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LSTARBIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LSTARBIE` writer - ALRLST Interrupt Enable"]
pub struct LSTARBIE_W<'a> {
    w: &'a mut W,
}
impl<'a> LSTARBIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u32 & 0x01) << 7);
        self.w
    }
}
#[doc = "Field `RAEIE` reader - RAE Interrupt Enable"]
pub struct RAEIE_R(crate::FieldReader<bool, bool>);
impl RAEIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        RAEIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RAEIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RAEIE` writer - RAE Interrupt Enable"]
pub struct RAEIE_W<'a> {
    w: &'a mut W,
}
impl<'a> RAEIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u32 & 0x01) << 6);
        self.w
    }
}
#[doc = "Field `RLBPEIE` reader - RLBPE Interrupt Enable"]
pub struct RLBPEIE_R(crate::FieldReader<bool, bool>);
impl RLBPEIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        RLBPEIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RLBPEIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RLBPEIE` writer - RLBPE Interrupt Enable"]
pub struct RLBPEIE_W<'a> {
    w: &'a mut W,
}
impl<'a> RLBPEIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u32 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `RSBPEIE` reader - RSBPE Interrupt Enable"]
pub struct RSBPEIE_R(crate::FieldReader<bool, bool>);
impl RSBPEIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        RSBPEIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RSBPEIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RSBPEIE` writer - RSBPE Interrupt Enable"]
pub struct RSBPEIE_W<'a> {
    w: &'a mut W,
}
impl<'a> RSBPEIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u32 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `RBREIE` reader - RBRE Interrupt Enable"]
pub struct RBREIE_R(crate::FieldReader<bool, bool>);
impl RBREIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        RBREIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RBREIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RBREIE` writer - RBRE Interrupt Enable"]
pub struct RBREIE_W<'a> {
    w: &'a mut W,
}
impl<'a> RBREIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u32 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `ROIE` reader - RO Interrupt Enable"]
pub struct ROIE_R(crate::FieldReader<bool, bool>);
impl ROIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        ROIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ROIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ROIE` writer - RO Interrupt Enable"]
pub struct ROIE_W<'a> {
    w: &'a mut W,
}
impl<'a> ROIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u32 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `RENDIE` reader - REND Interrupt Enable"]
pub struct RENDIE_R(crate::FieldReader<bool, bool>);
impl RENDIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        RENDIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RENDIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RENDIE` writer - REND Interrupt Enable"]
pub struct RENDIE_W<'a> {
    w: &'a mut W,
}
impl<'a> RENDIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `RBRIE` reader - RBR Interrupt Enable"]
pub struct RBRIE_R(crate::FieldReader<bool, bool>);
impl RBRIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        RBRIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RBRIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RBRIE` writer - RBR Interrupt Enable"]
pub struct RBRIE_W<'a> {
    w: &'a mut W,
}
impl<'a> RBRIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
impl R {
    #[doc = "Bit 12 - TAERR Interrupt Enable"]
    #[inline(always)]
    pub fn taerrie(&self) -> TAERRIE_R {
        TAERRIE_R::new(((self.bits >> 12) & 0x01) != 0)
    }
    #[doc = "Bit 11 - TERR Interrupt Enable"]
    #[inline(always)]
    pub fn terrie(&self) -> TERRIE_R {
        TERRIE_R::new(((self.bits >> 11) & 0x01) != 0)
    }
    #[doc = "Bit 10 - TU Interrupt Enable"]
    #[inline(always)]
    pub fn tuie(&self) -> TUIE_R {
        TUIE_R::new(((self.bits >> 10) & 0x01) != 0)
    }
    #[doc = "Bit 9 - TEND Interrupt Enable"]
    #[inline(always)]
    pub fn txendie(&self) -> TXENDIE_R {
        TXENDIE_R::new(((self.bits >> 9) & 0x01) != 0)
    }
    #[doc = "Bit 8 - TBR Interrupt Enable"]
    #[inline(always)]
    pub fn tbrie(&self) -> TBRIE_R {
        TBRIE_R::new(((self.bits >> 8) & 0x01) != 0)
    }
    #[doc = "Bit 7 - ALRLST Interrupt Enable"]
    #[inline(always)]
    pub fn lstarbie(&self) -> LSTARBIE_R {
        LSTARBIE_R::new(((self.bits >> 7) & 0x01) != 0)
    }
    #[doc = "Bit 6 - RAE Interrupt Enable"]
    #[inline(always)]
    pub fn raeie(&self) -> RAEIE_R {
        RAEIE_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 5 - RLBPE Interrupt Enable"]
    #[inline(always)]
    pub fn rlbpeie(&self) -> RLBPEIE_R {
        RLBPEIE_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 4 - RSBPE Interrupt Enable"]
    #[inline(always)]
    pub fn rsbpeie(&self) -> RSBPEIE_R {
        RSBPEIE_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 3 - RBRE Interrupt Enable"]
    #[inline(always)]
    pub fn rbreie(&self) -> RBREIE_R {
        RBREIE_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 2 - RO Interrupt Enable"]
    #[inline(always)]
    pub fn roie(&self) -> ROIE_R {
        ROIE_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 1 - REND Interrupt Enable"]
    #[inline(always)]
    pub fn rendie(&self) -> RENDIE_R {
        RENDIE_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 0 - RBR Interrupt Enable"]
    #[inline(always)]
    pub fn rbrie(&self) -> RBRIE_R {
        RBRIE_R::new((self.bits & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 12 - TAERR Interrupt Enable"]
    #[inline(always)]
    pub fn taerrie(&mut self) -> TAERRIE_W {
        TAERRIE_W { w: self }
    }
    #[doc = "Bit 11 - TERR Interrupt Enable"]
    #[inline(always)]
    pub fn terrie(&mut self) -> TERRIE_W {
        TERRIE_W { w: self }
    }
    #[doc = "Bit 10 - TU Interrupt Enable"]
    #[inline(always)]
    pub fn tuie(&mut self) -> TUIE_W {
        TUIE_W { w: self }
    }
    #[doc = "Bit 9 - TEND Interrupt Enable"]
    #[inline(always)]
    pub fn txendie(&mut self) -> TXENDIE_W {
        TXENDIE_W { w: self }
    }
    #[doc = "Bit 8 - TBR Interrupt Enable"]
    #[inline(always)]
    pub fn tbrie(&mut self) -> TBRIE_W {
        TBRIE_W { w: self }
    }
    #[doc = "Bit 7 - ALRLST Interrupt Enable"]
    #[inline(always)]
    pub fn lstarbie(&mut self) -> LSTARBIE_W {
        LSTARBIE_W { w: self }
    }
    #[doc = "Bit 6 - RAE Interrupt Enable"]
    #[inline(always)]
    pub fn raeie(&mut self) -> RAEIE_W {
        RAEIE_W { w: self }
    }
    #[doc = "Bit 5 - RLBPE Interrupt Enable"]
    #[inline(always)]
    pub fn rlbpeie(&mut self) -> RLBPEIE_W {
        RLBPEIE_W { w: self }
    }
    #[doc = "Bit 4 - RSBPE Interrupt Enable"]
    #[inline(always)]
    pub fn rsbpeie(&mut self) -> RSBPEIE_W {
        RSBPEIE_W { w: self }
    }
    #[doc = "Bit 3 - RBRE Interrupt Enable"]
    #[inline(always)]
    pub fn rbreie(&mut self) -> RBREIE_W {
        RBREIE_W { w: self }
    }
    #[doc = "Bit 2 - RO Interrupt Enable"]
    #[inline(always)]
    pub fn roie(&mut self) -> ROIE_W {
        ROIE_W { w: self }
    }
    #[doc = "Bit 1 - REND Interrupt Enable"]
    #[inline(always)]
    pub fn rendie(&mut self) -> RENDIE_W {
        RENDIE_W { w: self }
    }
    #[doc = "Bit 0 - RBR Interrupt Enable"]
    #[inline(always)]
    pub fn rbrie(&mut self) -> RBRIE_W {
        RBRIE_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "interrupt enable register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [inten](index.html) module"]
pub struct INTEN_SPEC;
impl crate::RegisterSpec for INTEN_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [inten::R](R) reader structure"]
impl crate::Readable for INTEN_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [inten::W](W) writer structure"]
impl crate::Writable for INTEN_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets INTEN to value 0"]
impl crate::Resettable for INTEN_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
