#[doc = "Register `CTL0` reader"]
pub struct R(crate::R<CTL0_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<CTL0_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::convert::From<crate::R<CTL0_SPEC>> for R {
    fn from(reader: crate::R<CTL0_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `CTL0` writer"]
pub struct W(crate::W<CTL0_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<CTL0_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl core::convert::From<crate::W<CTL0_SPEC>> for W {
    fn from(writer: crate::W<CTL0_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Sleep mode hold register\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum SLP_HOLD_A {
    #[doc = "0: No effect"]
    DISABLED = 0,
    #[doc = "1: In sleep mode the AHB clock is on"]
    ENABLED = 1,
}
impl From<SLP_HOLD_A> for bool {
    #[inline(always)]
    fn from(variant: SLP_HOLD_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `SLP_HOLD` reader - Sleep mode hold register"]
pub struct SLP_HOLD_R(crate::FieldReader<bool, SLP_HOLD_A>);
impl SLP_HOLD_R {
    pub(crate) fn new(bits: bool) -> Self {
        SLP_HOLD_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> SLP_HOLD_A {
        match self.bits {
            false => SLP_HOLD_A::DISABLED,
            true => SLP_HOLD_A::ENABLED,
        }
    }
    #[doc = "Checks if the value of the field is `DISABLED`"]
    #[inline(always)]
    pub fn is_disabled(&self) -> bool {
        **self == SLP_HOLD_A::DISABLED
    }
    #[doc = "Checks if the value of the field is `ENABLED`"]
    #[inline(always)]
    pub fn is_enabled(&self) -> bool {
        **self == SLP_HOLD_A::ENABLED
    }
}
impl core::ops::Deref for SLP_HOLD_R {
    type Target = crate::FieldReader<bool, SLP_HOLD_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SLP_HOLD` writer - Sleep mode hold register"]
pub struct SLP_HOLD_W<'a> {
    w: &'a mut W,
}
impl<'a> SLP_HOLD_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: SLP_HOLD_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "No effect"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(SLP_HOLD_A::DISABLED)
    }
    #[doc = "In sleep mode the AHB clock is on"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(SLP_HOLD_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
#[doc = "Deep-sleep mode hold register\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum DSLP_HOLD_A {
    #[doc = "0: No effect"]
    DISABLED = 0,
    #[doc = "1: In deep-sleep mode the AHB clock and system clock are provided by IRC8M"]
    ENABLED = 1,
}
impl From<DSLP_HOLD_A> for bool {
    #[inline(always)]
    fn from(variant: DSLP_HOLD_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `DSLP_HOLD` reader - Deep-sleep mode hold register"]
pub struct DSLP_HOLD_R(crate::FieldReader<bool, DSLP_HOLD_A>);
impl DSLP_HOLD_R {
    pub(crate) fn new(bits: bool) -> Self {
        DSLP_HOLD_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> DSLP_HOLD_A {
        match self.bits {
            false => DSLP_HOLD_A::DISABLED,
            true => DSLP_HOLD_A::ENABLED,
        }
    }
    #[doc = "Checks if the value of the field is `DISABLED`"]
    #[inline(always)]
    pub fn is_disabled(&self) -> bool {
        **self == DSLP_HOLD_A::DISABLED
    }
    #[doc = "Checks if the value of the field is `ENABLED`"]
    #[inline(always)]
    pub fn is_enabled(&self) -> bool {
        **self == DSLP_HOLD_A::ENABLED
    }
}
impl core::ops::Deref for DSLP_HOLD_R {
    type Target = crate::FieldReader<bool, DSLP_HOLD_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DSLP_HOLD` writer - Deep-sleep mode hold register"]
pub struct DSLP_HOLD_W<'a> {
    w: &'a mut W,
}
impl<'a> DSLP_HOLD_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: DSLP_HOLD_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "No effect"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(DSLP_HOLD_A::DISABLED)
    }
    #[doc = "In deep-sleep mode the AHB clock and system clock are provided by IRC8M"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(DSLP_HOLD_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "Standby mode hold register\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum STB_HOLD_A {
    #[doc = "0: No effect"]
    DISABLED = 0,
    #[doc = "1: In standby mode the AHB clock and system clock are provided by IRC8M"]
    ENABLED = 1,
}
impl From<STB_HOLD_A> for bool {
    #[inline(always)]
    fn from(variant: STB_HOLD_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `STB_HOLD` reader - Standby mode hold register"]
pub struct STB_HOLD_R(crate::FieldReader<bool, STB_HOLD_A>);
impl STB_HOLD_R {
    pub(crate) fn new(bits: bool) -> Self {
        STB_HOLD_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> STB_HOLD_A {
        match self.bits {
            false => STB_HOLD_A::DISABLED,
            true => STB_HOLD_A::ENABLED,
        }
    }
    #[doc = "Checks if the value of the field is `DISABLED`"]
    #[inline(always)]
    pub fn is_disabled(&self) -> bool {
        **self == STB_HOLD_A::DISABLED
    }
    #[doc = "Checks if the value of the field is `ENABLED`"]
    #[inline(always)]
    pub fn is_enabled(&self) -> bool {
        **self == STB_HOLD_A::ENABLED
    }
}
impl core::ops::Deref for STB_HOLD_R {
    type Target = crate::FieldReader<bool, STB_HOLD_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `STB_HOLD` writer - Standby mode hold register"]
pub struct STB_HOLD_W<'a> {
    w: &'a mut W,
}
impl<'a> STB_HOLD_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: STB_HOLD_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "No effect"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(STB_HOLD_A::DISABLED)
    }
    #[doc = "In standby mode the AHB clock and system clock are provided by IRC8M"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(STB_HOLD_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u32 & 0x01) << 2);
        self.w
    }
}
#[doc = "FWDGT hold register\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum FWDGT_HOLD_A {
    #[doc = "0: Continue running the watchdog timer as usual"]
    CONTINUE = 0,
    #[doc = "1: Hold the watchdog timer for debug when the core is halted"]
    STOP = 1,
}
impl From<FWDGT_HOLD_A> for bool {
    #[inline(always)]
    fn from(variant: FWDGT_HOLD_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `FWDGT_HOLD` reader - FWDGT hold register"]
pub struct FWDGT_HOLD_R(crate::FieldReader<bool, FWDGT_HOLD_A>);
impl FWDGT_HOLD_R {
    pub(crate) fn new(bits: bool) -> Self {
        FWDGT_HOLD_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> FWDGT_HOLD_A {
        match self.bits {
            false => FWDGT_HOLD_A::CONTINUE,
            true => FWDGT_HOLD_A::STOP,
        }
    }
    #[doc = "Checks if the value of the field is `CONTINUE`"]
    #[inline(always)]
    pub fn is_continue(&self) -> bool {
        **self == FWDGT_HOLD_A::CONTINUE
    }
    #[doc = "Checks if the value of the field is `STOP`"]
    #[inline(always)]
    pub fn is_stop(&self) -> bool {
        **self == FWDGT_HOLD_A::STOP
    }
}
impl core::ops::Deref for FWDGT_HOLD_R {
    type Target = crate::FieldReader<bool, FWDGT_HOLD_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FWDGT_HOLD` writer - FWDGT hold register"]
pub struct FWDGT_HOLD_W<'a> {
    w: &'a mut W,
}
impl<'a> FWDGT_HOLD_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FWDGT_HOLD_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Continue running the watchdog timer as usual"]
    #[inline(always)]
    pub fn continue_(self) -> &'a mut W {
        self.variant(FWDGT_HOLD_A::CONTINUE)
    }
    #[doc = "Hold the watchdog timer for debug when the core is halted"]
    #[inline(always)]
    pub fn stop(self) -> &'a mut W {
        self.variant(FWDGT_HOLD_A::STOP)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 8)) | ((value as u32 & 0x01) << 8);
        self.w
    }
}
#[doc = "WWDGT hold register"]
pub type WWDGT_HOLD_A = FWDGT_HOLD_A;
#[doc = "Field `WWDGT_HOLD` reader - WWDGT hold register"]
pub type WWDGT_HOLD_R = FWDGT_HOLD_R;
#[doc = "Field `WWDGT_HOLD` writer - WWDGT hold register"]
pub struct WWDGT_HOLD_W<'a> {
    w: &'a mut W,
}
impl<'a> WWDGT_HOLD_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: WWDGT_HOLD_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Continue running the watchdog timer as usual"]
    #[inline(always)]
    pub fn continue_(self) -> &'a mut W {
        self.variant(WWDGT_HOLD_A::CONTINUE)
    }
    #[doc = "Hold the watchdog timer for debug when the core is halted"]
    #[inline(always)]
    pub fn stop(self) -> &'a mut W {
        self.variant(WWDGT_HOLD_A::STOP)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 9)) | ((value as u32 & 0x01) << 9);
        self.w
    }
}
#[doc = "Timer 0 hold register\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum TIMER0_HOLD_A {
    #[doc = "0: Continue running the timer as usual"]
    CONTINUE = 0,
    #[doc = "1: Hold the timer counter for debug when the core is halted"]
    STOP = 1,
}
impl From<TIMER0_HOLD_A> for bool {
    #[inline(always)]
    fn from(variant: TIMER0_HOLD_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `TIMER0_HOLD` reader - Timer 0 hold register"]
pub struct TIMER0_HOLD_R(crate::FieldReader<bool, TIMER0_HOLD_A>);
impl TIMER0_HOLD_R {
    pub(crate) fn new(bits: bool) -> Self {
        TIMER0_HOLD_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> TIMER0_HOLD_A {
        match self.bits {
            false => TIMER0_HOLD_A::CONTINUE,
            true => TIMER0_HOLD_A::STOP,
        }
    }
    #[doc = "Checks if the value of the field is `CONTINUE`"]
    #[inline(always)]
    pub fn is_continue(&self) -> bool {
        **self == TIMER0_HOLD_A::CONTINUE
    }
    #[doc = "Checks if the value of the field is `STOP`"]
    #[inline(always)]
    pub fn is_stop(&self) -> bool {
        **self == TIMER0_HOLD_A::STOP
    }
}
impl core::ops::Deref for TIMER0_HOLD_R {
    type Target = crate::FieldReader<bool, TIMER0_HOLD_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TIMER0_HOLD` writer - Timer 0 hold register"]
pub struct TIMER0_HOLD_W<'a> {
    w: &'a mut W,
}
impl<'a> TIMER0_HOLD_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: TIMER0_HOLD_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Continue running the timer as usual"]
    #[inline(always)]
    pub fn continue_(self) -> &'a mut W {
        self.variant(TIMER0_HOLD_A::CONTINUE)
    }
    #[doc = "Hold the timer counter for debug when the core is halted"]
    #[inline(always)]
    pub fn stop(self) -> &'a mut W {
        self.variant(TIMER0_HOLD_A::STOP)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 10)) | ((value as u32 & 0x01) << 10);
        self.w
    }
}
#[doc = "Timer 1 hold register"]
pub type TIMER1_HOLD_A = TIMER0_HOLD_A;
#[doc = "Field `TIMER1_HOLD` reader - Timer 1 hold register"]
pub type TIMER1_HOLD_R = TIMER0_HOLD_R;
#[doc = "Field `TIMER1_HOLD` writer - Timer 1 hold register"]
pub struct TIMER1_HOLD_W<'a> {
    w: &'a mut W,
}
impl<'a> TIMER1_HOLD_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: TIMER1_HOLD_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Continue running the timer as usual"]
    #[inline(always)]
    pub fn continue_(self) -> &'a mut W {
        self.variant(TIMER1_HOLD_A::CONTINUE)
    }
    #[doc = "Hold the timer counter for debug when the core is halted"]
    #[inline(always)]
    pub fn stop(self) -> &'a mut W {
        self.variant(TIMER1_HOLD_A::STOP)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 11)) | ((value as u32 & 0x01) << 11);
        self.w
    }
}
#[doc = "Timer 2 hold register"]
pub type TIMER2_HOLD_A = TIMER0_HOLD_A;
#[doc = "Field `TIMER2_HOLD` reader - Timer 2 hold register"]
pub type TIMER2_HOLD_R = TIMER0_HOLD_R;
#[doc = "Field `TIMER2_HOLD` writer - Timer 2 hold register"]
pub struct TIMER2_HOLD_W<'a> {
    w: &'a mut W,
}
impl<'a> TIMER2_HOLD_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: TIMER2_HOLD_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Continue running the timer as usual"]
    #[inline(always)]
    pub fn continue_(self) -> &'a mut W {
        self.variant(TIMER2_HOLD_A::CONTINUE)
    }
    #[doc = "Hold the timer counter for debug when the core is halted"]
    #[inline(always)]
    pub fn stop(self) -> &'a mut W {
        self.variant(TIMER2_HOLD_A::STOP)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 12)) | ((value as u32 & 0x01) << 12);
        self.w
    }
}
#[doc = "I2C0 hold register\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum I2C0_HOLD_A {
    #[doc = "0: Continue running I2C as usual"]
    CONTINUE = 0,
    #[doc = "1: Hold the I2C timeout for debug when the core is halted"]
    STOP = 1,
}
impl From<I2C0_HOLD_A> for bool {
    #[inline(always)]
    fn from(variant: I2C0_HOLD_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `I2C0_HOLD` reader - I2C0 hold register"]
pub struct I2C0_HOLD_R(crate::FieldReader<bool, I2C0_HOLD_A>);
impl I2C0_HOLD_R {
    pub(crate) fn new(bits: bool) -> Self {
        I2C0_HOLD_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> I2C0_HOLD_A {
        match self.bits {
            false => I2C0_HOLD_A::CONTINUE,
            true => I2C0_HOLD_A::STOP,
        }
    }
    #[doc = "Checks if the value of the field is `CONTINUE`"]
    #[inline(always)]
    pub fn is_continue(&self) -> bool {
        **self == I2C0_HOLD_A::CONTINUE
    }
    #[doc = "Checks if the value of the field is `STOP`"]
    #[inline(always)]
    pub fn is_stop(&self) -> bool {
        **self == I2C0_HOLD_A::STOP
    }
}
impl core::ops::Deref for I2C0_HOLD_R {
    type Target = crate::FieldReader<bool, I2C0_HOLD_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `I2C0_HOLD` writer - I2C0 hold register"]
pub struct I2C0_HOLD_W<'a> {
    w: &'a mut W,
}
impl<'a> I2C0_HOLD_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: I2C0_HOLD_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Continue running I2C as usual"]
    #[inline(always)]
    pub fn continue_(self) -> &'a mut W {
        self.variant(I2C0_HOLD_A::CONTINUE)
    }
    #[doc = "Hold the I2C timeout for debug when the core is halted"]
    #[inline(always)]
    pub fn stop(self) -> &'a mut W {
        self.variant(I2C0_HOLD_A::STOP)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 15)) | ((value as u32 & 0x01) << 15);
        self.w
    }
}
#[doc = "I2C1 hold register"]
pub type I2C1_HOLD_A = I2C0_HOLD_A;
#[doc = "Field `I2C1_HOLD` reader - I2C1 hold register"]
pub type I2C1_HOLD_R = I2C0_HOLD_R;
#[doc = "Field `I2C1_HOLD` writer - I2C1 hold register"]
pub struct I2C1_HOLD_W<'a> {
    w: &'a mut W,
}
impl<'a> I2C1_HOLD_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: I2C1_HOLD_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Continue running I2C as usual"]
    #[inline(always)]
    pub fn continue_(self) -> &'a mut W {
        self.variant(I2C1_HOLD_A::CONTINUE)
    }
    #[doc = "Hold the I2C timeout for debug when the core is halted"]
    #[inline(always)]
    pub fn stop(self) -> &'a mut W {
        self.variant(I2C1_HOLD_A::STOP)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 16)) | ((value as u32 & 0x01) << 16);
        self.w
    }
}
#[doc = "I2C2 hold register"]
pub type I2C2_HOLD_A = I2C0_HOLD_A;
#[doc = "Field `I2C2_HOLD` reader - I2C2 hold register"]
pub type I2C2_HOLD_R = I2C0_HOLD_R;
#[doc = "Field `I2C2_HOLD` writer - I2C2 hold register"]
pub struct I2C2_HOLD_W<'a> {
    w: &'a mut W,
}
impl<'a> I2C2_HOLD_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: I2C2_HOLD_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Continue running I2C as usual"]
    #[inline(always)]
    pub fn continue_(self) -> &'a mut W {
        self.variant(I2C2_HOLD_A::CONTINUE)
    }
    #[doc = "Hold the I2C timeout for debug when the core is halted"]
    #[inline(always)]
    pub fn stop(self) -> &'a mut W {
        self.variant(I2C2_HOLD_A::STOP)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 17)) | ((value as u32 & 0x01) << 17);
        self.w
    }
}
#[doc = "Timer 5 hold register"]
pub type TIMER5_HOLD_A = TIMER0_HOLD_A;
#[doc = "Field `TIMER5_HOLD` reader - Timer 5 hold register"]
pub type TIMER5_HOLD_R = TIMER0_HOLD_R;
#[doc = "Field `TIMER5_HOLD` writer - Timer 5 hold register"]
pub struct TIMER5_HOLD_W<'a> {
    w: &'a mut W,
}
impl<'a> TIMER5_HOLD_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: TIMER5_HOLD_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Continue running the timer as usual"]
    #[inline(always)]
    pub fn continue_(self) -> &'a mut W {
        self.variant(TIMER5_HOLD_A::CONTINUE)
    }
    #[doc = "Hold the timer counter for debug when the core is halted"]
    #[inline(always)]
    pub fn stop(self) -> &'a mut W {
        self.variant(TIMER5_HOLD_A::STOP)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 19)) | ((value as u32 & 0x01) << 19);
        self.w
    }
}
#[doc = "Timer 13 hold register"]
pub type TIMER13_HOLD_A = TIMER0_HOLD_A;
#[doc = "Field `TIMER13_HOLD` reader - Timer 13 hold register"]
pub type TIMER13_HOLD_R = TIMER0_HOLD_R;
#[doc = "Field `TIMER13_HOLD` writer - Timer 13 hold register"]
pub struct TIMER13_HOLD_W<'a> {
    w: &'a mut W,
}
impl<'a> TIMER13_HOLD_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: TIMER13_HOLD_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Continue running the timer as usual"]
    #[inline(always)]
    pub fn continue_(self) -> &'a mut W {
        self.variant(TIMER13_HOLD_A::CONTINUE)
    }
    #[doc = "Hold the timer counter for debug when the core is halted"]
    #[inline(always)]
    pub fn stop(self) -> &'a mut W {
        self.variant(TIMER13_HOLD_A::STOP)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 27)) | ((value as u32 & 0x01) << 27);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Sleep mode hold register"]
    #[inline(always)]
    pub fn slp_hold(&self) -> SLP_HOLD_R {
        SLP_HOLD_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Deep-sleep mode hold register"]
    #[inline(always)]
    pub fn dslp_hold(&self) -> DSLP_HOLD_R {
        DSLP_HOLD_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Standby mode hold register"]
    #[inline(always)]
    pub fn stb_hold(&self) -> STB_HOLD_R {
        STB_HOLD_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 8 - FWDGT hold register"]
    #[inline(always)]
    pub fn fwdgt_hold(&self) -> FWDGT_HOLD_R {
        FWDGT_HOLD_R::new(((self.bits >> 8) & 0x01) != 0)
    }
    #[doc = "Bit 9 - WWDGT hold register"]
    #[inline(always)]
    pub fn wwdgt_hold(&self) -> WWDGT_HOLD_R {
        WWDGT_HOLD_R::new(((self.bits >> 9) & 0x01) != 0)
    }
    #[doc = "Bit 10 - Timer 0 hold register"]
    #[inline(always)]
    pub fn timer0_hold(&self) -> TIMER0_HOLD_R {
        TIMER0_HOLD_R::new(((self.bits >> 10) & 0x01) != 0)
    }
    #[doc = "Bit 11 - Timer 1 hold register"]
    #[inline(always)]
    pub fn timer1_hold(&self) -> TIMER1_HOLD_R {
        TIMER1_HOLD_R::new(((self.bits >> 11) & 0x01) != 0)
    }
    #[doc = "Bit 12 - Timer 2 hold register"]
    #[inline(always)]
    pub fn timer2_hold(&self) -> TIMER2_HOLD_R {
        TIMER2_HOLD_R::new(((self.bits >> 12) & 0x01) != 0)
    }
    #[doc = "Bit 15 - I2C0 hold register"]
    #[inline(always)]
    pub fn i2c0_hold(&self) -> I2C0_HOLD_R {
        I2C0_HOLD_R::new(((self.bits >> 15) & 0x01) != 0)
    }
    #[doc = "Bit 16 - I2C1 hold register"]
    #[inline(always)]
    pub fn i2c1_hold(&self) -> I2C1_HOLD_R {
        I2C1_HOLD_R::new(((self.bits >> 16) & 0x01) != 0)
    }
    #[doc = "Bit 17 - I2C2 hold register"]
    #[inline(always)]
    pub fn i2c2_hold(&self) -> I2C2_HOLD_R {
        I2C2_HOLD_R::new(((self.bits >> 17) & 0x01) != 0)
    }
    #[doc = "Bit 19 - Timer 5 hold register"]
    #[inline(always)]
    pub fn timer5_hold(&self) -> TIMER5_HOLD_R {
        TIMER5_HOLD_R::new(((self.bits >> 19) & 0x01) != 0)
    }
    #[doc = "Bit 27 - Timer 13 hold register"]
    #[inline(always)]
    pub fn timer13_hold(&self) -> TIMER13_HOLD_R {
        TIMER13_HOLD_R::new(((self.bits >> 27) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Sleep mode hold register"]
    #[inline(always)]
    pub fn slp_hold(&mut self) -> SLP_HOLD_W {
        SLP_HOLD_W { w: self }
    }
    #[doc = "Bit 1 - Deep-sleep mode hold register"]
    #[inline(always)]
    pub fn dslp_hold(&mut self) -> DSLP_HOLD_W {
        DSLP_HOLD_W { w: self }
    }
    #[doc = "Bit 2 - Standby mode hold register"]
    #[inline(always)]
    pub fn stb_hold(&mut self) -> STB_HOLD_W {
        STB_HOLD_W { w: self }
    }
    #[doc = "Bit 8 - FWDGT hold register"]
    #[inline(always)]
    pub fn fwdgt_hold(&mut self) -> FWDGT_HOLD_W {
        FWDGT_HOLD_W { w: self }
    }
    #[doc = "Bit 9 - WWDGT hold register"]
    #[inline(always)]
    pub fn wwdgt_hold(&mut self) -> WWDGT_HOLD_W {
        WWDGT_HOLD_W { w: self }
    }
    #[doc = "Bit 10 - Timer 0 hold register"]
    #[inline(always)]
    pub fn timer0_hold(&mut self) -> TIMER0_HOLD_W {
        TIMER0_HOLD_W { w: self }
    }
    #[doc = "Bit 11 - Timer 1 hold register"]
    #[inline(always)]
    pub fn timer1_hold(&mut self) -> TIMER1_HOLD_W {
        TIMER1_HOLD_W { w: self }
    }
    #[doc = "Bit 12 - Timer 2 hold register"]
    #[inline(always)]
    pub fn timer2_hold(&mut self) -> TIMER2_HOLD_W {
        TIMER2_HOLD_W { w: self }
    }
    #[doc = "Bit 15 - I2C0 hold register"]
    #[inline(always)]
    pub fn i2c0_hold(&mut self) -> I2C0_HOLD_W {
        I2C0_HOLD_W { w: self }
    }
    #[doc = "Bit 16 - I2C1 hold register"]
    #[inline(always)]
    pub fn i2c1_hold(&mut self) -> I2C1_HOLD_W {
        I2C1_HOLD_W { w: self }
    }
    #[doc = "Bit 17 - I2C2 hold register"]
    #[inline(always)]
    pub fn i2c2_hold(&mut self) -> I2C2_HOLD_W {
        I2C2_HOLD_W { w: self }
    }
    #[doc = "Bit 19 - Timer 5 hold register"]
    #[inline(always)]
    pub fn timer5_hold(&mut self) -> TIMER5_HOLD_W {
        TIMER5_HOLD_W { w: self }
    }
    #[doc = "Bit 27 - Timer 13 hold register"]
    #[inline(always)]
    pub fn timer13_hold(&mut self) -> TIMER13_HOLD_W {
        TIMER13_HOLD_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Debug Control Register 0\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ctl0](index.html) module"]
pub struct CTL0_SPEC;
impl crate::RegisterSpec for CTL0_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [ctl0::R](R) reader structure"]
impl crate::Readable for CTL0_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [ctl0::W](W) writer structure"]
impl crate::Writable for CTL0_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets CTL0 to value 0"]
impl crate::Resettable for CTL0_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
