#[doc = "Register `ALRM0TD` reader"]
pub struct R(crate::R<ALRM0TD_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<ALRM0TD_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::convert::From<crate::R<ALRM0TD_SPEC>> for R {
    fn from(reader: crate::R<ALRM0TD_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `ALRM0TD` writer"]
pub struct W(crate::W<ALRM0TD_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<ALRM0TD_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl core::convert::From<crate::W<ALRM0TD_SPEC>> for W {
    fn from(writer: crate::W<ALRM0TD_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `MSKD` reader - Alarm date mask bit"]
pub struct MSKD_R(crate::FieldReader<bool, bool>);
impl MSKD_R {
    pub(crate) fn new(bits: bool) -> Self {
        MSKD_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for MSKD_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `MSKD` writer - Alarm date mask bit"]
pub struct MSKD_W<'a> {
    w: &'a mut W,
}
impl<'a> MSKD_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 31)) | ((value as u32 & 0x01) << 31);
        self.w
    }
}
#[doc = "Field `DOWS` reader - Day of the week selected"]
pub struct DOWS_R(crate::FieldReader<bool, bool>);
impl DOWS_R {
    pub(crate) fn new(bits: bool) -> Self {
        DOWS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DOWS_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DOWS` writer - Day of the week selected"]
pub struct DOWS_W<'a> {
    w: &'a mut W,
}
impl<'a> DOWS_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 30)) | ((value as u32 & 0x01) << 30);
        self.w
    }
}
#[doc = "Field `DAYT` reader - Date tens in BCD code"]
pub struct DAYT_R(crate::FieldReader<u8, u8>);
impl DAYT_R {
    pub(crate) fn new(bits: u8) -> Self {
        DAYT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DAYT_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DAYT` writer - Date tens in BCD code"]
pub struct DAYT_W<'a> {
    w: &'a mut W,
}
impl<'a> DAYT_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 28)) | ((value as u32 & 0x03) << 28);
        self.w
    }
}
#[doc = "Field `DAYU` reader - Date units or week day in BCD code"]
pub struct DAYU_R(crate::FieldReader<u8, u8>);
impl DAYU_R {
    pub(crate) fn new(bits: u8) -> Self {
        DAYU_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DAYU_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DAYU` writer - Date units or week day in BCD code"]
pub struct DAYU_W<'a> {
    w: &'a mut W,
}
impl<'a> DAYU_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 24)) | ((value as u32 & 0x0f) << 24);
        self.w
    }
}
#[doc = "Field `MSKH` reader - Alarm hour mask bit"]
pub struct MSKH_R(crate::FieldReader<bool, bool>);
impl MSKH_R {
    pub(crate) fn new(bits: bool) -> Self {
        MSKH_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for MSKH_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `MSKH` writer - Alarm hour mask bit"]
pub struct MSKH_W<'a> {
    w: &'a mut W,
}
impl<'a> MSKH_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 23)) | ((value as u32 & 0x01) << 23);
        self.w
    }
}
#[doc = "Field `PM` reader - AM/PM flag"]
pub struct PM_R(crate::FieldReader<bool, bool>);
impl PM_R {
    pub(crate) fn new(bits: bool) -> Self {
        PM_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PM_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PM` writer - AM/PM flag"]
pub struct PM_W<'a> {
    w: &'a mut W,
}
impl<'a> PM_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 22)) | ((value as u32 & 0x01) << 22);
        self.w
    }
}
#[doc = "Field `HRT` reader - Hour tens in BCD code"]
pub struct HRT_R(crate::FieldReader<u8, u8>);
impl HRT_R {
    pub(crate) fn new(bits: u8) -> Self {
        HRT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for HRT_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `HRT` writer - Hour tens in BCD code"]
pub struct HRT_W<'a> {
    w: &'a mut W,
}
impl<'a> HRT_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 20)) | ((value as u32 & 0x03) << 20);
        self.w
    }
}
#[doc = "Field `HRU` reader - Hour units in BCD code"]
pub struct HRU_R(crate::FieldReader<u8, u8>);
impl HRU_R {
    pub(crate) fn new(bits: u8) -> Self {
        HRU_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for HRU_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `HRU` writer - Hour units in BCD code"]
pub struct HRU_W<'a> {
    w: &'a mut W,
}
impl<'a> HRU_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 16)) | ((value as u32 & 0x0f) << 16);
        self.w
    }
}
#[doc = "Field `MSKM` reader - Alarm minutes mask bit"]
pub struct MSKM_R(crate::FieldReader<bool, bool>);
impl MSKM_R {
    pub(crate) fn new(bits: bool) -> Self {
        MSKM_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for MSKM_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `MSKM` writer - Alarm minutes mask bit"]
pub struct MSKM_W<'a> {
    w: &'a mut W,
}
impl<'a> MSKM_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 15)) | ((value as u32 & 0x01) << 15);
        self.w
    }
}
#[doc = "Field `MNT` reader - Minutes tens in BCD code"]
pub struct MNT_R(crate::FieldReader<u8, u8>);
impl MNT_R {
    pub(crate) fn new(bits: u8) -> Self {
        MNT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for MNT_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `MNT` writer - Minutes tens in BCD code"]
pub struct MNT_W<'a> {
    w: &'a mut W,
}
impl<'a> MNT_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 12)) | ((value as u32 & 0x07) << 12);
        self.w
    }
}
#[doc = "Field `MNU` reader - Minutes units in BCD code"]
pub struct MNU_R(crate::FieldReader<u8, u8>);
impl MNU_R {
    pub(crate) fn new(bits: u8) -> Self {
        MNU_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for MNU_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `MNU` writer - Minutes units in BCD code"]
pub struct MNU_W<'a> {
    w: &'a mut W,
}
impl<'a> MNU_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 8)) | ((value as u32 & 0x0f) << 8);
        self.w
    }
}
#[doc = "Field `MSKS` reader - Alarm second mask bit"]
pub struct MSKS_R(crate::FieldReader<bool, bool>);
impl MSKS_R {
    pub(crate) fn new(bits: bool) -> Self {
        MSKS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for MSKS_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `MSKS` writer - Alarm second mask bit"]
pub struct MSKS_W<'a> {
    w: &'a mut W,
}
impl<'a> MSKS_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u32 & 0x01) << 7);
        self.w
    }
}
#[doc = "Field `SCT` reader - Second tens in BCD code"]
pub struct SCT_R(crate::FieldReader<u8, u8>);
impl SCT_R {
    pub(crate) fn new(bits: u8) -> Self {
        SCT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SCT_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SCT` writer - Second tens in BCD code"]
pub struct SCT_W<'a> {
    w: &'a mut W,
}
impl<'a> SCT_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 4)) | ((value as u32 & 0x07) << 4);
        self.w
    }
}
#[doc = "Field `SCU` reader - Second units in BCD code"]
pub struct SCU_R(crate::FieldReader<u8, u8>);
impl SCU_R {
    pub(crate) fn new(bits: u8) -> Self {
        SCU_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SCU_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SCU` writer - Second units in BCD code"]
pub struct SCU_W<'a> {
    w: &'a mut W,
}
impl<'a> SCU_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x0f) | (value as u32 & 0x0f);
        self.w
    }
}
impl R {
    #[doc = "Bit 31 - Alarm date mask bit"]
    #[inline(always)]
    pub fn mskd(&self) -> MSKD_R {
        MSKD_R::new(((self.bits >> 31) & 0x01) != 0)
    }
    #[doc = "Bit 30 - Day of the week selected"]
    #[inline(always)]
    pub fn dows(&self) -> DOWS_R {
        DOWS_R::new(((self.bits >> 30) & 0x01) != 0)
    }
    #[doc = "Bits 28:29 - Date tens in BCD code"]
    #[inline(always)]
    pub fn dayt(&self) -> DAYT_R {
        DAYT_R::new(((self.bits >> 28) & 0x03) as u8)
    }
    #[doc = "Bits 24:27 - Date units or week day in BCD code"]
    #[inline(always)]
    pub fn dayu(&self) -> DAYU_R {
        DAYU_R::new(((self.bits >> 24) & 0x0f) as u8)
    }
    #[doc = "Bit 23 - Alarm hour mask bit"]
    #[inline(always)]
    pub fn mskh(&self) -> MSKH_R {
        MSKH_R::new(((self.bits >> 23) & 0x01) != 0)
    }
    #[doc = "Bit 22 - AM/PM flag"]
    #[inline(always)]
    pub fn pm(&self) -> PM_R {
        PM_R::new(((self.bits >> 22) & 0x01) != 0)
    }
    #[doc = "Bits 20:21 - Hour tens in BCD code"]
    #[inline(always)]
    pub fn hrt(&self) -> HRT_R {
        HRT_R::new(((self.bits >> 20) & 0x03) as u8)
    }
    #[doc = "Bits 16:19 - Hour units in BCD code"]
    #[inline(always)]
    pub fn hru(&self) -> HRU_R {
        HRU_R::new(((self.bits >> 16) & 0x0f) as u8)
    }
    #[doc = "Bit 15 - Alarm minutes mask bit"]
    #[inline(always)]
    pub fn mskm(&self) -> MSKM_R {
        MSKM_R::new(((self.bits >> 15) & 0x01) != 0)
    }
    #[doc = "Bits 12:14 - Minutes tens in BCD code"]
    #[inline(always)]
    pub fn mnt(&self) -> MNT_R {
        MNT_R::new(((self.bits >> 12) & 0x07) as u8)
    }
    #[doc = "Bits 8:11 - Minutes units in BCD code"]
    #[inline(always)]
    pub fn mnu(&self) -> MNU_R {
        MNU_R::new(((self.bits >> 8) & 0x0f) as u8)
    }
    #[doc = "Bit 7 - Alarm second mask bit"]
    #[inline(always)]
    pub fn msks(&self) -> MSKS_R {
        MSKS_R::new(((self.bits >> 7) & 0x01) != 0)
    }
    #[doc = "Bits 4:6 - Second tens in BCD code"]
    #[inline(always)]
    pub fn sct(&self) -> SCT_R {
        SCT_R::new(((self.bits >> 4) & 0x07) as u8)
    }
    #[doc = "Bits 0:3 - Second units in BCD code"]
    #[inline(always)]
    pub fn scu(&self) -> SCU_R {
        SCU_R::new((self.bits & 0x0f) as u8)
    }
}
impl W {
    #[doc = "Bit 31 - Alarm date mask bit"]
    #[inline(always)]
    pub fn mskd(&mut self) -> MSKD_W {
        MSKD_W { w: self }
    }
    #[doc = "Bit 30 - Day of the week selected"]
    #[inline(always)]
    pub fn dows(&mut self) -> DOWS_W {
        DOWS_W { w: self }
    }
    #[doc = "Bits 28:29 - Date tens in BCD code"]
    #[inline(always)]
    pub fn dayt(&mut self) -> DAYT_W {
        DAYT_W { w: self }
    }
    #[doc = "Bits 24:27 - Date units or week day in BCD code"]
    #[inline(always)]
    pub fn dayu(&mut self) -> DAYU_W {
        DAYU_W { w: self }
    }
    #[doc = "Bit 23 - Alarm hour mask bit"]
    #[inline(always)]
    pub fn mskh(&mut self) -> MSKH_W {
        MSKH_W { w: self }
    }
    #[doc = "Bit 22 - AM/PM flag"]
    #[inline(always)]
    pub fn pm(&mut self) -> PM_W {
        PM_W { w: self }
    }
    #[doc = "Bits 20:21 - Hour tens in BCD code"]
    #[inline(always)]
    pub fn hrt(&mut self) -> HRT_W {
        HRT_W { w: self }
    }
    #[doc = "Bits 16:19 - Hour units in BCD code"]
    #[inline(always)]
    pub fn hru(&mut self) -> HRU_W {
        HRU_W { w: self }
    }
    #[doc = "Bit 15 - Alarm minutes mask bit"]
    #[inline(always)]
    pub fn mskm(&mut self) -> MSKM_W {
        MSKM_W { w: self }
    }
    #[doc = "Bits 12:14 - Minutes tens in BCD code"]
    #[inline(always)]
    pub fn mnt(&mut self) -> MNT_W {
        MNT_W { w: self }
    }
    #[doc = "Bits 8:11 - Minutes units in BCD code"]
    #[inline(always)]
    pub fn mnu(&mut self) -> MNU_W {
        MNU_W { w: self }
    }
    #[doc = "Bit 7 - Alarm second mask bit"]
    #[inline(always)]
    pub fn msks(&mut self) -> MSKS_W {
        MSKS_W { w: self }
    }
    #[doc = "Bits 4:6 - Second tens in BCD code"]
    #[inline(always)]
    pub fn sct(&mut self) -> SCT_W {
        SCT_W { w: self }
    }
    #[doc = "Bits 0:3 - Second units in BCD code"]
    #[inline(always)]
    pub fn scu(&mut self) -> SCU_W {
        SCU_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Alarm 0 Time and date register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [alrm0td](index.html) module"]
pub struct ALRM0TD_SPEC;
impl crate::RegisterSpec for ALRM0TD_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [alrm0td::R](R) reader structure"]
impl crate::Readable for ALRM0TD_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [alrm0td::W](W) writer structure"]
impl crate::Writable for ALRM0TD_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets ALRM0TD to value 0"]
impl crate::Resettable for ALRM0TD_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
