#[doc = "Register `EVEN` reader"]
pub struct R(crate::R<EVEN_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<EVEN_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::convert::From<crate::R<EVEN_SPEC>> for R {
    fn from(reader: crate::R<EVEN_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `EVEN` writer"]
pub struct W(crate::W<EVEN_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<EVEN_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl core::convert::From<crate::W<EVEN_SPEC>> for W {
    fn from(writer: crate::W<EVEN_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Event enable on line 0\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum EVEN0_A {
    #[doc = "0: Event from line is disabled"]
    MASKED = 0,
    #[doc = "1: Event from line is enabled"]
    UNMASKED = 1,
}
impl From<EVEN0_A> for bool {
    #[inline(always)]
    fn from(variant: EVEN0_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `EVEN0` reader - Event enable on line 0"]
pub struct EVEN0_R(crate::FieldReader<bool, EVEN0_A>);
impl EVEN0_R {
    pub(crate) fn new(bits: bool) -> Self {
        EVEN0_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> EVEN0_A {
        match self.bits {
            false => EVEN0_A::MASKED,
            true => EVEN0_A::UNMASKED,
        }
    }
    #[doc = "Checks if the value of the field is `MASKED`"]
    #[inline(always)]
    pub fn is_masked(&self) -> bool {
        **self == EVEN0_A::MASKED
    }
    #[doc = "Checks if the value of the field is `UNMASKED`"]
    #[inline(always)]
    pub fn is_unmasked(&self) -> bool {
        **self == EVEN0_A::UNMASKED
    }
}
impl core::ops::Deref for EVEN0_R {
    type Target = crate::FieldReader<bool, EVEN0_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `EVEN0` writer - Event enable on line 0"]
pub struct EVEN0_W<'a> {
    w: &'a mut W,
}
impl<'a> EVEN0_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: EVEN0_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Event from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(EVEN0_A::MASKED)
    }
    #[doc = "Event from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(EVEN0_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
#[doc = "Event enable on line 1"]
pub type EVEN1_A = EVEN0_A;
#[doc = "Field `EVEN1` reader - Event enable on line 1"]
pub type EVEN1_R = EVEN0_R;
#[doc = "Field `EVEN1` writer - Event enable on line 1"]
pub struct EVEN1_W<'a> {
    w: &'a mut W,
}
impl<'a> EVEN1_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: EVEN1_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Event from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(EVEN1_A::MASKED)
    }
    #[doc = "Event from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(EVEN1_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "Event enable on line 2"]
pub type EVEN2_A = EVEN0_A;
#[doc = "Field `EVEN2` reader - Event enable on line 2"]
pub type EVEN2_R = EVEN0_R;
#[doc = "Field `EVEN2` writer - Event enable on line 2"]
pub struct EVEN2_W<'a> {
    w: &'a mut W,
}
impl<'a> EVEN2_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: EVEN2_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Event from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(EVEN2_A::MASKED)
    }
    #[doc = "Event from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(EVEN2_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u32 & 0x01) << 2);
        self.w
    }
}
#[doc = "Event enable on line 3"]
pub type EVEN3_A = EVEN0_A;
#[doc = "Field `EVEN3` reader - Event enable on line 3"]
pub type EVEN3_R = EVEN0_R;
#[doc = "Field `EVEN3` writer - Event enable on line 3"]
pub struct EVEN3_W<'a> {
    w: &'a mut W,
}
impl<'a> EVEN3_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: EVEN3_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Event from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(EVEN3_A::MASKED)
    }
    #[doc = "Event from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(EVEN3_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u32 & 0x01) << 3);
        self.w
    }
}
#[doc = "Event enable on line 4"]
pub type EVEN4_A = EVEN0_A;
#[doc = "Field `EVEN4` reader - Event enable on line 4"]
pub type EVEN4_R = EVEN0_R;
#[doc = "Field `EVEN4` writer - Event enable on line 4"]
pub struct EVEN4_W<'a> {
    w: &'a mut W,
}
impl<'a> EVEN4_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: EVEN4_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Event from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(EVEN4_A::MASKED)
    }
    #[doc = "Event from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(EVEN4_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u32 & 0x01) << 4);
        self.w
    }
}
#[doc = "Event enable on line 5"]
pub type EVEN5_A = EVEN0_A;
#[doc = "Field `EVEN5` reader - Event enable on line 5"]
pub type EVEN5_R = EVEN0_R;
#[doc = "Field `EVEN5` writer - Event enable on line 5"]
pub struct EVEN5_W<'a> {
    w: &'a mut W,
}
impl<'a> EVEN5_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: EVEN5_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Event from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(EVEN5_A::MASKED)
    }
    #[doc = "Event from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(EVEN5_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u32 & 0x01) << 5);
        self.w
    }
}
#[doc = "Event enable on line 6"]
pub type EVEN6_A = EVEN0_A;
#[doc = "Field `EVEN6` reader - Event enable on line 6"]
pub type EVEN6_R = EVEN0_R;
#[doc = "Field `EVEN6` writer - Event enable on line 6"]
pub struct EVEN6_W<'a> {
    w: &'a mut W,
}
impl<'a> EVEN6_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: EVEN6_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Event from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(EVEN6_A::MASKED)
    }
    #[doc = "Event from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(EVEN6_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u32 & 0x01) << 6);
        self.w
    }
}
#[doc = "Event enable on line 7"]
pub type EVEN7_A = EVEN0_A;
#[doc = "Field `EVEN7` reader - Event enable on line 7"]
pub type EVEN7_R = EVEN0_R;
#[doc = "Field `EVEN7` writer - Event enable on line 7"]
pub struct EVEN7_W<'a> {
    w: &'a mut W,
}
impl<'a> EVEN7_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: EVEN7_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Event from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(EVEN7_A::MASKED)
    }
    #[doc = "Event from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(EVEN7_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u32 & 0x01) << 7);
        self.w
    }
}
#[doc = "Event enable on line 8"]
pub type EVEN8_A = EVEN0_A;
#[doc = "Field `EVEN8` reader - Event enable on line 8"]
pub type EVEN8_R = EVEN0_R;
#[doc = "Field `EVEN8` writer - Event enable on line 8"]
pub struct EVEN8_W<'a> {
    w: &'a mut W,
}
impl<'a> EVEN8_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: EVEN8_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Event from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(EVEN8_A::MASKED)
    }
    #[doc = "Event from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(EVEN8_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 8)) | ((value as u32 & 0x01) << 8);
        self.w
    }
}
#[doc = "Event enable on line 9"]
pub type EVEN9_A = EVEN0_A;
#[doc = "Field `EVEN9` reader - Event enable on line 9"]
pub type EVEN9_R = EVEN0_R;
#[doc = "Field `EVEN9` writer - Event enable on line 9"]
pub struct EVEN9_W<'a> {
    w: &'a mut W,
}
impl<'a> EVEN9_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: EVEN9_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Event from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(EVEN9_A::MASKED)
    }
    #[doc = "Event from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(EVEN9_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 9)) | ((value as u32 & 0x01) << 9);
        self.w
    }
}
#[doc = "Event enable on line 10"]
pub type EVEN10_A = EVEN0_A;
#[doc = "Field `EVEN10` reader - Event enable on line 10"]
pub type EVEN10_R = EVEN0_R;
#[doc = "Field `EVEN10` writer - Event enable on line 10"]
pub struct EVEN10_W<'a> {
    w: &'a mut W,
}
impl<'a> EVEN10_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: EVEN10_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Event from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(EVEN10_A::MASKED)
    }
    #[doc = "Event from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(EVEN10_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 10)) | ((value as u32 & 0x01) << 10);
        self.w
    }
}
#[doc = "Event enable on line 11"]
pub type EVEN11_A = EVEN0_A;
#[doc = "Field `EVEN11` reader - Event enable on line 11"]
pub type EVEN11_R = EVEN0_R;
#[doc = "Field `EVEN11` writer - Event enable on line 11"]
pub struct EVEN11_W<'a> {
    w: &'a mut W,
}
impl<'a> EVEN11_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: EVEN11_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Event from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(EVEN11_A::MASKED)
    }
    #[doc = "Event from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(EVEN11_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 11)) | ((value as u32 & 0x01) << 11);
        self.w
    }
}
#[doc = "Event enable on line 12"]
pub type EVEN12_A = EVEN0_A;
#[doc = "Field `EVEN12` reader - Event enable on line 12"]
pub type EVEN12_R = EVEN0_R;
#[doc = "Field `EVEN12` writer - Event enable on line 12"]
pub struct EVEN12_W<'a> {
    w: &'a mut W,
}
impl<'a> EVEN12_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: EVEN12_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Event from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(EVEN12_A::MASKED)
    }
    #[doc = "Event from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(EVEN12_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 12)) | ((value as u32 & 0x01) << 12);
        self.w
    }
}
#[doc = "Event enable on line 13"]
pub type EVEN13_A = EVEN0_A;
#[doc = "Field `EVEN13` reader - Event enable on line 13"]
pub type EVEN13_R = EVEN0_R;
#[doc = "Field `EVEN13` writer - Event enable on line 13"]
pub struct EVEN13_W<'a> {
    w: &'a mut W,
}
impl<'a> EVEN13_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: EVEN13_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Event from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(EVEN13_A::MASKED)
    }
    #[doc = "Event from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(EVEN13_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 13)) | ((value as u32 & 0x01) << 13);
        self.w
    }
}
#[doc = "Event enable on line 14"]
pub type EVEN14_A = EVEN0_A;
#[doc = "Field `EVEN14` reader - Event enable on line 14"]
pub type EVEN14_R = EVEN0_R;
#[doc = "Field `EVEN14` writer - Event enable on line 14"]
pub struct EVEN14_W<'a> {
    w: &'a mut W,
}
impl<'a> EVEN14_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: EVEN14_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Event from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(EVEN14_A::MASKED)
    }
    #[doc = "Event from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(EVEN14_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 14)) | ((value as u32 & 0x01) << 14);
        self.w
    }
}
#[doc = "Event enable on line 15"]
pub type EVEN15_A = EVEN0_A;
#[doc = "Field `EVEN15` reader - Event enable on line 15"]
pub type EVEN15_R = EVEN0_R;
#[doc = "Field `EVEN15` writer - Event enable on line 15"]
pub struct EVEN15_W<'a> {
    w: &'a mut W,
}
impl<'a> EVEN15_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: EVEN15_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Event from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(EVEN15_A::MASKED)
    }
    #[doc = "Event from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(EVEN15_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 15)) | ((value as u32 & 0x01) << 15);
        self.w
    }
}
#[doc = "Event enable on line 16"]
pub type EVEN16_A = EVEN0_A;
#[doc = "Field `EVEN16` reader - Event enable on line 16"]
pub type EVEN16_R = EVEN0_R;
#[doc = "Field `EVEN16` writer - Event enable on line 16"]
pub struct EVEN16_W<'a> {
    w: &'a mut W,
}
impl<'a> EVEN16_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: EVEN16_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Event from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(EVEN16_A::MASKED)
    }
    #[doc = "Event from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(EVEN16_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 16)) | ((value as u32 & 0x01) << 16);
        self.w
    }
}
#[doc = "Event enable on line 17"]
pub type EVEN17_A = EVEN0_A;
#[doc = "Field `EVEN17` reader - Event enable on line 17"]
pub type EVEN17_R = EVEN0_R;
#[doc = "Field `EVEN17` writer - Event enable on line 17"]
pub struct EVEN17_W<'a> {
    w: &'a mut W,
}
impl<'a> EVEN17_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: EVEN17_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Event from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(EVEN17_A::MASKED)
    }
    #[doc = "Event from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(EVEN17_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 17)) | ((value as u32 & 0x01) << 17);
        self.w
    }
}
#[doc = "Event enable on line 18"]
pub type EVEN18_A = EVEN0_A;
#[doc = "Field `EVEN18` reader - Event enable on line 18"]
pub type EVEN18_R = EVEN0_R;
#[doc = "Field `EVEN18` writer - Event enable on line 18"]
pub struct EVEN18_W<'a> {
    w: &'a mut W,
}
impl<'a> EVEN18_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: EVEN18_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Event from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(EVEN18_A::MASKED)
    }
    #[doc = "Event from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(EVEN18_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 18)) | ((value as u32 & 0x01) << 18);
        self.w
    }
}
#[doc = "Event enable on line 19"]
pub type EVEN19_A = EVEN0_A;
#[doc = "Field `EVEN19` reader - Event enable on line 19"]
pub type EVEN19_R = EVEN0_R;
#[doc = "Field `EVEN19` writer - Event enable on line 19"]
pub struct EVEN19_W<'a> {
    w: &'a mut W,
}
impl<'a> EVEN19_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: EVEN19_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Event from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(EVEN19_A::MASKED)
    }
    #[doc = "Event from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(EVEN19_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 19)) | ((value as u32 & 0x01) << 19);
        self.w
    }
}
#[doc = "Event enable on line 20"]
pub type EVEN20_A = EVEN0_A;
#[doc = "Field `EVEN20` reader - Event enable on line 20"]
pub type EVEN20_R = EVEN0_R;
#[doc = "Field `EVEN20` writer - Event enable on line 20"]
pub struct EVEN20_W<'a> {
    w: &'a mut W,
}
impl<'a> EVEN20_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: EVEN20_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Event from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(EVEN20_A::MASKED)
    }
    #[doc = "Event from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(EVEN20_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 20)) | ((value as u32 & 0x01) << 20);
        self.w
    }
}
#[doc = "Event enable on line 21"]
pub type EVEN21_A = EVEN0_A;
#[doc = "Field `EVEN21` reader - Event enable on line 21"]
pub type EVEN21_R = EVEN0_R;
#[doc = "Field `EVEN21` writer - Event enable on line 21"]
pub struct EVEN21_W<'a> {
    w: &'a mut W,
}
impl<'a> EVEN21_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: EVEN21_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Event from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(EVEN21_A::MASKED)
    }
    #[doc = "Event from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(EVEN21_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 21)) | ((value as u32 & 0x01) << 21);
        self.w
    }
}
#[doc = "Event enable on line 22"]
pub type EVEN22_A = EVEN0_A;
#[doc = "Field `EVEN22` reader - Event enable on line 22"]
pub type EVEN22_R = EVEN0_R;
#[doc = "Field `EVEN22` writer - Event enable on line 22"]
pub struct EVEN22_W<'a> {
    w: &'a mut W,
}
impl<'a> EVEN22_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: EVEN22_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Event from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(EVEN22_A::MASKED)
    }
    #[doc = "Event from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(EVEN22_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 22)) | ((value as u32 & 0x01) << 22);
        self.w
    }
}
#[doc = "Event enable on line 23"]
pub type EVEN23_A = EVEN0_A;
#[doc = "Field `EVEN23` reader - Event enable on line 23"]
pub type EVEN23_R = EVEN0_R;
#[doc = "Field `EVEN23` writer - Event enable on line 23"]
pub struct EVEN23_W<'a> {
    w: &'a mut W,
}
impl<'a> EVEN23_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: EVEN23_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Event from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(EVEN23_A::MASKED)
    }
    #[doc = "Event from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(EVEN23_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 23)) | ((value as u32 & 0x01) << 23);
        self.w
    }
}
#[doc = "Event enable on line 24"]
pub type EVEN24_A = EVEN0_A;
#[doc = "Field `EVEN24` reader - Event enable on line 24"]
pub type EVEN24_R = EVEN0_R;
#[doc = "Field `EVEN24` writer - Event enable on line 24"]
pub struct EVEN24_W<'a> {
    w: &'a mut W,
}
impl<'a> EVEN24_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: EVEN24_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Event from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(EVEN24_A::MASKED)
    }
    #[doc = "Event from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(EVEN24_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 24)) | ((value as u32 & 0x01) << 24);
        self.w
    }
}
#[doc = "Event enable on line 25"]
pub type EVEN25_A = EVEN0_A;
#[doc = "Field `EVEN25` reader - Event enable on line 25"]
pub type EVEN25_R = EVEN0_R;
#[doc = "Field `EVEN25` writer - Event enable on line 25"]
pub struct EVEN25_W<'a> {
    w: &'a mut W,
}
impl<'a> EVEN25_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: EVEN25_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Event from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(EVEN25_A::MASKED)
    }
    #[doc = "Event from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(EVEN25_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 25)) | ((value as u32 & 0x01) << 25);
        self.w
    }
}
#[doc = "Event enable on line 26"]
pub type EVEN26_A = EVEN0_A;
#[doc = "Field `EVEN26` reader - Event enable on line 26"]
pub type EVEN26_R = EVEN0_R;
#[doc = "Field `EVEN26` writer - Event enable on line 26"]
pub struct EVEN26_W<'a> {
    w: &'a mut W,
}
impl<'a> EVEN26_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: EVEN26_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Event from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(EVEN26_A::MASKED)
    }
    #[doc = "Event from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(EVEN26_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 26)) | ((value as u32 & 0x01) << 26);
        self.w
    }
}
#[doc = "Event enable on line 27"]
pub type EVEN27_A = EVEN0_A;
#[doc = "Field `EVEN27` reader - Event enable on line 27"]
pub type EVEN27_R = EVEN0_R;
#[doc = "Field `EVEN27` writer - Event enable on line 27"]
pub struct EVEN27_W<'a> {
    w: &'a mut W,
}
impl<'a> EVEN27_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: EVEN27_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Event from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(EVEN27_A::MASKED)
    }
    #[doc = "Event from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(EVEN27_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 27)) | ((value as u32 & 0x01) << 27);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Event enable on line 0"]
    #[inline(always)]
    pub fn even0(&self) -> EVEN0_R {
        EVEN0_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Event enable on line 1"]
    #[inline(always)]
    pub fn even1(&self) -> EVEN1_R {
        EVEN1_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Event enable on line 2"]
    #[inline(always)]
    pub fn even2(&self) -> EVEN2_R {
        EVEN2_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Event enable on line 3"]
    #[inline(always)]
    pub fn even3(&self) -> EVEN3_R {
        EVEN3_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Event enable on line 4"]
    #[inline(always)]
    pub fn even4(&self) -> EVEN4_R {
        EVEN4_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Event enable on line 5"]
    #[inline(always)]
    pub fn even5(&self) -> EVEN5_R {
        EVEN5_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Event enable on line 6"]
    #[inline(always)]
    pub fn even6(&self) -> EVEN6_R {
        EVEN6_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Event enable on line 7"]
    #[inline(always)]
    pub fn even7(&self) -> EVEN7_R {
        EVEN7_R::new(((self.bits >> 7) & 0x01) != 0)
    }
    #[doc = "Bit 8 - Event enable on line 8"]
    #[inline(always)]
    pub fn even8(&self) -> EVEN8_R {
        EVEN8_R::new(((self.bits >> 8) & 0x01) != 0)
    }
    #[doc = "Bit 9 - Event enable on line 9"]
    #[inline(always)]
    pub fn even9(&self) -> EVEN9_R {
        EVEN9_R::new(((self.bits >> 9) & 0x01) != 0)
    }
    #[doc = "Bit 10 - Event enable on line 10"]
    #[inline(always)]
    pub fn even10(&self) -> EVEN10_R {
        EVEN10_R::new(((self.bits >> 10) & 0x01) != 0)
    }
    #[doc = "Bit 11 - Event enable on line 11"]
    #[inline(always)]
    pub fn even11(&self) -> EVEN11_R {
        EVEN11_R::new(((self.bits >> 11) & 0x01) != 0)
    }
    #[doc = "Bit 12 - Event enable on line 12"]
    #[inline(always)]
    pub fn even12(&self) -> EVEN12_R {
        EVEN12_R::new(((self.bits >> 12) & 0x01) != 0)
    }
    #[doc = "Bit 13 - Event enable on line 13"]
    #[inline(always)]
    pub fn even13(&self) -> EVEN13_R {
        EVEN13_R::new(((self.bits >> 13) & 0x01) != 0)
    }
    #[doc = "Bit 14 - Event enable on line 14"]
    #[inline(always)]
    pub fn even14(&self) -> EVEN14_R {
        EVEN14_R::new(((self.bits >> 14) & 0x01) != 0)
    }
    #[doc = "Bit 15 - Event enable on line 15"]
    #[inline(always)]
    pub fn even15(&self) -> EVEN15_R {
        EVEN15_R::new(((self.bits >> 15) & 0x01) != 0)
    }
    #[doc = "Bit 16 - Event enable on line 16"]
    #[inline(always)]
    pub fn even16(&self) -> EVEN16_R {
        EVEN16_R::new(((self.bits >> 16) & 0x01) != 0)
    }
    #[doc = "Bit 17 - Event enable on line 17"]
    #[inline(always)]
    pub fn even17(&self) -> EVEN17_R {
        EVEN17_R::new(((self.bits >> 17) & 0x01) != 0)
    }
    #[doc = "Bit 18 - Event enable on line 18"]
    #[inline(always)]
    pub fn even18(&self) -> EVEN18_R {
        EVEN18_R::new(((self.bits >> 18) & 0x01) != 0)
    }
    #[doc = "Bit 19 - Event enable on line 19"]
    #[inline(always)]
    pub fn even19(&self) -> EVEN19_R {
        EVEN19_R::new(((self.bits >> 19) & 0x01) != 0)
    }
    #[doc = "Bit 20 - Event enable on line 20"]
    #[inline(always)]
    pub fn even20(&self) -> EVEN20_R {
        EVEN20_R::new(((self.bits >> 20) & 0x01) != 0)
    }
    #[doc = "Bit 21 - Event enable on line 21"]
    #[inline(always)]
    pub fn even21(&self) -> EVEN21_R {
        EVEN21_R::new(((self.bits >> 21) & 0x01) != 0)
    }
    #[doc = "Bit 22 - Event enable on line 22"]
    #[inline(always)]
    pub fn even22(&self) -> EVEN22_R {
        EVEN22_R::new(((self.bits >> 22) & 0x01) != 0)
    }
    #[doc = "Bit 23 - Event enable on line 23"]
    #[inline(always)]
    pub fn even23(&self) -> EVEN23_R {
        EVEN23_R::new(((self.bits >> 23) & 0x01) != 0)
    }
    #[doc = "Bit 24 - Event enable on line 24"]
    #[inline(always)]
    pub fn even24(&self) -> EVEN24_R {
        EVEN24_R::new(((self.bits >> 24) & 0x01) != 0)
    }
    #[doc = "Bit 25 - Event enable on line 25"]
    #[inline(always)]
    pub fn even25(&self) -> EVEN25_R {
        EVEN25_R::new(((self.bits >> 25) & 0x01) != 0)
    }
    #[doc = "Bit 26 - Event enable on line 26"]
    #[inline(always)]
    pub fn even26(&self) -> EVEN26_R {
        EVEN26_R::new(((self.bits >> 26) & 0x01) != 0)
    }
    #[doc = "Bit 27 - Event enable on line 27"]
    #[inline(always)]
    pub fn even27(&self) -> EVEN27_R {
        EVEN27_R::new(((self.bits >> 27) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Event enable on line 0"]
    #[inline(always)]
    pub fn even0(&mut self) -> EVEN0_W {
        EVEN0_W { w: self }
    }
    #[doc = "Bit 1 - Event enable on line 1"]
    #[inline(always)]
    pub fn even1(&mut self) -> EVEN1_W {
        EVEN1_W { w: self }
    }
    #[doc = "Bit 2 - Event enable on line 2"]
    #[inline(always)]
    pub fn even2(&mut self) -> EVEN2_W {
        EVEN2_W { w: self }
    }
    #[doc = "Bit 3 - Event enable on line 3"]
    #[inline(always)]
    pub fn even3(&mut self) -> EVEN3_W {
        EVEN3_W { w: self }
    }
    #[doc = "Bit 4 - Event enable on line 4"]
    #[inline(always)]
    pub fn even4(&mut self) -> EVEN4_W {
        EVEN4_W { w: self }
    }
    #[doc = "Bit 5 - Event enable on line 5"]
    #[inline(always)]
    pub fn even5(&mut self) -> EVEN5_W {
        EVEN5_W { w: self }
    }
    #[doc = "Bit 6 - Event enable on line 6"]
    #[inline(always)]
    pub fn even6(&mut self) -> EVEN6_W {
        EVEN6_W { w: self }
    }
    #[doc = "Bit 7 - Event enable on line 7"]
    #[inline(always)]
    pub fn even7(&mut self) -> EVEN7_W {
        EVEN7_W { w: self }
    }
    #[doc = "Bit 8 - Event enable on line 8"]
    #[inline(always)]
    pub fn even8(&mut self) -> EVEN8_W {
        EVEN8_W { w: self }
    }
    #[doc = "Bit 9 - Event enable on line 9"]
    #[inline(always)]
    pub fn even9(&mut self) -> EVEN9_W {
        EVEN9_W { w: self }
    }
    #[doc = "Bit 10 - Event enable on line 10"]
    #[inline(always)]
    pub fn even10(&mut self) -> EVEN10_W {
        EVEN10_W { w: self }
    }
    #[doc = "Bit 11 - Event enable on line 11"]
    #[inline(always)]
    pub fn even11(&mut self) -> EVEN11_W {
        EVEN11_W { w: self }
    }
    #[doc = "Bit 12 - Event enable on line 12"]
    #[inline(always)]
    pub fn even12(&mut self) -> EVEN12_W {
        EVEN12_W { w: self }
    }
    #[doc = "Bit 13 - Event enable on line 13"]
    #[inline(always)]
    pub fn even13(&mut self) -> EVEN13_W {
        EVEN13_W { w: self }
    }
    #[doc = "Bit 14 - Event enable on line 14"]
    #[inline(always)]
    pub fn even14(&mut self) -> EVEN14_W {
        EVEN14_W { w: self }
    }
    #[doc = "Bit 15 - Event enable on line 15"]
    #[inline(always)]
    pub fn even15(&mut self) -> EVEN15_W {
        EVEN15_W { w: self }
    }
    #[doc = "Bit 16 - Event enable on line 16"]
    #[inline(always)]
    pub fn even16(&mut self) -> EVEN16_W {
        EVEN16_W { w: self }
    }
    #[doc = "Bit 17 - Event enable on line 17"]
    #[inline(always)]
    pub fn even17(&mut self) -> EVEN17_W {
        EVEN17_W { w: self }
    }
    #[doc = "Bit 18 - Event enable on line 18"]
    #[inline(always)]
    pub fn even18(&mut self) -> EVEN18_W {
        EVEN18_W { w: self }
    }
    #[doc = "Bit 19 - Event enable on line 19"]
    #[inline(always)]
    pub fn even19(&mut self) -> EVEN19_W {
        EVEN19_W { w: self }
    }
    #[doc = "Bit 20 - Event enable on line 20"]
    #[inline(always)]
    pub fn even20(&mut self) -> EVEN20_W {
        EVEN20_W { w: self }
    }
    #[doc = "Bit 21 - Event enable on line 21"]
    #[inline(always)]
    pub fn even21(&mut self) -> EVEN21_W {
        EVEN21_W { w: self }
    }
    #[doc = "Bit 22 - Event enable on line 22"]
    #[inline(always)]
    pub fn even22(&mut self) -> EVEN22_W {
        EVEN22_W { w: self }
    }
    #[doc = "Bit 23 - Event enable on line 23"]
    #[inline(always)]
    pub fn even23(&mut self) -> EVEN23_W {
        EVEN23_W { w: self }
    }
    #[doc = "Bit 24 - Event enable on line 24"]
    #[inline(always)]
    pub fn even24(&mut self) -> EVEN24_W {
        EVEN24_W { w: self }
    }
    #[doc = "Bit 25 - Event enable on line 25"]
    #[inline(always)]
    pub fn even25(&mut self) -> EVEN25_W {
        EVEN25_W { w: self }
    }
    #[doc = "Bit 26 - Event enable on line 26"]
    #[inline(always)]
    pub fn even26(&mut self) -> EVEN26_W {
        EVEN26_W { w: self }
    }
    #[doc = "Bit 27 - Event enable on line 27"]
    #[inline(always)]
    pub fn even27(&mut self) -> EVEN27_W {
        EVEN27_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Event enable register (EXTI_EVEN)\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [even](index.html) module"]
pub struct EVEN_SPEC;
impl crate::RegisterSpec for EVEN_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [even::R](R) reader structure"]
impl crate::Readable for EVEN_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [even::W](W) writer structure"]
impl crate::Writable for EVEN_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets EVEN to value 0"]
impl crate::Resettable for EVEN_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
