#[doc = "Register `LPMINTF` reader"]
pub struct R(crate::R<LPMINTF_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<LPMINTF_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::convert::From<crate::R<LPMINTF_SPEC>> for R {
    fn from(reader: crate::R<LPMINTF_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `LPMINTF` writer"]
pub struct W(crate::W<LPMINTF_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<LPMINTF_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl core::convert::From<crate::W<LPMINTF_SPEC>> for W {
    fn from(writer: crate::W<LPMINTF_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `LPMSTIF` reader - LPM token Correct transfer interrupt flag"]
pub struct LPMSTIF_R(crate::FieldReader<bool, bool>);
impl LPMSTIF_R {
    pub(crate) fn new(bits: bool) -> Self {
        LPMSTIF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LPMSTIF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LPMSTIF` writer - LPM token Correct transfer interrupt flag"]
pub struct LPMSTIF_W<'a> {
    w: &'a mut W,
}
impl<'a> LPMSTIF_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 15)) | ((value as u16 & 0x01) << 15);
        self.w
    }
}
impl R {
    #[doc = "Bit 15 - LPM token Correct transfer interrupt flag"]
    #[inline(always)]
    pub fn lpmstif(&self) -> LPMSTIF_R {
        LPMSTIF_R::new(((self.bits >> 15) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 15 - LPM token Correct transfer interrupt flag"]
    #[inline(always)]
    pub fn lpmstif(&mut self) -> LPMSTIF_W {
        LPMSTIF_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    pub unsafe fn bits(&mut self, bits: u16) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "USB LPM interrupt flag register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [lpmintf](index.html) module"]
pub struct LPMINTF_SPEC;
impl crate::RegisterSpec for LPMINTF_SPEC {
    type Ux = u16;
}
#[doc = "`read()` method returns [lpmintf::R](R) reader structure"]
impl crate::Readable for LPMINTF_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [lpmintf::W](W) writer structure"]
impl crate::Writable for LPMINTF_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets LPMINTF to value 0"]
impl crate::Resettable for LPMINTF_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
