#[doc = "Register `TAMP` reader"]
pub struct R(crate::R<TAMP_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TAMP_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::convert::From<crate::R<TAMP_SPEC>> for R {
    fn from(reader: crate::R<TAMP_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `TAMP` writer"]
pub struct W(crate::W<TAMP_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<TAMP_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl core::convert::From<crate::W<TAMP_SPEC>> for W {
    fn from(writer: crate::W<TAMP_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `PC15MDE` reader - PC15 mode"]
pub struct PC15MDE_R(crate::FieldReader<bool, bool>);
impl PC15MDE_R {
    pub(crate) fn new(bits: bool) -> Self {
        PC15MDE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PC15MDE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PC15MDE` writer - PC15 mode"]
pub struct PC15MDE_W<'a> {
    w: &'a mut W,
}
impl<'a> PC15MDE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 23)) | ((value as u32 & 0x01) << 23);
        self.w
    }
}
#[doc = "Field `PC15VAL` reader - PC15 value"]
pub struct PC15VAL_R(crate::FieldReader<bool, bool>);
impl PC15VAL_R {
    pub(crate) fn new(bits: bool) -> Self {
        PC15VAL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PC15VAL_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PC15VAL` writer - PC15 value"]
pub struct PC15VAL_W<'a> {
    w: &'a mut W,
}
impl<'a> PC15VAL_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 22)) | ((value as u32 & 0x01) << 22);
        self.w
    }
}
#[doc = "Field `PC14MDE` reader - PC14 mode"]
pub struct PC14MDE_R(crate::FieldReader<bool, bool>);
impl PC14MDE_R {
    pub(crate) fn new(bits: bool) -> Self {
        PC14MDE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PC14MDE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PC14MDE` writer - PC14 mode"]
pub struct PC14MDE_W<'a> {
    w: &'a mut W,
}
impl<'a> PC14MDE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 21)) | ((value as u32 & 0x01) << 21);
        self.w
    }
}
#[doc = "Field `PC14VAL` reader - PC14 value"]
pub struct PC14VAL_R(crate::FieldReader<bool, bool>);
impl PC14VAL_R {
    pub(crate) fn new(bits: bool) -> Self {
        PC14VAL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PC14VAL_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PC14VAL` writer - PC14 value"]
pub struct PC14VAL_W<'a> {
    w: &'a mut W,
}
impl<'a> PC14VAL_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 20)) | ((value as u32 & 0x01) << 20);
        self.w
    }
}
#[doc = "Field `PC13MDE` reader - PC13 mode"]
pub struct PC13MDE_R(crate::FieldReader<bool, bool>);
impl PC13MDE_R {
    pub(crate) fn new(bits: bool) -> Self {
        PC13MDE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PC13MDE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PC13MDE` writer - PC13 mode"]
pub struct PC13MDE_W<'a> {
    w: &'a mut W,
}
impl<'a> PC13MDE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 19)) | ((value as u32 & 0x01) << 19);
        self.w
    }
}
#[doc = "Field `PC13VAL` reader - Alarm output type control/PC13 output value"]
pub struct PC13VAL_R(crate::FieldReader<bool, bool>);
impl PC13VAL_R {
    pub(crate) fn new(bits: bool) -> Self {
        PC13VAL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PC13VAL_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PC13VAL` writer - Alarm output type control/PC13 output value"]
pub struct PC13VAL_W<'a> {
    w: &'a mut W,
}
impl<'a> PC13VAL_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 18)) | ((value as u32 & 0x01) << 18);
        self.w
    }
}
#[doc = "Field `DISPU` reader - RTC_TAMPx pull up disable bit"]
pub struct DISPU_R(crate::FieldReader<bool, bool>);
impl DISPU_R {
    pub(crate) fn new(bits: bool) -> Self {
        DISPU_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DISPU_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DISPU` writer - RTC_TAMPx pull up disable bit"]
pub struct DISPU_W<'a> {
    w: &'a mut W,
}
impl<'a> DISPU_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 15)) | ((value as u32 & 0x01) << 15);
        self.w
    }
}
#[doc = "Field `PRCH` reader - Precharge duration time of RTC_TAMPx"]
pub struct PRCH_R(crate::FieldReader<u8, u8>);
impl PRCH_R {
    pub(crate) fn new(bits: u8) -> Self {
        PRCH_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PRCH_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PRCH` writer - Precharge duration time of RTC_TAMPx"]
pub struct PRCH_W<'a> {
    w: &'a mut W,
}
impl<'a> PRCH_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 13)) | ((value as u32 & 0x03) << 13);
        self.w
    }
}
#[doc = "Field `FLT` reader - RTC_TAMPx filter count setting"]
pub struct FLT_R(crate::FieldReader<u8, u8>);
impl FLT_R {
    pub(crate) fn new(bits: u8) -> Self {
        FLT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FLT_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FLT` writer - RTC_TAMPx filter count setting"]
pub struct FLT_W<'a> {
    w: &'a mut W,
}
impl<'a> FLT_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 11)) | ((value as u32 & 0x03) << 11);
        self.w
    }
}
#[doc = "Field `FREQ` reader - Sample frequency of tamper event detection"]
pub struct FREQ_R(crate::FieldReader<u8, u8>);
impl FREQ_R {
    pub(crate) fn new(bits: u8) -> Self {
        FREQ_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FREQ_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FREQ` writer - Sample frequency of tamper event detection"]
pub struct FREQ_W<'a> {
    w: &'a mut W,
}
impl<'a> FREQ_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 8)) | ((value as u32 & 0x07) << 8);
        self.w
    }
}
#[doc = "Field `TPTS` reader - Make tamper function used for timestamp function"]
pub struct TPTS_R(crate::FieldReader<bool, bool>);
impl TPTS_R {
    pub(crate) fn new(bits: bool) -> Self {
        TPTS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TPTS_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TPTS` writer - Make tamper function used for timestamp function"]
pub struct TPTS_W<'a> {
    w: &'a mut W,
}
impl<'a> TPTS_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u32 & 0x01) << 7);
        self.w
    }
}
#[doc = "Field `TP1EG` reader - Tamper 1 event trigger edge for RTC_TAMP1 input"]
pub struct TP1EG_R(crate::FieldReader<bool, bool>);
impl TP1EG_R {
    pub(crate) fn new(bits: bool) -> Self {
        TP1EG_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TP1EG_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TP1EG` writer - Tamper 1 event trigger edge for RTC_TAMP1 input"]
pub struct TP1EG_W<'a> {
    w: &'a mut W,
}
impl<'a> TP1EG_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u32 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `TP1EN` reader - Tamper 1 detection enable"]
pub struct TP1EN_R(crate::FieldReader<bool, bool>);
impl TP1EN_R {
    pub(crate) fn new(bits: bool) -> Self {
        TP1EN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TP1EN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TP1EN` writer - Tamper 1 detection enable"]
pub struct TP1EN_W<'a> {
    w: &'a mut W,
}
impl<'a> TP1EN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u32 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `TPIE` reader - Tamper detection interrupt enable"]
pub struct TPIE_R(crate::FieldReader<bool, bool>);
impl TPIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        TPIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TPIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TPIE` writer - Tamper detection interrupt enable"]
pub struct TPIE_W<'a> {
    w: &'a mut W,
}
impl<'a> TPIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u32 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `TP0EG` reader - Tamper 0 event trigger edge for RTC_TAMP0 input"]
pub struct TP0EG_R(crate::FieldReader<bool, bool>);
impl TP0EG_R {
    pub(crate) fn new(bits: bool) -> Self {
        TP0EG_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TP0EG_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TP0EG` writer - Tamper 0 event trigger edge for RTC_TAMP0 input"]
pub struct TP0EG_W<'a> {
    w: &'a mut W,
}
impl<'a> TP0EG_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `TP0EN` reader - RTC_TAMP1 input detection enable"]
pub struct TP0EN_R(crate::FieldReader<bool, bool>);
impl TP0EN_R {
    pub(crate) fn new(bits: bool) -> Self {
        TP0EN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TP0EN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TP0EN` writer - RTC_TAMP1 input detection enable"]
pub struct TP0EN_W<'a> {
    w: &'a mut W,
}
impl<'a> TP0EN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
impl R {
    #[doc = "Bit 23 - PC15 mode"]
    #[inline(always)]
    pub fn pc15mde(&self) -> PC15MDE_R {
        PC15MDE_R::new(((self.bits >> 23) & 0x01) != 0)
    }
    #[doc = "Bit 22 - PC15 value"]
    #[inline(always)]
    pub fn pc15val(&self) -> PC15VAL_R {
        PC15VAL_R::new(((self.bits >> 22) & 0x01) != 0)
    }
    #[doc = "Bit 21 - PC14 mode"]
    #[inline(always)]
    pub fn pc14mde(&self) -> PC14MDE_R {
        PC14MDE_R::new(((self.bits >> 21) & 0x01) != 0)
    }
    #[doc = "Bit 20 - PC14 value"]
    #[inline(always)]
    pub fn pc14val(&self) -> PC14VAL_R {
        PC14VAL_R::new(((self.bits >> 20) & 0x01) != 0)
    }
    #[doc = "Bit 19 - PC13 mode"]
    #[inline(always)]
    pub fn pc13mde(&self) -> PC13MDE_R {
        PC13MDE_R::new(((self.bits >> 19) & 0x01) != 0)
    }
    #[doc = "Bit 18 - Alarm output type control/PC13 output value"]
    #[inline(always)]
    pub fn pc13val(&self) -> PC13VAL_R {
        PC13VAL_R::new(((self.bits >> 18) & 0x01) != 0)
    }
    #[doc = "Bit 15 - RTC_TAMPx pull up disable bit"]
    #[inline(always)]
    pub fn dispu(&self) -> DISPU_R {
        DISPU_R::new(((self.bits >> 15) & 0x01) != 0)
    }
    #[doc = "Bits 13:14 - Precharge duration time of RTC_TAMPx"]
    #[inline(always)]
    pub fn prch(&self) -> PRCH_R {
        PRCH_R::new(((self.bits >> 13) & 0x03) as u8)
    }
    #[doc = "Bits 11:12 - RTC_TAMPx filter count setting"]
    #[inline(always)]
    pub fn flt(&self) -> FLT_R {
        FLT_R::new(((self.bits >> 11) & 0x03) as u8)
    }
    #[doc = "Bits 8:10 - Sample frequency of tamper event detection"]
    #[inline(always)]
    pub fn freq(&self) -> FREQ_R {
        FREQ_R::new(((self.bits >> 8) & 0x07) as u8)
    }
    #[doc = "Bit 7 - Make tamper function used for timestamp function"]
    #[inline(always)]
    pub fn tpts(&self) -> TPTS_R {
        TPTS_R::new(((self.bits >> 7) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Tamper 1 event trigger edge for RTC_TAMP1 input"]
    #[inline(always)]
    pub fn tp1eg(&self) -> TP1EG_R {
        TP1EG_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Tamper 1 detection enable"]
    #[inline(always)]
    pub fn tp1en(&self) -> TP1EN_R {
        TP1EN_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Tamper detection interrupt enable"]
    #[inline(always)]
    pub fn tpie(&self) -> TPIE_R {
        TPIE_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 1 - Tamper 0 event trigger edge for RTC_TAMP0 input"]
    #[inline(always)]
    pub fn tp0eg(&self) -> TP0EG_R {
        TP0EG_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 0 - RTC_TAMP1 input detection enable"]
    #[inline(always)]
    pub fn tp0en(&self) -> TP0EN_R {
        TP0EN_R::new((self.bits & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 23 - PC15 mode"]
    #[inline(always)]
    pub fn pc15mde(&mut self) -> PC15MDE_W {
        PC15MDE_W { w: self }
    }
    #[doc = "Bit 22 - PC15 value"]
    #[inline(always)]
    pub fn pc15val(&mut self) -> PC15VAL_W {
        PC15VAL_W { w: self }
    }
    #[doc = "Bit 21 - PC14 mode"]
    #[inline(always)]
    pub fn pc14mde(&mut self) -> PC14MDE_W {
        PC14MDE_W { w: self }
    }
    #[doc = "Bit 20 - PC14 value"]
    #[inline(always)]
    pub fn pc14val(&mut self) -> PC14VAL_W {
        PC14VAL_W { w: self }
    }
    #[doc = "Bit 19 - PC13 mode"]
    #[inline(always)]
    pub fn pc13mde(&mut self) -> PC13MDE_W {
        PC13MDE_W { w: self }
    }
    #[doc = "Bit 18 - Alarm output type control/PC13 output value"]
    #[inline(always)]
    pub fn pc13val(&mut self) -> PC13VAL_W {
        PC13VAL_W { w: self }
    }
    #[doc = "Bit 15 - RTC_TAMPx pull up disable bit"]
    #[inline(always)]
    pub fn dispu(&mut self) -> DISPU_W {
        DISPU_W { w: self }
    }
    #[doc = "Bits 13:14 - Precharge duration time of RTC_TAMPx"]
    #[inline(always)]
    pub fn prch(&mut self) -> PRCH_W {
        PRCH_W { w: self }
    }
    #[doc = "Bits 11:12 - RTC_TAMPx filter count setting"]
    #[inline(always)]
    pub fn flt(&mut self) -> FLT_W {
        FLT_W { w: self }
    }
    #[doc = "Bits 8:10 - Sample frequency of tamper event detection"]
    #[inline(always)]
    pub fn freq(&mut self) -> FREQ_W {
        FREQ_W { w: self }
    }
    #[doc = "Bit 7 - Make tamper function used for timestamp function"]
    #[inline(always)]
    pub fn tpts(&mut self) -> TPTS_W {
        TPTS_W { w: self }
    }
    #[doc = "Bit 4 - Tamper 1 event trigger edge for RTC_TAMP1 input"]
    #[inline(always)]
    pub fn tp1eg(&mut self) -> TP1EG_W {
        TP1EG_W { w: self }
    }
    #[doc = "Bit 3 - Tamper 1 detection enable"]
    #[inline(always)]
    pub fn tp1en(&mut self) -> TP1EN_W {
        TP1EN_W { w: self }
    }
    #[doc = "Bit 2 - Tamper detection interrupt enable"]
    #[inline(always)]
    pub fn tpie(&mut self) -> TPIE_W {
        TPIE_W { w: self }
    }
    #[doc = "Bit 1 - Tamper 0 event trigger edge for RTC_TAMP0 input"]
    #[inline(always)]
    pub fn tp0eg(&mut self) -> TP0EG_W {
        TP0EG_W { w: self }
    }
    #[doc = "Bit 0 - RTC_TAMP1 input detection enable"]
    #[inline(always)]
    pub fn tp0en(&mut self) -> TP0EN_W {
        TP0EN_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Tamper register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [tamp](index.html) module"]
pub struct TAMP_SPEC;
impl crate::RegisterSpec for TAMP_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [tamp::R](R) reader structure"]
impl crate::Readable for TAMP_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [tamp::W](W) writer structure"]
impl crate::Writable for TAMP_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets TAMP to value 0"]
impl crate::Resettable for TAMP_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
