#[doc = "Register `HRFC` reader"]
pub struct R(crate::R<HRFC_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<HRFC_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::convert::From<crate::R<HRFC_SPEC>> for R {
    fn from(reader: crate::R<HRFC_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `HRFC` writer"]
pub struct W(crate::W<HRFC_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<HRFC_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl core::convert::From<crate::W<HRFC_SPEC>> for W {
    fn from(writer: crate::W<HRFC_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `FREQI` reader - Increase RTC frequency by 488.5ppm"]
pub struct FREQI_R(crate::FieldReader<bool, bool>);
impl FREQI_R {
    pub(crate) fn new(bits: bool) -> Self {
        FREQI_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for FREQI_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FREQI` writer - Increase RTC frequency by 488.5ppm"]
pub struct FREQI_W<'a> {
    w: &'a mut W,
}
impl<'a> FREQI_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 15)) | ((value as u32 & 0x01) << 15);
        self.w
    }
}
#[doc = "Field `CWND8` reader - Frequency compensation window 8 second selected"]
pub struct CWND8_R(crate::FieldReader<bool, bool>);
impl CWND8_R {
    pub(crate) fn new(bits: bool) -> Self {
        CWND8_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CWND8_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CWND8` writer - Frequency compensation window 8 second selected"]
pub struct CWND8_W<'a> {
    w: &'a mut W,
}
impl<'a> CWND8_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 14)) | ((value as u32 & 0x01) << 14);
        self.w
    }
}
#[doc = "Field `CWND16` reader - Frequency compensation window 16 second selected"]
pub struct CWND16_R(crate::FieldReader<bool, bool>);
impl CWND16_R {
    pub(crate) fn new(bits: bool) -> Self {
        CWND16_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CWND16_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CWND16` writer - Frequency compensation window 16 second selected"]
pub struct CWND16_W<'a> {
    w: &'a mut W,
}
impl<'a> CWND16_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 13)) | ((value as u32 & 0x01) << 13);
        self.w
    }
}
#[doc = "Field `CMSK` reader - Calibration mask number"]
pub struct CMSK_R(crate::FieldReader<u16, u16>);
impl CMSK_R {
    pub(crate) fn new(bits: u16) -> Self {
        CMSK_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CMSK_R {
    type Target = crate::FieldReader<u16, u16>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CMSK` writer - Calibration mask number"]
pub struct CMSK_W<'a> {
    w: &'a mut W,
}
impl<'a> CMSK_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u16) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01ff) | (value as u32 & 0x01ff);
        self.w
    }
}
impl R {
    #[doc = "Bit 15 - Increase RTC frequency by 488.5ppm"]
    #[inline(always)]
    pub fn freqi(&self) -> FREQI_R {
        FREQI_R::new(((self.bits >> 15) & 0x01) != 0)
    }
    #[doc = "Bit 14 - Frequency compensation window 8 second selected"]
    #[inline(always)]
    pub fn cwnd8(&self) -> CWND8_R {
        CWND8_R::new(((self.bits >> 14) & 0x01) != 0)
    }
    #[doc = "Bit 13 - Frequency compensation window 16 second selected"]
    #[inline(always)]
    pub fn cwnd16(&self) -> CWND16_R {
        CWND16_R::new(((self.bits >> 13) & 0x01) != 0)
    }
    #[doc = "Bits 0:8 - Calibration mask number"]
    #[inline(always)]
    pub fn cmsk(&self) -> CMSK_R {
        CMSK_R::new((self.bits & 0x01ff) as u16)
    }
}
impl W {
    #[doc = "Bit 15 - Increase RTC frequency by 488.5ppm"]
    #[inline(always)]
    pub fn freqi(&mut self) -> FREQI_W {
        FREQI_W { w: self }
    }
    #[doc = "Bit 14 - Frequency compensation window 8 second selected"]
    #[inline(always)]
    pub fn cwnd8(&mut self) -> CWND8_W {
        CWND8_W { w: self }
    }
    #[doc = "Bit 13 - Frequency compensation window 16 second selected"]
    #[inline(always)]
    pub fn cwnd16(&mut self) -> CWND16_W {
        CWND16_W { w: self }
    }
    #[doc = "Bits 0:8 - Calibration mask number"]
    #[inline(always)]
    pub fn cmsk(&mut self) -> CMSK_W {
        CMSK_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "High resolution frequency compensation register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [hrfc](index.html) module"]
pub struct HRFC_SPEC;
impl crate::RegisterSpec for HRFC_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [hrfc::R](R) reader structure"]
impl crate::Readable for HRFC_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [hrfc::W](W) writer structure"]
impl crate::Writable for HRFC_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets HRFC to value 0"]
impl crate::Resettable for HRFC_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
