#[doc = "Register `CFG2` reader"]
pub struct R(crate::R<CFG2_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<CFG2_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::convert::From<crate::R<CFG2_SPEC>> for R {
    fn from(reader: crate::R<CFG2_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `CFG2` writer"]
pub struct W(crate::W<CFG2_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<CFG2_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl core::convert::From<crate::W<CFG2_SPEC>> for W {
    fn from(writer: crate::W<CFG2_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "CK_USART0 clock source selection\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum USART0SEL_A {
    #[doc = "0: APB2 selected as USART0 clock source"]
    APB2 = 0,
    #[doc = "1: SYS selected as USART0 clock source"]
    SYS = 1,
    #[doc = "2: LXTAL selected as USART0 clock source"]
    LXTAL = 2,
    #[doc = "3: IRC8M selected as USART0 clock source"]
    IRC8M = 3,
}
impl From<USART0SEL_A> for u8 {
    #[inline(always)]
    fn from(variant: USART0SEL_A) -> Self {
        variant as _
    }
}
#[doc = "Field `USART0SEL` reader - CK_USART0 clock source selection"]
pub struct USART0SEL_R(crate::FieldReader<u8, USART0SEL_A>);
impl USART0SEL_R {
    pub(crate) fn new(bits: u8) -> Self {
        USART0SEL_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> USART0SEL_A {
        match self.bits {
            0 => USART0SEL_A::APB2,
            1 => USART0SEL_A::SYS,
            2 => USART0SEL_A::LXTAL,
            3 => USART0SEL_A::IRC8M,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `APB2`"]
    #[inline(always)]
    pub fn is_apb2(&self) -> bool {
        **self == USART0SEL_A::APB2
    }
    #[doc = "Checks if the value of the field is `SYS`"]
    #[inline(always)]
    pub fn is_sys(&self) -> bool {
        **self == USART0SEL_A::SYS
    }
    #[doc = "Checks if the value of the field is `LXTAL`"]
    #[inline(always)]
    pub fn is_lxtal(&self) -> bool {
        **self == USART0SEL_A::LXTAL
    }
    #[doc = "Checks if the value of the field is `IRC8M`"]
    #[inline(always)]
    pub fn is_irc8m(&self) -> bool {
        **self == USART0SEL_A::IRC8M
    }
}
impl core::ops::Deref for USART0SEL_R {
    type Target = crate::FieldReader<u8, USART0SEL_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `USART0SEL` writer - CK_USART0 clock source selection"]
pub struct USART0SEL_W<'a> {
    w: &'a mut W,
}
impl<'a> USART0SEL_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: USART0SEL_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "APB2 selected as USART0 clock source"]
    #[inline(always)]
    pub fn apb2(self) -> &'a mut W {
        self.variant(USART0SEL_A::APB2)
    }
    #[doc = "SYS selected as USART0 clock source"]
    #[inline(always)]
    pub fn sys(self) -> &'a mut W {
        self.variant(USART0SEL_A::SYS)
    }
    #[doc = "LXTAL selected as USART0 clock source"]
    #[inline(always)]
    pub fn lxtal(self) -> &'a mut W {
        self.variant(USART0SEL_A::LXTAL)
    }
    #[doc = "IRC8M selected as USART0 clock source"]
    #[inline(always)]
    pub fn irc8m(self) -> &'a mut W {
        self.variant(USART0SEL_A::IRC8M)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x03) | (value as u32 & 0x03);
        self.w
    }
}
#[doc = "CK_CEC clock source selection\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum CECSEL_A {
    #[doc = "0: IRC8M clock divided by 244 selected as CEC clock source"]
    IRC8M_DIV244 = 0,
    #[doc = "1: LXTAL clock selected as CEC clock source"]
    LXTAL = 1,
}
impl From<CECSEL_A> for bool {
    #[inline(always)]
    fn from(variant: CECSEL_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `CECSEL` reader - CK_CEC clock source selection"]
pub struct CECSEL_R(crate::FieldReader<bool, CECSEL_A>);
impl CECSEL_R {
    pub(crate) fn new(bits: bool) -> Self {
        CECSEL_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> CECSEL_A {
        match self.bits {
            false => CECSEL_A::IRC8M_DIV244,
            true => CECSEL_A::LXTAL,
        }
    }
    #[doc = "Checks if the value of the field is `IRC8M_DIV244`"]
    #[inline(always)]
    pub fn is_irc8m_div244(&self) -> bool {
        **self == CECSEL_A::IRC8M_DIV244
    }
    #[doc = "Checks if the value of the field is `LXTAL`"]
    #[inline(always)]
    pub fn is_lxtal(&self) -> bool {
        **self == CECSEL_A::LXTAL
    }
}
impl core::ops::Deref for CECSEL_R {
    type Target = crate::FieldReader<bool, CECSEL_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CECSEL` writer - CK_CEC clock source selection"]
pub struct CECSEL_W<'a> {
    w: &'a mut W,
}
impl<'a> CECSEL_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CECSEL_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "IRC8M clock divided by 244 selected as CEC clock source"]
    #[inline(always)]
    pub fn irc8m_div244(self) -> &'a mut W {
        self.variant(CECSEL_A::IRC8M_DIV244)
    }
    #[doc = "LXTAL clock selected as CEC clock source"]
    #[inline(always)]
    pub fn lxtal(self) -> &'a mut W {
        self.variant(CECSEL_A::LXTAL)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u32 & 0x01) << 6);
        self.w
    }
}
#[doc = "CK_ADC clock source selection\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum ADCSEL_A {
    #[doc = "0: IRC28M selected as ADC clock source, possibly divided by 2"]
    IRC28M = 0,
    #[doc = "1: APB2 divided by prescaler selected as ADC clock source"]
    APB2 = 1,
}
impl From<ADCSEL_A> for bool {
    #[inline(always)]
    fn from(variant: ADCSEL_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `ADCSEL` reader - CK_ADC clock source selection"]
pub struct ADCSEL_R(crate::FieldReader<bool, ADCSEL_A>);
impl ADCSEL_R {
    pub(crate) fn new(bits: bool) -> Self {
        ADCSEL_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> ADCSEL_A {
        match self.bits {
            false => ADCSEL_A::IRC28M,
            true => ADCSEL_A::APB2,
        }
    }
    #[doc = "Checks if the value of the field is `IRC28M`"]
    #[inline(always)]
    pub fn is_irc28m(&self) -> bool {
        **self == ADCSEL_A::IRC28M
    }
    #[doc = "Checks if the value of the field is `APB2`"]
    #[inline(always)]
    pub fn is_apb2(&self) -> bool {
        **self == ADCSEL_A::APB2
    }
}
impl core::ops::Deref for ADCSEL_R {
    type Target = crate::FieldReader<bool, ADCSEL_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ADCSEL` writer - CK_ADC clock source selection"]
pub struct ADCSEL_W<'a> {
    w: &'a mut W,
}
impl<'a> ADCSEL_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: ADCSEL_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "IRC28M selected as ADC clock source, possibly divided by 2"]
    #[inline(always)]
    pub fn irc28m(self) -> &'a mut W {
        self.variant(ADCSEL_A::IRC28M)
    }
    #[doc = "APB2 divided by prescaler selected as ADC clock source"]
    #[inline(always)]
    pub fn apb2(self) -> &'a mut W {
        self.variant(ADCSEL_A::APB2)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 8)) | ((value as u32 & 0x01) << 8);
        self.w
    }
}
#[doc = "CK_IRC28M divider 2 or not\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum IRC28MDIV_A {
    #[doc = "0: IRC28M is divided by 2 for ADC clock"]
    DIV2 = 0,
    #[doc = "1: IRC28M is not divided for ADC clock"]
    DIV1 = 1,
}
impl From<IRC28MDIV_A> for bool {
    #[inline(always)]
    fn from(variant: IRC28MDIV_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `IRC28MDIV` reader - CK_IRC28M divider 2 or not"]
pub struct IRC28MDIV_R(crate::FieldReader<bool, IRC28MDIV_A>);
impl IRC28MDIV_R {
    pub(crate) fn new(bits: bool) -> Self {
        IRC28MDIV_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> IRC28MDIV_A {
        match self.bits {
            false => IRC28MDIV_A::DIV2,
            true => IRC28MDIV_A::DIV1,
        }
    }
    #[doc = "Checks if the value of the field is `DIV2`"]
    #[inline(always)]
    pub fn is_div2(&self) -> bool {
        **self == IRC28MDIV_A::DIV2
    }
    #[doc = "Checks if the value of the field is `DIV1`"]
    #[inline(always)]
    pub fn is_div1(&self) -> bool {
        **self == IRC28MDIV_A::DIV1
    }
}
impl core::ops::Deref for IRC28MDIV_R {
    type Target = crate::FieldReader<bool, IRC28MDIV_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `IRC28MDIV` writer - CK_IRC28M divider 2 or not"]
pub struct IRC28MDIV_W<'a> {
    w: &'a mut W,
}
impl<'a> IRC28MDIV_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: IRC28MDIV_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "IRC28M is divided by 2 for ADC clock"]
    #[inline(always)]
    pub fn div2(self) -> &'a mut W {
        self.variant(IRC28MDIV_A::DIV2)
    }
    #[doc = "IRC28M is not divided for ADC clock"]
    #[inline(always)]
    pub fn div1(self) -> &'a mut W {
        self.variant(IRC28MDIV_A::DIV1)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 16)) | ((value as u32 & 0x01) << 16);
        self.w
    }
}
impl R {
    #[doc = "Bits 0:1 - CK_USART0 clock source selection"]
    #[inline(always)]
    pub fn usart0sel(&self) -> USART0SEL_R {
        USART0SEL_R::new((self.bits & 0x03) as u8)
    }
    #[doc = "Bit 6 - CK_CEC clock source selection"]
    #[inline(always)]
    pub fn cecsel(&self) -> CECSEL_R {
        CECSEL_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 8 - CK_ADC clock source selection"]
    #[inline(always)]
    pub fn adcsel(&self) -> ADCSEL_R {
        ADCSEL_R::new(((self.bits >> 8) & 0x01) != 0)
    }
    #[doc = "Bit 16 - CK_IRC28M divider 2 or not"]
    #[inline(always)]
    pub fn irc28mdiv(&self) -> IRC28MDIV_R {
        IRC28MDIV_R::new(((self.bits >> 16) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bits 0:1 - CK_USART0 clock source selection"]
    #[inline(always)]
    pub fn usart0sel(&mut self) -> USART0SEL_W {
        USART0SEL_W { w: self }
    }
    #[doc = "Bit 6 - CK_CEC clock source selection"]
    #[inline(always)]
    pub fn cecsel(&mut self) -> CECSEL_W {
        CECSEL_W { w: self }
    }
    #[doc = "Bit 8 - CK_ADC clock source selection"]
    #[inline(always)]
    pub fn adcsel(&mut self) -> ADCSEL_W {
        ADCSEL_W { w: self }
    }
    #[doc = "Bit 16 - CK_IRC28M divider 2 or not"]
    #[inline(always)]
    pub fn irc28mdiv(&mut self) -> IRC28MDIV_W {
        IRC28MDIV_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Configuration register 2\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [cfg2](index.html) module"]
pub struct CFG2_SPEC;
impl crate::RegisterSpec for CFG2_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [cfg2::R](R) reader structure"]
impl crate::Readable for CFG2_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [cfg2::W](W) writer structure"]
impl crate::Writable for CFG2_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets CFG2 to value 0"]
impl crate::Resettable for CFG2_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
