#[doc = "Register `CTL` reader"]
pub struct R(crate::R<CTL_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<CTL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::convert::From<crate::R<CTL_SPEC>> for R {
    fn from(reader: crate::R<CTL_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `CTL` writer"]
pub struct W(crate::W<CTL_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<CTL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl core::convert::From<crate::W<CTL_SPEC>> for W {
    fn from(writer: crate::W<CTL_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Backup Domain Write Enable\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum BKPWEN_A {
    #[doc = "0: Access to backup domain registers disabled"]
    DISABLED = 0,
    #[doc = "1: Access to backup domain registers enabled"]
    ENABLED = 1,
}
impl From<BKPWEN_A> for bool {
    #[inline(always)]
    fn from(variant: BKPWEN_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `BKPWEN` reader - Backup Domain Write Enable"]
pub struct BKPWEN_R(crate::FieldReader<bool, BKPWEN_A>);
impl BKPWEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        BKPWEN_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> BKPWEN_A {
        match self.bits {
            false => BKPWEN_A::DISABLED,
            true => BKPWEN_A::ENABLED,
        }
    }
    #[doc = "Checks if the value of the field is `DISABLED`"]
    #[inline(always)]
    pub fn is_disabled(&self) -> bool {
        **self == BKPWEN_A::DISABLED
    }
    #[doc = "Checks if the value of the field is `ENABLED`"]
    #[inline(always)]
    pub fn is_enabled(&self) -> bool {
        **self == BKPWEN_A::ENABLED
    }
}
impl core::ops::Deref for BKPWEN_R {
    type Target = crate::FieldReader<bool, BKPWEN_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `BKPWEN` writer - Backup Domain Write Enable"]
pub struct BKPWEN_W<'a> {
    w: &'a mut W,
}
impl<'a> BKPWEN_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: BKPWEN_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Access to backup domain registers disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(BKPWEN_A::DISABLED)
    }
    #[doc = "Access to backup domain registers enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(BKPWEN_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 8)) | ((value as u32 & 0x01) << 8);
        self.w
    }
}
#[doc = "Low Voltage Detector Threshold\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum LVDT_A {
    #[doc = "0: 2.2 V"]
    V2_2 = 0,
    #[doc = "1: 2.3 V"]
    V2_3 = 1,
    #[doc = "2: 2.4 V"]
    V2_4 = 2,
    #[doc = "3: 2.5 V"]
    V2_5 = 3,
    #[doc = "4: 2.6 V"]
    V2_6 = 4,
    #[doc = "5: 2.7 V"]
    V2_7 = 5,
    #[doc = "6: 2.8 V"]
    V2_8 = 6,
    #[doc = "7: 2.9 V"]
    V2_9 = 7,
}
impl From<LVDT_A> for u8 {
    #[inline(always)]
    fn from(variant: LVDT_A) -> Self {
        variant as _
    }
}
#[doc = "Field `LVDT` reader - Low Voltage Detector Threshold"]
pub struct LVDT_R(crate::FieldReader<u8, LVDT_A>);
impl LVDT_R {
    pub(crate) fn new(bits: u8) -> Self {
        LVDT_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> LVDT_A {
        match self.bits {
            0 => LVDT_A::V2_2,
            1 => LVDT_A::V2_3,
            2 => LVDT_A::V2_4,
            3 => LVDT_A::V2_5,
            4 => LVDT_A::V2_6,
            5 => LVDT_A::V2_7,
            6 => LVDT_A::V2_8,
            7 => LVDT_A::V2_9,
            _ => unreachable!(),
        }
    }
    #[doc = "Checks if the value of the field is `V2_2`"]
    #[inline(always)]
    pub fn is_v2_2(&self) -> bool {
        **self == LVDT_A::V2_2
    }
    #[doc = "Checks if the value of the field is `V2_3`"]
    #[inline(always)]
    pub fn is_v2_3(&self) -> bool {
        **self == LVDT_A::V2_3
    }
    #[doc = "Checks if the value of the field is `V2_4`"]
    #[inline(always)]
    pub fn is_v2_4(&self) -> bool {
        **self == LVDT_A::V2_4
    }
    #[doc = "Checks if the value of the field is `V2_5`"]
    #[inline(always)]
    pub fn is_v2_5(&self) -> bool {
        **self == LVDT_A::V2_5
    }
    #[doc = "Checks if the value of the field is `V2_6`"]
    #[inline(always)]
    pub fn is_v2_6(&self) -> bool {
        **self == LVDT_A::V2_6
    }
    #[doc = "Checks if the value of the field is `V2_7`"]
    #[inline(always)]
    pub fn is_v2_7(&self) -> bool {
        **self == LVDT_A::V2_7
    }
    #[doc = "Checks if the value of the field is `V2_8`"]
    #[inline(always)]
    pub fn is_v2_8(&self) -> bool {
        **self == LVDT_A::V2_8
    }
    #[doc = "Checks if the value of the field is `V2_9`"]
    #[inline(always)]
    pub fn is_v2_9(&self) -> bool {
        **self == LVDT_A::V2_9
    }
}
impl core::ops::Deref for LVDT_R {
    type Target = crate::FieldReader<u8, LVDT_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LVDT` writer - Low Voltage Detector Threshold"]
pub struct LVDT_W<'a> {
    w: &'a mut W,
}
impl<'a> LVDT_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: LVDT_A) -> &'a mut W {
        self.bits(variant.into())
    }
    #[doc = "2.2 V"]
    #[inline(always)]
    pub fn v2_2(self) -> &'a mut W {
        self.variant(LVDT_A::V2_2)
    }
    #[doc = "2.3 V"]
    #[inline(always)]
    pub fn v2_3(self) -> &'a mut W {
        self.variant(LVDT_A::V2_3)
    }
    #[doc = "2.4 V"]
    #[inline(always)]
    pub fn v2_4(self) -> &'a mut W {
        self.variant(LVDT_A::V2_4)
    }
    #[doc = "2.5 V"]
    #[inline(always)]
    pub fn v2_5(self) -> &'a mut W {
        self.variant(LVDT_A::V2_5)
    }
    #[doc = "2.6 V"]
    #[inline(always)]
    pub fn v2_6(self) -> &'a mut W {
        self.variant(LVDT_A::V2_6)
    }
    #[doc = "2.7 V"]
    #[inline(always)]
    pub fn v2_7(self) -> &'a mut W {
        self.variant(LVDT_A::V2_7)
    }
    #[doc = "2.8 V"]
    #[inline(always)]
    pub fn v2_8(self) -> &'a mut W {
        self.variant(LVDT_A::V2_8)
    }
    #[doc = "2.9 V"]
    #[inline(always)]
    pub fn v2_9(self) -> &'a mut W {
        self.variant(LVDT_A::V2_9)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 5)) | ((value as u32 & 0x07) << 5);
        self.w
    }
}
#[doc = "Low Voltage Detector Enable\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum LVDEN_A {
    #[doc = "0: Low voltage detector disabled"]
    DISABLED = 0,
    #[doc = "1: Low voltage detector enabled"]
    ENABLED = 1,
}
impl From<LVDEN_A> for bool {
    #[inline(always)]
    fn from(variant: LVDEN_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `LVDEN` reader - Low Voltage Detector Enable"]
pub struct LVDEN_R(crate::FieldReader<bool, LVDEN_A>);
impl LVDEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        LVDEN_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> LVDEN_A {
        match self.bits {
            false => LVDEN_A::DISABLED,
            true => LVDEN_A::ENABLED,
        }
    }
    #[doc = "Checks if the value of the field is `DISABLED`"]
    #[inline(always)]
    pub fn is_disabled(&self) -> bool {
        **self == LVDEN_A::DISABLED
    }
    #[doc = "Checks if the value of the field is `ENABLED`"]
    #[inline(always)]
    pub fn is_enabled(&self) -> bool {
        **self == LVDEN_A::ENABLED
    }
}
impl core::ops::Deref for LVDEN_R {
    type Target = crate::FieldReader<bool, LVDEN_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LVDEN` writer - Low Voltage Detector Enable"]
pub struct LVDEN_W<'a> {
    w: &'a mut W,
}
impl<'a> LVDEN_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: LVDEN_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Low voltage detector disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(LVDEN_A::DISABLED)
    }
    #[doc = "Low voltage detector enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(LVDEN_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u32 & 0x01) << 4);
        self.w
    }
}
#[doc = "Standby Flag Reset\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum STBRST_A {
    #[doc = "1: Clear the standby flag"]
    CLEAR = 1,
}
impl From<STBRST_A> for bool {
    #[inline(always)]
    fn from(variant: STBRST_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `STBRST` reader - Standby Flag Reset"]
pub struct STBRST_R(crate::FieldReader<bool, STBRST_A>);
impl STBRST_R {
    pub(crate) fn new(bits: bool) -> Self {
        STBRST_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<STBRST_A> {
        match self.bits {
            true => Some(STBRST_A::CLEAR),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `CLEAR`"]
    #[inline(always)]
    pub fn is_clear(&self) -> bool {
        **self == STBRST_A::CLEAR
    }
}
impl core::ops::Deref for STBRST_R {
    type Target = crate::FieldReader<bool, STBRST_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `STBRST` writer - Standby Flag Reset"]
pub struct STBRST_W<'a> {
    w: &'a mut W,
}
impl<'a> STBRST_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: STBRST_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Clear the standby flag"]
    #[inline(always)]
    pub fn clear(self) -> &'a mut W {
        self.variant(STBRST_A::CLEAR)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u32 & 0x01) << 3);
        self.w
    }
}
#[doc = "Wakeup Flag Reset\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum WURST_A {
    #[doc = "1: Clear the wakeup flag"]
    CLEAR = 1,
}
impl From<WURST_A> for bool {
    #[inline(always)]
    fn from(variant: WURST_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `WURST` reader - Wakeup Flag Reset"]
pub struct WURST_R(crate::FieldReader<bool, WURST_A>);
impl WURST_R {
    pub(crate) fn new(bits: bool) -> Self {
        WURST_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<WURST_A> {
        match self.bits {
            true => Some(WURST_A::CLEAR),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `CLEAR`"]
    #[inline(always)]
    pub fn is_clear(&self) -> bool {
        **self == WURST_A::CLEAR
    }
}
impl core::ops::Deref for WURST_R {
    type Target = crate::FieldReader<bool, WURST_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `WURST` writer - Wakeup Flag Reset"]
pub struct WURST_W<'a> {
    w: &'a mut W,
}
impl<'a> WURST_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: WURST_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Clear the wakeup flag"]
    #[inline(always)]
    pub fn clear(self) -> &'a mut W {
        self.variant(WURST_A::CLEAR)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u32 & 0x01) << 2);
        self.w
    }
}
#[doc = "Standby Mode\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum STBMOD_A {
    #[doc = "0: Enter Deep-sleep mode when the CPU enters deepsleep"]
    DEEPSLEEP = 0,
    #[doc = "1: Enter Standby mode when the CPU enters deepsleep"]
    STANDBY = 1,
}
impl From<STBMOD_A> for bool {
    #[inline(always)]
    fn from(variant: STBMOD_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `STBMOD` reader - Standby Mode"]
pub struct STBMOD_R(crate::FieldReader<bool, STBMOD_A>);
impl STBMOD_R {
    pub(crate) fn new(bits: bool) -> Self {
        STBMOD_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> STBMOD_A {
        match self.bits {
            false => STBMOD_A::DEEPSLEEP,
            true => STBMOD_A::STANDBY,
        }
    }
    #[doc = "Checks if the value of the field is `DEEPSLEEP`"]
    #[inline(always)]
    pub fn is_deep_sleep(&self) -> bool {
        **self == STBMOD_A::DEEPSLEEP
    }
    #[doc = "Checks if the value of the field is `STANDBY`"]
    #[inline(always)]
    pub fn is_standby(&self) -> bool {
        **self == STBMOD_A::STANDBY
    }
}
impl core::ops::Deref for STBMOD_R {
    type Target = crate::FieldReader<bool, STBMOD_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `STBMOD` writer - Standby Mode"]
pub struct STBMOD_W<'a> {
    w: &'a mut W,
}
impl<'a> STBMOD_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: STBMOD_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Enter Deep-sleep mode when the CPU enters deepsleep"]
    #[inline(always)]
    pub fn deep_sleep(self) -> &'a mut W {
        self.variant(STBMOD_A::DEEPSLEEP)
    }
    #[doc = "Enter Standby mode when the CPU enters deepsleep"]
    #[inline(always)]
    pub fn standby(self) -> &'a mut W {
        self.variant(STBMOD_A::STANDBY)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "LDO Low Power Mode\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum LDOLP_A {
    #[doc = "0: LDO operates normally during Deepsleep mode"]
    NORMAL = 0,
    #[doc = "1: LDO in low-power mode during Deepsleep mode"]
    LOWPOWER = 1,
}
impl From<LDOLP_A> for bool {
    #[inline(always)]
    fn from(variant: LDOLP_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `LDOLP` reader - LDO Low Power Mode"]
pub struct LDOLP_R(crate::FieldReader<bool, LDOLP_A>);
impl LDOLP_R {
    pub(crate) fn new(bits: bool) -> Self {
        LDOLP_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> LDOLP_A {
        match self.bits {
            false => LDOLP_A::NORMAL,
            true => LDOLP_A::LOWPOWER,
        }
    }
    #[doc = "Checks if the value of the field is `NORMAL`"]
    #[inline(always)]
    pub fn is_normal(&self) -> bool {
        **self == LDOLP_A::NORMAL
    }
    #[doc = "Checks if the value of the field is `LOWPOWER`"]
    #[inline(always)]
    pub fn is_low_power(&self) -> bool {
        **self == LDOLP_A::LOWPOWER
    }
}
impl core::ops::Deref for LDOLP_R {
    type Target = crate::FieldReader<bool, LDOLP_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LDOLP` writer - LDO Low Power Mode"]
pub struct LDOLP_W<'a> {
    w: &'a mut W,
}
impl<'a> LDOLP_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: LDOLP_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "LDO operates normally during Deepsleep mode"]
    #[inline(always)]
    pub fn normal(self) -> &'a mut W {
        self.variant(LDOLP_A::NORMAL)
    }
    #[doc = "LDO in low-power mode during Deepsleep mode"]
    #[inline(always)]
    pub fn low_power(self) -> &'a mut W {
        self.variant(LDOLP_A::LOWPOWER)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
impl R {
    #[doc = "Bit 8 - Backup Domain Write Enable"]
    #[inline(always)]
    pub fn bkpwen(&self) -> BKPWEN_R {
        BKPWEN_R::new(((self.bits >> 8) & 0x01) != 0)
    }
    #[doc = "Bits 5:7 - Low Voltage Detector Threshold"]
    #[inline(always)]
    pub fn lvdt(&self) -> LVDT_R {
        LVDT_R::new(((self.bits >> 5) & 0x07) as u8)
    }
    #[doc = "Bit 4 - Low Voltage Detector Enable"]
    #[inline(always)]
    pub fn lvden(&self) -> LVDEN_R {
        LVDEN_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Standby Flag Reset"]
    #[inline(always)]
    pub fn stbrst(&self) -> STBRST_R {
        STBRST_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Wakeup Flag Reset"]
    #[inline(always)]
    pub fn wurst(&self) -> WURST_R {
        WURST_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 1 - Standby Mode"]
    #[inline(always)]
    pub fn stbmod(&self) -> STBMOD_R {
        STBMOD_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 0 - LDO Low Power Mode"]
    #[inline(always)]
    pub fn ldolp(&self) -> LDOLP_R {
        LDOLP_R::new((self.bits & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 8 - Backup Domain Write Enable"]
    #[inline(always)]
    pub fn bkpwen(&mut self) -> BKPWEN_W {
        BKPWEN_W { w: self }
    }
    #[doc = "Bits 5:7 - Low Voltage Detector Threshold"]
    #[inline(always)]
    pub fn lvdt(&mut self) -> LVDT_W {
        LVDT_W { w: self }
    }
    #[doc = "Bit 4 - Low Voltage Detector Enable"]
    #[inline(always)]
    pub fn lvden(&mut self) -> LVDEN_W {
        LVDEN_W { w: self }
    }
    #[doc = "Bit 3 - Standby Flag Reset"]
    #[inline(always)]
    pub fn stbrst(&mut self) -> STBRST_W {
        STBRST_W { w: self }
    }
    #[doc = "Bit 2 - Wakeup Flag Reset"]
    #[inline(always)]
    pub fn wurst(&mut self) -> WURST_W {
        WURST_W { w: self }
    }
    #[doc = "Bit 1 - Standby Mode"]
    #[inline(always)]
    pub fn stbmod(&mut self) -> STBMOD_W {
        STBMOD_W { w: self }
    }
    #[doc = "Bit 0 - LDO Low Power Mode"]
    #[inline(always)]
    pub fn ldolp(&mut self) -> LDOLP_W {
        LDOLP_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "power control register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ctl](index.html) module"]
pub struct CTL_SPEC;
impl crate::RegisterSpec for CTL_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [ctl::R](R) reader structure"]
impl crate::Readable for CTL_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [ctl::W](W) writer structure"]
impl crate::Writable for CTL_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets CTL to value 0"]
impl crate::Resettable for CTL_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
