#[doc = "Register `ISTAT` reader"]
pub struct R(crate::R<ISTAT_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<ISTAT_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::convert::From<crate::R<ISTAT_SPEC>> for R {
    fn from(reader: crate::R<ISTAT_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Port input data 14\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum ISTAT15_A {
    #[doc = "0: Input is logic low"]
    LOW = 0,
    #[doc = "1: Input is logic high"]
    HIGH = 1,
}
impl From<ISTAT15_A> for bool {
    #[inline(always)]
    fn from(variant: ISTAT15_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `ISTAT15` reader - Port input data 14"]
pub struct ISTAT15_R(crate::FieldReader<bool, ISTAT15_A>);
impl ISTAT15_R {
    pub(crate) fn new(bits: bool) -> Self {
        ISTAT15_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> ISTAT15_A {
        match self.bits {
            false => ISTAT15_A::LOW,
            true => ISTAT15_A::HIGH,
        }
    }
    #[doc = "Checks if the value of the field is `LOW`"]
    #[inline(always)]
    pub fn is_low(&self) -> bool {
        **self == ISTAT15_A::LOW
    }
    #[doc = "Checks if the value of the field is `HIGH`"]
    #[inline(always)]
    pub fn is_high(&self) -> bool {
        **self == ISTAT15_A::HIGH
    }
}
impl core::ops::Deref for ISTAT15_R {
    type Target = crate::FieldReader<bool, ISTAT15_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Port input data 14"]
pub type ISTAT14_A = ISTAT15_A;
#[doc = "Field `ISTAT14` reader - Port input data 14"]
pub type ISTAT14_R = ISTAT15_R;
#[doc = "Port input data 13"]
pub type ISTAT13_A = ISTAT15_A;
#[doc = "Field `ISTAT13` reader - Port input data 13"]
pub type ISTAT13_R = ISTAT15_R;
#[doc = "Port input data 12"]
pub type ISTAT12_A = ISTAT15_A;
#[doc = "Field `ISTAT12` reader - Port input data 12"]
pub type ISTAT12_R = ISTAT15_R;
#[doc = "Port input data 11"]
pub type ISTAT11_A = ISTAT15_A;
#[doc = "Field `ISTAT11` reader - Port input data 11"]
pub type ISTAT11_R = ISTAT15_R;
#[doc = "Port input data 10"]
pub type ISTAT10_A = ISTAT15_A;
#[doc = "Field `ISTAT10` reader - Port input data 10"]
pub type ISTAT10_R = ISTAT15_R;
#[doc = "Port input data 9"]
pub type ISTAT9_A = ISTAT15_A;
#[doc = "Field `ISTAT9` reader - Port input data 9"]
pub type ISTAT9_R = ISTAT15_R;
#[doc = "Port input data 8"]
pub type ISTAT8_A = ISTAT15_A;
#[doc = "Field `ISTAT8` reader - Port input data 8"]
pub type ISTAT8_R = ISTAT15_R;
#[doc = "Port input data 7"]
pub type ISTAT7_A = ISTAT15_A;
#[doc = "Field `ISTAT7` reader - Port input data 7"]
pub type ISTAT7_R = ISTAT15_R;
#[doc = "Port input data 6"]
pub type ISTAT6_A = ISTAT15_A;
#[doc = "Field `ISTAT6` reader - Port input data 6"]
pub type ISTAT6_R = ISTAT15_R;
#[doc = "Port input data 5"]
pub type ISTAT5_A = ISTAT15_A;
#[doc = "Field `ISTAT5` reader - Port input data 5"]
pub type ISTAT5_R = ISTAT15_R;
#[doc = "Port input data 4"]
pub type ISTAT4_A = ISTAT15_A;
#[doc = "Field `ISTAT4` reader - Port input data 4"]
pub type ISTAT4_R = ISTAT15_R;
#[doc = "Port input data 3"]
pub type ISTAT3_A = ISTAT15_A;
#[doc = "Field `ISTAT3` reader - Port input data 3"]
pub type ISTAT3_R = ISTAT15_R;
#[doc = "Port input data 2"]
pub type ISTAT2_A = ISTAT15_A;
#[doc = "Field `ISTAT2` reader - Port input data 2"]
pub type ISTAT2_R = ISTAT15_R;
#[doc = "Port input data 1"]
pub type ISTAT1_A = ISTAT15_A;
#[doc = "Field `ISTAT1` reader - Port input data 1"]
pub type ISTAT1_R = ISTAT15_R;
#[doc = "Port input data 0"]
pub type ISTAT0_A = ISTAT15_A;
#[doc = "Field `ISTAT0` reader - Port input data 0"]
pub type ISTAT0_R = ISTAT15_R;
impl R {
    #[doc = "Bit 15 - Port input data 14"]
    #[inline(always)]
    pub fn istat15(&self) -> ISTAT15_R {
        ISTAT15_R::new(((self.bits >> 15) & 0x01) != 0)
    }
    #[doc = "Bit 14 - Port input data 14"]
    #[inline(always)]
    pub fn istat14(&self) -> ISTAT14_R {
        ISTAT14_R::new(((self.bits >> 14) & 0x01) != 0)
    }
    #[doc = "Bit 13 - Port input data 13"]
    #[inline(always)]
    pub fn istat13(&self) -> ISTAT13_R {
        ISTAT13_R::new(((self.bits >> 13) & 0x01) != 0)
    }
    #[doc = "Bit 12 - Port input data 12"]
    #[inline(always)]
    pub fn istat12(&self) -> ISTAT12_R {
        ISTAT12_R::new(((self.bits >> 12) & 0x01) != 0)
    }
    #[doc = "Bit 11 - Port input data 11"]
    #[inline(always)]
    pub fn istat11(&self) -> ISTAT11_R {
        ISTAT11_R::new(((self.bits >> 11) & 0x01) != 0)
    }
    #[doc = "Bit 10 - Port input data 10"]
    #[inline(always)]
    pub fn istat10(&self) -> ISTAT10_R {
        ISTAT10_R::new(((self.bits >> 10) & 0x01) != 0)
    }
    #[doc = "Bit 9 - Port input data 9"]
    #[inline(always)]
    pub fn istat9(&self) -> ISTAT9_R {
        ISTAT9_R::new(((self.bits >> 9) & 0x01) != 0)
    }
    #[doc = "Bit 8 - Port input data 8"]
    #[inline(always)]
    pub fn istat8(&self) -> ISTAT8_R {
        ISTAT8_R::new(((self.bits >> 8) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Port input data 7"]
    #[inline(always)]
    pub fn istat7(&self) -> ISTAT7_R {
        ISTAT7_R::new(((self.bits >> 7) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Port input data 6"]
    #[inline(always)]
    pub fn istat6(&self) -> ISTAT6_R {
        ISTAT6_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Port input data 5"]
    #[inline(always)]
    pub fn istat5(&self) -> ISTAT5_R {
        ISTAT5_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Port input data 4"]
    #[inline(always)]
    pub fn istat4(&self) -> ISTAT4_R {
        ISTAT4_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Port input data 3"]
    #[inline(always)]
    pub fn istat3(&self) -> ISTAT3_R {
        ISTAT3_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Port input data 2"]
    #[inline(always)]
    pub fn istat2(&self) -> ISTAT2_R {
        ISTAT2_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 1 - Port input data 1"]
    #[inline(always)]
    pub fn istat1(&self) -> ISTAT1_R {
        ISTAT1_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 0 - Port input data 0"]
    #[inline(always)]
    pub fn istat0(&self) -> ISTAT0_R {
        ISTAT0_R::new((self.bits & 0x01) != 0)
    }
}
#[doc = "GPIO port input data register\n\nThis register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [istat](index.html) module"]
pub struct ISTAT_SPEC;
impl crate::RegisterSpec for ISTAT_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [istat::R](R) reader structure"]
impl crate::Readable for ISTAT_SPEC {
    type Reader = R;
}
#[doc = "`reset()` method sets ISTAT to value 0"]
impl crate::Resettable for ISTAT_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
