#[doc = "Register `OSPD` reader"]
pub struct R(crate::R<OSPD_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<OSPD_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::convert::From<crate::R<OSPD_SPEC>> for R {
    fn from(reader: crate::R<OSPD_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `OSPD` writer"]
pub struct W(crate::W<OSPD_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<OSPD_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl core::convert::From<crate::W<OSPD_SPEC>> for W {
    fn from(writer: crate::W<OSPD_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Pin 15 output max speed bits\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
#[repr(u8)]
pub enum OSPD15_A {
    #[doc = "0: Max output speed 2 MHz"]
    SPEED2M = 0,
    #[doc = "1: Max output speed 10 MHz"]
    SPEED10M = 1,
    #[doc = "3: Max output speed 50 MHz"]
    SPEED50M = 3,
}
impl From<OSPD15_A> for u8 {
    #[inline(always)]
    fn from(variant: OSPD15_A) -> Self {
        variant as _
    }
}
#[doc = "Field `OSPD15` reader - Pin 15 output max speed bits"]
pub struct OSPD15_R(crate::FieldReader<u8, OSPD15_A>);
impl OSPD15_R {
    pub(crate) fn new(bits: u8) -> Self {
        OSPD15_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> Option<OSPD15_A> {
        match self.bits {
            0 => Some(OSPD15_A::SPEED2M),
            1 => Some(OSPD15_A::SPEED10M),
            3 => Some(OSPD15_A::SPEED50M),
            _ => None,
        }
    }
    #[doc = "Checks if the value of the field is `SPEED2M`"]
    #[inline(always)]
    pub fn is_speed2m(&self) -> bool {
        **self == OSPD15_A::SPEED2M
    }
    #[doc = "Checks if the value of the field is `SPEED10M`"]
    #[inline(always)]
    pub fn is_speed10m(&self) -> bool {
        **self == OSPD15_A::SPEED10M
    }
    #[doc = "Checks if the value of the field is `SPEED50M`"]
    #[inline(always)]
    pub fn is_speed50m(&self) -> bool {
        **self == OSPD15_A::SPEED50M
    }
}
impl core::ops::Deref for OSPD15_R {
    type Target = crate::FieldReader<u8, OSPD15_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `OSPD15` writer - Pin 15 output max speed bits"]
pub struct OSPD15_W<'a> {
    w: &'a mut W,
}
impl<'a> OSPD15_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OSPD15_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "Max output speed 2 MHz"]
    #[inline(always)]
    pub fn speed2m(self) -> &'a mut W {
        self.variant(OSPD15_A::SPEED2M)
    }
    #[doc = "Max output speed 10 MHz"]
    #[inline(always)]
    pub fn speed10m(self) -> &'a mut W {
        self.variant(OSPD15_A::SPEED10M)
    }
    #[doc = "Max output speed 50 MHz"]
    #[inline(always)]
    pub fn speed50m(self) -> &'a mut W {
        self.variant(OSPD15_A::SPEED50M)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 30)) | ((value as u32 & 0x03) << 30);
        self.w
    }
}
#[doc = "Pin 14 output max speed bits"]
pub type OSPD14_A = OSPD15_A;
#[doc = "Field `OSPD14` reader - Pin 14 output max speed bits"]
pub type OSPD14_R = OSPD15_R;
#[doc = "Field `OSPD14` writer - Pin 14 output max speed bits"]
pub struct OSPD14_W<'a> {
    w: &'a mut W,
}
impl<'a> OSPD14_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OSPD14_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "Max output speed 2 MHz"]
    #[inline(always)]
    pub fn speed2m(self) -> &'a mut W {
        self.variant(OSPD14_A::SPEED2M)
    }
    #[doc = "Max output speed 10 MHz"]
    #[inline(always)]
    pub fn speed10m(self) -> &'a mut W {
        self.variant(OSPD14_A::SPEED10M)
    }
    #[doc = "Max output speed 50 MHz"]
    #[inline(always)]
    pub fn speed50m(self) -> &'a mut W {
        self.variant(OSPD14_A::SPEED50M)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 28)) | ((value as u32 & 0x03) << 28);
        self.w
    }
}
#[doc = "Pin 13 output max speed bits"]
pub type OSPD13_A = OSPD15_A;
#[doc = "Field `OSPD13` reader - Pin 13 output max speed bits"]
pub type OSPD13_R = OSPD15_R;
#[doc = "Field `OSPD13` writer - Pin 13 output max speed bits"]
pub struct OSPD13_W<'a> {
    w: &'a mut W,
}
impl<'a> OSPD13_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OSPD13_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "Max output speed 2 MHz"]
    #[inline(always)]
    pub fn speed2m(self) -> &'a mut W {
        self.variant(OSPD13_A::SPEED2M)
    }
    #[doc = "Max output speed 10 MHz"]
    #[inline(always)]
    pub fn speed10m(self) -> &'a mut W {
        self.variant(OSPD13_A::SPEED10M)
    }
    #[doc = "Max output speed 50 MHz"]
    #[inline(always)]
    pub fn speed50m(self) -> &'a mut W {
        self.variant(OSPD13_A::SPEED50M)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 26)) | ((value as u32 & 0x03) << 26);
        self.w
    }
}
#[doc = "Pin 12 output max speed bits"]
pub type OSPD12_A = OSPD15_A;
#[doc = "Field `OSPD12` reader - Pin 12 output max speed bits"]
pub type OSPD12_R = OSPD15_R;
#[doc = "Field `OSPD12` writer - Pin 12 output max speed bits"]
pub struct OSPD12_W<'a> {
    w: &'a mut W,
}
impl<'a> OSPD12_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OSPD12_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "Max output speed 2 MHz"]
    #[inline(always)]
    pub fn speed2m(self) -> &'a mut W {
        self.variant(OSPD12_A::SPEED2M)
    }
    #[doc = "Max output speed 10 MHz"]
    #[inline(always)]
    pub fn speed10m(self) -> &'a mut W {
        self.variant(OSPD12_A::SPEED10M)
    }
    #[doc = "Max output speed 50 MHz"]
    #[inline(always)]
    pub fn speed50m(self) -> &'a mut W {
        self.variant(OSPD12_A::SPEED50M)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 24)) | ((value as u32 & 0x03) << 24);
        self.w
    }
}
#[doc = "Pin 11 output max speed bits"]
pub type OSPD11_A = OSPD15_A;
#[doc = "Field `OSPD11` reader - Pin 11 output max speed bits"]
pub type OSPD11_R = OSPD15_R;
#[doc = "Field `OSPD11` writer - Pin 11 output max speed bits"]
pub struct OSPD11_W<'a> {
    w: &'a mut W,
}
impl<'a> OSPD11_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OSPD11_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "Max output speed 2 MHz"]
    #[inline(always)]
    pub fn speed2m(self) -> &'a mut W {
        self.variant(OSPD11_A::SPEED2M)
    }
    #[doc = "Max output speed 10 MHz"]
    #[inline(always)]
    pub fn speed10m(self) -> &'a mut W {
        self.variant(OSPD11_A::SPEED10M)
    }
    #[doc = "Max output speed 50 MHz"]
    #[inline(always)]
    pub fn speed50m(self) -> &'a mut W {
        self.variant(OSPD11_A::SPEED50M)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 22)) | ((value as u32 & 0x03) << 22);
        self.w
    }
}
#[doc = "Pin 10 output max speed bits"]
pub type OSPD10_A = OSPD15_A;
#[doc = "Field `OSPD10` reader - Pin 10 output max speed bits"]
pub type OSPD10_R = OSPD15_R;
#[doc = "Field `OSPD10` writer - Pin 10 output max speed bits"]
pub struct OSPD10_W<'a> {
    w: &'a mut W,
}
impl<'a> OSPD10_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OSPD10_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "Max output speed 2 MHz"]
    #[inline(always)]
    pub fn speed2m(self) -> &'a mut W {
        self.variant(OSPD10_A::SPEED2M)
    }
    #[doc = "Max output speed 10 MHz"]
    #[inline(always)]
    pub fn speed10m(self) -> &'a mut W {
        self.variant(OSPD10_A::SPEED10M)
    }
    #[doc = "Max output speed 50 MHz"]
    #[inline(always)]
    pub fn speed50m(self) -> &'a mut W {
        self.variant(OSPD10_A::SPEED50M)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 20)) | ((value as u32 & 0x03) << 20);
        self.w
    }
}
#[doc = "Pin 9 output max speed bits"]
pub type OSPD9_A = OSPD15_A;
#[doc = "Field `OSPD9` reader - Pin 9 output max speed bits"]
pub type OSPD9_R = OSPD15_R;
#[doc = "Field `OSPD9` writer - Pin 9 output max speed bits"]
pub struct OSPD9_W<'a> {
    w: &'a mut W,
}
impl<'a> OSPD9_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OSPD9_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "Max output speed 2 MHz"]
    #[inline(always)]
    pub fn speed2m(self) -> &'a mut W {
        self.variant(OSPD9_A::SPEED2M)
    }
    #[doc = "Max output speed 10 MHz"]
    #[inline(always)]
    pub fn speed10m(self) -> &'a mut W {
        self.variant(OSPD9_A::SPEED10M)
    }
    #[doc = "Max output speed 50 MHz"]
    #[inline(always)]
    pub fn speed50m(self) -> &'a mut W {
        self.variant(OSPD9_A::SPEED50M)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 18)) | ((value as u32 & 0x03) << 18);
        self.w
    }
}
#[doc = "Pin 8 output max speed bits"]
pub type OSPD8_A = OSPD15_A;
#[doc = "Field `OSPD8` reader - Pin 8 output max speed bits"]
pub type OSPD8_R = OSPD15_R;
#[doc = "Field `OSPD8` writer - Pin 8 output max speed bits"]
pub struct OSPD8_W<'a> {
    w: &'a mut W,
}
impl<'a> OSPD8_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OSPD8_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "Max output speed 2 MHz"]
    #[inline(always)]
    pub fn speed2m(self) -> &'a mut W {
        self.variant(OSPD8_A::SPEED2M)
    }
    #[doc = "Max output speed 10 MHz"]
    #[inline(always)]
    pub fn speed10m(self) -> &'a mut W {
        self.variant(OSPD8_A::SPEED10M)
    }
    #[doc = "Max output speed 50 MHz"]
    #[inline(always)]
    pub fn speed50m(self) -> &'a mut W {
        self.variant(OSPD8_A::SPEED50M)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 16)) | ((value as u32 & 0x03) << 16);
        self.w
    }
}
#[doc = "Pin 7 output max speed bits"]
pub type OSPD7_A = OSPD15_A;
#[doc = "Field `OSPD7` reader - Pin 7 output max speed bits"]
pub type OSPD7_R = OSPD15_R;
#[doc = "Field `OSPD7` writer - Pin 7 output max speed bits"]
pub struct OSPD7_W<'a> {
    w: &'a mut W,
}
impl<'a> OSPD7_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OSPD7_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "Max output speed 2 MHz"]
    #[inline(always)]
    pub fn speed2m(self) -> &'a mut W {
        self.variant(OSPD7_A::SPEED2M)
    }
    #[doc = "Max output speed 10 MHz"]
    #[inline(always)]
    pub fn speed10m(self) -> &'a mut W {
        self.variant(OSPD7_A::SPEED10M)
    }
    #[doc = "Max output speed 50 MHz"]
    #[inline(always)]
    pub fn speed50m(self) -> &'a mut W {
        self.variant(OSPD7_A::SPEED50M)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 14)) | ((value as u32 & 0x03) << 14);
        self.w
    }
}
#[doc = "Pin 6 output max speed bits"]
pub type OSPD6_A = OSPD15_A;
#[doc = "Field `OSPD6` reader - Pin 6 output max speed bits"]
pub type OSPD6_R = OSPD15_R;
#[doc = "Field `OSPD6` writer - Pin 6 output max speed bits"]
pub struct OSPD6_W<'a> {
    w: &'a mut W,
}
impl<'a> OSPD6_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OSPD6_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "Max output speed 2 MHz"]
    #[inline(always)]
    pub fn speed2m(self) -> &'a mut W {
        self.variant(OSPD6_A::SPEED2M)
    }
    #[doc = "Max output speed 10 MHz"]
    #[inline(always)]
    pub fn speed10m(self) -> &'a mut W {
        self.variant(OSPD6_A::SPEED10M)
    }
    #[doc = "Max output speed 50 MHz"]
    #[inline(always)]
    pub fn speed50m(self) -> &'a mut W {
        self.variant(OSPD6_A::SPEED50M)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 12)) | ((value as u32 & 0x03) << 12);
        self.w
    }
}
#[doc = "Pin 5 output max speed bits"]
pub type OSPD5_A = OSPD15_A;
#[doc = "Field `OSPD5` reader - Pin 5 output max speed bits"]
pub type OSPD5_R = OSPD15_R;
#[doc = "Field `OSPD5` writer - Pin 5 output max speed bits"]
pub struct OSPD5_W<'a> {
    w: &'a mut W,
}
impl<'a> OSPD5_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OSPD5_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "Max output speed 2 MHz"]
    #[inline(always)]
    pub fn speed2m(self) -> &'a mut W {
        self.variant(OSPD5_A::SPEED2M)
    }
    #[doc = "Max output speed 10 MHz"]
    #[inline(always)]
    pub fn speed10m(self) -> &'a mut W {
        self.variant(OSPD5_A::SPEED10M)
    }
    #[doc = "Max output speed 50 MHz"]
    #[inline(always)]
    pub fn speed50m(self) -> &'a mut W {
        self.variant(OSPD5_A::SPEED50M)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 10)) | ((value as u32 & 0x03) << 10);
        self.w
    }
}
#[doc = "Pin 4 output max speed bits"]
pub type OSPD4_A = OSPD15_A;
#[doc = "Field `OSPD4` reader - Pin 4 output max speed bits"]
pub type OSPD4_R = OSPD15_R;
#[doc = "Field `OSPD4` writer - Pin 4 output max speed bits"]
pub struct OSPD4_W<'a> {
    w: &'a mut W,
}
impl<'a> OSPD4_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OSPD4_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "Max output speed 2 MHz"]
    #[inline(always)]
    pub fn speed2m(self) -> &'a mut W {
        self.variant(OSPD4_A::SPEED2M)
    }
    #[doc = "Max output speed 10 MHz"]
    #[inline(always)]
    pub fn speed10m(self) -> &'a mut W {
        self.variant(OSPD4_A::SPEED10M)
    }
    #[doc = "Max output speed 50 MHz"]
    #[inline(always)]
    pub fn speed50m(self) -> &'a mut W {
        self.variant(OSPD4_A::SPEED50M)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 8)) | ((value as u32 & 0x03) << 8);
        self.w
    }
}
#[doc = "Pin 3 output max speed bits"]
pub type OSPD3_A = OSPD15_A;
#[doc = "Field `OSPD3` reader - Pin 3 output max speed bits"]
pub type OSPD3_R = OSPD15_R;
#[doc = "Field `OSPD3` writer - Pin 3 output max speed bits"]
pub struct OSPD3_W<'a> {
    w: &'a mut W,
}
impl<'a> OSPD3_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OSPD3_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "Max output speed 2 MHz"]
    #[inline(always)]
    pub fn speed2m(self) -> &'a mut W {
        self.variant(OSPD3_A::SPEED2M)
    }
    #[doc = "Max output speed 10 MHz"]
    #[inline(always)]
    pub fn speed10m(self) -> &'a mut W {
        self.variant(OSPD3_A::SPEED10M)
    }
    #[doc = "Max output speed 50 MHz"]
    #[inline(always)]
    pub fn speed50m(self) -> &'a mut W {
        self.variant(OSPD3_A::SPEED50M)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 6)) | ((value as u32 & 0x03) << 6);
        self.w
    }
}
#[doc = "Pin 2 output max speed bits"]
pub type OSPD2_A = OSPD15_A;
#[doc = "Field `OSPD2` reader - Pin 2 output max speed bits"]
pub type OSPD2_R = OSPD15_R;
#[doc = "Field `OSPD2` writer - Pin 2 output max speed bits"]
pub struct OSPD2_W<'a> {
    w: &'a mut W,
}
impl<'a> OSPD2_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OSPD2_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "Max output speed 2 MHz"]
    #[inline(always)]
    pub fn speed2m(self) -> &'a mut W {
        self.variant(OSPD2_A::SPEED2M)
    }
    #[doc = "Max output speed 10 MHz"]
    #[inline(always)]
    pub fn speed10m(self) -> &'a mut W {
        self.variant(OSPD2_A::SPEED10M)
    }
    #[doc = "Max output speed 50 MHz"]
    #[inline(always)]
    pub fn speed50m(self) -> &'a mut W {
        self.variant(OSPD2_A::SPEED50M)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 4)) | ((value as u32 & 0x03) << 4);
        self.w
    }
}
#[doc = "Pin 1 output max speed bits"]
pub type OSPD1_A = OSPD15_A;
#[doc = "Field `OSPD1` reader - Pin 1 output max speed bits"]
pub type OSPD1_R = OSPD15_R;
#[doc = "Field `OSPD1` writer - Pin 1 output max speed bits"]
pub struct OSPD1_W<'a> {
    w: &'a mut W,
}
impl<'a> OSPD1_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OSPD1_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "Max output speed 2 MHz"]
    #[inline(always)]
    pub fn speed2m(self) -> &'a mut W {
        self.variant(OSPD1_A::SPEED2M)
    }
    #[doc = "Max output speed 10 MHz"]
    #[inline(always)]
    pub fn speed10m(self) -> &'a mut W {
        self.variant(OSPD1_A::SPEED10M)
    }
    #[doc = "Max output speed 50 MHz"]
    #[inline(always)]
    pub fn speed50m(self) -> &'a mut W {
        self.variant(OSPD1_A::SPEED50M)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 2)) | ((value as u32 & 0x03) << 2);
        self.w
    }
}
#[doc = "Pin 0 output max speed bits"]
pub type OSPD0_A = OSPD15_A;
#[doc = "Field `OSPD0` reader - Pin 0 output max speed bits"]
pub type OSPD0_R = OSPD15_R;
#[doc = "Field `OSPD0` writer - Pin 0 output max speed bits"]
pub struct OSPD0_W<'a> {
    w: &'a mut W,
}
impl<'a> OSPD0_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: OSPD0_A) -> &'a mut W {
        unsafe { self.bits(variant.into()) }
    }
    #[doc = "Max output speed 2 MHz"]
    #[inline(always)]
    pub fn speed2m(self) -> &'a mut W {
        self.variant(OSPD0_A::SPEED2M)
    }
    #[doc = "Max output speed 10 MHz"]
    #[inline(always)]
    pub fn speed10m(self) -> &'a mut W {
        self.variant(OSPD0_A::SPEED10M)
    }
    #[doc = "Max output speed 50 MHz"]
    #[inline(always)]
    pub fn speed50m(self) -> &'a mut W {
        self.variant(OSPD0_A::SPEED50M)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x03) | (value as u32 & 0x03);
        self.w
    }
}
impl R {
    #[doc = "Bits 30:31 - Pin 15 output max speed bits"]
    #[inline(always)]
    pub fn ospd15(&self) -> OSPD15_R {
        OSPD15_R::new(((self.bits >> 30) & 0x03) as u8)
    }
    #[doc = "Bits 28:29 - Pin 14 output max speed bits"]
    #[inline(always)]
    pub fn ospd14(&self) -> OSPD14_R {
        OSPD14_R::new(((self.bits >> 28) & 0x03) as u8)
    }
    #[doc = "Bits 26:27 - Pin 13 output max speed bits"]
    #[inline(always)]
    pub fn ospd13(&self) -> OSPD13_R {
        OSPD13_R::new(((self.bits >> 26) & 0x03) as u8)
    }
    #[doc = "Bits 24:25 - Pin 12 output max speed bits"]
    #[inline(always)]
    pub fn ospd12(&self) -> OSPD12_R {
        OSPD12_R::new(((self.bits >> 24) & 0x03) as u8)
    }
    #[doc = "Bits 22:23 - Pin 11 output max speed bits"]
    #[inline(always)]
    pub fn ospd11(&self) -> OSPD11_R {
        OSPD11_R::new(((self.bits >> 22) & 0x03) as u8)
    }
    #[doc = "Bits 20:21 - Pin 10 output max speed bits"]
    #[inline(always)]
    pub fn ospd10(&self) -> OSPD10_R {
        OSPD10_R::new(((self.bits >> 20) & 0x03) as u8)
    }
    #[doc = "Bits 18:19 - Pin 9 output max speed bits"]
    #[inline(always)]
    pub fn ospd9(&self) -> OSPD9_R {
        OSPD9_R::new(((self.bits >> 18) & 0x03) as u8)
    }
    #[doc = "Bits 16:17 - Pin 8 output max speed bits"]
    #[inline(always)]
    pub fn ospd8(&self) -> OSPD8_R {
        OSPD8_R::new(((self.bits >> 16) & 0x03) as u8)
    }
    #[doc = "Bits 14:15 - Pin 7 output max speed bits"]
    #[inline(always)]
    pub fn ospd7(&self) -> OSPD7_R {
        OSPD7_R::new(((self.bits >> 14) & 0x03) as u8)
    }
    #[doc = "Bits 12:13 - Pin 6 output max speed bits"]
    #[inline(always)]
    pub fn ospd6(&self) -> OSPD6_R {
        OSPD6_R::new(((self.bits >> 12) & 0x03) as u8)
    }
    #[doc = "Bits 10:11 - Pin 5 output max speed bits"]
    #[inline(always)]
    pub fn ospd5(&self) -> OSPD5_R {
        OSPD5_R::new(((self.bits >> 10) & 0x03) as u8)
    }
    #[doc = "Bits 8:9 - Pin 4 output max speed bits"]
    #[inline(always)]
    pub fn ospd4(&self) -> OSPD4_R {
        OSPD4_R::new(((self.bits >> 8) & 0x03) as u8)
    }
    #[doc = "Bits 6:7 - Pin 3 output max speed bits"]
    #[inline(always)]
    pub fn ospd3(&self) -> OSPD3_R {
        OSPD3_R::new(((self.bits >> 6) & 0x03) as u8)
    }
    #[doc = "Bits 4:5 - Pin 2 output max speed bits"]
    #[inline(always)]
    pub fn ospd2(&self) -> OSPD2_R {
        OSPD2_R::new(((self.bits >> 4) & 0x03) as u8)
    }
    #[doc = "Bits 2:3 - Pin 1 output max speed bits"]
    #[inline(always)]
    pub fn ospd1(&self) -> OSPD1_R {
        OSPD1_R::new(((self.bits >> 2) & 0x03) as u8)
    }
    #[doc = "Bits 0:1 - Pin 0 output max speed bits"]
    #[inline(always)]
    pub fn ospd0(&self) -> OSPD0_R {
        OSPD0_R::new((self.bits & 0x03) as u8)
    }
}
impl W {
    #[doc = "Bits 30:31 - Pin 15 output max speed bits"]
    #[inline(always)]
    pub fn ospd15(&mut self) -> OSPD15_W {
        OSPD15_W { w: self }
    }
    #[doc = "Bits 28:29 - Pin 14 output max speed bits"]
    #[inline(always)]
    pub fn ospd14(&mut self) -> OSPD14_W {
        OSPD14_W { w: self }
    }
    #[doc = "Bits 26:27 - Pin 13 output max speed bits"]
    #[inline(always)]
    pub fn ospd13(&mut self) -> OSPD13_W {
        OSPD13_W { w: self }
    }
    #[doc = "Bits 24:25 - Pin 12 output max speed bits"]
    #[inline(always)]
    pub fn ospd12(&mut self) -> OSPD12_W {
        OSPD12_W { w: self }
    }
    #[doc = "Bits 22:23 - Pin 11 output max speed bits"]
    #[inline(always)]
    pub fn ospd11(&mut self) -> OSPD11_W {
        OSPD11_W { w: self }
    }
    #[doc = "Bits 20:21 - Pin 10 output max speed bits"]
    #[inline(always)]
    pub fn ospd10(&mut self) -> OSPD10_W {
        OSPD10_W { w: self }
    }
    #[doc = "Bits 18:19 - Pin 9 output max speed bits"]
    #[inline(always)]
    pub fn ospd9(&mut self) -> OSPD9_W {
        OSPD9_W { w: self }
    }
    #[doc = "Bits 16:17 - Pin 8 output max speed bits"]
    #[inline(always)]
    pub fn ospd8(&mut self) -> OSPD8_W {
        OSPD8_W { w: self }
    }
    #[doc = "Bits 14:15 - Pin 7 output max speed bits"]
    #[inline(always)]
    pub fn ospd7(&mut self) -> OSPD7_W {
        OSPD7_W { w: self }
    }
    #[doc = "Bits 12:13 - Pin 6 output max speed bits"]
    #[inline(always)]
    pub fn ospd6(&mut self) -> OSPD6_W {
        OSPD6_W { w: self }
    }
    #[doc = "Bits 10:11 - Pin 5 output max speed bits"]
    #[inline(always)]
    pub fn ospd5(&mut self) -> OSPD5_W {
        OSPD5_W { w: self }
    }
    #[doc = "Bits 8:9 - Pin 4 output max speed bits"]
    #[inline(always)]
    pub fn ospd4(&mut self) -> OSPD4_W {
        OSPD4_W { w: self }
    }
    #[doc = "Bits 6:7 - Pin 3 output max speed bits"]
    #[inline(always)]
    pub fn ospd3(&mut self) -> OSPD3_W {
        OSPD3_W { w: self }
    }
    #[doc = "Bits 4:5 - Pin 2 output max speed bits"]
    #[inline(always)]
    pub fn ospd2(&mut self) -> OSPD2_W {
        OSPD2_W { w: self }
    }
    #[doc = "Bits 2:3 - Pin 1 output max speed bits"]
    #[inline(always)]
    pub fn ospd1(&mut self) -> OSPD1_W {
        OSPD1_W { w: self }
    }
    #[doc = "Bits 0:1 - Pin 0 output max speed bits"]
    #[inline(always)]
    pub fn ospd0(&mut self) -> OSPD0_W {
        OSPD0_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "GPIO port output speed register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ospd](index.html) module"]
pub struct OSPD_SPEC;
impl crate::RegisterSpec for OSPD_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [ospd::R](R) reader structure"]
impl crate::Readable for OSPD_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [ospd::W](W) writer structure"]
impl crate::Writable for OSPD_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets OSPD to value 0"]
impl crate::Resettable for OSPD_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
