#[doc = "Register `STATC` reader"]
pub struct R(crate::R<STATC_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<STATC_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::convert::From<crate::R<STATC_SPEC>> for R {
    fn from(reader: crate::R<STATC_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `STATC` writer"]
pub struct W(crate::W<STATC_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<STATC_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl core::convert::From<crate::W<STATC_SPEC>> for W {
    fn from(writer: crate::W<STATC_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `SOFC` reader - Start of frame flag clear"]
pub struct SOFC_R(crate::FieldReader<bool, bool>);
impl SOFC_R {
    pub(crate) fn new(bits: bool) -> Self {
        SOFC_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SOFC_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SOFC` writer - Start of frame flag clear"]
pub struct SOFC_W<'a> {
    w: &'a mut W,
}
impl<'a> SOFC_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `UPDC` reader - SLCD data update done clear bit"]
pub struct UPDC_R(crate::FieldReader<bool, bool>);
impl UPDC_R {
    pub(crate) fn new(bits: bool) -> Self {
        UPDC_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for UPDC_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `UPDC` writer - SLCD data update done clear bit"]
pub struct UPDC_W<'a> {
    w: &'a mut W,
}
impl<'a> UPDC_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u32 & 0x01) << 3);
        self.w
    }
}
impl R {
    #[doc = "Bit 1 - Start of frame flag clear"]
    #[inline(always)]
    pub fn sofc(&self) -> SOFC_R {
        SOFC_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 3 - SLCD data update done clear bit"]
    #[inline(always)]
    pub fn updc(&self) -> UPDC_R {
        UPDC_R::new(((self.bits >> 3) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 1 - Start of frame flag clear"]
    #[inline(always)]
    pub fn sofc(&mut self) -> SOFC_W {
        SOFC_W { w: self }
    }
    #[doc = "Bit 3 - SLCD data update done clear bit"]
    #[inline(always)]
    pub fn updc(&mut self) -> UPDC_W {
        UPDC_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "SLCD status flag clear register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [statc](index.html) module"]
pub struct STATC_SPEC;
impl crate::RegisterSpec for STATC_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [statc::R](R) reader structure"]
impl crate::Readable for STATC_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [statc::W](W) writer structure"]
impl crate::Writable for STATC_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets STATC to value 0"]
impl crate::Resettable for STATC_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
