#[doc = "Register `FAFIFO` reader"]
pub struct R(crate::R<FAFIFO_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<FAFIFO_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::convert::From<crate::R<FAFIFO_SPEC>> for R {
    fn from(reader: crate::R<FAFIFO_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `FAFIFO` writer"]
pub struct W(crate::W<FAFIFO_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<FAFIFO_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl core::convert::From<crate::W<FAFIFO_SPEC>> for W {
    fn from(writer: crate::W<FAFIFO_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Filter 0 associated FIFO\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum FAF0_A {
    #[doc = "0: Filter associated with FIFO0"]
    FIFO0 = 0,
    #[doc = "1: Filter associated with FIFO1"]
    FIFO1 = 1,
}
impl From<FAF0_A> for bool {
    #[inline(always)]
    fn from(variant: FAF0_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `FAF0` reader - Filter 0 associated FIFO"]
pub struct FAF0_R(crate::FieldReader<bool, FAF0_A>);
impl FAF0_R {
    pub(crate) fn new(bits: bool) -> Self {
        FAF0_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> FAF0_A {
        match self.bits {
            false => FAF0_A::FIFO0,
            true => FAF0_A::FIFO1,
        }
    }
    #[doc = "Checks if the value of the field is `FIFO0`"]
    #[inline(always)]
    pub fn is_fifo0(&self) -> bool {
        **self == FAF0_A::FIFO0
    }
    #[doc = "Checks if the value of the field is `FIFO1`"]
    #[inline(always)]
    pub fn is_fifo1(&self) -> bool {
        **self == FAF0_A::FIFO1
    }
}
impl core::ops::Deref for FAF0_R {
    type Target = crate::FieldReader<bool, FAF0_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FAF0` writer - Filter 0 associated FIFO"]
pub struct FAF0_W<'a> {
    w: &'a mut W,
}
impl<'a> FAF0_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FAF0_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter associated with FIFO0"]
    #[inline(always)]
    pub fn fifo0(self) -> &'a mut W {
        self.variant(FAF0_A::FIFO0)
    }
    #[doc = "Filter associated with FIFO1"]
    #[inline(always)]
    pub fn fifo1(self) -> &'a mut W {
        self.variant(FAF0_A::FIFO1)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
#[doc = "Filter 1 associated FIFO"]
pub type FAF1_A = FAF0_A;
#[doc = "Field `FAF1` reader - Filter 1 associated FIFO"]
pub type FAF1_R = FAF0_R;
#[doc = "Field `FAF1` writer - Filter 1 associated FIFO"]
pub struct FAF1_W<'a> {
    w: &'a mut W,
}
impl<'a> FAF1_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FAF1_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter associated with FIFO0"]
    #[inline(always)]
    pub fn fifo0(self) -> &'a mut W {
        self.variant(FAF1_A::FIFO0)
    }
    #[doc = "Filter associated with FIFO1"]
    #[inline(always)]
    pub fn fifo1(self) -> &'a mut W {
        self.variant(FAF1_A::FIFO1)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "Filter 2 associated FIFO"]
pub type FAF2_A = FAF0_A;
#[doc = "Field `FAF2` reader - Filter 2 associated FIFO"]
pub type FAF2_R = FAF0_R;
#[doc = "Field `FAF2` writer - Filter 2 associated FIFO"]
pub struct FAF2_W<'a> {
    w: &'a mut W,
}
impl<'a> FAF2_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FAF2_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter associated with FIFO0"]
    #[inline(always)]
    pub fn fifo0(self) -> &'a mut W {
        self.variant(FAF2_A::FIFO0)
    }
    #[doc = "Filter associated with FIFO1"]
    #[inline(always)]
    pub fn fifo1(self) -> &'a mut W {
        self.variant(FAF2_A::FIFO1)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u32 & 0x01) << 2);
        self.w
    }
}
#[doc = "Filter 3 associated FIFO"]
pub type FAF3_A = FAF0_A;
#[doc = "Field `FAF3` reader - Filter 3 associated FIFO"]
pub type FAF3_R = FAF0_R;
#[doc = "Field `FAF3` writer - Filter 3 associated FIFO"]
pub struct FAF3_W<'a> {
    w: &'a mut W,
}
impl<'a> FAF3_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FAF3_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter associated with FIFO0"]
    #[inline(always)]
    pub fn fifo0(self) -> &'a mut W {
        self.variant(FAF3_A::FIFO0)
    }
    #[doc = "Filter associated with FIFO1"]
    #[inline(always)]
    pub fn fifo1(self) -> &'a mut W {
        self.variant(FAF3_A::FIFO1)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u32 & 0x01) << 3);
        self.w
    }
}
#[doc = "Filter 4 associated FIFO"]
pub type FAF4_A = FAF0_A;
#[doc = "Field `FAF4` reader - Filter 4 associated FIFO"]
pub type FAF4_R = FAF0_R;
#[doc = "Field `FAF4` writer - Filter 4 associated FIFO"]
pub struct FAF4_W<'a> {
    w: &'a mut W,
}
impl<'a> FAF4_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FAF4_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter associated with FIFO0"]
    #[inline(always)]
    pub fn fifo0(self) -> &'a mut W {
        self.variant(FAF4_A::FIFO0)
    }
    #[doc = "Filter associated with FIFO1"]
    #[inline(always)]
    pub fn fifo1(self) -> &'a mut W {
        self.variant(FAF4_A::FIFO1)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u32 & 0x01) << 4);
        self.w
    }
}
#[doc = "Filter 5 associated FIFO"]
pub type FAF5_A = FAF0_A;
#[doc = "Field `FAF5` reader - Filter 5 associated FIFO"]
pub type FAF5_R = FAF0_R;
#[doc = "Field `FAF5` writer - Filter 5 associated FIFO"]
pub struct FAF5_W<'a> {
    w: &'a mut W,
}
impl<'a> FAF5_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FAF5_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter associated with FIFO0"]
    #[inline(always)]
    pub fn fifo0(self) -> &'a mut W {
        self.variant(FAF5_A::FIFO0)
    }
    #[doc = "Filter associated with FIFO1"]
    #[inline(always)]
    pub fn fifo1(self) -> &'a mut W {
        self.variant(FAF5_A::FIFO1)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u32 & 0x01) << 5);
        self.w
    }
}
#[doc = "Filter 6 associated FIFO"]
pub type FAF6_A = FAF0_A;
#[doc = "Field `FAF6` reader - Filter 6 associated FIFO"]
pub type FAF6_R = FAF0_R;
#[doc = "Field `FAF6` writer - Filter 6 associated FIFO"]
pub struct FAF6_W<'a> {
    w: &'a mut W,
}
impl<'a> FAF6_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FAF6_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter associated with FIFO0"]
    #[inline(always)]
    pub fn fifo0(self) -> &'a mut W {
        self.variant(FAF6_A::FIFO0)
    }
    #[doc = "Filter associated with FIFO1"]
    #[inline(always)]
    pub fn fifo1(self) -> &'a mut W {
        self.variant(FAF6_A::FIFO1)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u32 & 0x01) << 6);
        self.w
    }
}
#[doc = "Filter 7 associated FIFO"]
pub type FAF7_A = FAF0_A;
#[doc = "Field `FAF7` reader - Filter 7 associated FIFO"]
pub type FAF7_R = FAF0_R;
#[doc = "Field `FAF7` writer - Filter 7 associated FIFO"]
pub struct FAF7_W<'a> {
    w: &'a mut W,
}
impl<'a> FAF7_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FAF7_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter associated with FIFO0"]
    #[inline(always)]
    pub fn fifo0(self) -> &'a mut W {
        self.variant(FAF7_A::FIFO0)
    }
    #[doc = "Filter associated with FIFO1"]
    #[inline(always)]
    pub fn fifo1(self) -> &'a mut W {
        self.variant(FAF7_A::FIFO1)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u32 & 0x01) << 7);
        self.w
    }
}
#[doc = "Filter 8 associated FIFO"]
pub type FAF8_A = FAF0_A;
#[doc = "Field `FAF8` reader - Filter 8 associated FIFO"]
pub type FAF8_R = FAF0_R;
#[doc = "Field `FAF8` writer - Filter 8 associated FIFO"]
pub struct FAF8_W<'a> {
    w: &'a mut W,
}
impl<'a> FAF8_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FAF8_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter associated with FIFO0"]
    #[inline(always)]
    pub fn fifo0(self) -> &'a mut W {
        self.variant(FAF8_A::FIFO0)
    }
    #[doc = "Filter associated with FIFO1"]
    #[inline(always)]
    pub fn fifo1(self) -> &'a mut W {
        self.variant(FAF8_A::FIFO1)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 8)) | ((value as u32 & 0x01) << 8);
        self.w
    }
}
#[doc = "Filter 9 associated FIFO"]
pub type FAF9_A = FAF0_A;
#[doc = "Field `FAF9` reader - Filter 9 associated FIFO"]
pub type FAF9_R = FAF0_R;
#[doc = "Field `FAF9` writer - Filter 9 associated FIFO"]
pub struct FAF9_W<'a> {
    w: &'a mut W,
}
impl<'a> FAF9_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FAF9_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter associated with FIFO0"]
    #[inline(always)]
    pub fn fifo0(self) -> &'a mut W {
        self.variant(FAF9_A::FIFO0)
    }
    #[doc = "Filter associated with FIFO1"]
    #[inline(always)]
    pub fn fifo1(self) -> &'a mut W {
        self.variant(FAF9_A::FIFO1)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 9)) | ((value as u32 & 0x01) << 9);
        self.w
    }
}
#[doc = "Filter 10 associated FIFO"]
pub type FAF10_A = FAF0_A;
#[doc = "Field `FAF10` reader - Filter 10 associated FIFO"]
pub type FAF10_R = FAF0_R;
#[doc = "Field `FAF10` writer - Filter 10 associated FIFO"]
pub struct FAF10_W<'a> {
    w: &'a mut W,
}
impl<'a> FAF10_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FAF10_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter associated with FIFO0"]
    #[inline(always)]
    pub fn fifo0(self) -> &'a mut W {
        self.variant(FAF10_A::FIFO0)
    }
    #[doc = "Filter associated with FIFO1"]
    #[inline(always)]
    pub fn fifo1(self) -> &'a mut W {
        self.variant(FAF10_A::FIFO1)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 10)) | ((value as u32 & 0x01) << 10);
        self.w
    }
}
#[doc = "Filter 11 associated FIFO"]
pub type FAF11_A = FAF0_A;
#[doc = "Field `FAF11` reader - Filter 11 associated FIFO"]
pub type FAF11_R = FAF0_R;
#[doc = "Field `FAF11` writer - Filter 11 associated FIFO"]
pub struct FAF11_W<'a> {
    w: &'a mut W,
}
impl<'a> FAF11_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FAF11_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter associated with FIFO0"]
    #[inline(always)]
    pub fn fifo0(self) -> &'a mut W {
        self.variant(FAF11_A::FIFO0)
    }
    #[doc = "Filter associated with FIFO1"]
    #[inline(always)]
    pub fn fifo1(self) -> &'a mut W {
        self.variant(FAF11_A::FIFO1)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 11)) | ((value as u32 & 0x01) << 11);
        self.w
    }
}
#[doc = "Filter 12 associated FIFO"]
pub type FAF12_A = FAF0_A;
#[doc = "Field `FAF12` reader - Filter 12 associated FIFO"]
pub type FAF12_R = FAF0_R;
#[doc = "Field `FAF12` writer - Filter 12 associated FIFO"]
pub struct FAF12_W<'a> {
    w: &'a mut W,
}
impl<'a> FAF12_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FAF12_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter associated with FIFO0"]
    #[inline(always)]
    pub fn fifo0(self) -> &'a mut W {
        self.variant(FAF12_A::FIFO0)
    }
    #[doc = "Filter associated with FIFO1"]
    #[inline(always)]
    pub fn fifo1(self) -> &'a mut W {
        self.variant(FAF12_A::FIFO1)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 12)) | ((value as u32 & 0x01) << 12);
        self.w
    }
}
#[doc = "Filter 13 associated FIFO"]
pub type FAF13_A = FAF0_A;
#[doc = "Field `FAF13` reader - Filter 13 associated FIFO"]
pub type FAF13_R = FAF0_R;
#[doc = "Field `FAF13` writer - Filter 13 associated FIFO"]
pub struct FAF13_W<'a> {
    w: &'a mut W,
}
impl<'a> FAF13_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FAF13_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter associated with FIFO0"]
    #[inline(always)]
    pub fn fifo0(self) -> &'a mut W {
        self.variant(FAF13_A::FIFO0)
    }
    #[doc = "Filter associated with FIFO1"]
    #[inline(always)]
    pub fn fifo1(self) -> &'a mut W {
        self.variant(FAF13_A::FIFO1)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 13)) | ((value as u32 & 0x01) << 13);
        self.w
    }
}
#[doc = "Filter 14 associated FIFO"]
pub type FAF14_A = FAF0_A;
#[doc = "Field `FAF14` reader - Filter 14 associated FIFO"]
pub type FAF14_R = FAF0_R;
#[doc = "Field `FAF14` writer - Filter 14 associated FIFO"]
pub struct FAF14_W<'a> {
    w: &'a mut W,
}
impl<'a> FAF14_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FAF14_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter associated with FIFO0"]
    #[inline(always)]
    pub fn fifo0(self) -> &'a mut W {
        self.variant(FAF14_A::FIFO0)
    }
    #[doc = "Filter associated with FIFO1"]
    #[inline(always)]
    pub fn fifo1(self) -> &'a mut W {
        self.variant(FAF14_A::FIFO1)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 14)) | ((value as u32 & 0x01) << 14);
        self.w
    }
}
#[doc = "Filter 15 associated FIFO"]
pub type FAF15_A = FAF0_A;
#[doc = "Field `FAF15` reader - Filter 15 associated FIFO"]
pub type FAF15_R = FAF0_R;
#[doc = "Field `FAF15` writer - Filter 15 associated FIFO"]
pub struct FAF15_W<'a> {
    w: &'a mut W,
}
impl<'a> FAF15_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FAF15_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter associated with FIFO0"]
    #[inline(always)]
    pub fn fifo0(self) -> &'a mut W {
        self.variant(FAF15_A::FIFO0)
    }
    #[doc = "Filter associated with FIFO1"]
    #[inline(always)]
    pub fn fifo1(self) -> &'a mut W {
        self.variant(FAF15_A::FIFO1)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 15)) | ((value as u32 & 0x01) << 15);
        self.w
    }
}
#[doc = "Filter 16 associated FIFO"]
pub type FAF16_A = FAF0_A;
#[doc = "Field `FAF16` reader - Filter 16 associated FIFO"]
pub type FAF16_R = FAF0_R;
#[doc = "Field `FAF16` writer - Filter 16 associated FIFO"]
pub struct FAF16_W<'a> {
    w: &'a mut W,
}
impl<'a> FAF16_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FAF16_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter associated with FIFO0"]
    #[inline(always)]
    pub fn fifo0(self) -> &'a mut W {
        self.variant(FAF16_A::FIFO0)
    }
    #[doc = "Filter associated with FIFO1"]
    #[inline(always)]
    pub fn fifo1(self) -> &'a mut W {
        self.variant(FAF16_A::FIFO1)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 16)) | ((value as u32 & 0x01) << 16);
        self.w
    }
}
#[doc = "Filter 17 associated FIFO"]
pub type FAF17_A = FAF0_A;
#[doc = "Field `FAF17` reader - Filter 17 associated FIFO"]
pub type FAF17_R = FAF0_R;
#[doc = "Field `FAF17` writer - Filter 17 associated FIFO"]
pub struct FAF17_W<'a> {
    w: &'a mut W,
}
impl<'a> FAF17_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FAF17_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter associated with FIFO0"]
    #[inline(always)]
    pub fn fifo0(self) -> &'a mut W {
        self.variant(FAF17_A::FIFO0)
    }
    #[doc = "Filter associated with FIFO1"]
    #[inline(always)]
    pub fn fifo1(self) -> &'a mut W {
        self.variant(FAF17_A::FIFO1)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 17)) | ((value as u32 & 0x01) << 17);
        self.w
    }
}
#[doc = "Filter 18 associated FIFO"]
pub type FAF18_A = FAF0_A;
#[doc = "Field `FAF18` reader - Filter 18 associated FIFO"]
pub type FAF18_R = FAF0_R;
#[doc = "Field `FAF18` writer - Filter 18 associated FIFO"]
pub struct FAF18_W<'a> {
    w: &'a mut W,
}
impl<'a> FAF18_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FAF18_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter associated with FIFO0"]
    #[inline(always)]
    pub fn fifo0(self) -> &'a mut W {
        self.variant(FAF18_A::FIFO0)
    }
    #[doc = "Filter associated with FIFO1"]
    #[inline(always)]
    pub fn fifo1(self) -> &'a mut W {
        self.variant(FAF18_A::FIFO1)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 18)) | ((value as u32 & 0x01) << 18);
        self.w
    }
}
#[doc = "Filter 19 associated FIFO"]
pub type FAF19_A = FAF0_A;
#[doc = "Field `FAF19` reader - Filter 19 associated FIFO"]
pub type FAF19_R = FAF0_R;
#[doc = "Field `FAF19` writer - Filter 19 associated FIFO"]
pub struct FAF19_W<'a> {
    w: &'a mut W,
}
impl<'a> FAF19_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FAF19_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter associated with FIFO0"]
    #[inline(always)]
    pub fn fifo0(self) -> &'a mut W {
        self.variant(FAF19_A::FIFO0)
    }
    #[doc = "Filter associated with FIFO1"]
    #[inline(always)]
    pub fn fifo1(self) -> &'a mut W {
        self.variant(FAF19_A::FIFO1)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 19)) | ((value as u32 & 0x01) << 19);
        self.w
    }
}
#[doc = "Filter 20 associated FIFO"]
pub type FAF20_A = FAF0_A;
#[doc = "Field `FAF20` reader - Filter 20 associated FIFO"]
pub type FAF20_R = FAF0_R;
#[doc = "Field `FAF20` writer - Filter 20 associated FIFO"]
pub struct FAF20_W<'a> {
    w: &'a mut W,
}
impl<'a> FAF20_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FAF20_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter associated with FIFO0"]
    #[inline(always)]
    pub fn fifo0(self) -> &'a mut W {
        self.variant(FAF20_A::FIFO0)
    }
    #[doc = "Filter associated with FIFO1"]
    #[inline(always)]
    pub fn fifo1(self) -> &'a mut W {
        self.variant(FAF20_A::FIFO1)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 20)) | ((value as u32 & 0x01) << 20);
        self.w
    }
}
#[doc = "Filter 21 associated FIFO"]
pub type FAF21_A = FAF0_A;
#[doc = "Field `FAF21` reader - Filter 21 associated FIFO"]
pub type FAF21_R = FAF0_R;
#[doc = "Field `FAF21` writer - Filter 21 associated FIFO"]
pub struct FAF21_W<'a> {
    w: &'a mut W,
}
impl<'a> FAF21_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FAF21_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter associated with FIFO0"]
    #[inline(always)]
    pub fn fifo0(self) -> &'a mut W {
        self.variant(FAF21_A::FIFO0)
    }
    #[doc = "Filter associated with FIFO1"]
    #[inline(always)]
    pub fn fifo1(self) -> &'a mut W {
        self.variant(FAF21_A::FIFO1)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 21)) | ((value as u32 & 0x01) << 21);
        self.w
    }
}
#[doc = "Filter 22 associated FIFO"]
pub type FAF22_A = FAF0_A;
#[doc = "Field `FAF22` reader - Filter 22 associated FIFO"]
pub type FAF22_R = FAF0_R;
#[doc = "Field `FAF22` writer - Filter 22 associated FIFO"]
pub struct FAF22_W<'a> {
    w: &'a mut W,
}
impl<'a> FAF22_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FAF22_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter associated with FIFO0"]
    #[inline(always)]
    pub fn fifo0(self) -> &'a mut W {
        self.variant(FAF22_A::FIFO0)
    }
    #[doc = "Filter associated with FIFO1"]
    #[inline(always)]
    pub fn fifo1(self) -> &'a mut W {
        self.variant(FAF22_A::FIFO1)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 22)) | ((value as u32 & 0x01) << 22);
        self.w
    }
}
#[doc = "Filter 23 associated FIFO"]
pub type FAF23_A = FAF0_A;
#[doc = "Field `FAF23` reader - Filter 23 associated FIFO"]
pub type FAF23_R = FAF0_R;
#[doc = "Field `FAF23` writer - Filter 23 associated FIFO"]
pub struct FAF23_W<'a> {
    w: &'a mut W,
}
impl<'a> FAF23_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FAF23_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter associated with FIFO0"]
    #[inline(always)]
    pub fn fifo0(self) -> &'a mut W {
        self.variant(FAF23_A::FIFO0)
    }
    #[doc = "Filter associated with FIFO1"]
    #[inline(always)]
    pub fn fifo1(self) -> &'a mut W {
        self.variant(FAF23_A::FIFO1)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 23)) | ((value as u32 & 0x01) << 23);
        self.w
    }
}
#[doc = "Filter 24 associated FIFO"]
pub type FAF24_A = FAF0_A;
#[doc = "Field `FAF24` reader - Filter 24 associated FIFO"]
pub type FAF24_R = FAF0_R;
#[doc = "Field `FAF24` writer - Filter 24 associated FIFO"]
pub struct FAF24_W<'a> {
    w: &'a mut W,
}
impl<'a> FAF24_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FAF24_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter associated with FIFO0"]
    #[inline(always)]
    pub fn fifo0(self) -> &'a mut W {
        self.variant(FAF24_A::FIFO0)
    }
    #[doc = "Filter associated with FIFO1"]
    #[inline(always)]
    pub fn fifo1(self) -> &'a mut W {
        self.variant(FAF24_A::FIFO1)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 24)) | ((value as u32 & 0x01) << 24);
        self.w
    }
}
#[doc = "Filter 25 associated FIFO"]
pub type FAF25_A = FAF0_A;
#[doc = "Field `FAF25` reader - Filter 25 associated FIFO"]
pub type FAF25_R = FAF0_R;
#[doc = "Field `FAF25` writer - Filter 25 associated FIFO"]
pub struct FAF25_W<'a> {
    w: &'a mut W,
}
impl<'a> FAF25_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FAF25_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter associated with FIFO0"]
    #[inline(always)]
    pub fn fifo0(self) -> &'a mut W {
        self.variant(FAF25_A::FIFO0)
    }
    #[doc = "Filter associated with FIFO1"]
    #[inline(always)]
    pub fn fifo1(self) -> &'a mut W {
        self.variant(FAF25_A::FIFO1)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 25)) | ((value as u32 & 0x01) << 25);
        self.w
    }
}
#[doc = "Filter 26 associated FIFO"]
pub type FAF26_A = FAF0_A;
#[doc = "Field `FAF26` reader - Filter 26 associated FIFO"]
pub type FAF26_R = FAF0_R;
#[doc = "Field `FAF26` writer - Filter 26 associated FIFO"]
pub struct FAF26_W<'a> {
    w: &'a mut W,
}
impl<'a> FAF26_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FAF26_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter associated with FIFO0"]
    #[inline(always)]
    pub fn fifo0(self) -> &'a mut W {
        self.variant(FAF26_A::FIFO0)
    }
    #[doc = "Filter associated with FIFO1"]
    #[inline(always)]
    pub fn fifo1(self) -> &'a mut W {
        self.variant(FAF26_A::FIFO1)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 26)) | ((value as u32 & 0x01) << 26);
        self.w
    }
}
#[doc = "Filter 27 associated FIFO"]
pub type FAF27_A = FAF0_A;
#[doc = "Field `FAF27` reader - Filter 27 associated FIFO"]
pub type FAF27_R = FAF0_R;
#[doc = "Field `FAF27` writer - Filter 27 associated FIFO"]
pub struct FAF27_W<'a> {
    w: &'a mut W,
}
impl<'a> FAF27_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FAF27_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Filter associated with FIFO0"]
    #[inline(always)]
    pub fn fifo0(self) -> &'a mut W {
        self.variant(FAF27_A::FIFO0)
    }
    #[doc = "Filter associated with FIFO1"]
    #[inline(always)]
    pub fn fifo1(self) -> &'a mut W {
        self.variant(FAF27_A::FIFO1)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 27)) | ((value as u32 & 0x01) << 27);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Filter 0 associated FIFO"]
    #[inline(always)]
    pub fn faf0(&self) -> FAF0_R {
        FAF0_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Filter 1 associated FIFO"]
    #[inline(always)]
    pub fn faf1(&self) -> FAF1_R {
        FAF1_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Filter 2 associated FIFO"]
    #[inline(always)]
    pub fn faf2(&self) -> FAF2_R {
        FAF2_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Filter 3 associated FIFO"]
    #[inline(always)]
    pub fn faf3(&self) -> FAF3_R {
        FAF3_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Filter 4 associated FIFO"]
    #[inline(always)]
    pub fn faf4(&self) -> FAF4_R {
        FAF4_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Filter 5 associated FIFO"]
    #[inline(always)]
    pub fn faf5(&self) -> FAF5_R {
        FAF5_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Filter 6 associated FIFO"]
    #[inline(always)]
    pub fn faf6(&self) -> FAF6_R {
        FAF6_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Filter 7 associated FIFO"]
    #[inline(always)]
    pub fn faf7(&self) -> FAF7_R {
        FAF7_R::new(((self.bits >> 7) & 0x01) != 0)
    }
    #[doc = "Bit 8 - Filter 8 associated FIFO"]
    #[inline(always)]
    pub fn faf8(&self) -> FAF8_R {
        FAF8_R::new(((self.bits >> 8) & 0x01) != 0)
    }
    #[doc = "Bit 9 - Filter 9 associated FIFO"]
    #[inline(always)]
    pub fn faf9(&self) -> FAF9_R {
        FAF9_R::new(((self.bits >> 9) & 0x01) != 0)
    }
    #[doc = "Bit 10 - Filter 10 associated FIFO"]
    #[inline(always)]
    pub fn faf10(&self) -> FAF10_R {
        FAF10_R::new(((self.bits >> 10) & 0x01) != 0)
    }
    #[doc = "Bit 11 - Filter 11 associated FIFO"]
    #[inline(always)]
    pub fn faf11(&self) -> FAF11_R {
        FAF11_R::new(((self.bits >> 11) & 0x01) != 0)
    }
    #[doc = "Bit 12 - Filter 12 associated FIFO"]
    #[inline(always)]
    pub fn faf12(&self) -> FAF12_R {
        FAF12_R::new(((self.bits >> 12) & 0x01) != 0)
    }
    #[doc = "Bit 13 - Filter 13 associated FIFO"]
    #[inline(always)]
    pub fn faf13(&self) -> FAF13_R {
        FAF13_R::new(((self.bits >> 13) & 0x01) != 0)
    }
    #[doc = "Bit 14 - Filter 14 associated FIFO"]
    #[inline(always)]
    pub fn faf14(&self) -> FAF14_R {
        FAF14_R::new(((self.bits >> 14) & 0x01) != 0)
    }
    #[doc = "Bit 15 - Filter 15 associated FIFO"]
    #[inline(always)]
    pub fn faf15(&self) -> FAF15_R {
        FAF15_R::new(((self.bits >> 15) & 0x01) != 0)
    }
    #[doc = "Bit 16 - Filter 16 associated FIFO"]
    #[inline(always)]
    pub fn faf16(&self) -> FAF16_R {
        FAF16_R::new(((self.bits >> 16) & 0x01) != 0)
    }
    #[doc = "Bit 17 - Filter 17 associated FIFO"]
    #[inline(always)]
    pub fn faf17(&self) -> FAF17_R {
        FAF17_R::new(((self.bits >> 17) & 0x01) != 0)
    }
    #[doc = "Bit 18 - Filter 18 associated FIFO"]
    #[inline(always)]
    pub fn faf18(&self) -> FAF18_R {
        FAF18_R::new(((self.bits >> 18) & 0x01) != 0)
    }
    #[doc = "Bit 19 - Filter 19 associated FIFO"]
    #[inline(always)]
    pub fn faf19(&self) -> FAF19_R {
        FAF19_R::new(((self.bits >> 19) & 0x01) != 0)
    }
    #[doc = "Bit 20 - Filter 20 associated FIFO"]
    #[inline(always)]
    pub fn faf20(&self) -> FAF20_R {
        FAF20_R::new(((self.bits >> 20) & 0x01) != 0)
    }
    #[doc = "Bit 21 - Filter 21 associated FIFO"]
    #[inline(always)]
    pub fn faf21(&self) -> FAF21_R {
        FAF21_R::new(((self.bits >> 21) & 0x01) != 0)
    }
    #[doc = "Bit 22 - Filter 22 associated FIFO"]
    #[inline(always)]
    pub fn faf22(&self) -> FAF22_R {
        FAF22_R::new(((self.bits >> 22) & 0x01) != 0)
    }
    #[doc = "Bit 23 - Filter 23 associated FIFO"]
    #[inline(always)]
    pub fn faf23(&self) -> FAF23_R {
        FAF23_R::new(((self.bits >> 23) & 0x01) != 0)
    }
    #[doc = "Bit 24 - Filter 24 associated FIFO"]
    #[inline(always)]
    pub fn faf24(&self) -> FAF24_R {
        FAF24_R::new(((self.bits >> 24) & 0x01) != 0)
    }
    #[doc = "Bit 25 - Filter 25 associated FIFO"]
    #[inline(always)]
    pub fn faf25(&self) -> FAF25_R {
        FAF25_R::new(((self.bits >> 25) & 0x01) != 0)
    }
    #[doc = "Bit 26 - Filter 26 associated FIFO"]
    #[inline(always)]
    pub fn faf26(&self) -> FAF26_R {
        FAF26_R::new(((self.bits >> 26) & 0x01) != 0)
    }
    #[doc = "Bit 27 - Filter 27 associated FIFO"]
    #[inline(always)]
    pub fn faf27(&self) -> FAF27_R {
        FAF27_R::new(((self.bits >> 27) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Filter 0 associated FIFO"]
    #[inline(always)]
    pub fn faf0(&mut self) -> FAF0_W {
        FAF0_W { w: self }
    }
    #[doc = "Bit 1 - Filter 1 associated FIFO"]
    #[inline(always)]
    pub fn faf1(&mut self) -> FAF1_W {
        FAF1_W { w: self }
    }
    #[doc = "Bit 2 - Filter 2 associated FIFO"]
    #[inline(always)]
    pub fn faf2(&mut self) -> FAF2_W {
        FAF2_W { w: self }
    }
    #[doc = "Bit 3 - Filter 3 associated FIFO"]
    #[inline(always)]
    pub fn faf3(&mut self) -> FAF3_W {
        FAF3_W { w: self }
    }
    #[doc = "Bit 4 - Filter 4 associated FIFO"]
    #[inline(always)]
    pub fn faf4(&mut self) -> FAF4_W {
        FAF4_W { w: self }
    }
    #[doc = "Bit 5 - Filter 5 associated FIFO"]
    #[inline(always)]
    pub fn faf5(&mut self) -> FAF5_W {
        FAF5_W { w: self }
    }
    #[doc = "Bit 6 - Filter 6 associated FIFO"]
    #[inline(always)]
    pub fn faf6(&mut self) -> FAF6_W {
        FAF6_W { w: self }
    }
    #[doc = "Bit 7 - Filter 7 associated FIFO"]
    #[inline(always)]
    pub fn faf7(&mut self) -> FAF7_W {
        FAF7_W { w: self }
    }
    #[doc = "Bit 8 - Filter 8 associated FIFO"]
    #[inline(always)]
    pub fn faf8(&mut self) -> FAF8_W {
        FAF8_W { w: self }
    }
    #[doc = "Bit 9 - Filter 9 associated FIFO"]
    #[inline(always)]
    pub fn faf9(&mut self) -> FAF9_W {
        FAF9_W { w: self }
    }
    #[doc = "Bit 10 - Filter 10 associated FIFO"]
    #[inline(always)]
    pub fn faf10(&mut self) -> FAF10_W {
        FAF10_W { w: self }
    }
    #[doc = "Bit 11 - Filter 11 associated FIFO"]
    #[inline(always)]
    pub fn faf11(&mut self) -> FAF11_W {
        FAF11_W { w: self }
    }
    #[doc = "Bit 12 - Filter 12 associated FIFO"]
    #[inline(always)]
    pub fn faf12(&mut self) -> FAF12_W {
        FAF12_W { w: self }
    }
    #[doc = "Bit 13 - Filter 13 associated FIFO"]
    #[inline(always)]
    pub fn faf13(&mut self) -> FAF13_W {
        FAF13_W { w: self }
    }
    #[doc = "Bit 14 - Filter 14 associated FIFO"]
    #[inline(always)]
    pub fn faf14(&mut self) -> FAF14_W {
        FAF14_W { w: self }
    }
    #[doc = "Bit 15 - Filter 15 associated FIFO"]
    #[inline(always)]
    pub fn faf15(&mut self) -> FAF15_W {
        FAF15_W { w: self }
    }
    #[doc = "Bit 16 - Filter 16 associated FIFO"]
    #[inline(always)]
    pub fn faf16(&mut self) -> FAF16_W {
        FAF16_W { w: self }
    }
    #[doc = "Bit 17 - Filter 17 associated FIFO"]
    #[inline(always)]
    pub fn faf17(&mut self) -> FAF17_W {
        FAF17_W { w: self }
    }
    #[doc = "Bit 18 - Filter 18 associated FIFO"]
    #[inline(always)]
    pub fn faf18(&mut self) -> FAF18_W {
        FAF18_W { w: self }
    }
    #[doc = "Bit 19 - Filter 19 associated FIFO"]
    #[inline(always)]
    pub fn faf19(&mut self) -> FAF19_W {
        FAF19_W { w: self }
    }
    #[doc = "Bit 20 - Filter 20 associated FIFO"]
    #[inline(always)]
    pub fn faf20(&mut self) -> FAF20_W {
        FAF20_W { w: self }
    }
    #[doc = "Bit 21 - Filter 21 associated FIFO"]
    #[inline(always)]
    pub fn faf21(&mut self) -> FAF21_W {
        FAF21_W { w: self }
    }
    #[doc = "Bit 22 - Filter 22 associated FIFO"]
    #[inline(always)]
    pub fn faf22(&mut self) -> FAF22_W {
        FAF22_W { w: self }
    }
    #[doc = "Bit 23 - Filter 23 associated FIFO"]
    #[inline(always)]
    pub fn faf23(&mut self) -> FAF23_W {
        FAF23_W { w: self }
    }
    #[doc = "Bit 24 - Filter 24 associated FIFO"]
    #[inline(always)]
    pub fn faf24(&mut self) -> FAF24_W {
        FAF24_W { w: self }
    }
    #[doc = "Bit 25 - Filter 25 associated FIFO"]
    #[inline(always)]
    pub fn faf25(&mut self) -> FAF25_W {
        FAF25_W { w: self }
    }
    #[doc = "Bit 26 - Filter 26 associated FIFO"]
    #[inline(always)]
    pub fn faf26(&mut self) -> FAF26_W {
        FAF26_W { w: self }
    }
    #[doc = "Bit 27 - Filter 27 associated FIFO"]
    #[inline(always)]
    pub fn faf27(&mut self) -> FAF27_W {
        FAF27_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Filter associated FIFO register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [fafifo](index.html) module"]
pub struct FAFIFO_SPEC;
impl crate::RegisterSpec for FAFIFO_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [fafifo::R](R) reader structure"]
impl crate::Readable for FAFIFO_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [fafifo::W](W) writer structure"]
impl crate::Writable for FAFIFO_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets FAFIFO to value 0"]
impl crate::Resettable for FAFIFO_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
