#[doc = "Register `SEP3` reader"]
pub struct R(crate::R<SEP3_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<SEP3_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::convert::From<crate::R<SEP3_SPEC>> for R {
    fn from(reader: crate::R<SEP3_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `SEP3` writer"]
pub struct W(crate::W<SEP3_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<SEP3_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl core::convert::From<crate::W<SEP3_SPEC>> for W {
    fn from(writer: crate::W<SEP3_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `SUB_ST` reader - Successful Receive for LPM Token"]
pub struct SUB_ST_R(crate::FieldReader<bool, bool>);
impl SUB_ST_R {
    pub(crate) fn new(bits: bool) -> Self {
        SUB_ST_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SUB_ST_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SUB_ST` writer - Successful Receive for LPM Token"]
pub struct SUB_ST_W<'a> {
    w: &'a mut W,
}
impl<'a> SUB_ST_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 15)) | ((value as u16 & 0x01) << 15);
        self.w
    }
}
#[doc = "Field `SUB_STA` reader - Status bits, for the handshake of receiving subpid LPM"]
pub struct SUB_STA_R(crate::FieldReader<u8, u8>);
impl SUB_STA_R {
    pub(crate) fn new(bits: u8) -> Self {
        SUB_STA_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SUB_STA_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SUB_STA` writer - Status bits, for the handshake of receiving subpid LPM"]
pub struct SUB_STA_W<'a> {
    w: &'a mut W,
}
impl<'a> SUB_STA_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 12)) | ((value as u16 & 0x03) << 12);
        self.w
    }
}
#[doc = "Field `SUBPID_ATTR` reader - LPM Token bmAttribute Field."]
pub struct SUBPID_ATTR_R(crate::FieldReader<u16, u16>);
impl SUBPID_ATTR_R {
    pub(crate) fn new(bits: u16) -> Self {
        SUBPID_ATTR_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SUBPID_ATTR_R {
    type Target = crate::FieldReader<u16, u16>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SUBPID_ATTR` writer - LPM Token bmAttribute Field."]
pub struct SUBPID_ATTR_W<'a> {
    w: &'a mut W,
}
impl<'a> SUBPID_ATTR_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u16) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x07ff) | (value as u16 & 0x07ff);
        self.w
    }
}
impl R {
    #[doc = "Bit 15 - Successful Receive for LPM Token"]
    #[inline(always)]
    pub fn sub_st(&self) -> SUB_ST_R {
        SUB_ST_R::new(((self.bits >> 15) & 0x01) != 0)
    }
    #[doc = "Bits 12:13 - Status bits, for the handshake of receiving subpid LPM"]
    #[inline(always)]
    pub fn sub_sta(&self) -> SUB_STA_R {
        SUB_STA_R::new(((self.bits >> 12) & 0x03) as u8)
    }
    #[doc = "Bits 0:10 - LPM Token bmAttribute Field."]
    #[inline(always)]
    pub fn subpid_attr(&self) -> SUBPID_ATTR_R {
        SUBPID_ATTR_R::new((self.bits & 0x07ff) as u16)
    }
}
impl W {
    #[doc = "Bit 15 - Successful Receive for LPM Token"]
    #[inline(always)]
    pub fn sub_st(&mut self) -> SUB_ST_W {
        SUB_ST_W { w: self }
    }
    #[doc = "Bits 12:13 - Status bits, for the handshake of receiving subpid LPM"]
    #[inline(always)]
    pub fn sub_sta(&mut self) -> SUB_STA_W {
        SUB_STA_W { w: self }
    }
    #[doc = "Bits 0:10 - LPM Token bmAttribute Field."]
    #[inline(always)]
    pub fn subpid_attr(&mut self) -> SUBPID_ATTR_W {
        SUBPID_ATTR_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    pub unsafe fn bits(&mut self, bits: u16) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "USB sub-endpoint 3 register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [sep3](index.html) module"]
pub struct SEP3_SPEC;
impl crate::RegisterSpec for SEP3_SPEC {
    type Ux = u16;
}
#[doc = "`read()` method returns [sep3::R](R) reader structure"]
impl crate::Readable for SEP3_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [sep3::W](W) writer structure"]
impl crate::Writable for SEP3_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets SEP3 to value 0"]
impl crate::Resettable for SEP3_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
