#[doc = "Register `LPMCTL` reader"]
pub struct R(crate::R<LPMCTL_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<LPMCTL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::convert::From<crate::R<LPMCTL_SPEC>> for R {
    fn from(reader: crate::R<LPMCTL_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `LPMCTL` writer"]
pub struct W(crate::W<LPMCTL_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<LPMCTL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl core::convert::From<crate::W<LPMCTL_SPEC>> for W {
    fn from(writer: crate::W<LPMCTL_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `LPMSTIE` reader - LPM token successful transfer interrupt enable"]
pub struct LPMSTIE_R(crate::FieldReader<bool, bool>);
impl LPMSTIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        LPMSTIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LPMSTIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LPMSTIE` writer - LPM token successful transfer interrupt enable"]
pub struct LPMSTIE_W<'a> {
    w: &'a mut W,
}
impl<'a> LPMSTIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 15)) | ((value as u16 & 0x01) << 15);
        self.w
    }
}
impl R {
    #[doc = "Bit 15 - LPM token successful transfer interrupt enable"]
    #[inline(always)]
    pub fn lpmstie(&self) -> LPMSTIE_R {
        LPMSTIE_R::new(((self.bits >> 15) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 15 - LPM token successful transfer interrupt enable"]
    #[inline(always)]
    pub fn lpmstie(&mut self) -> LPMSTIE_W {
        LPMSTIE_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    pub unsafe fn bits(&mut self, bits: u16) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "USB LPM control register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [lpmctl](index.html) module"]
pub struct LPMCTL_SPEC;
impl crate::RegisterSpec for LPMCTL_SPEC {
    type Ux = u16;
}
#[doc = "`read()` method returns [lpmctl::R](R) reader structure"]
impl crate::Readable for LPMCTL_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [lpmctl::W](W) writer structure"]
impl crate::Writable for LPMCTL_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets LPMCTL to value 0"]
impl crate::Resettable for LPMCTL_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
