#[doc = "Register `GCTL` reader"]
pub struct R(crate::R<GCTL_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<GCTL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::convert::From<crate::R<GCTL_SPEC>> for R {
    fn from(reader: crate::R<GCTL_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `GCTL` writer"]
pub struct W(crate::W<GCTL_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<GCTL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl core::convert::From<crate::W<GCTL_SPEC>> for W {
    fn from(writer: crate::W<GCTL_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `GC5` reader - Analog I/O group 5 status"]
pub struct GC5_R(crate::FieldReader<bool, bool>);
impl GC5_R {
    pub(crate) fn new(bits: bool) -> Self {
        GC5_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for GC5_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `GC4` reader - Analog I/O group 4 status"]
pub struct GC4_R(crate::FieldReader<bool, bool>);
impl GC4_R {
    pub(crate) fn new(bits: bool) -> Self {
        GC4_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for GC4_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `GC3` reader - Analog I/O group 3 status"]
pub struct GC3_R(crate::FieldReader<bool, bool>);
impl GC3_R {
    pub(crate) fn new(bits: bool) -> Self {
        GC3_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for GC3_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `GC2` reader - Analog I/O group 2 status"]
pub struct GC2_R(crate::FieldReader<bool, bool>);
impl GC2_R {
    pub(crate) fn new(bits: bool) -> Self {
        GC2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for GC2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `GC1` reader - Analog I/O group 1 status"]
pub struct GC1_R(crate::FieldReader<bool, bool>);
impl GC1_R {
    pub(crate) fn new(bits: bool) -> Self {
        GC1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for GC1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `GC0` reader - Analog I/O group 0 status"]
pub struct GC0_R(crate::FieldReader<bool, bool>);
impl GC0_R {
    pub(crate) fn new(bits: bool) -> Self {
        GC0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for GC0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `GE5` reader - Analog I/O group 5 enable"]
pub struct GE5_R(crate::FieldReader<bool, bool>);
impl GE5_R {
    pub(crate) fn new(bits: bool) -> Self {
        GE5_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for GE5_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `GE5` writer - Analog I/O group 5 enable"]
pub struct GE5_W<'a> {
    w: &'a mut W,
}
impl<'a> GE5_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u32 & 0x01) << 5);
        self.w
    }
}
#[doc = "Field `GE4` reader - Analog I/O group 4 enable"]
pub struct GE4_R(crate::FieldReader<bool, bool>);
impl GE4_R {
    pub(crate) fn new(bits: bool) -> Self {
        GE4_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for GE4_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `GE4` writer - Analog I/O group 4 enable"]
pub struct GE4_W<'a> {
    w: &'a mut W,
}
impl<'a> GE4_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u32 & 0x01) << 4);
        self.w
    }
}
#[doc = "Field `GE3` reader - Analog I/O group 3 enable"]
pub struct GE3_R(crate::FieldReader<bool, bool>);
impl GE3_R {
    pub(crate) fn new(bits: bool) -> Self {
        GE3_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for GE3_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `GE3` writer - Analog I/O group 3 enable"]
pub struct GE3_W<'a> {
    w: &'a mut W,
}
impl<'a> GE3_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u32 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `GE2` reader - Analog I/O group 2 enable"]
pub struct GE2_R(crate::FieldReader<bool, bool>);
impl GE2_R {
    pub(crate) fn new(bits: bool) -> Self {
        GE2_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for GE2_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `GE2` writer - Analog I/O group 2 enable"]
pub struct GE2_W<'a> {
    w: &'a mut W,
}
impl<'a> GE2_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u32 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `GE1` reader - Analog I/O group 1 enable"]
pub struct GE1_R(crate::FieldReader<bool, bool>);
impl GE1_R {
    pub(crate) fn new(bits: bool) -> Self {
        GE1_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for GE1_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `GE1` writer - Analog I/O group 1 enable"]
pub struct GE1_W<'a> {
    w: &'a mut W,
}
impl<'a> GE1_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "Field `GE0` reader - Analog I/O group 0 enable"]
pub struct GE0_R(crate::FieldReader<bool, bool>);
impl GE0_R {
    pub(crate) fn new(bits: bool) -> Self {
        GE0_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for GE0_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `GE0` writer - Analog I/O group 0 enable"]
pub struct GE0_W<'a> {
    w: &'a mut W,
}
impl<'a> GE0_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
impl R {
    #[doc = "Bit 21 - Analog I/O group 5 status"]
    #[inline(always)]
    pub fn gc5(&self) -> GC5_R {
        GC5_R::new(((self.bits >> 21) & 0x01) != 0)
    }
    #[doc = "Bit 20 - Analog I/O group 4 status"]
    #[inline(always)]
    pub fn gc4(&self) -> GC4_R {
        GC4_R::new(((self.bits >> 20) & 0x01) != 0)
    }
    #[doc = "Bit 19 - Analog I/O group 3 status"]
    #[inline(always)]
    pub fn gc3(&self) -> GC3_R {
        GC3_R::new(((self.bits >> 19) & 0x01) != 0)
    }
    #[doc = "Bit 18 - Analog I/O group 2 status"]
    #[inline(always)]
    pub fn gc2(&self) -> GC2_R {
        GC2_R::new(((self.bits >> 18) & 0x01) != 0)
    }
    #[doc = "Bit 17 - Analog I/O group 1 status"]
    #[inline(always)]
    pub fn gc1(&self) -> GC1_R {
        GC1_R::new(((self.bits >> 17) & 0x01) != 0)
    }
    #[doc = "Bit 16 - Analog I/O group 0 status"]
    #[inline(always)]
    pub fn gc0(&self) -> GC0_R {
        GC0_R::new(((self.bits >> 16) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Analog I/O group 5 enable"]
    #[inline(always)]
    pub fn ge5(&self) -> GE5_R {
        GE5_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Analog I/O group 4 enable"]
    #[inline(always)]
    pub fn ge4(&self) -> GE4_R {
        GE4_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Analog I/O group 3 enable"]
    #[inline(always)]
    pub fn ge3(&self) -> GE3_R {
        GE3_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Analog I/O group 2 enable"]
    #[inline(always)]
    pub fn ge2(&self) -> GE2_R {
        GE2_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 1 - Analog I/O group 1 enable"]
    #[inline(always)]
    pub fn ge1(&self) -> GE1_R {
        GE1_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 0 - Analog I/O group 0 enable"]
    #[inline(always)]
    pub fn ge0(&self) -> GE0_R {
        GE0_R::new((self.bits & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 5 - Analog I/O group 5 enable"]
    #[inline(always)]
    pub fn ge5(&mut self) -> GE5_W {
        GE5_W { w: self }
    }
    #[doc = "Bit 4 - Analog I/O group 4 enable"]
    #[inline(always)]
    pub fn ge4(&mut self) -> GE4_W {
        GE4_W { w: self }
    }
    #[doc = "Bit 3 - Analog I/O group 3 enable"]
    #[inline(always)]
    pub fn ge3(&mut self) -> GE3_W {
        GE3_W { w: self }
    }
    #[doc = "Bit 2 - Analog I/O group 2 enable"]
    #[inline(always)]
    pub fn ge2(&mut self) -> GE2_W {
        GE2_W { w: self }
    }
    #[doc = "Bit 1 - Analog I/O group 1 enable"]
    #[inline(always)]
    pub fn ge1(&mut self) -> GE1_W {
        GE1_W { w: self }
    }
    #[doc = "Bit 0 - Analog I/O group 0 enable"]
    #[inline(always)]
    pub fn ge0(&mut self) -> GE0_W {
        GE0_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "I/O group control register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [gctl](index.html) module"]
pub struct GCTL_SPEC;
impl crate::RegisterSpec for GCTL_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [gctl::R](R) reader structure"]
impl crate::Readable for GCTL_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [gctl::W](W) writer structure"]
impl crate::Writable for GCTL_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets GCTL to value 0"]
impl crate::Resettable for GCTL_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
