#[doc = "Register `CHCTL2` reader"]
pub struct R(crate::R<CHCTL2_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<CHCTL2_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::convert::From<crate::R<CHCTL2_SPEC>> for R {
    fn from(reader: crate::R<CHCTL2_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `CHCTL2` writer"]
pub struct W(crate::W<CHCTL2_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<CHCTL2_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl core::convert::From<crate::W<CHCTL2_SPEC>> for W {
    fn from(writer: crate::W<CHCTL2_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Channel 3 polarity\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum CH3P_A {
    #[doc = "0: Channel is active high"]
    NOTINVERTED = 0,
    #[doc = "1: Channel is active low"]
    INVERTED = 1,
}
impl From<CH3P_A> for bool {
    #[inline(always)]
    fn from(variant: CH3P_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `CH3P` reader - Channel 3 polarity"]
pub struct CH3P_R(crate::FieldReader<bool, CH3P_A>);
impl CH3P_R {
    pub(crate) fn new(bits: bool) -> Self {
        CH3P_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> CH3P_A {
        match self.bits {
            false => CH3P_A::NOTINVERTED,
            true => CH3P_A::INVERTED,
        }
    }
    #[doc = "Checks if the value of the field is `NOTINVERTED`"]
    #[inline(always)]
    pub fn is_not_inverted(&self) -> bool {
        **self == CH3P_A::NOTINVERTED
    }
    #[doc = "Checks if the value of the field is `INVERTED`"]
    #[inline(always)]
    pub fn is_inverted(&self) -> bool {
        **self == CH3P_A::INVERTED
    }
}
impl core::ops::Deref for CH3P_R {
    type Target = crate::FieldReader<bool, CH3P_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CH3P` writer - Channel 3 polarity"]
pub struct CH3P_W<'a> {
    w: &'a mut W,
}
impl<'a> CH3P_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CH3P_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Channel is active high"]
    #[inline(always)]
    pub fn not_inverted(self) -> &'a mut W {
        self.variant(CH3P_A::NOTINVERTED)
    }
    #[doc = "Channel is active low"]
    #[inline(always)]
    pub fn inverted(self) -> &'a mut W {
        self.variant(CH3P_A::INVERTED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 13)) | ((value as u16 & 0x01) << 13);
        self.w
    }
}
#[doc = "Channel 3 enable\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum CH3EN_A {
    #[doc = "0: Channel output is disabled"]
    DISABLED = 0,
    #[doc = "1: Channel output is enabled"]
    ENABLED = 1,
}
impl From<CH3EN_A> for bool {
    #[inline(always)]
    fn from(variant: CH3EN_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `CH3EN` reader - Channel 3 enable"]
pub struct CH3EN_R(crate::FieldReader<bool, CH3EN_A>);
impl CH3EN_R {
    pub(crate) fn new(bits: bool) -> Self {
        CH3EN_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> CH3EN_A {
        match self.bits {
            false => CH3EN_A::DISABLED,
            true => CH3EN_A::ENABLED,
        }
    }
    #[doc = "Checks if the value of the field is `DISABLED`"]
    #[inline(always)]
    pub fn is_disabled(&self) -> bool {
        **self == CH3EN_A::DISABLED
    }
    #[doc = "Checks if the value of the field is `ENABLED`"]
    #[inline(always)]
    pub fn is_enabled(&self) -> bool {
        **self == CH3EN_A::ENABLED
    }
}
impl core::ops::Deref for CH3EN_R {
    type Target = crate::FieldReader<bool, CH3EN_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CH3EN` writer - Channel 3 enable"]
pub struct CH3EN_W<'a> {
    w: &'a mut W,
}
impl<'a> CH3EN_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CH3EN_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Channel output is disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(CH3EN_A::DISABLED)
    }
    #[doc = "Channel output is enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(CH3EN_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 12)) | ((value as u16 & 0x01) << 12);
        self.w
    }
}
#[doc = "Channel 2 complementary output polarity\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum CH2NP_A {
    #[doc = "0: Complementary channel is active high"]
    NOTINVERTED = 0,
    #[doc = "1: Complementary channel is active low"]
    INVERTED = 1,
}
impl From<CH2NP_A> for bool {
    #[inline(always)]
    fn from(variant: CH2NP_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `CH2NP` reader - Channel 2 complementary output polarity"]
pub struct CH2NP_R(crate::FieldReader<bool, CH2NP_A>);
impl CH2NP_R {
    pub(crate) fn new(bits: bool) -> Self {
        CH2NP_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> CH2NP_A {
        match self.bits {
            false => CH2NP_A::NOTINVERTED,
            true => CH2NP_A::INVERTED,
        }
    }
    #[doc = "Checks if the value of the field is `NOTINVERTED`"]
    #[inline(always)]
    pub fn is_not_inverted(&self) -> bool {
        **self == CH2NP_A::NOTINVERTED
    }
    #[doc = "Checks if the value of the field is `INVERTED`"]
    #[inline(always)]
    pub fn is_inverted(&self) -> bool {
        **self == CH2NP_A::INVERTED
    }
}
impl core::ops::Deref for CH2NP_R {
    type Target = crate::FieldReader<bool, CH2NP_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CH2NP` writer - Channel 2 complementary output polarity"]
pub struct CH2NP_W<'a> {
    w: &'a mut W,
}
impl<'a> CH2NP_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CH2NP_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Complementary channel is active high"]
    #[inline(always)]
    pub fn not_inverted(self) -> &'a mut W {
        self.variant(CH2NP_A::NOTINVERTED)
    }
    #[doc = "Complementary channel is active low"]
    #[inline(always)]
    pub fn inverted(self) -> &'a mut W {
        self.variant(CH2NP_A::INVERTED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 11)) | ((value as u16 & 0x01) << 11);
        self.w
    }
}
#[doc = "Channel 2 complementary output enable\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum CH2NEN_A {
    #[doc = "0: Channel complementary output is disabled"]
    DISABLED = 0,
    #[doc = "1: Channel complementary output is enabled"]
    ENABLED = 1,
}
impl From<CH2NEN_A> for bool {
    #[inline(always)]
    fn from(variant: CH2NEN_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `CH2NEN` reader - Channel 2 complementary output enable"]
pub struct CH2NEN_R(crate::FieldReader<bool, CH2NEN_A>);
impl CH2NEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        CH2NEN_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> CH2NEN_A {
        match self.bits {
            false => CH2NEN_A::DISABLED,
            true => CH2NEN_A::ENABLED,
        }
    }
    #[doc = "Checks if the value of the field is `DISABLED`"]
    #[inline(always)]
    pub fn is_disabled(&self) -> bool {
        **self == CH2NEN_A::DISABLED
    }
    #[doc = "Checks if the value of the field is `ENABLED`"]
    #[inline(always)]
    pub fn is_enabled(&self) -> bool {
        **self == CH2NEN_A::ENABLED
    }
}
impl core::ops::Deref for CH2NEN_R {
    type Target = crate::FieldReader<bool, CH2NEN_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CH2NEN` writer - Channel 2 complementary output enable"]
pub struct CH2NEN_W<'a> {
    w: &'a mut W,
}
impl<'a> CH2NEN_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CH2NEN_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Channel complementary output is disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(CH2NEN_A::DISABLED)
    }
    #[doc = "Channel complementary output is enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(CH2NEN_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 10)) | ((value as u16 & 0x01) << 10);
        self.w
    }
}
#[doc = "Channel 2 polarity"]
pub type CH2P_A = CH3P_A;
#[doc = "Field `CH2P` reader - Channel 2 polarity"]
pub type CH2P_R = CH3P_R;
#[doc = "Field `CH2P` writer - Channel 2 polarity"]
pub struct CH2P_W<'a> {
    w: &'a mut W,
}
impl<'a> CH2P_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CH2P_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Channel is active high"]
    #[inline(always)]
    pub fn not_inverted(self) -> &'a mut W {
        self.variant(CH2P_A::NOTINVERTED)
    }
    #[doc = "Channel is active low"]
    #[inline(always)]
    pub fn inverted(self) -> &'a mut W {
        self.variant(CH2P_A::INVERTED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 9)) | ((value as u16 & 0x01) << 9);
        self.w
    }
}
#[doc = "Channel 2 enable"]
pub type CH2EN_A = CH3EN_A;
#[doc = "Field `CH2EN` reader - Channel 2 enable"]
pub type CH2EN_R = CH3EN_R;
#[doc = "Field `CH2EN` writer - Channel 2 enable"]
pub struct CH2EN_W<'a> {
    w: &'a mut W,
}
impl<'a> CH2EN_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CH2EN_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Channel output is disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(CH2EN_A::DISABLED)
    }
    #[doc = "Channel output is enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(CH2EN_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 8)) | ((value as u16 & 0x01) << 8);
        self.w
    }
}
#[doc = "Channel 1 complementary output polarity"]
pub type CH1NP_A = CH2NP_A;
#[doc = "Field `CH1NP` reader - Channel 1 complementary output polarity"]
pub type CH1NP_R = CH2NP_R;
#[doc = "Field `CH1NP` writer - Channel 1 complementary output polarity"]
pub struct CH1NP_W<'a> {
    w: &'a mut W,
}
impl<'a> CH1NP_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CH1NP_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Complementary channel is active high"]
    #[inline(always)]
    pub fn not_inverted(self) -> &'a mut W {
        self.variant(CH1NP_A::NOTINVERTED)
    }
    #[doc = "Complementary channel is active low"]
    #[inline(always)]
    pub fn inverted(self) -> &'a mut W {
        self.variant(CH1NP_A::INVERTED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u16 & 0x01) << 7);
        self.w
    }
}
#[doc = "Channel 1 complementary output enable"]
pub type CH1NEN_A = CH2NEN_A;
#[doc = "Field `CH1NEN` reader - Channel 1 complementary output enable"]
pub type CH1NEN_R = CH2NEN_R;
#[doc = "Field `CH1NEN` writer - Channel 1 complementary output enable"]
pub struct CH1NEN_W<'a> {
    w: &'a mut W,
}
impl<'a> CH1NEN_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CH1NEN_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Channel complementary output is disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(CH1NEN_A::DISABLED)
    }
    #[doc = "Channel complementary output is enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(CH1NEN_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u16 & 0x01) << 6);
        self.w
    }
}
#[doc = "Channel 1 polarity"]
pub type CH1P_A = CH3P_A;
#[doc = "Field `CH1P` reader - Channel 1 polarity"]
pub type CH1P_R = CH3P_R;
#[doc = "Field `CH1P` writer - Channel 1 polarity"]
pub struct CH1P_W<'a> {
    w: &'a mut W,
}
impl<'a> CH1P_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CH1P_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Channel is active high"]
    #[inline(always)]
    pub fn not_inverted(self) -> &'a mut W {
        self.variant(CH1P_A::NOTINVERTED)
    }
    #[doc = "Channel is active low"]
    #[inline(always)]
    pub fn inverted(self) -> &'a mut W {
        self.variant(CH1P_A::INVERTED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u16 & 0x01) << 5);
        self.w
    }
}
#[doc = "Channel 1 enable"]
pub type CH1EN_A = CH3EN_A;
#[doc = "Field `CH1EN` reader - Channel 1 enable"]
pub type CH1EN_R = CH3EN_R;
#[doc = "Field `CH1EN` writer - Channel 1 enable"]
pub struct CH1EN_W<'a> {
    w: &'a mut W,
}
impl<'a> CH1EN_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CH1EN_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Channel output is disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(CH1EN_A::DISABLED)
    }
    #[doc = "Channel output is enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(CH1EN_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u16 & 0x01) << 4);
        self.w
    }
}
#[doc = "Channel 0 complementary output polarity"]
pub type CH0NP_A = CH2NP_A;
#[doc = "Field `CH0NP` reader - Channel 0 complementary output polarity"]
pub type CH0NP_R = CH2NP_R;
#[doc = "Field `CH0NP` writer - Channel 0 complementary output polarity"]
pub struct CH0NP_W<'a> {
    w: &'a mut W,
}
impl<'a> CH0NP_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CH0NP_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Complementary channel is active high"]
    #[inline(always)]
    pub fn not_inverted(self) -> &'a mut W {
        self.variant(CH0NP_A::NOTINVERTED)
    }
    #[doc = "Complementary channel is active low"]
    #[inline(always)]
    pub fn inverted(self) -> &'a mut W {
        self.variant(CH0NP_A::INVERTED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u16 & 0x01) << 3);
        self.w
    }
}
#[doc = "Channel 0 complementary output enable"]
pub type CH0NEN_A = CH2NEN_A;
#[doc = "Field `CH0NEN` reader - Channel 0 complementary output enable"]
pub type CH0NEN_R = CH2NEN_R;
#[doc = "Field `CH0NEN` writer - Channel 0 complementary output enable"]
pub struct CH0NEN_W<'a> {
    w: &'a mut W,
}
impl<'a> CH0NEN_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CH0NEN_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Channel complementary output is disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(CH0NEN_A::DISABLED)
    }
    #[doc = "Channel complementary output is enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(CH0NEN_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u16 & 0x01) << 2);
        self.w
    }
}
#[doc = "Channel 0 polarity"]
pub type CH0P_A = CH3P_A;
#[doc = "Field `CH0P` reader - Channel 0 polarity"]
pub type CH0P_R = CH3P_R;
#[doc = "Field `CH0P` writer - Channel 0 polarity"]
pub struct CH0P_W<'a> {
    w: &'a mut W,
}
impl<'a> CH0P_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CH0P_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Channel is active high"]
    #[inline(always)]
    pub fn not_inverted(self) -> &'a mut W {
        self.variant(CH0P_A::NOTINVERTED)
    }
    #[doc = "Channel is active low"]
    #[inline(always)]
    pub fn inverted(self) -> &'a mut W {
        self.variant(CH0P_A::INVERTED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u16 & 0x01) << 1);
        self.w
    }
}
#[doc = "Channel 0 enable"]
pub type CH0EN_A = CH3EN_A;
#[doc = "Field `CH0EN` reader - Channel 0 enable"]
pub type CH0EN_R = CH3EN_R;
#[doc = "Field `CH0EN` writer - Channel 0 enable"]
pub struct CH0EN_W<'a> {
    w: &'a mut W,
}
impl<'a> CH0EN_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: CH0EN_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Channel output is disabled"]
    #[inline(always)]
    pub fn disabled(self) -> &'a mut W {
        self.variant(CH0EN_A::DISABLED)
    }
    #[doc = "Channel output is enabled"]
    #[inline(always)]
    pub fn enabled(self) -> &'a mut W {
        self.variant(CH0EN_A::ENABLED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u16 & 0x01);
        self.w
    }
}
impl R {
    #[doc = "Bit 13 - Channel 3 polarity"]
    #[inline(always)]
    pub fn ch3p(&self) -> CH3P_R {
        CH3P_R::new(((self.bits >> 13) & 0x01) != 0)
    }
    #[doc = "Bit 12 - Channel 3 enable"]
    #[inline(always)]
    pub fn ch3en(&self) -> CH3EN_R {
        CH3EN_R::new(((self.bits >> 12) & 0x01) != 0)
    }
    #[doc = "Bit 11 - Channel 2 complementary output polarity"]
    #[inline(always)]
    pub fn ch2np(&self) -> CH2NP_R {
        CH2NP_R::new(((self.bits >> 11) & 0x01) != 0)
    }
    #[doc = "Bit 10 - Channel 2 complementary output enable"]
    #[inline(always)]
    pub fn ch2nen(&self) -> CH2NEN_R {
        CH2NEN_R::new(((self.bits >> 10) & 0x01) != 0)
    }
    #[doc = "Bit 9 - Channel 2 polarity"]
    #[inline(always)]
    pub fn ch2p(&self) -> CH2P_R {
        CH2P_R::new(((self.bits >> 9) & 0x01) != 0)
    }
    #[doc = "Bit 8 - Channel 2 enable"]
    #[inline(always)]
    pub fn ch2en(&self) -> CH2EN_R {
        CH2EN_R::new(((self.bits >> 8) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Channel 1 complementary output polarity"]
    #[inline(always)]
    pub fn ch1np(&self) -> CH1NP_R {
        CH1NP_R::new(((self.bits >> 7) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Channel 1 complementary output enable"]
    #[inline(always)]
    pub fn ch1nen(&self) -> CH1NEN_R {
        CH1NEN_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Channel 1 polarity"]
    #[inline(always)]
    pub fn ch1p(&self) -> CH1P_R {
        CH1P_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Channel 1 enable"]
    #[inline(always)]
    pub fn ch1en(&self) -> CH1EN_R {
        CH1EN_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Channel 0 complementary output polarity"]
    #[inline(always)]
    pub fn ch0np(&self) -> CH0NP_R {
        CH0NP_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Channel 0 complementary output enable"]
    #[inline(always)]
    pub fn ch0nen(&self) -> CH0NEN_R {
        CH0NEN_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 1 - Channel 0 polarity"]
    #[inline(always)]
    pub fn ch0p(&self) -> CH0P_R {
        CH0P_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 0 - Channel 0 enable"]
    #[inline(always)]
    pub fn ch0en(&self) -> CH0EN_R {
        CH0EN_R::new((self.bits & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 13 - Channel 3 polarity"]
    #[inline(always)]
    pub fn ch3p(&mut self) -> CH3P_W {
        CH3P_W { w: self }
    }
    #[doc = "Bit 12 - Channel 3 enable"]
    #[inline(always)]
    pub fn ch3en(&mut self) -> CH3EN_W {
        CH3EN_W { w: self }
    }
    #[doc = "Bit 11 - Channel 2 complementary output polarity"]
    #[inline(always)]
    pub fn ch2np(&mut self) -> CH2NP_W {
        CH2NP_W { w: self }
    }
    #[doc = "Bit 10 - Channel 2 complementary output enable"]
    #[inline(always)]
    pub fn ch2nen(&mut self) -> CH2NEN_W {
        CH2NEN_W { w: self }
    }
    #[doc = "Bit 9 - Channel 2 polarity"]
    #[inline(always)]
    pub fn ch2p(&mut self) -> CH2P_W {
        CH2P_W { w: self }
    }
    #[doc = "Bit 8 - Channel 2 enable"]
    #[inline(always)]
    pub fn ch2en(&mut self) -> CH2EN_W {
        CH2EN_W { w: self }
    }
    #[doc = "Bit 7 - Channel 1 complementary output polarity"]
    #[inline(always)]
    pub fn ch1np(&mut self) -> CH1NP_W {
        CH1NP_W { w: self }
    }
    #[doc = "Bit 6 - Channel 1 complementary output enable"]
    #[inline(always)]
    pub fn ch1nen(&mut self) -> CH1NEN_W {
        CH1NEN_W { w: self }
    }
    #[doc = "Bit 5 - Channel 1 polarity"]
    #[inline(always)]
    pub fn ch1p(&mut self) -> CH1P_W {
        CH1P_W { w: self }
    }
    #[doc = "Bit 4 - Channel 1 enable"]
    #[inline(always)]
    pub fn ch1en(&mut self) -> CH1EN_W {
        CH1EN_W { w: self }
    }
    #[doc = "Bit 3 - Channel 0 complementary output polarity"]
    #[inline(always)]
    pub fn ch0np(&mut self) -> CH0NP_W {
        CH0NP_W { w: self }
    }
    #[doc = "Bit 2 - Channel 0 complementary output enable"]
    #[inline(always)]
    pub fn ch0nen(&mut self) -> CH0NEN_W {
        CH0NEN_W { w: self }
    }
    #[doc = "Bit 1 - Channel 0 polarity"]
    #[inline(always)]
    pub fn ch0p(&mut self) -> CH0P_W {
        CH0P_W { w: self }
    }
    #[doc = "Bit 0 - Channel 0 enable"]
    #[inline(always)]
    pub fn ch0en(&mut self) -> CH0EN_W {
        CH0EN_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    pub unsafe fn bits(&mut self, bits: u16) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Channel control register 2\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [chctl2](index.html) module"]
pub struct CHCTL2_SPEC;
impl crate::RegisterSpec for CHCTL2_SPEC {
    type Ux = u16;
}
#[doc = "`read()` method returns [chctl2::R](R) reader structure"]
impl crate::Readable for CHCTL2_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [chctl2::W](W) writer structure"]
impl crate::Writable for CHCTL2_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets CHCTL2 to value 0"]
impl crate::Resettable for CHCTL2_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
