#[doc = "Register `INTC` writer"]
pub struct W(crate::W<INTC_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<INTC_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl core::convert::From<crate::W<INTC_SPEC>> for W {
    fn from(writer: crate::W<INTC_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Clear global interrupt flag of channel 0\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum GIC0_AW {
    #[doc = "1: Clears the GIF flag in INTF"]
    CLEAR = 1,
}
impl From<GIC0_AW> for bool {
    #[inline(always)]
    fn from(variant: GIC0_AW) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `GIC0` writer - Clear global interrupt flag of channel 0"]
pub struct GIC0_W<'a> {
    w: &'a mut W,
}
impl<'a> GIC0_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: GIC0_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Clears the GIF flag in INTF"]
    #[inline(always)]
    pub fn clear(self) -> &'a mut W {
        self.variant(GIC0_AW::CLEAR)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
#[doc = "Clear global interrupt flag of channel 1"]
pub type GIC1_AW = GIC0_AW;
#[doc = "Field `GIC1` writer - Clear global interrupt flag of channel 1"]
pub struct GIC1_W<'a> {
    w: &'a mut W,
}
impl<'a> GIC1_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: GIC1_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Clears the GIF flag in INTF"]
    #[inline(always)]
    pub fn clear(self) -> &'a mut W {
        self.variant(GIC1_AW::CLEAR)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u32 & 0x01) << 4);
        self.w
    }
}
#[doc = "Clear global interrupt flag of channel 2"]
pub type GIC2_AW = GIC0_AW;
#[doc = "Field `GIC2` writer - Clear global interrupt flag of channel 2"]
pub struct GIC2_W<'a> {
    w: &'a mut W,
}
impl<'a> GIC2_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: GIC2_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Clears the GIF flag in INTF"]
    #[inline(always)]
    pub fn clear(self) -> &'a mut W {
        self.variant(GIC2_AW::CLEAR)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 8)) | ((value as u32 & 0x01) << 8);
        self.w
    }
}
#[doc = "Clear global interrupt flag of channel 3"]
pub type GIC3_AW = GIC0_AW;
#[doc = "Field `GIC3` writer - Clear global interrupt flag of channel 3"]
pub struct GIC3_W<'a> {
    w: &'a mut W,
}
impl<'a> GIC3_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: GIC3_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Clears the GIF flag in INTF"]
    #[inline(always)]
    pub fn clear(self) -> &'a mut W {
        self.variant(GIC3_AW::CLEAR)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 12)) | ((value as u32 & 0x01) << 12);
        self.w
    }
}
#[doc = "Clear global interrupt flag of channel 4"]
pub type GIC4_AW = GIC0_AW;
#[doc = "Field `GIC4` writer - Clear global interrupt flag of channel 4"]
pub struct GIC4_W<'a> {
    w: &'a mut W,
}
impl<'a> GIC4_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: GIC4_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Clears the GIF flag in INTF"]
    #[inline(always)]
    pub fn clear(self) -> &'a mut W {
        self.variant(GIC4_AW::CLEAR)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 16)) | ((value as u32 & 0x01) << 16);
        self.w
    }
}
#[doc = "Clear global interrupt flag of channel 5"]
pub type GIC5_AW = GIC0_AW;
#[doc = "Field `GIC5` writer - Clear global interrupt flag of channel 5"]
pub struct GIC5_W<'a> {
    w: &'a mut W,
}
impl<'a> GIC5_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: GIC5_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Clears the GIF flag in INTF"]
    #[inline(always)]
    pub fn clear(self) -> &'a mut W {
        self.variant(GIC5_AW::CLEAR)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 20)) | ((value as u32 & 0x01) << 20);
        self.w
    }
}
#[doc = "Clear global interrupt flag of channel 6"]
pub type GIC6_AW = GIC0_AW;
#[doc = "Field `GIC6` writer - Clear global interrupt flag of channel 6"]
pub struct GIC6_W<'a> {
    w: &'a mut W,
}
impl<'a> GIC6_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: GIC6_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Clears the GIF flag in INTF"]
    #[inline(always)]
    pub fn clear(self) -> &'a mut W {
        self.variant(GIC6_AW::CLEAR)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 24)) | ((value as u32 & 0x01) << 24);
        self.w
    }
}
#[doc = "Clear bit for Full transfer finish flag of channel 0\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum FTFIFC0_AW {
    #[doc = "1: Clears the FDFIF flag in INTF"]
    CLEAR = 1,
}
impl From<FTFIFC0_AW> for bool {
    #[inline(always)]
    fn from(variant: FTFIFC0_AW) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `FTFIFC0` writer - Clear bit for Full transfer finish flag of channel 0"]
pub struct FTFIFC0_W<'a> {
    w: &'a mut W,
}
impl<'a> FTFIFC0_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FTFIFC0_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Clears the FDFIF flag in INTF"]
    #[inline(always)]
    pub fn clear(self) -> &'a mut W {
        self.variant(FTFIFC0_AW::CLEAR)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "Clear bit for Full transfer finish flag of channel 1"]
pub type FTFIFC1_AW = FTFIFC0_AW;
#[doc = "Field `FTFIFC1` writer - Clear bit for Full transfer finish flag of channel 1"]
pub struct FTFIFC1_W<'a> {
    w: &'a mut W,
}
impl<'a> FTFIFC1_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FTFIFC1_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Clears the FDFIF flag in INTF"]
    #[inline(always)]
    pub fn clear(self) -> &'a mut W {
        self.variant(FTFIFC1_AW::CLEAR)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u32 & 0x01) << 5);
        self.w
    }
}
#[doc = "Clear bit for Full transfer finish flag of channel 2"]
pub type FTFIFC2_AW = FTFIFC0_AW;
#[doc = "Field `FTFIFC2` writer - Clear bit for Full transfer finish flag of channel 2"]
pub struct FTFIFC2_W<'a> {
    w: &'a mut W,
}
impl<'a> FTFIFC2_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FTFIFC2_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Clears the FDFIF flag in INTF"]
    #[inline(always)]
    pub fn clear(self) -> &'a mut W {
        self.variant(FTFIFC2_AW::CLEAR)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 9)) | ((value as u32 & 0x01) << 9);
        self.w
    }
}
#[doc = "Clear bit for Full transfer finish flag of channel 3"]
pub type FTFIFC3_AW = FTFIFC0_AW;
#[doc = "Field `FTFIFC3` writer - Clear bit for Full transfer finish flag of channel 3"]
pub struct FTFIFC3_W<'a> {
    w: &'a mut W,
}
impl<'a> FTFIFC3_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FTFIFC3_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Clears the FDFIF flag in INTF"]
    #[inline(always)]
    pub fn clear(self) -> &'a mut W {
        self.variant(FTFIFC3_AW::CLEAR)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 13)) | ((value as u32 & 0x01) << 13);
        self.w
    }
}
#[doc = "Clear bit for Full transfer finish flag of channel 4"]
pub type FTFIFC4_AW = FTFIFC0_AW;
#[doc = "Field `FTFIFC4` writer - Clear bit for Full transfer finish flag of channel 4"]
pub struct FTFIFC4_W<'a> {
    w: &'a mut W,
}
impl<'a> FTFIFC4_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FTFIFC4_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Clears the FDFIF flag in INTF"]
    #[inline(always)]
    pub fn clear(self) -> &'a mut W {
        self.variant(FTFIFC4_AW::CLEAR)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 17)) | ((value as u32 & 0x01) << 17);
        self.w
    }
}
#[doc = "Clear bit for Full transfer finish flag of channel 5"]
pub type FTFIFC5_AW = FTFIFC0_AW;
#[doc = "Field `FTFIFC5` writer - Clear bit for Full transfer finish flag of channel 5"]
pub struct FTFIFC5_W<'a> {
    w: &'a mut W,
}
impl<'a> FTFIFC5_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FTFIFC5_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Clears the FDFIF flag in INTF"]
    #[inline(always)]
    pub fn clear(self) -> &'a mut W {
        self.variant(FTFIFC5_AW::CLEAR)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 21)) | ((value as u32 & 0x01) << 21);
        self.w
    }
}
#[doc = "Clear bit for Full transfer finish flag of channel 6"]
pub type FTFIFC6_AW = FTFIFC0_AW;
#[doc = "Field `FTFIFC6` writer - Clear bit for Full transfer finish flag of channel 6"]
pub struct FTFIFC6_W<'a> {
    w: &'a mut W,
}
impl<'a> FTFIFC6_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FTFIFC6_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Clears the FDFIF flag in INTF"]
    #[inline(always)]
    pub fn clear(self) -> &'a mut W {
        self.variant(FTFIFC6_AW::CLEAR)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 25)) | ((value as u32 & 0x01) << 25);
        self.w
    }
}
#[doc = "Clear bit for half transfer finish flag of channel 0\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum HTFIFC0_AW {
    #[doc = "1: Clears the HTFIF flag in INTF"]
    CLEAR = 1,
}
impl From<HTFIFC0_AW> for bool {
    #[inline(always)]
    fn from(variant: HTFIFC0_AW) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `HTFIFC0` writer - Clear bit for half transfer finish flag of channel 0"]
pub struct HTFIFC0_W<'a> {
    w: &'a mut W,
}
impl<'a> HTFIFC0_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: HTFIFC0_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Clears the HTFIF flag in INTF"]
    #[inline(always)]
    pub fn clear(self) -> &'a mut W {
        self.variant(HTFIFC0_AW::CLEAR)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u32 & 0x01) << 2);
        self.w
    }
}
#[doc = "Clear bit for half transfer finish flag of channel 1"]
pub type HTFIFC1_AW = HTFIFC0_AW;
#[doc = "Field `HTFIFC1` writer - Clear bit for half transfer finish flag of channel 1"]
pub struct HTFIFC1_W<'a> {
    w: &'a mut W,
}
impl<'a> HTFIFC1_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: HTFIFC1_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Clears the HTFIF flag in INTF"]
    #[inline(always)]
    pub fn clear(self) -> &'a mut W {
        self.variant(HTFIFC1_AW::CLEAR)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u32 & 0x01) << 6);
        self.w
    }
}
#[doc = "Clear bit for half transfer finish flag of channel 2"]
pub type HTFIFC2_AW = HTFIFC0_AW;
#[doc = "Field `HTFIFC2` writer - Clear bit for half transfer finish flag of channel 2"]
pub struct HTFIFC2_W<'a> {
    w: &'a mut W,
}
impl<'a> HTFIFC2_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: HTFIFC2_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Clears the HTFIF flag in INTF"]
    #[inline(always)]
    pub fn clear(self) -> &'a mut W {
        self.variant(HTFIFC2_AW::CLEAR)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 10)) | ((value as u32 & 0x01) << 10);
        self.w
    }
}
#[doc = "Clear bit for half transfer finish flag of channel 3"]
pub type HTFIFC3_AW = HTFIFC0_AW;
#[doc = "Field `HTFIFC3` writer - Clear bit for half transfer finish flag of channel 3"]
pub struct HTFIFC3_W<'a> {
    w: &'a mut W,
}
impl<'a> HTFIFC3_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: HTFIFC3_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Clears the HTFIF flag in INTF"]
    #[inline(always)]
    pub fn clear(self) -> &'a mut W {
        self.variant(HTFIFC3_AW::CLEAR)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 14)) | ((value as u32 & 0x01) << 14);
        self.w
    }
}
#[doc = "Clear bit for half transfer finish flag of channel 4"]
pub type HTFIFC4_AW = HTFIFC0_AW;
#[doc = "Field `HTFIFC4` writer - Clear bit for half transfer finish flag of channel 4"]
pub struct HTFIFC4_W<'a> {
    w: &'a mut W,
}
impl<'a> HTFIFC4_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: HTFIFC4_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Clears the HTFIF flag in INTF"]
    #[inline(always)]
    pub fn clear(self) -> &'a mut W {
        self.variant(HTFIFC4_AW::CLEAR)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 18)) | ((value as u32 & 0x01) << 18);
        self.w
    }
}
#[doc = "Clear bit for half transfer finish flag of channel 5"]
pub type HTFIFC5_AW = HTFIFC0_AW;
#[doc = "Field `HTFIFC5` writer - Clear bit for half transfer finish flag of channel 5"]
pub struct HTFIFC5_W<'a> {
    w: &'a mut W,
}
impl<'a> HTFIFC5_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: HTFIFC5_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Clears the HTFIF flag in INTF"]
    #[inline(always)]
    pub fn clear(self) -> &'a mut W {
        self.variant(HTFIFC5_AW::CLEAR)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 22)) | ((value as u32 & 0x01) << 22);
        self.w
    }
}
#[doc = "Clear bit for half transfer finish flag of channel 6"]
pub type HTFIFC6_AW = HTFIFC0_AW;
#[doc = "Field `HTFIFC6` writer - Clear bit for half transfer finish flag of channel 6"]
pub struct HTFIFC6_W<'a> {
    w: &'a mut W,
}
impl<'a> HTFIFC6_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: HTFIFC6_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Clears the HTFIF flag in INTF"]
    #[inline(always)]
    pub fn clear(self) -> &'a mut W {
        self.variant(HTFIFC6_AW::CLEAR)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 26)) | ((value as u32 & 0x01) << 26);
        self.w
    }
}
#[doc = "Clear bit for transfer access error flag of channel 0\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum TAEIFC0_AW {
    #[doc = "1: Clears the ERRIF flag in INTF"]
    CLEAR = 1,
}
impl From<TAEIFC0_AW> for bool {
    #[inline(always)]
    fn from(variant: TAEIFC0_AW) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `TAEIFC0` writer - Clear bit for transfer access error flag of channel 0"]
pub struct TAEIFC0_W<'a> {
    w: &'a mut W,
}
impl<'a> TAEIFC0_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: TAEIFC0_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Clears the ERRIF flag in INTF"]
    #[inline(always)]
    pub fn clear(self) -> &'a mut W {
        self.variant(TAEIFC0_AW::CLEAR)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u32 & 0x01) << 3);
        self.w
    }
}
#[doc = "Clear bit for transfer access error flag of channel 1"]
pub type TAEIFC1_AW = TAEIFC0_AW;
#[doc = "Field `TAEIFC1` writer - Clear bit for transfer access error flag of channel 1"]
pub struct TAEIFC1_W<'a> {
    w: &'a mut W,
}
impl<'a> TAEIFC1_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: TAEIFC1_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Clears the ERRIF flag in INTF"]
    #[inline(always)]
    pub fn clear(self) -> &'a mut W {
        self.variant(TAEIFC1_AW::CLEAR)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u32 & 0x01) << 7);
        self.w
    }
}
#[doc = "Clear bit for transfer access error flag of channel 2"]
pub type TAEIFC2_AW = TAEIFC0_AW;
#[doc = "Field `TAEIFC2` writer - Clear bit for transfer access error flag of channel 2"]
pub struct TAEIFC2_W<'a> {
    w: &'a mut W,
}
impl<'a> TAEIFC2_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: TAEIFC2_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Clears the ERRIF flag in INTF"]
    #[inline(always)]
    pub fn clear(self) -> &'a mut W {
        self.variant(TAEIFC2_AW::CLEAR)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 11)) | ((value as u32 & 0x01) << 11);
        self.w
    }
}
#[doc = "Clear bit for transfer access error flag of channel 3"]
pub type TAEIFC3_AW = TAEIFC0_AW;
#[doc = "Field `TAEIFC3` writer - Clear bit for transfer access error flag of channel 3"]
pub struct TAEIFC3_W<'a> {
    w: &'a mut W,
}
impl<'a> TAEIFC3_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: TAEIFC3_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Clears the ERRIF flag in INTF"]
    #[inline(always)]
    pub fn clear(self) -> &'a mut W {
        self.variant(TAEIFC3_AW::CLEAR)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 15)) | ((value as u32 & 0x01) << 15);
        self.w
    }
}
#[doc = "Clear bit for transfer access error flag of channel 4"]
pub type TAEIFC4_AW = TAEIFC0_AW;
#[doc = "Field `TAEIFC4` writer - Clear bit for transfer access error flag of channel 4"]
pub struct TAEIFC4_W<'a> {
    w: &'a mut W,
}
impl<'a> TAEIFC4_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: TAEIFC4_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Clears the ERRIF flag in INTF"]
    #[inline(always)]
    pub fn clear(self) -> &'a mut W {
        self.variant(TAEIFC4_AW::CLEAR)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 19)) | ((value as u32 & 0x01) << 19);
        self.w
    }
}
#[doc = "Clear bit for transfer access error flag of channel 5"]
pub type TAEIFC5_AW = TAEIFC0_AW;
#[doc = "Field `TAEIFC5` writer - Clear bit for transfer access error flag of channel 5"]
pub struct TAEIFC5_W<'a> {
    w: &'a mut W,
}
impl<'a> TAEIFC5_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: TAEIFC5_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Clears the ERRIF flag in INTF"]
    #[inline(always)]
    pub fn clear(self) -> &'a mut W {
        self.variant(TAEIFC5_AW::CLEAR)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 23)) | ((value as u32 & 0x01) << 23);
        self.w
    }
}
#[doc = "Clear bit for transfer access error flag of channel 6"]
pub type TAEIFC6_AW = TAEIFC0_AW;
#[doc = "Field `TAEIFC6` writer - Clear bit for transfer access error flag of channel 6"]
pub struct TAEIFC6_W<'a> {
    w: &'a mut W,
}
impl<'a> TAEIFC6_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: TAEIFC6_AW) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Clears the ERRIF flag in INTF"]
    #[inline(always)]
    pub fn clear(self) -> &'a mut W {
        self.variant(TAEIFC6_AW::CLEAR)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 27)) | ((value as u32 & 0x01) << 27);
        self.w
    }
}
impl W {
    #[doc = "Bit 0 - Clear global interrupt flag of channel 0"]
    #[inline(always)]
    pub fn gic0(&mut self) -> GIC0_W {
        GIC0_W { w: self }
    }
    #[doc = "Bit 4 - Clear global interrupt flag of channel 1"]
    #[inline(always)]
    pub fn gic1(&mut self) -> GIC1_W {
        GIC1_W { w: self }
    }
    #[doc = "Bit 8 - Clear global interrupt flag of channel 2"]
    #[inline(always)]
    pub fn gic2(&mut self) -> GIC2_W {
        GIC2_W { w: self }
    }
    #[doc = "Bit 12 - Clear global interrupt flag of channel 3"]
    #[inline(always)]
    pub fn gic3(&mut self) -> GIC3_W {
        GIC3_W { w: self }
    }
    #[doc = "Bit 16 - Clear global interrupt flag of channel 4"]
    #[inline(always)]
    pub fn gic4(&mut self) -> GIC4_W {
        GIC4_W { w: self }
    }
    #[doc = "Bit 20 - Clear global interrupt flag of channel 5"]
    #[inline(always)]
    pub fn gic5(&mut self) -> GIC5_W {
        GIC5_W { w: self }
    }
    #[doc = "Bit 24 - Clear global interrupt flag of channel 6"]
    #[inline(always)]
    pub fn gic6(&mut self) -> GIC6_W {
        GIC6_W { w: self }
    }
    #[doc = "Bit 1 - Clear bit for Full transfer finish flag of channel 0"]
    #[inline(always)]
    pub fn ftfifc0(&mut self) -> FTFIFC0_W {
        FTFIFC0_W { w: self }
    }
    #[doc = "Bit 5 - Clear bit for Full transfer finish flag of channel 1"]
    #[inline(always)]
    pub fn ftfifc1(&mut self) -> FTFIFC1_W {
        FTFIFC1_W { w: self }
    }
    #[doc = "Bit 9 - Clear bit for Full transfer finish flag of channel 2"]
    #[inline(always)]
    pub fn ftfifc2(&mut self) -> FTFIFC2_W {
        FTFIFC2_W { w: self }
    }
    #[doc = "Bit 13 - Clear bit for Full transfer finish flag of channel 3"]
    #[inline(always)]
    pub fn ftfifc3(&mut self) -> FTFIFC3_W {
        FTFIFC3_W { w: self }
    }
    #[doc = "Bit 17 - Clear bit for Full transfer finish flag of channel 4"]
    #[inline(always)]
    pub fn ftfifc4(&mut self) -> FTFIFC4_W {
        FTFIFC4_W { w: self }
    }
    #[doc = "Bit 21 - Clear bit for Full transfer finish flag of channel 5"]
    #[inline(always)]
    pub fn ftfifc5(&mut self) -> FTFIFC5_W {
        FTFIFC5_W { w: self }
    }
    #[doc = "Bit 25 - Clear bit for Full transfer finish flag of channel 6"]
    #[inline(always)]
    pub fn ftfifc6(&mut self) -> FTFIFC6_W {
        FTFIFC6_W { w: self }
    }
    #[doc = "Bit 2 - Clear bit for half transfer finish flag of channel 0"]
    #[inline(always)]
    pub fn htfifc0(&mut self) -> HTFIFC0_W {
        HTFIFC0_W { w: self }
    }
    #[doc = "Bit 6 - Clear bit for half transfer finish flag of channel 1"]
    #[inline(always)]
    pub fn htfifc1(&mut self) -> HTFIFC1_W {
        HTFIFC1_W { w: self }
    }
    #[doc = "Bit 10 - Clear bit for half transfer finish flag of channel 2"]
    #[inline(always)]
    pub fn htfifc2(&mut self) -> HTFIFC2_W {
        HTFIFC2_W { w: self }
    }
    #[doc = "Bit 14 - Clear bit for half transfer finish flag of channel 3"]
    #[inline(always)]
    pub fn htfifc3(&mut self) -> HTFIFC3_W {
        HTFIFC3_W { w: self }
    }
    #[doc = "Bit 18 - Clear bit for half transfer finish flag of channel 4"]
    #[inline(always)]
    pub fn htfifc4(&mut self) -> HTFIFC4_W {
        HTFIFC4_W { w: self }
    }
    #[doc = "Bit 22 - Clear bit for half transfer finish flag of channel 5"]
    #[inline(always)]
    pub fn htfifc5(&mut self) -> HTFIFC5_W {
        HTFIFC5_W { w: self }
    }
    #[doc = "Bit 26 - Clear bit for half transfer finish flag of channel 6"]
    #[inline(always)]
    pub fn htfifc6(&mut self) -> HTFIFC6_W {
        HTFIFC6_W { w: self }
    }
    #[doc = "Bit 3 - Clear bit for transfer access error flag of channel 0"]
    #[inline(always)]
    pub fn taeifc0(&mut self) -> TAEIFC0_W {
        TAEIFC0_W { w: self }
    }
    #[doc = "Bit 7 - Clear bit for transfer access error flag of channel 1"]
    #[inline(always)]
    pub fn taeifc1(&mut self) -> TAEIFC1_W {
        TAEIFC1_W { w: self }
    }
    #[doc = "Bit 11 - Clear bit for transfer access error flag of channel 2"]
    #[inline(always)]
    pub fn taeifc2(&mut self) -> TAEIFC2_W {
        TAEIFC2_W { w: self }
    }
    #[doc = "Bit 15 - Clear bit for transfer access error flag of channel 3"]
    #[inline(always)]
    pub fn taeifc3(&mut self) -> TAEIFC3_W {
        TAEIFC3_W { w: self }
    }
    #[doc = "Bit 19 - Clear bit for transfer access error flag of channel 4"]
    #[inline(always)]
    pub fn taeifc4(&mut self) -> TAEIFC4_W {
        TAEIFC4_W { w: self }
    }
    #[doc = "Bit 23 - Clear bit for transfer access error flag of channel 5"]
    #[inline(always)]
    pub fn taeifc5(&mut self) -> TAEIFC5_W {
        TAEIFC5_W { w: self }
    }
    #[doc = "Bit 27 - Clear bit for transfer access error flag of channel 6"]
    #[inline(always)]
    pub fn taeifc6(&mut self) -> TAEIFC6_W {
        TAEIFC6_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "DMA interrupt flag clear register (DMA_INTC)\n\nThis register you can [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [intc](index.html) module"]
pub struct INTC_SPEC;
impl crate::RegisterSpec for INTC_SPEC {
    type Ux = u32;
}
#[doc = "`write(|w| ..)` method takes [intc::W](W) writer structure"]
impl crate::Writable for INTC_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets INTC to value 0"]
impl crate::Resettable for INTC_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
