//! Peripheral access API for GD32E2 microcontrollers
//! (generated using [svd2rust](https://github.com/rust-embedded/svd2rust)
//! 0.19.0)
//!
//! You can find an overview of the API here:
//! [svd2rust/#peripheral-api](https://docs.rs/svd2rust/0.19.0/svd2rust/#peripheral-api)
//!
//! For more details see the README here:
//! [gd32-rs](https://github.com/qwandor/gd32-rs)
//!
//! This crate supports all GD32E2 devices; for the complete list please
//! see:
//! [gd32e2](https://github.com/qwandor/gd32-rs-nightlies/tree/main/gd32e2)
//!
//! Due to doc build limitations, not all devices may be shown on docs.rs;
//! a representative few have been selected instead. For a complete list of
//! available registers and fields see: [gd32-rs Device Coverage](https://qwandor.github.io/gd32-rs/)

#![allow(non_camel_case_types)]
#![no_std]

mod generic;
pub use self::generic::*;

#[cfg(feature = "gd32e230")]
pub mod gd32e230;

#[cfg(feature = "gd32e231")]
pub mod gd32e231;

