#[doc = "Register `RFCS` reader"]
pub struct R(crate::R<RFCS_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<RFCS_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<RFCS_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<RFCS_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `RFCS` writer"]
pub struct W(crate::W<RFCS_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<RFCS_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<RFCS_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<RFCS_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `RFFINT` reader - Receive FIFO full interrupt flag"]
pub struct RFFINT_R(crate::FieldReader<bool, bool>);
impl RFFINT_R {
    pub(crate) fn new(bits: bool) -> Self {
        RFFINT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RFFINT_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RFFINT` writer - Receive FIFO full interrupt flag"]
pub struct RFFINT_W<'a> {
    w: &'a mut W,
}
impl<'a> RFFINT_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 15)) | ((value as u32 & 0x01) << 15);
        self.w
    }
}
#[doc = "Field `RFCNT` reader - Receive FIFO count number"]
pub struct RFCNT_R(crate::FieldReader<u8, u8>);
impl RFCNT_R {
    pub(crate) fn new(bits: u8) -> Self {
        RFCNT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RFCNT_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RFF` reader - Receive FIFO full flag"]
pub struct RFF_R(crate::FieldReader<bool, bool>);
impl RFF_R {
    pub(crate) fn new(bits: bool) -> Self {
        RFF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RFF_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RFE` reader - Receive FIFO empty flag"]
pub struct RFE_R(crate::FieldReader<bool, bool>);
impl RFE_R {
    pub(crate) fn new(bits: bool) -> Self {
        RFE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RFE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RFFIE` reader - Receive FIFO full interrupt enable"]
pub struct RFFIE_R(crate::FieldReader<bool, bool>);
impl RFFIE_R {
    pub(crate) fn new(bits: bool) -> Self {
        RFFIE_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RFFIE_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RFFIE` writer - Receive FIFO full interrupt enable"]
pub struct RFFIE_W<'a> {
    w: &'a mut W,
}
impl<'a> RFFIE_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 9)) | ((value as u32 & 0x01) << 9);
        self.w
    }
}
#[doc = "Field `RFEN` reader - Receive FIFO enable"]
pub struct RFEN_R(crate::FieldReader<bool, bool>);
impl RFEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        RFEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RFEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RFEN` writer - Receive FIFO enable"]
pub struct RFEN_W<'a> {
    w: &'a mut W,
}
impl<'a> RFEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 8)) | ((value as u32 & 0x01) << 8);
        self.w
    }
}
#[doc = "Field `ELNACK` reader - Early NKEN when smartcard mode is selected"]
pub struct ELNACK_R(crate::FieldReader<bool, bool>);
impl ELNACK_R {
    pub(crate) fn new(bits: bool) -> Self {
        ELNACK_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ELNACK_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ELNACK` writer - Early NKEN when smartcard mode is selected"]
pub struct ELNACK_W<'a> {
    w: &'a mut W,
}
impl<'a> ELNACK_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
impl R {
    #[doc = "Bit 15 - Receive FIFO full interrupt flag"]
    #[inline(always)]
    pub fn rffint(&self) -> RFFINT_R {
        RFFINT_R::new(((self.bits >> 15) & 0x01) != 0)
    }
    #[doc = "Bits 12:14 - Receive FIFO count number"]
    #[inline(always)]
    pub fn rfcnt(&self) -> RFCNT_R {
        RFCNT_R::new(((self.bits >> 12) & 0x07) as u8)
    }
    #[doc = "Bit 11 - Receive FIFO full flag"]
    #[inline(always)]
    pub fn rff(&self) -> RFF_R {
        RFF_R::new(((self.bits >> 11) & 0x01) != 0)
    }
    #[doc = "Bit 10 - Receive FIFO empty flag"]
    #[inline(always)]
    pub fn rfe(&self) -> RFE_R {
        RFE_R::new(((self.bits >> 10) & 0x01) != 0)
    }
    #[doc = "Bit 9 - Receive FIFO full interrupt enable"]
    #[inline(always)]
    pub fn rffie(&self) -> RFFIE_R {
        RFFIE_R::new(((self.bits >> 9) & 0x01) != 0)
    }
    #[doc = "Bit 8 - Receive FIFO enable"]
    #[inline(always)]
    pub fn rfen(&self) -> RFEN_R {
        RFEN_R::new(((self.bits >> 8) & 0x01) != 0)
    }
    #[doc = "Bit 0 - Early NKEN when smartcard mode is selected"]
    #[inline(always)]
    pub fn elnack(&self) -> ELNACK_R {
        ELNACK_R::new((self.bits & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 15 - Receive FIFO full interrupt flag"]
    #[inline(always)]
    pub fn rffint(&mut self) -> RFFINT_W {
        RFFINT_W { w: self }
    }
    #[doc = "Bit 9 - Receive FIFO full interrupt enable"]
    #[inline(always)]
    pub fn rffie(&mut self) -> RFFIE_W {
        RFFIE_W { w: self }
    }
    #[doc = "Bit 8 - Receive FIFO enable"]
    #[inline(always)]
    pub fn rfen(&mut self) -> RFEN_W {
        RFEN_W { w: self }
    }
    #[doc = "Bit 0 - Early NKEN when smartcard mode is selected"]
    #[inline(always)]
    pub fn elnack(&mut self) -> ELNACK_W {
        ELNACK_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "USART receive FIFO control and status register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [rfcs](index.html) module"]
pub struct RFCS_SPEC;
impl crate::RegisterSpec for RFCS_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [rfcs::R](R) reader structure"]
impl crate::Readable for RFCS_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [rfcs::W](W) writer structure"]
impl crate::Writable for RFCS_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets RFCS to value 0x0400"]
impl crate::Resettable for RFCS_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0x0400
    }
}
