#[doc = "Register `CHCTL1_Output` reader"]
pub struct R(crate::R<CHCTL1_OUTPUT_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<CHCTL1_OUTPUT_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<CHCTL1_OUTPUT_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<CHCTL1_OUTPUT_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `CHCTL1_Output` writer"]
pub struct W(crate::W<CHCTL1_OUTPUT_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<CHCTL1_OUTPUT_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<CHCTL1_OUTPUT_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<CHCTL1_OUTPUT_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `CH3COMCEN` reader - Output compare 3 clear enable"]
pub struct CH3COMCEN_R(crate::FieldReader<bool, bool>);
impl CH3COMCEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        CH3COMCEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CH3COMCEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CH3COMCEN` writer - Output compare 3 clear enable"]
pub struct CH3COMCEN_W<'a> {
    w: &'a mut W,
}
impl<'a> CH3COMCEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 15)) | ((value as u32 & 0x01) << 15);
        self.w
    }
}
#[doc = "Field `CH3COMCTL` reader - Output compare 3 mode"]
pub struct CH3COMCTL_R(crate::FieldReader<u8, u8>);
impl CH3COMCTL_R {
    pub(crate) fn new(bits: u8) -> Self {
        CH3COMCTL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CH3COMCTL_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CH3COMCTL` writer - Output compare 3 mode"]
pub struct CH3COMCTL_W<'a> {
    w: &'a mut W,
}
impl<'a> CH3COMCTL_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 12)) | ((value as u32 & 0x07) << 12);
        self.w
    }
}
#[doc = "Field `CH3COMSEN` reader - Output compare 3 preload enable"]
pub struct CH3COMSEN_R(crate::FieldReader<bool, bool>);
impl CH3COMSEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        CH3COMSEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CH3COMSEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CH3COMSEN` writer - Output compare 3 preload enable"]
pub struct CH3COMSEN_W<'a> {
    w: &'a mut W,
}
impl<'a> CH3COMSEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 11)) | ((value as u32 & 0x01) << 11);
        self.w
    }
}
#[doc = "Field `CH3COMFEN` reader - Output compare 3 fast enable"]
pub struct CH3COMFEN_R(crate::FieldReader<bool, bool>);
impl CH3COMFEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        CH3COMFEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CH3COMFEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CH3COMFEN` writer - Output compare 3 fast enable"]
pub struct CH3COMFEN_W<'a> {
    w: &'a mut W,
}
impl<'a> CH3COMFEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 10)) | ((value as u32 & 0x01) << 10);
        self.w
    }
}
#[doc = "Field `CH3MS` reader - Capture/Compare 3 selection"]
pub struct CH3MS_R(crate::FieldReader<u8, u8>);
impl CH3MS_R {
    pub(crate) fn new(bits: u8) -> Self {
        CH3MS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CH3MS_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CH3MS` writer - Capture/Compare 3 selection"]
pub struct CH3MS_W<'a> {
    w: &'a mut W,
}
impl<'a> CH3MS_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 8)) | ((value as u32 & 0x03) << 8);
        self.w
    }
}
#[doc = "Field `CH2COMCEN` reader - Output compare 2 clear enable"]
pub struct CH2COMCEN_R(crate::FieldReader<bool, bool>);
impl CH2COMCEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        CH2COMCEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CH2COMCEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CH2COMCEN` writer - Output compare 2 clear enable"]
pub struct CH2COMCEN_W<'a> {
    w: &'a mut W,
}
impl<'a> CH2COMCEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u32 & 0x01) << 7);
        self.w
    }
}
#[doc = "Field `CH2COMCTL` reader - Output compare 2 mode"]
pub struct CH2COMCTL_R(crate::FieldReader<u8, u8>);
impl CH2COMCTL_R {
    pub(crate) fn new(bits: u8) -> Self {
        CH2COMCTL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CH2COMCTL_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CH2COMCTL` writer - Output compare 2 mode"]
pub struct CH2COMCTL_W<'a> {
    w: &'a mut W,
}
impl<'a> CH2COMCTL_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 4)) | ((value as u32 & 0x07) << 4);
        self.w
    }
}
#[doc = "Field `CH2COMSEN` reader - Output compare 2 preload enable"]
pub struct CH2COMSEN_R(crate::FieldReader<bool, bool>);
impl CH2COMSEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        CH2COMSEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CH2COMSEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CH2COMSEN` writer - Output compare 2 preload enable"]
pub struct CH2COMSEN_W<'a> {
    w: &'a mut W,
}
impl<'a> CH2COMSEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u32 & 0x01) << 3);
        self.w
    }
}
#[doc = "Field `CH2COMFEN` reader - Output compare 2 fast enable"]
pub struct CH2COMFEN_R(crate::FieldReader<bool, bool>);
impl CH2COMFEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        CH2COMFEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CH2COMFEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CH2COMFEN` writer - Output compare 2 fast enable"]
pub struct CH2COMFEN_W<'a> {
    w: &'a mut W,
}
impl<'a> CH2COMFEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u32 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `CH2MS` reader - Capture/Compare 2 selection"]
pub struct CH2MS_R(crate::FieldReader<u8, u8>);
impl CH2MS_R {
    pub(crate) fn new(bits: u8) -> Self {
        CH2MS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CH2MS_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CH2MS` writer - Capture/Compare 2 selection"]
pub struct CH2MS_W<'a> {
    w: &'a mut W,
}
impl<'a> CH2MS_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x03) | (value as u32 & 0x03);
        self.w
    }
}
impl R {
    #[doc = "Bit 15 - Output compare 3 clear enable"]
    #[inline(always)]
    pub fn ch3comcen(&self) -> CH3COMCEN_R {
        CH3COMCEN_R::new(((self.bits >> 15) & 0x01) != 0)
    }
    #[doc = "Bits 12:14 - Output compare 3 mode"]
    #[inline(always)]
    pub fn ch3comctl(&self) -> CH3COMCTL_R {
        CH3COMCTL_R::new(((self.bits >> 12) & 0x07) as u8)
    }
    #[doc = "Bit 11 - Output compare 3 preload enable"]
    #[inline(always)]
    pub fn ch3comsen(&self) -> CH3COMSEN_R {
        CH3COMSEN_R::new(((self.bits >> 11) & 0x01) != 0)
    }
    #[doc = "Bit 10 - Output compare 3 fast enable"]
    #[inline(always)]
    pub fn ch3comfen(&self) -> CH3COMFEN_R {
        CH3COMFEN_R::new(((self.bits >> 10) & 0x01) != 0)
    }
    #[doc = "Bits 8:9 - Capture/Compare 3 selection"]
    #[inline(always)]
    pub fn ch3ms(&self) -> CH3MS_R {
        CH3MS_R::new(((self.bits >> 8) & 0x03) as u8)
    }
    #[doc = "Bit 7 - Output compare 2 clear enable"]
    #[inline(always)]
    pub fn ch2comcen(&self) -> CH2COMCEN_R {
        CH2COMCEN_R::new(((self.bits >> 7) & 0x01) != 0)
    }
    #[doc = "Bits 4:6 - Output compare 2 mode"]
    #[inline(always)]
    pub fn ch2comctl(&self) -> CH2COMCTL_R {
        CH2COMCTL_R::new(((self.bits >> 4) & 0x07) as u8)
    }
    #[doc = "Bit 3 - Output compare 2 preload enable"]
    #[inline(always)]
    pub fn ch2comsen(&self) -> CH2COMSEN_R {
        CH2COMSEN_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Output compare 2 fast enable"]
    #[inline(always)]
    pub fn ch2comfen(&self) -> CH2COMFEN_R {
        CH2COMFEN_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bits 0:1 - Capture/Compare 2 selection"]
    #[inline(always)]
    pub fn ch2ms(&self) -> CH2MS_R {
        CH2MS_R::new((self.bits & 0x03) as u8)
    }
}
impl W {
    #[doc = "Bit 15 - Output compare 3 clear enable"]
    #[inline(always)]
    pub fn ch3comcen(&mut self) -> CH3COMCEN_W {
        CH3COMCEN_W { w: self }
    }
    #[doc = "Bits 12:14 - Output compare 3 mode"]
    #[inline(always)]
    pub fn ch3comctl(&mut self) -> CH3COMCTL_W {
        CH3COMCTL_W { w: self }
    }
    #[doc = "Bit 11 - Output compare 3 preload enable"]
    #[inline(always)]
    pub fn ch3comsen(&mut self) -> CH3COMSEN_W {
        CH3COMSEN_W { w: self }
    }
    #[doc = "Bit 10 - Output compare 3 fast enable"]
    #[inline(always)]
    pub fn ch3comfen(&mut self) -> CH3COMFEN_W {
        CH3COMFEN_W { w: self }
    }
    #[doc = "Bits 8:9 - Capture/Compare 3 selection"]
    #[inline(always)]
    pub fn ch3ms(&mut self) -> CH3MS_W {
        CH3MS_W { w: self }
    }
    #[doc = "Bit 7 - Output compare 2 clear enable"]
    #[inline(always)]
    pub fn ch2comcen(&mut self) -> CH2COMCEN_W {
        CH2COMCEN_W { w: self }
    }
    #[doc = "Bits 4:6 - Output compare 2 mode"]
    #[inline(always)]
    pub fn ch2comctl(&mut self) -> CH2COMCTL_W {
        CH2COMCTL_W { w: self }
    }
    #[doc = "Bit 3 - Output compare 2 preload enable"]
    #[inline(always)]
    pub fn ch2comsen(&mut self) -> CH2COMSEN_W {
        CH2COMSEN_W { w: self }
    }
    #[doc = "Bit 2 - Output compare 2 fast enable"]
    #[inline(always)]
    pub fn ch2comfen(&mut self) -> CH2COMFEN_W {
        CH2COMFEN_W { w: self }
    }
    #[doc = "Bits 0:1 - Capture/Compare 2 selection"]
    #[inline(always)]
    pub fn ch2ms(&mut self) -> CH2MS_W {
        CH2MS_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "capture/compare mode register 1 (output mode)\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [chctl1_output](index.html) module"]
pub struct CHCTL1_OUTPUT_SPEC;
impl crate::RegisterSpec for CHCTL1_OUTPUT_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [chctl1_output::R](R) reader structure"]
impl crate::Readable for CHCTL1_OUTPUT_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [chctl1_output::W](W) writer structure"]
impl crate::Writable for CHCTL1_OUTPUT_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets CHCTL1_Output to value 0"]
impl crate::Resettable for CHCTL1_OUTPUT_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
