#[doc = "Register `CHCTL1_Input` reader"]
pub struct R(crate::R<CHCTL1_INPUT_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<CHCTL1_INPUT_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<CHCTL1_INPUT_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<CHCTL1_INPUT_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `CHCTL1_Input` writer"]
pub struct W(crate::W<CHCTL1_INPUT_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<CHCTL1_INPUT_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<CHCTL1_INPUT_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<CHCTL1_INPUT_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `CH3CAPFLT` reader - Input capture 3 filter"]
pub struct CH3CAPFLT_R(crate::FieldReader<u8, u8>);
impl CH3CAPFLT_R {
    pub(crate) fn new(bits: u8) -> Self {
        CH3CAPFLT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CH3CAPFLT_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CH3CAPFLT` writer - Input capture 3 filter"]
pub struct CH3CAPFLT_W<'a> {
    w: &'a mut W,
}
impl<'a> CH3CAPFLT_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 12)) | ((value as u32 & 0x0f) << 12);
        self.w
    }
}
#[doc = "Field `CH3CAPPSC` reader - Input capture 3 prescaler"]
pub struct CH3CAPPSC_R(crate::FieldReader<u8, u8>);
impl CH3CAPPSC_R {
    pub(crate) fn new(bits: u8) -> Self {
        CH3CAPPSC_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CH3CAPPSC_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CH3CAPPSC` writer - Input capture 3 prescaler"]
pub struct CH3CAPPSC_W<'a> {
    w: &'a mut W,
}
impl<'a> CH3CAPPSC_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 10)) | ((value as u32 & 0x03) << 10);
        self.w
    }
}
#[doc = "Field `CH3MS` reader - Capture/Compare 3 selection"]
pub struct CH3MS_R(crate::FieldReader<u8, u8>);
impl CH3MS_R {
    pub(crate) fn new(bits: u8) -> Self {
        CH3MS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CH3MS_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CH3MS` writer - Capture/Compare 3 selection"]
pub struct CH3MS_W<'a> {
    w: &'a mut W,
}
impl<'a> CH3MS_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 8)) | ((value as u32 & 0x03) << 8);
        self.w
    }
}
#[doc = "Field `CH2CAPFLT` reader - Input capture 2 filter"]
pub struct CH2CAPFLT_R(crate::FieldReader<u8, u8>);
impl CH2CAPFLT_R {
    pub(crate) fn new(bits: u8) -> Self {
        CH2CAPFLT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CH2CAPFLT_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CH2CAPFLT` writer - Input capture 2 filter"]
pub struct CH2CAPFLT_W<'a> {
    w: &'a mut W,
}
impl<'a> CH2CAPFLT_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 4)) | ((value as u32 & 0x0f) << 4);
        self.w
    }
}
#[doc = "Field `CH2CAPPSC` reader - Input capture 2 prescaler"]
pub struct CH2CAPPSC_R(crate::FieldReader<u8, u8>);
impl CH2CAPPSC_R {
    pub(crate) fn new(bits: u8) -> Self {
        CH2CAPPSC_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CH2CAPPSC_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CH2CAPPSC` writer - Input capture 2 prescaler"]
pub struct CH2CAPPSC_W<'a> {
    w: &'a mut W,
}
impl<'a> CH2CAPPSC_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 2)) | ((value as u32 & 0x03) << 2);
        self.w
    }
}
#[doc = "Field `CH2MS` reader - Capture/Compare 2 selection"]
pub struct CH2MS_R(crate::FieldReader<u8, u8>);
impl CH2MS_R {
    pub(crate) fn new(bits: u8) -> Self {
        CH2MS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CH2MS_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CH2MS` writer - Capture/Compare 2 selection"]
pub struct CH2MS_W<'a> {
    w: &'a mut W,
}
impl<'a> CH2MS_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x03) | (value as u32 & 0x03);
        self.w
    }
}
impl R {
    #[doc = "Bits 12:15 - Input capture 3 filter"]
    #[inline(always)]
    pub fn ch3capflt(&self) -> CH3CAPFLT_R {
        CH3CAPFLT_R::new(((self.bits >> 12) & 0x0f) as u8)
    }
    #[doc = "Bits 10:11 - Input capture 3 prescaler"]
    #[inline(always)]
    pub fn ch3cappsc(&self) -> CH3CAPPSC_R {
        CH3CAPPSC_R::new(((self.bits >> 10) & 0x03) as u8)
    }
    #[doc = "Bits 8:9 - Capture/Compare 3 selection"]
    #[inline(always)]
    pub fn ch3ms(&self) -> CH3MS_R {
        CH3MS_R::new(((self.bits >> 8) & 0x03) as u8)
    }
    #[doc = "Bits 4:7 - Input capture 2 filter"]
    #[inline(always)]
    pub fn ch2capflt(&self) -> CH2CAPFLT_R {
        CH2CAPFLT_R::new(((self.bits >> 4) & 0x0f) as u8)
    }
    #[doc = "Bits 2:3 - Input capture 2 prescaler"]
    #[inline(always)]
    pub fn ch2cappsc(&self) -> CH2CAPPSC_R {
        CH2CAPPSC_R::new(((self.bits >> 2) & 0x03) as u8)
    }
    #[doc = "Bits 0:1 - Capture/Compare 2 selection"]
    #[inline(always)]
    pub fn ch2ms(&self) -> CH2MS_R {
        CH2MS_R::new((self.bits & 0x03) as u8)
    }
}
impl W {
    #[doc = "Bits 12:15 - Input capture 3 filter"]
    #[inline(always)]
    pub fn ch3capflt(&mut self) -> CH3CAPFLT_W {
        CH3CAPFLT_W { w: self }
    }
    #[doc = "Bits 10:11 - Input capture 3 prescaler"]
    #[inline(always)]
    pub fn ch3cappsc(&mut self) -> CH3CAPPSC_W {
        CH3CAPPSC_W { w: self }
    }
    #[doc = "Bits 8:9 - Capture/Compare 3 selection"]
    #[inline(always)]
    pub fn ch3ms(&mut self) -> CH3MS_W {
        CH3MS_W { w: self }
    }
    #[doc = "Bits 4:7 - Input capture 2 filter"]
    #[inline(always)]
    pub fn ch2capflt(&mut self) -> CH2CAPFLT_W {
        CH2CAPFLT_W { w: self }
    }
    #[doc = "Bits 2:3 - Input capture 2 prescaler"]
    #[inline(always)]
    pub fn ch2cappsc(&mut self) -> CH2CAPPSC_W {
        CH2CAPPSC_W { w: self }
    }
    #[doc = "Bits 0:1 - Capture/Compare 2 selection"]
    #[inline(always)]
    pub fn ch2ms(&mut self) -> CH2MS_W {
        CH2MS_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "capture/compare mode register 1 (input mode)\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [chctl1_input](index.html) module"]
pub struct CHCTL1_INPUT_SPEC;
impl crate::RegisterSpec for CHCTL1_INPUT_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [chctl1_input::R](R) reader structure"]
impl crate::Readable for CHCTL1_INPUT_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [chctl1_input::W](W) writer structure"]
impl crate::Writable for CHCTL1_INPUT_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets CHCTL1_Input to value 0"]
impl crate::Resettable for CHCTL1_INPUT_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
