#[doc = "Register `TTS` reader"]
pub struct R(crate::R<TTS_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<TTS_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<TTS_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<TTS_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Field `PM` reader - AM/PM mark"]
pub struct PM_R(crate::FieldReader<bool, bool>);
impl PM_R {
    pub(crate) fn new(bits: bool) -> Self {
        PM_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PM_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `HRT` reader - Hour tens in BCD code"]
pub struct HRT_R(crate::FieldReader<u8, u8>);
impl HRT_R {
    pub(crate) fn new(bits: u8) -> Self {
        HRT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for HRT_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `HRU` reader - Hour units in BCD code"]
pub struct HRU_R(crate::FieldReader<u8, u8>);
impl HRU_R {
    pub(crate) fn new(bits: u8) -> Self {
        HRU_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for HRU_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `MNT` reader - Minute tens in BCD code"]
pub struct MNT_R(crate::FieldReader<u8, u8>);
impl MNT_R {
    pub(crate) fn new(bits: u8) -> Self {
        MNT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for MNT_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `MNU` reader - Minute units in BCD code"]
pub struct MNU_R(crate::FieldReader<u8, u8>);
impl MNU_R {
    pub(crate) fn new(bits: u8) -> Self {
        MNU_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for MNU_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SCT` reader - Second tens in BCD code"]
pub struct SCT_R(crate::FieldReader<u8, u8>);
impl SCT_R {
    pub(crate) fn new(bits: u8) -> Self {
        SCT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SCT_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SCU` reader - Second units in BCD code"]
pub struct SCU_R(crate::FieldReader<u8, u8>);
impl SCU_R {
    pub(crate) fn new(bits: u8) -> Self {
        SCU_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SCU_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl R {
    #[doc = "Bit 22 - AM/PM mark"]
    #[inline(always)]
    pub fn pm(&self) -> PM_R {
        PM_R::new(((self.bits >> 22) & 0x01) != 0)
    }
    #[doc = "Bits 20:21 - Hour tens in BCD code"]
    #[inline(always)]
    pub fn hrt(&self) -> HRT_R {
        HRT_R::new(((self.bits >> 20) & 0x03) as u8)
    }
    #[doc = "Bits 16:19 - Hour units in BCD code"]
    #[inline(always)]
    pub fn hru(&self) -> HRU_R {
        HRU_R::new(((self.bits >> 16) & 0x0f) as u8)
    }
    #[doc = "Bits 12:14 - Minute tens in BCD code"]
    #[inline(always)]
    pub fn mnt(&self) -> MNT_R {
        MNT_R::new(((self.bits >> 12) & 0x07) as u8)
    }
    #[doc = "Bits 8:11 - Minute units in BCD code"]
    #[inline(always)]
    pub fn mnu(&self) -> MNU_R {
        MNU_R::new(((self.bits >> 8) & 0x0f) as u8)
    }
    #[doc = "Bits 4:6 - Second tens in BCD code"]
    #[inline(always)]
    pub fn sct(&self) -> SCT_R {
        SCT_R::new(((self.bits >> 4) & 0x07) as u8)
    }
    #[doc = "Bits 0:3 - Second units in BCD code"]
    #[inline(always)]
    pub fn scu(&self) -> SCU_R {
        SCU_R::new((self.bits & 0x0f) as u8)
    }
}
#[doc = "timestamp time register\n\nThis register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [tts](index.html) module"]
pub struct TTS_SPEC;
impl crate::RegisterSpec for TTS_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [tts::R](R) reader structure"]
impl crate::Readable for TTS_SPEC {
    type Reader = R;
}
#[doc = "`reset()` method sets TTS to value 0"]
impl crate::Resettable for TTS_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
