#[doc = "Register `DTS` reader"]
pub struct R(crate::R<DTS_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<DTS_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<DTS_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<DTS_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Field `DOW` reader - Week day units"]
pub struct DOW_R(crate::FieldReader<u8, u8>);
impl DOW_R {
    pub(crate) fn new(bits: u8) -> Self {
        DOW_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DOW_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `MONT` reader - Month tens in BCD code"]
pub struct MONT_R(crate::FieldReader<bool, bool>);
impl MONT_R {
    pub(crate) fn new(bits: bool) -> Self {
        MONT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for MONT_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `MONU` reader - Month units in BCD code"]
pub struct MONU_R(crate::FieldReader<u8, u8>);
impl MONU_R {
    pub(crate) fn new(bits: u8) -> Self {
        MONU_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for MONU_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DAYT` reader - Date tens in BCD code"]
pub struct DAYT_R(crate::FieldReader<u8, u8>);
impl DAYT_R {
    pub(crate) fn new(bits: u8) -> Self {
        DAYT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DAYT_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DAYU` reader - Date units in BCD code"]
pub struct DAYU_R(crate::FieldReader<u8, u8>);
impl DAYU_R {
    pub(crate) fn new(bits: u8) -> Self {
        DAYU_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DAYU_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl R {
    #[doc = "Bits 13:15 - Week day units"]
    #[inline(always)]
    pub fn dow(&self) -> DOW_R {
        DOW_R::new(((self.bits >> 13) & 0x07) as u8)
    }
    #[doc = "Bit 12 - Month tens in BCD code"]
    #[inline(always)]
    pub fn mont(&self) -> MONT_R {
        MONT_R::new(((self.bits >> 12) & 0x01) != 0)
    }
    #[doc = "Bits 8:11 - Month units in BCD code"]
    #[inline(always)]
    pub fn monu(&self) -> MONU_R {
        MONU_R::new(((self.bits >> 8) & 0x0f) as u8)
    }
    #[doc = "Bits 5:6 - Date tens in BCD code"]
    #[inline(always)]
    pub fn dayt(&self) -> DAYT_R {
        DAYT_R::new(((self.bits >> 5) & 0x03) as u8)
    }
    #[doc = "Bits 0:4 - Date units in BCD code"]
    #[inline(always)]
    pub fn dayu(&self) -> DAYU_R {
        DAYU_R::new((self.bits & 0x1f) as u8)
    }
}
#[doc = "Date of time stamp register\n\nThis register you can [`read`](crate::generic::Reg::read). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [dts](index.html) module"]
pub struct DTS_SPEC;
impl crate::RegisterSpec for DTS_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [dts::R](R) reader structure"]
impl crate::Readable for DTS_SPEC {
    type Reader = R;
}
#[doc = "`reset()` method sets DTS to value 0"]
impl crate::Resettable for DTS_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
