#[doc = "Register `APB2EN` reader"]
pub struct R(crate::R<APB2EN_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<APB2EN_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<APB2EN_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<APB2EN_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `APB2EN` writer"]
pub struct W(crate::W<APB2EN_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<APB2EN_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<APB2EN_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<APB2EN_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `DBGMCUEN` reader - DBGMCU clock enable"]
pub struct DBGMCUEN_R(crate::FieldReader<bool, bool>);
impl DBGMCUEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        DBGMCUEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for DBGMCUEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DBGMCUEN` writer - DBGMCU clock enable"]
pub struct DBGMCUEN_W<'a> {
    w: &'a mut W,
}
impl<'a> DBGMCUEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 22)) | ((value as u32 & 0x01) << 22);
        self.w
    }
}
#[doc = "Field `TIMER16EN` reader - TIMER16 timer clock enable"]
pub struct TIMER16EN_R(crate::FieldReader<bool, bool>);
impl TIMER16EN_R {
    pub(crate) fn new(bits: bool) -> Self {
        TIMER16EN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TIMER16EN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TIMER16EN` writer - TIMER16 timer clock enable"]
pub struct TIMER16EN_W<'a> {
    w: &'a mut W,
}
impl<'a> TIMER16EN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 18)) | ((value as u32 & 0x01) << 18);
        self.w
    }
}
#[doc = "Field `TIMER15EN` reader - TIMER15 timer clock enable"]
pub struct TIMER15EN_R(crate::FieldReader<bool, bool>);
impl TIMER15EN_R {
    pub(crate) fn new(bits: bool) -> Self {
        TIMER15EN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TIMER15EN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TIMER15EN` writer - TIMER15 timer clock enable"]
pub struct TIMER15EN_W<'a> {
    w: &'a mut W,
}
impl<'a> TIMER15EN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 17)) | ((value as u32 & 0x01) << 17);
        self.w
    }
}
#[doc = "Field `TIMER14EN` reader - TIMER14 timer clock enable"]
pub struct TIMER14EN_R(crate::FieldReader<bool, bool>);
impl TIMER14EN_R {
    pub(crate) fn new(bits: bool) -> Self {
        TIMER14EN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TIMER14EN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TIMER14EN` writer - TIMER14 timer clock enable"]
pub struct TIMER14EN_W<'a> {
    w: &'a mut W,
}
impl<'a> TIMER14EN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 16)) | ((value as u32 & 0x01) << 16);
        self.w
    }
}
#[doc = "Field `USART0EN` reader - USART0 clock enable"]
pub struct USART0EN_R(crate::FieldReader<bool, bool>);
impl USART0EN_R {
    pub(crate) fn new(bits: bool) -> Self {
        USART0EN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for USART0EN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `USART0EN` writer - USART0 clock enable"]
pub struct USART0EN_W<'a> {
    w: &'a mut W,
}
impl<'a> USART0EN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 14)) | ((value as u32 & 0x01) << 14);
        self.w
    }
}
#[doc = "Field `SPI0EN` reader - SPI0 clock enable"]
pub struct SPI0EN_R(crate::FieldReader<bool, bool>);
impl SPI0EN_R {
    pub(crate) fn new(bits: bool) -> Self {
        SPI0EN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SPI0EN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SPI0EN` writer - SPI0 clock enable"]
pub struct SPI0EN_W<'a> {
    w: &'a mut W,
}
impl<'a> SPI0EN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 12)) | ((value as u32 & 0x01) << 12);
        self.w
    }
}
#[doc = "Field `TIMER0EN` reader - TIMER0 timer clock enable"]
pub struct TIMER0EN_R(crate::FieldReader<bool, bool>);
impl TIMER0EN_R {
    pub(crate) fn new(bits: bool) -> Self {
        TIMER0EN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for TIMER0EN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `TIMER0EN` writer - TIMER0 timer clock enable"]
pub struct TIMER0EN_W<'a> {
    w: &'a mut W,
}
impl<'a> TIMER0EN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 11)) | ((value as u32 & 0x01) << 11);
        self.w
    }
}
#[doc = "Field `ADCEN` reader - ADC interface clock enable"]
pub struct ADCEN_R(crate::FieldReader<bool, bool>);
impl ADCEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        ADCEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ADCEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ADCEN` writer - ADC interface clock enable"]
pub struct ADCEN_W<'a> {
    w: &'a mut W,
}
impl<'a> ADCEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 9)) | ((value as u32 & 0x01) << 9);
        self.w
    }
}
#[doc = "Field `CFGCMPEN` reader - System configuration and comparator clock enable"]
pub struct CFGCMPEN_R(crate::FieldReader<bool, bool>);
impl CFGCMPEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        CFGCMPEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CFGCMPEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CFGCMPEN` writer - System configuration and comparator clock enable"]
pub struct CFGCMPEN_W<'a> {
    w: &'a mut W,
}
impl<'a> CFGCMPEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
impl R {
    #[doc = "Bit 22 - DBGMCU clock enable"]
    #[inline(always)]
    pub fn dbgmcuen(&self) -> DBGMCUEN_R {
        DBGMCUEN_R::new(((self.bits >> 22) & 0x01) != 0)
    }
    #[doc = "Bit 18 - TIMER16 timer clock enable"]
    #[inline(always)]
    pub fn timer16en(&self) -> TIMER16EN_R {
        TIMER16EN_R::new(((self.bits >> 18) & 0x01) != 0)
    }
    #[doc = "Bit 17 - TIMER15 timer clock enable"]
    #[inline(always)]
    pub fn timer15en(&self) -> TIMER15EN_R {
        TIMER15EN_R::new(((self.bits >> 17) & 0x01) != 0)
    }
    #[doc = "Bit 16 - TIMER14 timer clock enable"]
    #[inline(always)]
    pub fn timer14en(&self) -> TIMER14EN_R {
        TIMER14EN_R::new(((self.bits >> 16) & 0x01) != 0)
    }
    #[doc = "Bit 14 - USART0 clock enable"]
    #[inline(always)]
    pub fn usart0en(&self) -> USART0EN_R {
        USART0EN_R::new(((self.bits >> 14) & 0x01) != 0)
    }
    #[doc = "Bit 12 - SPI0 clock enable"]
    #[inline(always)]
    pub fn spi0en(&self) -> SPI0EN_R {
        SPI0EN_R::new(((self.bits >> 12) & 0x01) != 0)
    }
    #[doc = "Bit 11 - TIMER0 timer clock enable"]
    #[inline(always)]
    pub fn timer0en(&self) -> TIMER0EN_R {
        TIMER0EN_R::new(((self.bits >> 11) & 0x01) != 0)
    }
    #[doc = "Bit 9 - ADC interface clock enable"]
    #[inline(always)]
    pub fn adcen(&self) -> ADCEN_R {
        ADCEN_R::new(((self.bits >> 9) & 0x01) != 0)
    }
    #[doc = "Bit 0 - System configuration and comparator clock enable"]
    #[inline(always)]
    pub fn cfgcmpen(&self) -> CFGCMPEN_R {
        CFGCMPEN_R::new((self.bits & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 22 - DBGMCU clock enable"]
    #[inline(always)]
    pub fn dbgmcuen(&mut self) -> DBGMCUEN_W {
        DBGMCUEN_W { w: self }
    }
    #[doc = "Bit 18 - TIMER16 timer clock enable"]
    #[inline(always)]
    pub fn timer16en(&mut self) -> TIMER16EN_W {
        TIMER16EN_W { w: self }
    }
    #[doc = "Bit 17 - TIMER15 timer clock enable"]
    #[inline(always)]
    pub fn timer15en(&mut self) -> TIMER15EN_W {
        TIMER15EN_W { w: self }
    }
    #[doc = "Bit 16 - TIMER14 timer clock enable"]
    #[inline(always)]
    pub fn timer14en(&mut self) -> TIMER14EN_W {
        TIMER14EN_W { w: self }
    }
    #[doc = "Bit 14 - USART0 clock enable"]
    #[inline(always)]
    pub fn usart0en(&mut self) -> USART0EN_W {
        USART0EN_W { w: self }
    }
    #[doc = "Bit 12 - SPI0 clock enable"]
    #[inline(always)]
    pub fn spi0en(&mut self) -> SPI0EN_W {
        SPI0EN_W { w: self }
    }
    #[doc = "Bit 11 - TIMER0 timer clock enable"]
    #[inline(always)]
    pub fn timer0en(&mut self) -> TIMER0EN_W {
        TIMER0EN_W { w: self }
    }
    #[doc = "Bit 9 - ADC interface clock enable"]
    #[inline(always)]
    pub fn adcen(&mut self) -> ADCEN_W {
        ADCEN_W { w: self }
    }
    #[doc = "Bit 0 - System configuration and comparator clock enable"]
    #[inline(always)]
    pub fn cfgcmpen(&mut self) -> CFGCMPEN_W {
        CFGCMPEN_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "APB2 enable register (RCU_APB2EN)\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [apb2en](index.html) module"]
pub struct APB2EN_SPEC;
impl crate::RegisterSpec for APB2EN_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [apb2en::R](R) reader structure"]
impl crate::Readable for APB2EN_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [apb2en::W](W) writer structure"]
impl crate::Writable for APB2EN_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets APB2EN to value 0"]
impl crate::Resettable for APB2EN_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
