#[doc = "Register `CKCFG` reader"]
pub struct R(crate::R<CKCFG_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<CKCFG_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<CKCFG_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<CKCFG_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `CKCFG` writer"]
pub struct W(crate::W<CKCFG_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<CKCFG_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<CKCFG_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<CKCFG_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "I2C master mode selection\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum FAST_A {
    #[doc = "0: Standard mode I2C"]
    STANDARD = 0,
    #[doc = "1: Fast mode I2C"]
    FAST = 1,
}
impl From<FAST_A> for bool {
    #[inline(always)]
    fn from(variant: FAST_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `FAST` reader - I2C master mode selection"]
pub struct FAST_R(crate::FieldReader<bool, FAST_A>);
impl FAST_R {
    pub(crate) fn new(bits: bool) -> Self {
        FAST_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> FAST_A {
        match self.bits {
            false => FAST_A::STANDARD,
            true => FAST_A::FAST,
        }
    }
    #[doc = "Checks if the value of the field is `STANDARD`"]
    #[inline(always)]
    pub fn is_standard(&self) -> bool {
        **self == FAST_A::STANDARD
    }
    #[doc = "Checks if the value of the field is `FAST`"]
    #[inline(always)]
    pub fn is_fast(&self) -> bool {
        **self == FAST_A::FAST
    }
}
impl core::ops::Deref for FAST_R {
    type Target = crate::FieldReader<bool, FAST_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `FAST` writer - I2C master mode selection"]
pub struct FAST_W<'a> {
    w: &'a mut W,
}
impl<'a> FAST_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: FAST_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Standard mode I2C"]
    #[inline(always)]
    pub fn standard(self) -> &'a mut W {
        self.variant(FAST_A::STANDARD)
    }
    #[doc = "Fast mode I2C"]
    #[inline(always)]
    pub fn fast(self) -> &'a mut W {
        self.variant(FAST_A::FAST)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 15)) | ((value as u32 & 0x01) << 15);
        self.w
    }
}
#[doc = "Fast mode duty cycle\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum DTCY_A {
    #[doc = "0: Duty cycle t_low/t_high = 2"]
    DUTY2 = 0,
    #[doc = "1: Duty cycle t_low/t_high = 16/9"]
    DUTY16_9 = 1,
}
impl From<DTCY_A> for bool {
    #[inline(always)]
    fn from(variant: DTCY_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `DTCY` reader - Fast mode duty cycle"]
pub struct DTCY_R(crate::FieldReader<bool, DTCY_A>);
impl DTCY_R {
    pub(crate) fn new(bits: bool) -> Self {
        DTCY_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> DTCY_A {
        match self.bits {
            false => DTCY_A::DUTY2,
            true => DTCY_A::DUTY16_9,
        }
    }
    #[doc = "Checks if the value of the field is `DUTY2`"]
    #[inline(always)]
    pub fn is_duty2(&self) -> bool {
        **self == DTCY_A::DUTY2
    }
    #[doc = "Checks if the value of the field is `DUTY16_9`"]
    #[inline(always)]
    pub fn is_duty16_9(&self) -> bool {
        **self == DTCY_A::DUTY16_9
    }
}
impl core::ops::Deref for DTCY_R {
    type Target = crate::FieldReader<bool, DTCY_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `DTCY` writer - Fast mode duty cycle"]
pub struct DTCY_W<'a> {
    w: &'a mut W,
}
impl<'a> DTCY_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: DTCY_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Duty cycle t_low/t_high = 2"]
    #[inline(always)]
    pub fn duty2(self) -> &'a mut W {
        self.variant(DTCY_A::DUTY2)
    }
    #[doc = "Duty cycle t_low/t_high = 16/9"]
    #[inline(always)]
    pub fn duty16_9(self) -> &'a mut W {
        self.variant(DTCY_A::DUTY16_9)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 14)) | ((value as u32 & 0x01) << 14);
        self.w
    }
}
#[doc = "Field `CLKC` reader - Clock control register in Fast/Standard mode (Master mode)"]
pub struct CLKC_R(crate::FieldReader<u16, u16>);
impl CLKC_R {
    pub(crate) fn new(bits: u16) -> Self {
        CLKC_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CLKC_R {
    type Target = crate::FieldReader<u16, u16>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CLKC` writer - Clock control register in Fast/Standard mode (Master mode)"]
pub struct CLKC_W<'a> {
    w: &'a mut W,
}
impl<'a> CLKC_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u16) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x0fff) | (value as u32 & 0x0fff);
        self.w
    }
}
impl R {
    #[doc = "Bit 15 - I2C master mode selection"]
    #[inline(always)]
    pub fn fast(&self) -> FAST_R {
        FAST_R::new(((self.bits >> 15) & 0x01) != 0)
    }
    #[doc = "Bit 14 - Fast mode duty cycle"]
    #[inline(always)]
    pub fn dtcy(&self) -> DTCY_R {
        DTCY_R::new(((self.bits >> 14) & 0x01) != 0)
    }
    #[doc = "Bits 0:11 - Clock control register in Fast/Standard mode (Master mode)"]
    #[inline(always)]
    pub fn clkc(&self) -> CLKC_R {
        CLKC_R::new((self.bits & 0x0fff) as u16)
    }
}
impl W {
    #[doc = "Bit 15 - I2C master mode selection"]
    #[inline(always)]
    pub fn fast(&mut self) -> FAST_W {
        FAST_W { w: self }
    }
    #[doc = "Bit 14 - Fast mode duty cycle"]
    #[inline(always)]
    pub fn dtcy(&mut self) -> DTCY_W {
        DTCY_W { w: self }
    }
    #[doc = "Bits 0:11 - Clock control register in Fast/Standard mode (Master mode)"]
    #[inline(always)]
    pub fn clkc(&mut self) -> CLKC_W {
        CLKC_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Clock configure register\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [ckcfg](index.html) module"]
pub struct CKCFG_SPEC;
impl crate::RegisterSpec for CKCFG_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [ckcfg::R](R) reader structure"]
impl crate::Readable for CKCFG_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [ckcfg::W](W) writer structure"]
impl crate::Writable for CKCFG_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets CKCFG to value 0"]
impl crate::Resettable for CKCFG_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
