#[doc = "Register `CHCTL0_Input` reader"]
pub struct R(crate::R<CHCTL0_INPUT_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<CHCTL0_INPUT_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<CHCTL0_INPUT_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<CHCTL0_INPUT_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `CHCTL0_Input` writer"]
pub struct W(crate::W<CHCTL0_INPUT_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<CHCTL0_INPUT_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<CHCTL0_INPUT_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<CHCTL0_INPUT_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `CH1CAPFLT` reader - Input capture 1 filter"]
pub struct CH1CAPFLT_R(crate::FieldReader<u8, u8>);
impl CH1CAPFLT_R {
    pub(crate) fn new(bits: u8) -> Self {
        CH1CAPFLT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CH1CAPFLT_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CH1CAPFLT` writer - Input capture 1 filter"]
pub struct CH1CAPFLT_W<'a> {
    w: &'a mut W,
}
impl<'a> CH1CAPFLT_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 12)) | ((value as u32 & 0x0f) << 12);
        self.w
    }
}
#[doc = "Field `CH1CAPPSC` reader - Input capture 1 prescaler"]
pub struct CH1CAPPSC_R(crate::FieldReader<u8, u8>);
impl CH1CAPPSC_R {
    pub(crate) fn new(bits: u8) -> Self {
        CH1CAPPSC_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CH1CAPPSC_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CH1CAPPSC` writer - Input capture 1 prescaler"]
pub struct CH1CAPPSC_W<'a> {
    w: &'a mut W,
}
impl<'a> CH1CAPPSC_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 10)) | ((value as u32 & 0x03) << 10);
        self.w
    }
}
#[doc = "Field `CH1MS` reader - Capture/Compare 1 selection"]
pub struct CH1MS_R(crate::FieldReader<u8, u8>);
impl CH1MS_R {
    pub(crate) fn new(bits: u8) -> Self {
        CH1MS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CH1MS_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CH1MS` writer - Capture/Compare 1 selection"]
pub struct CH1MS_W<'a> {
    w: &'a mut W,
}
impl<'a> CH1MS_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 8)) | ((value as u32 & 0x03) << 8);
        self.w
    }
}
#[doc = "Field `CH0CAPFLT` reader - Input capture 0 filter"]
pub struct CH0CAPFLT_R(crate::FieldReader<u8, u8>);
impl CH0CAPFLT_R {
    pub(crate) fn new(bits: u8) -> Self {
        CH0CAPFLT_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CH0CAPFLT_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CH0CAPFLT` writer - Input capture 0 filter"]
pub struct CH0CAPFLT_W<'a> {
    w: &'a mut W,
}
impl<'a> CH0CAPFLT_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 4)) | ((value as u32 & 0x0f) << 4);
        self.w
    }
}
#[doc = "Field `CH0CAPPSC` reader - Input capture 0 prescaler"]
pub struct CH0CAPPSC_R(crate::FieldReader<u8, u8>);
impl CH0CAPPSC_R {
    pub(crate) fn new(bits: u8) -> Self {
        CH0CAPPSC_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CH0CAPPSC_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CH0CAPPSC` writer - Input capture 0 prescaler"]
pub struct CH0CAPPSC_W<'a> {
    w: &'a mut W,
}
impl<'a> CH0CAPPSC_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 2)) | ((value as u32 & 0x03) << 2);
        self.w
    }
}
#[doc = "Field `CH0MS` reader - Capture/Compare 0 selection"]
pub struct CH0MS_R(crate::FieldReader<u8, u8>);
impl CH0MS_R {
    pub(crate) fn new(bits: u8) -> Self {
        CH0MS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CH0MS_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CH0MS` writer - Capture/Compare 0 selection"]
pub struct CH0MS_W<'a> {
    w: &'a mut W,
}
impl<'a> CH0MS_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x03) | (value as u32 & 0x03);
        self.w
    }
}
impl R {
    #[doc = "Bits 12:15 - Input capture 1 filter"]
    #[inline(always)]
    pub fn ch1capflt(&self) -> CH1CAPFLT_R {
        CH1CAPFLT_R::new(((self.bits >> 12) & 0x0f) as u8)
    }
    #[doc = "Bits 10:11 - Input capture 1 prescaler"]
    #[inline(always)]
    pub fn ch1cappsc(&self) -> CH1CAPPSC_R {
        CH1CAPPSC_R::new(((self.bits >> 10) & 0x03) as u8)
    }
    #[doc = "Bits 8:9 - Capture/Compare 1 selection"]
    #[inline(always)]
    pub fn ch1ms(&self) -> CH1MS_R {
        CH1MS_R::new(((self.bits >> 8) & 0x03) as u8)
    }
    #[doc = "Bits 4:7 - Input capture 0 filter"]
    #[inline(always)]
    pub fn ch0capflt(&self) -> CH0CAPFLT_R {
        CH0CAPFLT_R::new(((self.bits >> 4) & 0x0f) as u8)
    }
    #[doc = "Bits 2:3 - Input capture 0 prescaler"]
    #[inline(always)]
    pub fn ch0cappsc(&self) -> CH0CAPPSC_R {
        CH0CAPPSC_R::new(((self.bits >> 2) & 0x03) as u8)
    }
    #[doc = "Bits 0:1 - Capture/Compare 0 selection"]
    #[inline(always)]
    pub fn ch0ms(&self) -> CH0MS_R {
        CH0MS_R::new((self.bits & 0x03) as u8)
    }
}
impl W {
    #[doc = "Bits 12:15 - Input capture 1 filter"]
    #[inline(always)]
    pub fn ch1capflt(&mut self) -> CH1CAPFLT_W {
        CH1CAPFLT_W { w: self }
    }
    #[doc = "Bits 10:11 - Input capture 1 prescaler"]
    #[inline(always)]
    pub fn ch1cappsc(&mut self) -> CH1CAPPSC_W {
        CH1CAPPSC_W { w: self }
    }
    #[doc = "Bits 8:9 - Capture/Compare 1 selection"]
    #[inline(always)]
    pub fn ch1ms(&mut self) -> CH1MS_W {
        CH1MS_W { w: self }
    }
    #[doc = "Bits 4:7 - Input capture 0 filter"]
    #[inline(always)]
    pub fn ch0capflt(&mut self) -> CH0CAPFLT_W {
        CH0CAPFLT_W { w: self }
    }
    #[doc = "Bits 2:3 - Input capture 0 prescaler"]
    #[inline(always)]
    pub fn ch0cappsc(&mut self) -> CH0CAPPSC_W {
        CH0CAPPSC_W { w: self }
    }
    #[doc = "Bits 0:1 - Capture/Compare 0 selection"]
    #[inline(always)]
    pub fn ch0ms(&mut self) -> CH0MS_W {
        CH0MS_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "capture/compare mode register 0 (input mode)\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [chctl0_input](index.html) module"]
pub struct CHCTL0_INPUT_SPEC;
impl crate::RegisterSpec for CHCTL0_INPUT_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [chctl0_input::R](R) reader structure"]
impl crate::Readable for CHCTL0_INPUT_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [chctl0_input::W](W) writer structure"]
impl crate::Writable for CHCTL0_INPUT_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets CHCTL0_Input to value 0"]
impl crate::Resettable for CHCTL0_INPUT_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
