#[doc = "Register `CFG0` reader"]
pub struct R(crate::R<CFG0_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<CFG0_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<CFG0_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<CFG0_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `CFG0` writer"]
pub struct W(crate::W<CFG0_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<CFG0_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<CFG0_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<CFG0_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `PLLDV` reader - The CK_PLL divide by 1 or 2 for CK_OUT"]
pub struct PLLDV_R(crate::FieldReader<bool, bool>);
impl PLLDV_R {
    pub(crate) fn new(bits: bool) -> Self {
        PLLDV_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PLLDV_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PLLDV` writer - The CK_PLL divide by 1 or 2 for CK_OUT"]
pub struct PLLDV_W<'a> {
    w: &'a mut W,
}
impl<'a> PLLDV_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 31)) | ((value as u32 & 0x01) << 31);
        self.w
    }
}
#[doc = "Field `CKOUTDIV` reader - The CK_OUT divider which the CK_OUT frequency can be reduced"]
pub struct CKOUTDIV_R(crate::FieldReader<u8, u8>);
impl CKOUTDIV_R {
    pub(crate) fn new(bits: u8) -> Self {
        CKOUTDIV_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CKOUTDIV_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CKOUTDIV` writer - The CK_OUT divider which the CK_OUT frequency can be reduced"]
pub struct CKOUTDIV_W<'a> {
    w: &'a mut W,
}
impl<'a> CKOUTDIV_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 28)) | ((value as u32 & 0x07) << 28);
        self.w
    }
}
#[doc = "Field `PLLMF_MSB` reader - Bit 4 of PLLMF register"]
pub struct PLLMF_MSB_R(crate::FieldReader<bool, bool>);
impl PLLMF_MSB_R {
    pub(crate) fn new(bits: bool) -> Self {
        PLLMF_MSB_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PLLMF_MSB_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PLLMF_MSB` writer - Bit 4 of PLLMF register"]
pub struct PLLMF_MSB_W<'a> {
    w: &'a mut W,
}
impl<'a> PLLMF_MSB_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 27)) | ((value as u32 & 0x01) << 27);
        self.w
    }
}
#[doc = "Field `CKOUTSEL` reader - CK_OUT Clock Source Selection"]
pub struct CKOUTSEL_R(crate::FieldReader<u8, u8>);
impl CKOUTSEL_R {
    pub(crate) fn new(bits: u8) -> Self {
        CKOUTSEL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for CKOUTSEL_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `CKOUTSEL` writer - CK_OUT Clock Source Selection"]
pub struct CKOUTSEL_W<'a> {
    w: &'a mut W,
}
impl<'a> CKOUTSEL_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 24)) | ((value as u32 & 0x07) << 24);
        self.w
    }
}
#[doc = "Field `PLLMF` reader - PLL multiply factor"]
pub struct PLLMF_R(crate::FieldReader<u8, u8>);
impl PLLMF_R {
    pub(crate) fn new(bits: u8) -> Self {
        PLLMF_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PLLMF_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PLLMF` writer - PLL multiply factor"]
pub struct PLLMF_W<'a> {
    w: &'a mut W,
}
impl<'a> PLLMF_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 18)) | ((value as u32 & 0x0f) << 18);
        self.w
    }
}
#[doc = "Field `PLLPREDV` reader - HXTAL divider for PLL source clock selection."]
pub struct PLLPREDV_R(crate::FieldReader<bool, bool>);
impl PLLPREDV_R {
    pub(crate) fn new(bits: bool) -> Self {
        PLLPREDV_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PLLPREDV_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PLLPREDV` writer - HXTAL divider for PLL source clock selection."]
pub struct PLLPREDV_W<'a> {
    w: &'a mut W,
}
impl<'a> PLLPREDV_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 17)) | ((value as u32 & 0x01) << 17);
        self.w
    }
}
#[doc = "Field `PLLSEL` reader - PLL Clock Source Selection"]
pub struct PLLSEL_R(crate::FieldReader<bool, bool>);
impl PLLSEL_R {
    pub(crate) fn new(bits: bool) -> Self {
        PLLSEL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for PLLSEL_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `PLLSEL` writer - PLL Clock Source Selection"]
pub struct PLLSEL_W<'a> {
    w: &'a mut W,
}
impl<'a> PLLSEL_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 16)) | ((value as u32 & 0x01) << 16);
        self.w
    }
}
#[doc = "Field `ADCPSC` reader - ADC clock prescaler selection"]
pub struct ADCPSC_R(crate::FieldReader<u8, u8>);
impl ADCPSC_R {
    pub(crate) fn new(bits: u8) -> Self {
        ADCPSC_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for ADCPSC_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `ADCPSC` writer - ADC clock prescaler selection"]
pub struct ADCPSC_W<'a> {
    w: &'a mut W,
}
impl<'a> ADCPSC_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 14)) | ((value as u32 & 0x03) << 14);
        self.w
    }
}
#[doc = "Field `APB2PSC` reader - APB2 prescaler selection"]
pub struct APB2PSC_R(crate::FieldReader<u8, u8>);
impl APB2PSC_R {
    pub(crate) fn new(bits: u8) -> Self {
        APB2PSC_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for APB2PSC_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `APB2PSC` writer - APB2 prescaler selection"]
pub struct APB2PSC_W<'a> {
    w: &'a mut W,
}
impl<'a> APB2PSC_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 11)) | ((value as u32 & 0x07) << 11);
        self.w
    }
}
#[doc = "Field `APB1PSC` reader - APB1 prescaler selection"]
pub struct APB1PSC_R(crate::FieldReader<u8, u8>);
impl APB1PSC_R {
    pub(crate) fn new(bits: u8) -> Self {
        APB1PSC_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for APB1PSC_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `APB1PSC` writer - APB1 prescaler selection"]
pub struct APB1PSC_W<'a> {
    w: &'a mut W,
}
impl<'a> APB1PSC_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x07 << 8)) | ((value as u32 & 0x07) << 8);
        self.w
    }
}
#[doc = "Field `AHBPSC` reader - AHB prescaler selection"]
pub struct AHBPSC_R(crate::FieldReader<u8, u8>);
impl AHBPSC_R {
    pub(crate) fn new(bits: u8) -> Self {
        AHBPSC_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for AHBPSC_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `AHBPSC` writer - AHB prescaler selection"]
pub struct AHBPSC_W<'a> {
    w: &'a mut W,
}
impl<'a> AHBPSC_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 4)) | ((value as u32 & 0x0f) << 4);
        self.w
    }
}
#[doc = "Field `SCSS` reader - System clock switch status"]
pub struct SCSS_R(crate::FieldReader<u8, u8>);
impl SCSS_R {
    pub(crate) fn new(bits: u8) -> Self {
        SCSS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SCSS_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SCS` reader - System clock switch"]
pub struct SCS_R(crate::FieldReader<u8, u8>);
impl SCS_R {
    pub(crate) fn new(bits: u8) -> Self {
        SCS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for SCS_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `SCS` writer - System clock switch"]
pub struct SCS_W<'a> {
    w: &'a mut W,
}
impl<'a> SCS_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x03) | (value as u32 & 0x03);
        self.w
    }
}
impl R {
    #[doc = "Bit 31 - The CK_PLL divide by 1 or 2 for CK_OUT"]
    #[inline(always)]
    pub fn plldv(&self) -> PLLDV_R {
        PLLDV_R::new(((self.bits >> 31) & 0x01) != 0)
    }
    #[doc = "Bits 28:30 - The CK_OUT divider which the CK_OUT frequency can be reduced"]
    #[inline(always)]
    pub fn ckoutdiv(&self) -> CKOUTDIV_R {
        CKOUTDIV_R::new(((self.bits >> 28) & 0x07) as u8)
    }
    #[doc = "Bit 27 - Bit 4 of PLLMF register"]
    #[inline(always)]
    pub fn pllmf_msb(&self) -> PLLMF_MSB_R {
        PLLMF_MSB_R::new(((self.bits >> 27) & 0x01) != 0)
    }
    #[doc = "Bits 24:26 - CK_OUT Clock Source Selection"]
    #[inline(always)]
    pub fn ckoutsel(&self) -> CKOUTSEL_R {
        CKOUTSEL_R::new(((self.bits >> 24) & 0x07) as u8)
    }
    #[doc = "Bits 18:21 - PLL multiply factor"]
    #[inline(always)]
    pub fn pllmf(&self) -> PLLMF_R {
        PLLMF_R::new(((self.bits >> 18) & 0x0f) as u8)
    }
    #[doc = "Bit 17 - HXTAL divider for PLL source clock selection."]
    #[inline(always)]
    pub fn pllpredv(&self) -> PLLPREDV_R {
        PLLPREDV_R::new(((self.bits >> 17) & 0x01) != 0)
    }
    #[doc = "Bit 16 - PLL Clock Source Selection"]
    #[inline(always)]
    pub fn pllsel(&self) -> PLLSEL_R {
        PLLSEL_R::new(((self.bits >> 16) & 0x01) != 0)
    }
    #[doc = "Bits 14:15 - ADC clock prescaler selection"]
    #[inline(always)]
    pub fn adcpsc(&self) -> ADCPSC_R {
        ADCPSC_R::new(((self.bits >> 14) & 0x03) as u8)
    }
    #[doc = "Bits 11:13 - APB2 prescaler selection"]
    #[inline(always)]
    pub fn apb2psc(&self) -> APB2PSC_R {
        APB2PSC_R::new(((self.bits >> 11) & 0x07) as u8)
    }
    #[doc = "Bits 8:10 - APB1 prescaler selection"]
    #[inline(always)]
    pub fn apb1psc(&self) -> APB1PSC_R {
        APB1PSC_R::new(((self.bits >> 8) & 0x07) as u8)
    }
    #[doc = "Bits 4:7 - AHB prescaler selection"]
    #[inline(always)]
    pub fn ahbpsc(&self) -> AHBPSC_R {
        AHBPSC_R::new(((self.bits >> 4) & 0x0f) as u8)
    }
    #[doc = "Bits 2:3 - System clock switch status"]
    #[inline(always)]
    pub fn scss(&self) -> SCSS_R {
        SCSS_R::new(((self.bits >> 2) & 0x03) as u8)
    }
    #[doc = "Bits 0:1 - System clock switch"]
    #[inline(always)]
    pub fn scs(&self) -> SCS_R {
        SCS_R::new((self.bits & 0x03) as u8)
    }
}
impl W {
    #[doc = "Bit 31 - The CK_PLL divide by 1 or 2 for CK_OUT"]
    #[inline(always)]
    pub fn plldv(&mut self) -> PLLDV_W {
        PLLDV_W { w: self }
    }
    #[doc = "Bits 28:30 - The CK_OUT divider which the CK_OUT frequency can be reduced"]
    #[inline(always)]
    pub fn ckoutdiv(&mut self) -> CKOUTDIV_W {
        CKOUTDIV_W { w: self }
    }
    #[doc = "Bit 27 - Bit 4 of PLLMF register"]
    #[inline(always)]
    pub fn pllmf_msb(&mut self) -> PLLMF_MSB_W {
        PLLMF_MSB_W { w: self }
    }
    #[doc = "Bits 24:26 - CK_OUT Clock Source Selection"]
    #[inline(always)]
    pub fn ckoutsel(&mut self) -> CKOUTSEL_W {
        CKOUTSEL_W { w: self }
    }
    #[doc = "Bits 18:21 - PLL multiply factor"]
    #[inline(always)]
    pub fn pllmf(&mut self) -> PLLMF_W {
        PLLMF_W { w: self }
    }
    #[doc = "Bit 17 - HXTAL divider for PLL source clock selection."]
    #[inline(always)]
    pub fn pllpredv(&mut self) -> PLLPREDV_W {
        PLLPREDV_W { w: self }
    }
    #[doc = "Bit 16 - PLL Clock Source Selection"]
    #[inline(always)]
    pub fn pllsel(&mut self) -> PLLSEL_W {
        PLLSEL_W { w: self }
    }
    #[doc = "Bits 14:15 - ADC clock prescaler selection"]
    #[inline(always)]
    pub fn adcpsc(&mut self) -> ADCPSC_W {
        ADCPSC_W { w: self }
    }
    #[doc = "Bits 11:13 - APB2 prescaler selection"]
    #[inline(always)]
    pub fn apb2psc(&mut self) -> APB2PSC_W {
        APB2PSC_W { w: self }
    }
    #[doc = "Bits 8:10 - APB1 prescaler selection"]
    #[inline(always)]
    pub fn apb1psc(&mut self) -> APB1PSC_W {
        APB1PSC_W { w: self }
    }
    #[doc = "Bits 4:7 - AHB prescaler selection"]
    #[inline(always)]
    pub fn ahbpsc(&mut self) -> AHBPSC_W {
        AHBPSC_W { w: self }
    }
    #[doc = "Bits 0:1 - System clock switch"]
    #[inline(always)]
    pub fn scs(&mut self) -> SCS_W {
        SCS_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Clock configuration register 0 (RCU_CFG0)\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [cfg0](index.html) module"]
pub struct CFG0_SPEC;
impl crate::RegisterSpec for CFG0_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [cfg0::R](R) reader structure"]
impl crate::Readable for CFG0_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [cfg0::W](W) writer structure"]
impl crate::Writable for CFG0_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets CFG0 to value 0"]
impl crate::Resettable for CFG0_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
