#[doc = "Register `BDCTL` reader"]
pub struct R(crate::R<BDCTL_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<BDCTL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<BDCTL_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<BDCTL_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `BDCTL` writer"]
pub struct W(crate::W<BDCTL_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<BDCTL_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<BDCTL_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<BDCTL_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `BKPRST` reader - Backup domain reset"]
pub struct BKPRST_R(crate::FieldReader<bool, bool>);
impl BKPRST_R {
    pub(crate) fn new(bits: bool) -> Self {
        BKPRST_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for BKPRST_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `BKPRST` writer - Backup domain reset"]
pub struct BKPRST_W<'a> {
    w: &'a mut W,
}
impl<'a> BKPRST_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 16)) | ((value as u32 & 0x01) << 16);
        self.w
    }
}
#[doc = "Field `RTCEN` reader - RTC clock enable"]
pub struct RTCEN_R(crate::FieldReader<bool, bool>);
impl RTCEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        RTCEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RTCEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RTCEN` writer - RTC clock enable"]
pub struct RTCEN_W<'a> {
    w: &'a mut W,
}
impl<'a> RTCEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 15)) | ((value as u32 & 0x01) << 15);
        self.w
    }
}
#[doc = "Field `RTCSRC` reader - RTC clock entry selection"]
pub struct RTCSRC_R(crate::FieldReader<u8, u8>);
impl RTCSRC_R {
    pub(crate) fn new(bits: u8) -> Self {
        RTCSRC_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RTCSRC_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RTCSRC` writer - RTC clock entry selection"]
pub struct RTCSRC_W<'a> {
    w: &'a mut W,
}
impl<'a> RTCSRC_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 8)) | ((value as u32 & 0x03) << 8);
        self.w
    }
}
#[doc = "Field `LXTALDRI` reader - LXTAL drive capability"]
pub struct LXTALDRI_R(crate::FieldReader<u8, u8>);
impl LXTALDRI_R {
    pub(crate) fn new(bits: u8) -> Self {
        LXTALDRI_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LXTALDRI_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LXTALDRI` writer - LXTAL drive capability"]
pub struct LXTALDRI_W<'a> {
    w: &'a mut W,
}
impl<'a> LXTALDRI_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x03 << 3)) | ((value as u32 & 0x03) << 3);
        self.w
    }
}
#[doc = "Field `LXTALBPS` reader - LXTAL bypass mode enable"]
pub struct LXTALBPS_R(crate::FieldReader<bool, bool>);
impl LXTALBPS_R {
    pub(crate) fn new(bits: bool) -> Self {
        LXTALBPS_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LXTALBPS_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LXTALBPS` writer - LXTAL bypass mode enable"]
pub struct LXTALBPS_W<'a> {
    w: &'a mut W,
}
impl<'a> LXTALBPS_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u32 & 0x01) << 2);
        self.w
    }
}
#[doc = "Field `LXTALSTB` reader - External low-speed oscillator stabilization"]
pub struct LXTALSTB_R(crate::FieldReader<bool, bool>);
impl LXTALSTB_R {
    pub(crate) fn new(bits: bool) -> Self {
        LXTALSTB_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LXTALSTB_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LXTALEN` reader - LXTAL enable"]
pub struct LXTALEN_R(crate::FieldReader<bool, bool>);
impl LXTALEN_R {
    pub(crate) fn new(bits: bool) -> Self {
        LXTALEN_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for LXTALEN_R {
    type Target = crate::FieldReader<bool, bool>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `LXTALEN` writer - LXTAL enable"]
pub struct LXTALEN_W<'a> {
    w: &'a mut W,
}
impl<'a> LXTALEN_W<'a> {
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
impl R {
    #[doc = "Bit 16 - Backup domain reset"]
    #[inline(always)]
    pub fn bkprst(&self) -> BKPRST_R {
        BKPRST_R::new(((self.bits >> 16) & 0x01) != 0)
    }
    #[doc = "Bit 15 - RTC clock enable"]
    #[inline(always)]
    pub fn rtcen(&self) -> RTCEN_R {
        RTCEN_R::new(((self.bits >> 15) & 0x01) != 0)
    }
    #[doc = "Bits 8:9 - RTC clock entry selection"]
    #[inline(always)]
    pub fn rtcsrc(&self) -> RTCSRC_R {
        RTCSRC_R::new(((self.bits >> 8) & 0x03) as u8)
    }
    #[doc = "Bits 3:4 - LXTAL drive capability"]
    #[inline(always)]
    pub fn lxtaldri(&self) -> LXTALDRI_R {
        LXTALDRI_R::new(((self.bits >> 3) & 0x03) as u8)
    }
    #[doc = "Bit 2 - LXTAL bypass mode enable"]
    #[inline(always)]
    pub fn lxtalbps(&self) -> LXTALBPS_R {
        LXTALBPS_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 1 - External low-speed oscillator stabilization"]
    #[inline(always)]
    pub fn lxtalstb(&self) -> LXTALSTB_R {
        LXTALSTB_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 0 - LXTAL enable"]
    #[inline(always)]
    pub fn lxtalen(&self) -> LXTALEN_R {
        LXTALEN_R::new((self.bits & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 16 - Backup domain reset"]
    #[inline(always)]
    pub fn bkprst(&mut self) -> BKPRST_W {
        BKPRST_W { w: self }
    }
    #[doc = "Bit 15 - RTC clock enable"]
    #[inline(always)]
    pub fn rtcen(&mut self) -> RTCEN_W {
        RTCEN_W { w: self }
    }
    #[doc = "Bits 8:9 - RTC clock entry selection"]
    #[inline(always)]
    pub fn rtcsrc(&mut self) -> RTCSRC_W {
        RTCSRC_W { w: self }
    }
    #[doc = "Bits 3:4 - LXTAL drive capability"]
    #[inline(always)]
    pub fn lxtaldri(&mut self) -> LXTALDRI_W {
        LXTALDRI_W { w: self }
    }
    #[doc = "Bit 2 - LXTAL bypass mode enable"]
    #[inline(always)]
    pub fn lxtalbps(&mut self) -> LXTALBPS_W {
        LXTALBPS_W { w: self }
    }
    #[doc = "Bit 0 - LXTAL enable"]
    #[inline(always)]
    pub fn lxtalen(&mut self) -> LXTALEN_W {
        LXTALEN_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Backup domain control register (RCU_BDCTL)\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [bdctl](index.html) module"]
pub struct BDCTL_SPEC;
impl crate::RegisterSpec for BDCTL_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [bdctl::R](R) reader structure"]
impl crate::Readable for BDCTL_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [bdctl::W](W) writer structure"]
impl crate::Writable for BDCTL_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets BDCTL to value 0x18"]
impl crate::Resettable for BDCTL_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0x18
    }
}
