#[doc = "Register `INTEN` reader"]
pub struct R(crate::R<INTEN_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<INTEN_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<INTEN_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<INTEN_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `INTEN` writer"]
pub struct W(crate::W<INTEN_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<INTEN_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<INTEN_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<INTEN_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Enable Interrupt on line 0\n\nValue on reset: 0"]
#[derive(Clone, Copy, Debug, PartialEq)]
pub enum INTEN0_A {
    #[doc = "0: Interrupt from line is disabled"]
    MASKED = 0,
    #[doc = "1: Interrupt from line is enabled"]
    UNMASKED = 1,
}
impl From<INTEN0_A> for bool {
    #[inline(always)]
    fn from(variant: INTEN0_A) -> Self {
        variant as u8 != 0
    }
}
#[doc = "Field `INTEN0` reader - Enable Interrupt on line 0"]
pub struct INTEN0_R(crate::FieldReader<bool, INTEN0_A>);
impl INTEN0_R {
    pub(crate) fn new(bits: bool) -> Self {
        INTEN0_R(crate::FieldReader::new(bits))
    }
    #[doc = r"Get enumerated values variant"]
    #[inline(always)]
    pub fn variant(&self) -> INTEN0_A {
        match self.bits {
            false => INTEN0_A::MASKED,
            true => INTEN0_A::UNMASKED,
        }
    }
    #[doc = "Checks if the value of the field is `MASKED`"]
    #[inline(always)]
    pub fn is_masked(&self) -> bool {
        **self == INTEN0_A::MASKED
    }
    #[doc = "Checks if the value of the field is `UNMASKED`"]
    #[inline(always)]
    pub fn is_unmasked(&self) -> bool {
        **self == INTEN0_A::UNMASKED
    }
}
impl core::ops::Deref for INTEN0_R {
    type Target = crate::FieldReader<bool, INTEN0_A>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `INTEN0` writer - Enable Interrupt on line 0"]
pub struct INTEN0_W<'a> {
    w: &'a mut W,
}
impl<'a> INTEN0_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: INTEN0_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Interrupt from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(INTEN0_A::MASKED)
    }
    #[doc = "Interrupt from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(INTEN0_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x01) | (value as u32 & 0x01);
        self.w
    }
}
#[doc = "Enable Interrupt on line 1"]
pub type INTEN1_A = INTEN0_A;
#[doc = "Field `INTEN1` reader - Enable Interrupt on line 1"]
pub type INTEN1_R = INTEN0_R;
#[doc = "Field `INTEN1` writer - Enable Interrupt on line 1"]
pub struct INTEN1_W<'a> {
    w: &'a mut W,
}
impl<'a> INTEN1_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: INTEN1_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Interrupt from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(INTEN1_A::MASKED)
    }
    #[doc = "Interrupt from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(INTEN1_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 1)) | ((value as u32 & 0x01) << 1);
        self.w
    }
}
#[doc = "Enable Interrupt on line 2"]
pub type INTEN2_A = INTEN0_A;
#[doc = "Field `INTEN2` reader - Enable Interrupt on line 2"]
pub type INTEN2_R = INTEN0_R;
#[doc = "Field `INTEN2` writer - Enable Interrupt on line 2"]
pub struct INTEN2_W<'a> {
    w: &'a mut W,
}
impl<'a> INTEN2_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: INTEN2_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Interrupt from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(INTEN2_A::MASKED)
    }
    #[doc = "Interrupt from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(INTEN2_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 2)) | ((value as u32 & 0x01) << 2);
        self.w
    }
}
#[doc = "Enable Interrupt on line 3"]
pub type INTEN3_A = INTEN0_A;
#[doc = "Field `INTEN3` reader - Enable Interrupt on line 3"]
pub type INTEN3_R = INTEN0_R;
#[doc = "Field `INTEN3` writer - Enable Interrupt on line 3"]
pub struct INTEN3_W<'a> {
    w: &'a mut W,
}
impl<'a> INTEN3_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: INTEN3_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Interrupt from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(INTEN3_A::MASKED)
    }
    #[doc = "Interrupt from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(INTEN3_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 3)) | ((value as u32 & 0x01) << 3);
        self.w
    }
}
#[doc = "Enable Interrupt on line 4"]
pub type INTEN4_A = INTEN0_A;
#[doc = "Field `INTEN4` reader - Enable Interrupt on line 4"]
pub type INTEN4_R = INTEN0_R;
#[doc = "Field `INTEN4` writer - Enable Interrupt on line 4"]
pub struct INTEN4_W<'a> {
    w: &'a mut W,
}
impl<'a> INTEN4_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: INTEN4_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Interrupt from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(INTEN4_A::MASKED)
    }
    #[doc = "Interrupt from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(INTEN4_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 4)) | ((value as u32 & 0x01) << 4);
        self.w
    }
}
#[doc = "Enable Interrupt on line 5"]
pub type INTEN5_A = INTEN0_A;
#[doc = "Field `INTEN5` reader - Enable Interrupt on line 5"]
pub type INTEN5_R = INTEN0_R;
#[doc = "Field `INTEN5` writer - Enable Interrupt on line 5"]
pub struct INTEN5_W<'a> {
    w: &'a mut W,
}
impl<'a> INTEN5_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: INTEN5_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Interrupt from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(INTEN5_A::MASKED)
    }
    #[doc = "Interrupt from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(INTEN5_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 5)) | ((value as u32 & 0x01) << 5);
        self.w
    }
}
#[doc = "Enable Interrupt on line 6"]
pub type INTEN6_A = INTEN0_A;
#[doc = "Field `INTEN6` reader - Enable Interrupt on line 6"]
pub type INTEN6_R = INTEN0_R;
#[doc = "Field `INTEN6` writer - Enable Interrupt on line 6"]
pub struct INTEN6_W<'a> {
    w: &'a mut W,
}
impl<'a> INTEN6_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: INTEN6_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Interrupt from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(INTEN6_A::MASKED)
    }
    #[doc = "Interrupt from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(INTEN6_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 6)) | ((value as u32 & 0x01) << 6);
        self.w
    }
}
#[doc = "Enable Interrupt on line 7"]
pub type INTEN7_A = INTEN0_A;
#[doc = "Field `INTEN7` reader - Enable Interrupt on line 7"]
pub type INTEN7_R = INTEN0_R;
#[doc = "Field `INTEN7` writer - Enable Interrupt on line 7"]
pub struct INTEN7_W<'a> {
    w: &'a mut W,
}
impl<'a> INTEN7_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: INTEN7_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Interrupt from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(INTEN7_A::MASKED)
    }
    #[doc = "Interrupt from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(INTEN7_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 7)) | ((value as u32 & 0x01) << 7);
        self.w
    }
}
#[doc = "Enable Interrupt on line 8"]
pub type INTEN8_A = INTEN0_A;
#[doc = "Field `INTEN8` reader - Enable Interrupt on line 8"]
pub type INTEN8_R = INTEN0_R;
#[doc = "Field `INTEN8` writer - Enable Interrupt on line 8"]
pub struct INTEN8_W<'a> {
    w: &'a mut W,
}
impl<'a> INTEN8_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: INTEN8_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Interrupt from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(INTEN8_A::MASKED)
    }
    #[doc = "Interrupt from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(INTEN8_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 8)) | ((value as u32 & 0x01) << 8);
        self.w
    }
}
#[doc = "Enable Interrupt on line 9"]
pub type INTEN9_A = INTEN0_A;
#[doc = "Field `INTEN9` reader - Enable Interrupt on line 9"]
pub type INTEN9_R = INTEN0_R;
#[doc = "Field `INTEN9` writer - Enable Interrupt on line 9"]
pub struct INTEN9_W<'a> {
    w: &'a mut W,
}
impl<'a> INTEN9_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: INTEN9_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Interrupt from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(INTEN9_A::MASKED)
    }
    #[doc = "Interrupt from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(INTEN9_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 9)) | ((value as u32 & 0x01) << 9);
        self.w
    }
}
#[doc = "Enable Interrupt on line 10"]
pub type INTEN10_A = INTEN0_A;
#[doc = "Field `INTEN10` reader - Enable Interrupt on line 10"]
pub type INTEN10_R = INTEN0_R;
#[doc = "Field `INTEN10` writer - Enable Interrupt on line 10"]
pub struct INTEN10_W<'a> {
    w: &'a mut W,
}
impl<'a> INTEN10_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: INTEN10_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Interrupt from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(INTEN10_A::MASKED)
    }
    #[doc = "Interrupt from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(INTEN10_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 10)) | ((value as u32 & 0x01) << 10);
        self.w
    }
}
#[doc = "Enable Interrupt on line 11"]
pub type INTEN11_A = INTEN0_A;
#[doc = "Field `INTEN11` reader - Enable Interrupt on line 11"]
pub type INTEN11_R = INTEN0_R;
#[doc = "Field `INTEN11` writer - Enable Interrupt on line 11"]
pub struct INTEN11_W<'a> {
    w: &'a mut W,
}
impl<'a> INTEN11_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: INTEN11_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Interrupt from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(INTEN11_A::MASKED)
    }
    #[doc = "Interrupt from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(INTEN11_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 11)) | ((value as u32 & 0x01) << 11);
        self.w
    }
}
#[doc = "Enable Interrupt on line 12"]
pub type INTEN12_A = INTEN0_A;
#[doc = "Field `INTEN12` reader - Enable Interrupt on line 12"]
pub type INTEN12_R = INTEN0_R;
#[doc = "Field `INTEN12` writer - Enable Interrupt on line 12"]
pub struct INTEN12_W<'a> {
    w: &'a mut W,
}
impl<'a> INTEN12_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: INTEN12_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Interrupt from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(INTEN12_A::MASKED)
    }
    #[doc = "Interrupt from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(INTEN12_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 12)) | ((value as u32 & 0x01) << 12);
        self.w
    }
}
#[doc = "Enable Interrupt on line 13"]
pub type INTEN13_A = INTEN0_A;
#[doc = "Field `INTEN13` reader - Enable Interrupt on line 13"]
pub type INTEN13_R = INTEN0_R;
#[doc = "Field `INTEN13` writer - Enable Interrupt on line 13"]
pub struct INTEN13_W<'a> {
    w: &'a mut W,
}
impl<'a> INTEN13_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: INTEN13_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Interrupt from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(INTEN13_A::MASKED)
    }
    #[doc = "Interrupt from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(INTEN13_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 13)) | ((value as u32 & 0x01) << 13);
        self.w
    }
}
#[doc = "Enable Interrupt on line 14"]
pub type INTEN14_A = INTEN0_A;
#[doc = "Field `INTEN14` reader - Enable Interrupt on line 14"]
pub type INTEN14_R = INTEN0_R;
#[doc = "Field `INTEN14` writer - Enable Interrupt on line 14"]
pub struct INTEN14_W<'a> {
    w: &'a mut W,
}
impl<'a> INTEN14_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: INTEN14_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Interrupt from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(INTEN14_A::MASKED)
    }
    #[doc = "Interrupt from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(INTEN14_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 14)) | ((value as u32 & 0x01) << 14);
        self.w
    }
}
#[doc = "Enable Interrupt on line 15"]
pub type INTEN15_A = INTEN0_A;
#[doc = "Field `INTEN15` reader - Enable Interrupt on line 15"]
pub type INTEN15_R = INTEN0_R;
#[doc = "Field `INTEN15` writer - Enable Interrupt on line 15"]
pub struct INTEN15_W<'a> {
    w: &'a mut W,
}
impl<'a> INTEN15_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: INTEN15_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Interrupt from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(INTEN15_A::MASKED)
    }
    #[doc = "Interrupt from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(INTEN15_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 15)) | ((value as u32 & 0x01) << 15);
        self.w
    }
}
#[doc = "Enable Interrupt on line 16"]
pub type INTEN16_A = INTEN0_A;
#[doc = "Field `INTEN16` reader - Enable Interrupt on line 16"]
pub type INTEN16_R = INTEN0_R;
#[doc = "Field `INTEN16` writer - Enable Interrupt on line 16"]
pub struct INTEN16_W<'a> {
    w: &'a mut W,
}
impl<'a> INTEN16_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: INTEN16_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Interrupt from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(INTEN16_A::MASKED)
    }
    #[doc = "Interrupt from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(INTEN16_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 16)) | ((value as u32 & 0x01) << 16);
        self.w
    }
}
#[doc = "Enable Interrupt on line 17"]
pub type INTEN17_A = INTEN0_A;
#[doc = "Field `INTEN17` reader - Enable Interrupt on line 17"]
pub type INTEN17_R = INTEN0_R;
#[doc = "Field `INTEN17` writer - Enable Interrupt on line 17"]
pub struct INTEN17_W<'a> {
    w: &'a mut W,
}
impl<'a> INTEN17_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: INTEN17_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Interrupt from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(INTEN17_A::MASKED)
    }
    #[doc = "Interrupt from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(INTEN17_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 17)) | ((value as u32 & 0x01) << 17);
        self.w
    }
}
#[doc = "Enable Interrupt on line 18"]
pub type INTEN18_A = INTEN0_A;
#[doc = "Field `INTEN18` reader - Enable Interrupt on line 18"]
pub type INTEN18_R = INTEN0_R;
#[doc = "Field `INTEN18` writer - Enable Interrupt on line 18"]
pub struct INTEN18_W<'a> {
    w: &'a mut W,
}
impl<'a> INTEN18_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: INTEN18_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Interrupt from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(INTEN18_A::MASKED)
    }
    #[doc = "Interrupt from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(INTEN18_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 18)) | ((value as u32 & 0x01) << 18);
        self.w
    }
}
#[doc = "Enable Interrupt on line 19"]
pub type INTEN19_A = INTEN0_A;
#[doc = "Field `INTEN19` reader - Enable Interrupt on line 19"]
pub type INTEN19_R = INTEN0_R;
#[doc = "Field `INTEN19` writer - Enable Interrupt on line 19"]
pub struct INTEN19_W<'a> {
    w: &'a mut W,
}
impl<'a> INTEN19_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: INTEN19_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Interrupt from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(INTEN19_A::MASKED)
    }
    #[doc = "Interrupt from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(INTEN19_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 19)) | ((value as u32 & 0x01) << 19);
        self.w
    }
}
#[doc = "Enable Interrupt on line 20"]
pub type INTEN20_A = INTEN0_A;
#[doc = "Field `INTEN20` reader - Enable Interrupt on line 20"]
pub type INTEN20_R = INTEN0_R;
#[doc = "Field `INTEN20` writer - Enable Interrupt on line 20"]
pub struct INTEN20_W<'a> {
    w: &'a mut W,
}
impl<'a> INTEN20_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: INTEN20_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Interrupt from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(INTEN20_A::MASKED)
    }
    #[doc = "Interrupt from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(INTEN20_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 20)) | ((value as u32 & 0x01) << 20);
        self.w
    }
}
#[doc = "Enable Interrupt on line 21"]
pub type INTEN21_A = INTEN0_A;
#[doc = "Field `INTEN21` reader - Enable Interrupt on line 21"]
pub type INTEN21_R = INTEN0_R;
#[doc = "Field `INTEN21` writer - Enable Interrupt on line 21"]
pub struct INTEN21_W<'a> {
    w: &'a mut W,
}
impl<'a> INTEN21_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: INTEN21_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Interrupt from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(INTEN21_A::MASKED)
    }
    #[doc = "Interrupt from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(INTEN21_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 21)) | ((value as u32 & 0x01) << 21);
        self.w
    }
}
#[doc = "Enable Interrupt on line 22"]
pub type INTEN22_A = INTEN0_A;
#[doc = "Field `INTEN22` reader - Enable Interrupt on line 22"]
pub type INTEN22_R = INTEN0_R;
#[doc = "Field `INTEN22` writer - Enable Interrupt on line 22"]
pub struct INTEN22_W<'a> {
    w: &'a mut W,
}
impl<'a> INTEN22_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: INTEN22_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Interrupt from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(INTEN22_A::MASKED)
    }
    #[doc = "Interrupt from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(INTEN22_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 22)) | ((value as u32 & 0x01) << 22);
        self.w
    }
}
#[doc = "Enable Interrupt on line 23"]
pub type INTEN23_A = INTEN0_A;
#[doc = "Field `INTEN23` reader - Enable Interrupt on line 23"]
pub type INTEN23_R = INTEN0_R;
#[doc = "Field `INTEN23` writer - Enable Interrupt on line 23"]
pub struct INTEN23_W<'a> {
    w: &'a mut W,
}
impl<'a> INTEN23_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: INTEN23_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Interrupt from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(INTEN23_A::MASKED)
    }
    #[doc = "Interrupt from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(INTEN23_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 23)) | ((value as u32 & 0x01) << 23);
        self.w
    }
}
#[doc = "Enable Interrupt on line 24"]
pub type INTEN24_A = INTEN0_A;
#[doc = "Field `INTEN24` reader - Enable Interrupt on line 24"]
pub type INTEN24_R = INTEN0_R;
#[doc = "Field `INTEN24` writer - Enable Interrupt on line 24"]
pub struct INTEN24_W<'a> {
    w: &'a mut W,
}
impl<'a> INTEN24_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: INTEN24_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Interrupt from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(INTEN24_A::MASKED)
    }
    #[doc = "Interrupt from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(INTEN24_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 24)) | ((value as u32 & 0x01) << 24);
        self.w
    }
}
#[doc = "Enable Interrupt on line 25"]
pub type INTEN25_A = INTEN0_A;
#[doc = "Field `INTEN25` reader - Enable Interrupt on line 25"]
pub type INTEN25_R = INTEN0_R;
#[doc = "Field `INTEN25` writer - Enable Interrupt on line 25"]
pub struct INTEN25_W<'a> {
    w: &'a mut W,
}
impl<'a> INTEN25_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: INTEN25_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Interrupt from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(INTEN25_A::MASKED)
    }
    #[doc = "Interrupt from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(INTEN25_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 25)) | ((value as u32 & 0x01) << 25);
        self.w
    }
}
#[doc = "Enable Interrupt on line 26"]
pub type INTEN26_A = INTEN0_A;
#[doc = "Field `INTEN26` reader - Enable Interrupt on line 26"]
pub type INTEN26_R = INTEN0_R;
#[doc = "Field `INTEN26` writer - Enable Interrupt on line 26"]
pub struct INTEN26_W<'a> {
    w: &'a mut W,
}
impl<'a> INTEN26_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: INTEN26_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Interrupt from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(INTEN26_A::MASKED)
    }
    #[doc = "Interrupt from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(INTEN26_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 26)) | ((value as u32 & 0x01) << 26);
        self.w
    }
}
#[doc = "Enable Interrupt on line 27"]
pub type INTEN27_A = INTEN0_A;
#[doc = "Field `INTEN27` reader - Enable Interrupt on line 27"]
pub type INTEN27_R = INTEN0_R;
#[doc = "Field `INTEN27` writer - Enable Interrupt on line 27"]
pub struct INTEN27_W<'a> {
    w: &'a mut W,
}
impl<'a> INTEN27_W<'a> {
    #[doc = r"Writes `variant` to the field"]
    #[inline(always)]
    pub fn variant(self, variant: INTEN27_A) -> &'a mut W {
        self.bit(variant.into())
    }
    #[doc = "Interrupt from line is disabled"]
    #[inline(always)]
    pub fn masked(self) -> &'a mut W {
        self.variant(INTEN27_A::MASKED)
    }
    #[doc = "Interrupt from line is enabled"]
    #[inline(always)]
    pub fn unmasked(self) -> &'a mut W {
        self.variant(INTEN27_A::UNMASKED)
    }
    #[doc = r"Sets the field bit"]
    #[inline(always)]
    pub fn set_bit(self) -> &'a mut W {
        self.bit(true)
    }
    #[doc = r"Clears the field bit"]
    #[inline(always)]
    pub fn clear_bit(self) -> &'a mut W {
        self.bit(false)
    }
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bit(self, value: bool) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x01 << 27)) | ((value as u32 & 0x01) << 27);
        self.w
    }
}
impl R {
    #[doc = "Bit 0 - Enable Interrupt on line 0"]
    #[inline(always)]
    pub fn inten0(&self) -> INTEN0_R {
        INTEN0_R::new((self.bits & 0x01) != 0)
    }
    #[doc = "Bit 1 - Enable Interrupt on line 1"]
    #[inline(always)]
    pub fn inten1(&self) -> INTEN1_R {
        INTEN1_R::new(((self.bits >> 1) & 0x01) != 0)
    }
    #[doc = "Bit 2 - Enable Interrupt on line 2"]
    #[inline(always)]
    pub fn inten2(&self) -> INTEN2_R {
        INTEN2_R::new(((self.bits >> 2) & 0x01) != 0)
    }
    #[doc = "Bit 3 - Enable Interrupt on line 3"]
    #[inline(always)]
    pub fn inten3(&self) -> INTEN3_R {
        INTEN3_R::new(((self.bits >> 3) & 0x01) != 0)
    }
    #[doc = "Bit 4 - Enable Interrupt on line 4"]
    #[inline(always)]
    pub fn inten4(&self) -> INTEN4_R {
        INTEN4_R::new(((self.bits >> 4) & 0x01) != 0)
    }
    #[doc = "Bit 5 - Enable Interrupt on line 5"]
    #[inline(always)]
    pub fn inten5(&self) -> INTEN5_R {
        INTEN5_R::new(((self.bits >> 5) & 0x01) != 0)
    }
    #[doc = "Bit 6 - Enable Interrupt on line 6"]
    #[inline(always)]
    pub fn inten6(&self) -> INTEN6_R {
        INTEN6_R::new(((self.bits >> 6) & 0x01) != 0)
    }
    #[doc = "Bit 7 - Enable Interrupt on line 7"]
    #[inline(always)]
    pub fn inten7(&self) -> INTEN7_R {
        INTEN7_R::new(((self.bits >> 7) & 0x01) != 0)
    }
    #[doc = "Bit 8 - Enable Interrupt on line 8"]
    #[inline(always)]
    pub fn inten8(&self) -> INTEN8_R {
        INTEN8_R::new(((self.bits >> 8) & 0x01) != 0)
    }
    #[doc = "Bit 9 - Enable Interrupt on line 9"]
    #[inline(always)]
    pub fn inten9(&self) -> INTEN9_R {
        INTEN9_R::new(((self.bits >> 9) & 0x01) != 0)
    }
    #[doc = "Bit 10 - Enable Interrupt on line 10"]
    #[inline(always)]
    pub fn inten10(&self) -> INTEN10_R {
        INTEN10_R::new(((self.bits >> 10) & 0x01) != 0)
    }
    #[doc = "Bit 11 - Enable Interrupt on line 11"]
    #[inline(always)]
    pub fn inten11(&self) -> INTEN11_R {
        INTEN11_R::new(((self.bits >> 11) & 0x01) != 0)
    }
    #[doc = "Bit 12 - Enable Interrupt on line 12"]
    #[inline(always)]
    pub fn inten12(&self) -> INTEN12_R {
        INTEN12_R::new(((self.bits >> 12) & 0x01) != 0)
    }
    #[doc = "Bit 13 - Enable Interrupt on line 13"]
    #[inline(always)]
    pub fn inten13(&self) -> INTEN13_R {
        INTEN13_R::new(((self.bits >> 13) & 0x01) != 0)
    }
    #[doc = "Bit 14 - Enable Interrupt on line 14"]
    #[inline(always)]
    pub fn inten14(&self) -> INTEN14_R {
        INTEN14_R::new(((self.bits >> 14) & 0x01) != 0)
    }
    #[doc = "Bit 15 - Enable Interrupt on line 15"]
    #[inline(always)]
    pub fn inten15(&self) -> INTEN15_R {
        INTEN15_R::new(((self.bits >> 15) & 0x01) != 0)
    }
    #[doc = "Bit 16 - Enable Interrupt on line 16"]
    #[inline(always)]
    pub fn inten16(&self) -> INTEN16_R {
        INTEN16_R::new(((self.bits >> 16) & 0x01) != 0)
    }
    #[doc = "Bit 17 - Enable Interrupt on line 17"]
    #[inline(always)]
    pub fn inten17(&self) -> INTEN17_R {
        INTEN17_R::new(((self.bits >> 17) & 0x01) != 0)
    }
    #[doc = "Bit 18 - Enable Interrupt on line 18"]
    #[inline(always)]
    pub fn inten18(&self) -> INTEN18_R {
        INTEN18_R::new(((self.bits >> 18) & 0x01) != 0)
    }
    #[doc = "Bit 19 - Enable Interrupt on line 19"]
    #[inline(always)]
    pub fn inten19(&self) -> INTEN19_R {
        INTEN19_R::new(((self.bits >> 19) & 0x01) != 0)
    }
    #[doc = "Bit 20 - Enable Interrupt on line 20"]
    #[inline(always)]
    pub fn inten20(&self) -> INTEN20_R {
        INTEN20_R::new(((self.bits >> 20) & 0x01) != 0)
    }
    #[doc = "Bit 21 - Enable Interrupt on line 21"]
    #[inline(always)]
    pub fn inten21(&self) -> INTEN21_R {
        INTEN21_R::new(((self.bits >> 21) & 0x01) != 0)
    }
    #[doc = "Bit 22 - Enable Interrupt on line 22"]
    #[inline(always)]
    pub fn inten22(&self) -> INTEN22_R {
        INTEN22_R::new(((self.bits >> 22) & 0x01) != 0)
    }
    #[doc = "Bit 23 - Enable Interrupt on line 23"]
    #[inline(always)]
    pub fn inten23(&self) -> INTEN23_R {
        INTEN23_R::new(((self.bits >> 23) & 0x01) != 0)
    }
    #[doc = "Bit 24 - Enable Interrupt on line 24"]
    #[inline(always)]
    pub fn inten24(&self) -> INTEN24_R {
        INTEN24_R::new(((self.bits >> 24) & 0x01) != 0)
    }
    #[doc = "Bit 25 - Enable Interrupt on line 25"]
    #[inline(always)]
    pub fn inten25(&self) -> INTEN25_R {
        INTEN25_R::new(((self.bits >> 25) & 0x01) != 0)
    }
    #[doc = "Bit 26 - Enable Interrupt on line 26"]
    #[inline(always)]
    pub fn inten26(&self) -> INTEN26_R {
        INTEN26_R::new(((self.bits >> 26) & 0x01) != 0)
    }
    #[doc = "Bit 27 - Enable Interrupt on line 27"]
    #[inline(always)]
    pub fn inten27(&self) -> INTEN27_R {
        INTEN27_R::new(((self.bits >> 27) & 0x01) != 0)
    }
}
impl W {
    #[doc = "Bit 0 - Enable Interrupt on line 0"]
    #[inline(always)]
    pub fn inten0(&mut self) -> INTEN0_W {
        INTEN0_W { w: self }
    }
    #[doc = "Bit 1 - Enable Interrupt on line 1"]
    #[inline(always)]
    pub fn inten1(&mut self) -> INTEN1_W {
        INTEN1_W { w: self }
    }
    #[doc = "Bit 2 - Enable Interrupt on line 2"]
    #[inline(always)]
    pub fn inten2(&mut self) -> INTEN2_W {
        INTEN2_W { w: self }
    }
    #[doc = "Bit 3 - Enable Interrupt on line 3"]
    #[inline(always)]
    pub fn inten3(&mut self) -> INTEN3_W {
        INTEN3_W { w: self }
    }
    #[doc = "Bit 4 - Enable Interrupt on line 4"]
    #[inline(always)]
    pub fn inten4(&mut self) -> INTEN4_W {
        INTEN4_W { w: self }
    }
    #[doc = "Bit 5 - Enable Interrupt on line 5"]
    #[inline(always)]
    pub fn inten5(&mut self) -> INTEN5_W {
        INTEN5_W { w: self }
    }
    #[doc = "Bit 6 - Enable Interrupt on line 6"]
    #[inline(always)]
    pub fn inten6(&mut self) -> INTEN6_W {
        INTEN6_W { w: self }
    }
    #[doc = "Bit 7 - Enable Interrupt on line 7"]
    #[inline(always)]
    pub fn inten7(&mut self) -> INTEN7_W {
        INTEN7_W { w: self }
    }
    #[doc = "Bit 8 - Enable Interrupt on line 8"]
    #[inline(always)]
    pub fn inten8(&mut self) -> INTEN8_W {
        INTEN8_W { w: self }
    }
    #[doc = "Bit 9 - Enable Interrupt on line 9"]
    #[inline(always)]
    pub fn inten9(&mut self) -> INTEN9_W {
        INTEN9_W { w: self }
    }
    #[doc = "Bit 10 - Enable Interrupt on line 10"]
    #[inline(always)]
    pub fn inten10(&mut self) -> INTEN10_W {
        INTEN10_W { w: self }
    }
    #[doc = "Bit 11 - Enable Interrupt on line 11"]
    #[inline(always)]
    pub fn inten11(&mut self) -> INTEN11_W {
        INTEN11_W { w: self }
    }
    #[doc = "Bit 12 - Enable Interrupt on line 12"]
    #[inline(always)]
    pub fn inten12(&mut self) -> INTEN12_W {
        INTEN12_W { w: self }
    }
    #[doc = "Bit 13 - Enable Interrupt on line 13"]
    #[inline(always)]
    pub fn inten13(&mut self) -> INTEN13_W {
        INTEN13_W { w: self }
    }
    #[doc = "Bit 14 - Enable Interrupt on line 14"]
    #[inline(always)]
    pub fn inten14(&mut self) -> INTEN14_W {
        INTEN14_W { w: self }
    }
    #[doc = "Bit 15 - Enable Interrupt on line 15"]
    #[inline(always)]
    pub fn inten15(&mut self) -> INTEN15_W {
        INTEN15_W { w: self }
    }
    #[doc = "Bit 16 - Enable Interrupt on line 16"]
    #[inline(always)]
    pub fn inten16(&mut self) -> INTEN16_W {
        INTEN16_W { w: self }
    }
    #[doc = "Bit 17 - Enable Interrupt on line 17"]
    #[inline(always)]
    pub fn inten17(&mut self) -> INTEN17_W {
        INTEN17_W { w: self }
    }
    #[doc = "Bit 18 - Enable Interrupt on line 18"]
    #[inline(always)]
    pub fn inten18(&mut self) -> INTEN18_W {
        INTEN18_W { w: self }
    }
    #[doc = "Bit 19 - Enable Interrupt on line 19"]
    #[inline(always)]
    pub fn inten19(&mut self) -> INTEN19_W {
        INTEN19_W { w: self }
    }
    #[doc = "Bit 20 - Enable Interrupt on line 20"]
    #[inline(always)]
    pub fn inten20(&mut self) -> INTEN20_W {
        INTEN20_W { w: self }
    }
    #[doc = "Bit 21 - Enable Interrupt on line 21"]
    #[inline(always)]
    pub fn inten21(&mut self) -> INTEN21_W {
        INTEN21_W { w: self }
    }
    #[doc = "Bit 22 - Enable Interrupt on line 22"]
    #[inline(always)]
    pub fn inten22(&mut self) -> INTEN22_W {
        INTEN22_W { w: self }
    }
    #[doc = "Bit 23 - Enable Interrupt on line 23"]
    #[inline(always)]
    pub fn inten23(&mut self) -> INTEN23_W {
        INTEN23_W { w: self }
    }
    #[doc = "Bit 24 - Enable Interrupt on line 24"]
    #[inline(always)]
    pub fn inten24(&mut self) -> INTEN24_W {
        INTEN24_W { w: self }
    }
    #[doc = "Bit 25 - Enable Interrupt on line 25"]
    #[inline(always)]
    pub fn inten25(&mut self) -> INTEN25_W {
        INTEN25_W { w: self }
    }
    #[doc = "Bit 26 - Enable Interrupt on line 26"]
    #[inline(always)]
    pub fn inten26(&mut self) -> INTEN26_W {
        INTEN26_W { w: self }
    }
    #[doc = "Bit 27 - Enable Interrupt on line 27"]
    #[inline(always)]
    pub fn inten27(&mut self) -> INTEN27_W {
        INTEN27_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "Interrupt enable register (EXTI_INTEN)\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [inten](index.html) module"]
pub struct INTEN_SPEC;
impl crate::RegisterSpec for INTEN_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [inten::R](R) reader structure"]
impl crate::Readable for INTEN_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [inten::W](W) writer structure"]
impl crate::Writable for INTEN_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets INTEN to value 0x0f94_0000"]
impl crate::Resettable for INTEN_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0x0f94_0000
    }
}
