#[doc = "Register `RSQ0` reader"]
pub struct R(crate::R<RSQ0_SPEC>);
impl core::ops::Deref for R {
    type Target = crate::R<RSQ0_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl From<crate::R<RSQ0_SPEC>> for R {
    #[inline(always)]
    fn from(reader: crate::R<RSQ0_SPEC>) -> Self {
        R(reader)
    }
}
#[doc = "Register `RSQ0` writer"]
pub struct W(crate::W<RSQ0_SPEC>);
impl core::ops::Deref for W {
    type Target = crate::W<RSQ0_SPEC>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
impl core::ops::DerefMut for W {
    #[inline(always)]
    fn deref_mut(&mut self) -> &mut Self::Target {
        &mut self.0
    }
}
impl From<crate::W<RSQ0_SPEC>> for W {
    #[inline(always)]
    fn from(writer: crate::W<RSQ0_SPEC>) -> Self {
        W(writer)
    }
}
#[doc = "Field `RL` reader - Regular channel sequence length"]
pub struct RL_R(crate::FieldReader<u8, u8>);
impl RL_R {
    pub(crate) fn new(bits: u8) -> Self {
        RL_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RL_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RL` writer - Regular channel sequence length"]
pub struct RL_W<'a> {
    w: &'a mut W,
}
impl<'a> RL_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x0f << 20)) | ((value as u32 & 0x0f) << 20);
        self.w
    }
}
#[doc = "Field `RSQ15` reader - 15th conversion in regular sequence"]
pub struct RSQ15_R(crate::FieldReader<u8, u8>);
impl RSQ15_R {
    pub(crate) fn new(bits: u8) -> Self {
        RSQ15_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RSQ15_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RSQ15` writer - 15th conversion in regular sequence"]
pub struct RSQ15_W<'a> {
    w: &'a mut W,
}
impl<'a> RSQ15_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x1f << 15)) | ((value as u32 & 0x1f) << 15);
        self.w
    }
}
#[doc = "Field `RSQ14` reader - 14th conversion in regular sequence"]
pub struct RSQ14_R(crate::FieldReader<u8, u8>);
impl RSQ14_R {
    pub(crate) fn new(bits: u8) -> Self {
        RSQ14_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RSQ14_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RSQ14` writer - 14th conversion in regular sequence"]
pub struct RSQ14_W<'a> {
    w: &'a mut W,
}
impl<'a> RSQ14_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x1f << 10)) | ((value as u32 & 0x1f) << 10);
        self.w
    }
}
#[doc = "Field `RSQ13` reader - 13th conversion in regular sequence"]
pub struct RSQ13_R(crate::FieldReader<u8, u8>);
impl RSQ13_R {
    pub(crate) fn new(bits: u8) -> Self {
        RSQ13_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RSQ13_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RSQ13` writer - 13th conversion in regular sequence"]
pub struct RSQ13_W<'a> {
    w: &'a mut W,
}
impl<'a> RSQ13_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !(0x1f << 5)) | ((value as u32 & 0x1f) << 5);
        self.w
    }
}
#[doc = "Field `RSQ12` reader - 12th conversion in regular sequence"]
pub struct RSQ12_R(crate::FieldReader<u8, u8>);
impl RSQ12_R {
    pub(crate) fn new(bits: u8) -> Self {
        RSQ12_R(crate::FieldReader::new(bits))
    }
}
impl core::ops::Deref for RSQ12_R {
    type Target = crate::FieldReader<u8, u8>;
    #[inline(always)]
    fn deref(&self) -> &Self::Target {
        &self.0
    }
}
#[doc = "Field `RSQ12` writer - 12th conversion in regular sequence"]
pub struct RSQ12_W<'a> {
    w: &'a mut W,
}
impl<'a> RSQ12_W<'a> {
    #[doc = r"Writes raw bits to the field"]
    #[inline(always)]
    pub unsafe fn bits(self, value: u8) -> &'a mut W {
        self.w.bits = (self.w.bits & !0x1f) | (value as u32 & 0x1f);
        self.w
    }
}
impl R {
    #[doc = "Bits 20:23 - Regular channel sequence length"]
    #[inline(always)]
    pub fn rl(&self) -> RL_R {
        RL_R::new(((self.bits >> 20) & 0x0f) as u8)
    }
    #[doc = "Bits 15:19 - 15th conversion in regular sequence"]
    #[inline(always)]
    pub fn rsq15(&self) -> RSQ15_R {
        RSQ15_R::new(((self.bits >> 15) & 0x1f) as u8)
    }
    #[doc = "Bits 10:14 - 14th conversion in regular sequence"]
    #[inline(always)]
    pub fn rsq14(&self) -> RSQ14_R {
        RSQ14_R::new(((self.bits >> 10) & 0x1f) as u8)
    }
    #[doc = "Bits 5:9 - 13th conversion in regular sequence"]
    #[inline(always)]
    pub fn rsq13(&self) -> RSQ13_R {
        RSQ13_R::new(((self.bits >> 5) & 0x1f) as u8)
    }
    #[doc = "Bits 0:4 - 12th conversion in regular sequence"]
    #[inline(always)]
    pub fn rsq12(&self) -> RSQ12_R {
        RSQ12_R::new((self.bits & 0x1f) as u8)
    }
}
impl W {
    #[doc = "Bits 20:23 - Regular channel sequence length"]
    #[inline(always)]
    pub fn rl(&mut self) -> RL_W {
        RL_W { w: self }
    }
    #[doc = "Bits 15:19 - 15th conversion in regular sequence"]
    #[inline(always)]
    pub fn rsq15(&mut self) -> RSQ15_W {
        RSQ15_W { w: self }
    }
    #[doc = "Bits 10:14 - 14th conversion in regular sequence"]
    #[inline(always)]
    pub fn rsq14(&mut self) -> RSQ14_W {
        RSQ14_W { w: self }
    }
    #[doc = "Bits 5:9 - 13th conversion in regular sequence"]
    #[inline(always)]
    pub fn rsq13(&mut self) -> RSQ13_W {
        RSQ13_W { w: self }
    }
    #[doc = "Bits 0:4 - 12th conversion in regular sequence"]
    #[inline(always)]
    pub fn rsq12(&mut self) -> RSQ12_W {
        RSQ12_W { w: self }
    }
    #[doc = "Writes raw bits to the register."]
    #[inline(always)]
    pub unsafe fn bits(&mut self, bits: u32) -> &mut Self {
        self.0.bits(bits);
        self
    }
}
#[doc = "regular sequence register 0\n\nThis register you can [`read`](crate::generic::Reg::read), [`write_with_zero`](crate::generic::Reg::write_with_zero), [`reset`](crate::generic::Reg::reset), [`write`](crate::generic::Reg::write), [`modify`](crate::generic::Reg::modify). See [API](https://docs.rs/svd2rust/#read--modify--write-api).\n\nFor information about available fields see [rsq0](index.html) module"]
pub struct RSQ0_SPEC;
impl crate::RegisterSpec for RSQ0_SPEC {
    type Ux = u32;
}
#[doc = "`read()` method returns [rsq0::R](R) reader structure"]
impl crate::Readable for RSQ0_SPEC {
    type Reader = R;
}
#[doc = "`write(|w| ..)` method takes [rsq0::W](W) writer structure"]
impl crate::Writable for RSQ0_SPEC {
    type Writer = W;
}
#[doc = "`reset()` method sets RSQ0 to value 0"]
impl crate::Resettable for RSQ0_SPEC {
    #[inline(always)]
    fn reset_value() -> Self::Ux {
        0
    }
}
