
extern crate clap;
extern crate console;
extern crate regex;
extern crate rusqlite;
extern crate glob;
extern crate indicatif;
extern crate ctrlc;

pub mod error;
pub mod inputhandler;
pub mod outputhandler;
pub mod scriptfile;
pub mod db;
pub mod projectsfinder;
pub mod config;
pub mod constants;

pub mod lib {
    use std::path::PathBuf;
    use anyhow::Result;
    use crate::error::GcdError;

    pub fn current_dir() -> Result<String> {
        Ok(to_string(std::env::current_dir()?)?)
    }

    pub fn to_string(path: PathBuf) -> Result<String> {
        Ok(path.to_str().ok_or_else(|| {
            GcdError::new(format!("Failed to convert {}, not an utf8 path name", path.display()))
        })?.to_owned())
    }
}