//! List of Service [`Uuid`]s.
use crate::Uuid;

/// Generic Access
pub const GENERIC_ACCESS: Uuid = Uuid::new_uuid16(0x1800);
/// Generic Attribute
pub const GENERIC_ATTRIBUTE: Uuid = Uuid::new_uuid16(0x1801);
/// Immediate Alert
pub const IMMEDIATE_ALERT: Uuid = Uuid::new_uuid16(0x1802);
/// Link Loss
pub const LINK_LOSS: Uuid = Uuid::new_uuid16(0x1803);
/// Tx Power
pub const TX_POWER: Uuid = Uuid::new_uuid16(0x1804);
/// Current Time
pub const CURRENT_TIME: Uuid = Uuid::new_uuid16(0x1805);
/// Reference Time Update
pub const REFERENCE_TIME_UPDATE: Uuid = Uuid::new_uuid16(0x1806);
/// Next DST Change
pub const NEXT_DST_CHANGE: Uuid = Uuid::new_uuid16(0x1807);
/// Glucose
pub const GLUCOSE: Uuid = Uuid::new_uuid16(0x1808);
/// Health Thermometer
pub const HEALTH_THERMOMETER: Uuid = Uuid::new_uuid16(0x1809);
/// Device Information
pub const DEVICE_INFORMATION: Uuid = Uuid::new_uuid16(0x180A);
/// Heart Rate
pub const HEART_RATE: Uuid = Uuid::new_uuid16(0x180D);
/// Phone Alert Status
pub const PHONE_ALERT_STATUS: Uuid = Uuid::new_uuid16(0x180E);
/// Battery
pub const BATTERY: Uuid = Uuid::new_uuid16(0x180F);
/// Blood Pressure
pub const BLOOD_PRESSURE: Uuid = Uuid::new_uuid16(0x1810);
/// Alert Notification
pub const ALERT_NOTIFICATION: Uuid = Uuid::new_uuid16(0x1811);
/// Human Interface Devic
pub const HUMAN_INTERFACE_DEVIC: Uuid = Uuid::new_uuid16(0x1812);
/// Scan Parameters
pub const SCAN_PARAMETERS: Uuid = Uuid::new_uuid16(0x1813);
/// Running Speed and Cadence
pub const RUNNING_SPEED_AND_CADENCE: Uuid = Uuid::new_uuid16(0x1814);
/// Automation IO
pub const AUTOMATION_IO: Uuid = Uuid::new_uuid16(0x1815);
/// Cycling Speed and Cadence
pub const CYCLING_SPEED_AND_CADENCE: Uuid = Uuid::new_uuid16(0x1816);
/// Cycling Power
pub const CYCLING_POWER: Uuid = Uuid::new_uuid16(0x1818);
/// Location and Navigation
pub const LOCATION_AND_NAVIGATION: Uuid = Uuid::new_uuid16(0x1819);
/// Environmental Sensing
pub const ENVIRONMENTAL_SENSING: Uuid = Uuid::new_uuid16(0x181A);
/// Body Composition
pub const BODY_COMPOSITION: Uuid = Uuid::new_uuid16(0x181B);
/// User Data
pub const USER_DATA: Uuid = Uuid::new_uuid16(0x181C);
/// Weight Scale
pub const WEIGHT_SCALE: Uuid = Uuid::new_uuid16(0x181D);
/// Bond Management
pub const BOND_MANAGEMENT: Uuid = Uuid::new_uuid16(0x181E);
/// Continuous Glucose Monitoring
pub const CONTINUOUS_GLUCOSE_MONITORING: Uuid = Uuid::new_uuid16(0x181F);
/// Internet Protocol Support
pub const INTERNET_PROTOCOL_SUPPORT: Uuid = Uuid::new_uuid16(0x1820);
/// Indoor Positioning
pub const INDOOR_POSITIONING: Uuid = Uuid::new_uuid16(0x1821);
/// Pulse Oximeter
pub const PULSE_OXIMETER: Uuid = Uuid::new_uuid16(0x1822);
/// HTTP Proxy
pub const HTTP_PROXY: Uuid = Uuid::new_uuid16(0x1823);
/// Transport Discovery
pub const TRANSPORT_DISCOVERY: Uuid = Uuid::new_uuid16(0x1824);
/// Object Transfer
pub const OBJECT_TRANSFER: Uuid = Uuid::new_uuid16(0x1825);
/// Fitness Machine
pub const FITNESS_MACHINE: Uuid = Uuid::new_uuid16(0x1826);
/// Mesh Provisioning
pub const MESH_PROVISIONING: Uuid = Uuid::new_uuid16(0x1827);
/// Mesh Proxy
pub const MESH_PROXY: Uuid = Uuid::new_uuid16(0x1828);
/// Reconnection Configuration
pub const RECONNECTION_CONFIGURATION: Uuid = Uuid::new_uuid16(0x1829);
/// Insulin Delivery
pub const INSULIN_DELIVERY: Uuid = Uuid::new_uuid16(0x183A);
/// Binary Sensor
pub const BINARY_SENSOR: Uuid = Uuid::new_uuid16(0x183B);
/// Emergency Configuration
pub const EMERGENCY_CONFIGURATION: Uuid = Uuid::new_uuid16(0x183C);
