#!/usr/bin/env bash
source .common.sh

garbage=$(which garbage)
tmproot=$(mktemp -d)
mkdir -p $tmproot/{mnt,home}
echo "delete" > $tmproot/mnt/mnt-delete
echo "delete" > touch $tmproot/home/home-delete

cat > $tmproot/run.sh << EOF
  cd /mnt
  ls -al
  cat mnt-delete
  garbage put mnt-delete
  garbage list
EOF
chmod +x $tmproot/run.sh

proot \
  -0 \
  -r $tmproot \
  -b /bin \
  -b /nix \
  -w / \
  --kill-on-exit \
  "/run.sh"

