{
  inputs = {
    flake-utils.url = "github:numtide/flake-utils";
  };

  outputs = { self, nixpkgs, flake-utils }:
  flake-utils.lib.eachSystem ["x86_64-linux"] (system:
  let
    pkgs = nixpkgs.legacyPackages.${system};
    garbageProj = import ./Cargo.nix { inherit pkgs; };
    garbageProjDebug = import ./Cargo.nix { inherit pkgs; release = false; };
    garbage = pkgs.lib.recursiveUpdate garbageProj.rootCrate.build {
      meta = {
        description = "CLI tool to interact with the FreeDesktop trash API.";
        mainProgram = "garbage";
      };
    };
    flakePkgs = {
      inherit garbage;
      tests = pkgs.callPackage ./tests { garbage = garbageProjDebug.rootCrate.build; };
    };
  in
  rec {
    packages = flake-utils.lib.flattenTree flakePkgs;
    checks = { tests = packages.tests; };
    defaultPackage = flakePkgs.garbage;
  });
}
