use std::ops::Deref;

use chrono_humanize::HumanTime;
use prettytable::{cell, format::consts::FORMAT_CLEAN, Row, Table};

use crate::utils;
use crate::TrashInfo;

pub fn print_files_list<I, F>(files: F, with_index: bool)
where
    I: Deref<Target = TrashInfo>,
    F: Iterator<Item = I>,
{
    let mut table = Table::new();
    table.set_format(*FORMAT_CLEAN);

    for (i, info) in files.enumerate() {
        let mut row = Row::empty();

        if with_index {
            row.add_cell(cell!(format!("[{}]", i)));
        }

        row.add_cell(cell!(info.deletion_date));
        row.add_cell(cell!(HumanTime::from(info.deletion_date)));
        row.add_cell(cell!(utils::percent_encode(&info.path)));

        table.add_row(row);
    }

    table.printstd();
}
