use game_stat::prelude::*;
// info: demonstrates the use of an armor stat that we modify by "equipping different gears"
// the modifier is valid as long as you hold a key generated by the add_modifier() function

fn main() {
    // our use case will never exceed 2 modifiers 'should be set according to your constraints'
    let mut armor_stat: Stat<2> = Stat::new(10f32);
    println!("armor_stat: {}", armor_stat.value());
    {
        // let's make our armor stat stronger
        // this modifier is valid as long as the key generated from add_modifier() exists
        let _modifier_key = armor_stat.add_modifier(StatModifier::Flat(5f32));
        println!("armor_stat: {}", armor_stat.value());
    } // _modifier_key is dropped here, that invalidates the modifiers and gets removed next .value() call

    // our stat should be 10 again
    println!("armor_stat: {}", armor_stat.value());
}
