#![cfg(test)]
use crate::Bytes;
use std::fmt::Write;

#[test]
fn test_display_bytes() {
    // Min
    let b = Bytes(0 as u16);
    let mut w = String::new();
    write!(&mut w, "{}", b).unwrap();
    assert_eq!("0 B", w);

    // Max
    let b = Bytes(999 as u16);
    let mut w = String::new();
    write!(&mut w, "{}", b).unwrap();
    assert_eq!("999 B", w);

    // Above
    let b = Bytes(1000 as u16);
    let mut w = String::new();
    write!(&mut w, "{}", b).unwrap();
    assert_ne!("1000 B", w);
}

#[test]
fn test_display_kilobytes() {
    // Min
    let b = Bytes(1000 as u32);
    let mut w = String::new();
    write!(&mut w, "{}", b).unwrap();
    assert_eq!("1.00 KB", w);

    // Max
    let b = Bytes((1000_u32.pow(2) - 6) as u32);
    let mut w = String::new();
    write!(&mut w, "{}", b).unwrap();
    assert_eq!("999.99 KB", w);

    // Above
    let b = Bytes((1000_u32.pow(2) - 5) as u32);
    let mut w = String::new();
    write!(&mut w, "{}", b).unwrap();
    assert_ne!("1000.00 KB", w);
}
#[test]
fn test_display_megabytes() {
    // Min
    let b = Bytes((1000_u32.pow(2) - 5) as u32);
    let mut w = String::new();
    write!(&mut w, "{}", b).unwrap();
    assert_eq!("1.00 MB", w);

    // Max
    let b = Bytes((1000_u32.pow(3) - 5001) as u32);
    let mut w = String::new();
    write!(&mut w, "{}", b).unwrap();
    assert_eq!("999.99 MB", w);

    // Above
    let b = Bytes((1000_u32.pow(3) - 5000) as u32);
    let mut w = String::new();
    write!(&mut w, "{}", b).unwrap();
    assert_ne!("1000.00 MB", w);
}

#[test]
fn test_display_gigabytes() {
    // Min
    let b = Bytes((1000_u32.pow(3) - 5000) as u32);
    let mut w = String::new();
    write!(&mut w, "{}", b).unwrap();
    assert_eq!("1.00 GB", w);

    // Max
    let b = Bytes((1000_u64.pow(4) - 5000001) as u64);
    let mut w = String::new();
    write!(&mut w, "{}", b).unwrap();
    assert_eq!("999.99 GB", w);

    // Above
    let b = Bytes((1000_u64.pow(4) - 5000000) as u64);
    let mut w = String::new();
    write!(&mut w, "{}", b).unwrap();
    assert_ne!("1000.00 GB", w);
}

#[test]
fn test_display_terabytes() {
    // Min
    let b = Bytes((1000_u64.pow(4) - 5000000) as u64);
    let mut w = String::new();
    write!(&mut w, "{}", b).unwrap();
    assert_eq!("1.00 TB", w);

    // Max
    let b = Bytes((1000_u64.pow(5) - 5000000001) as u64);
    let mut w = String::new();
    write!(&mut w, "{}", b).unwrap();
    assert_eq!("999.99 TB", w);

    // Above
    let b = Bytes((1000_u64.pow(5) - 5000000000) as u64);
    let mut w = String::new();
    write!(&mut w, "{}", b).unwrap();
    assert_ne!("1000.00 TB", w);
}

#[test]
fn test_display_petabytes() {
    // Min
    let b = Bytes((1000_u64.pow(5) - 5000000000) as u64);
    let mut w = String::new();
    write!(&mut w, "{}", b).unwrap();
    assert_eq!("1.00 PB", w);

    // Max
    let b = Bytes((1000_u64.pow(6) - 5000000009999) as u64);
    let mut w = String::new();
    write!(&mut w, "{}", b).unwrap();
    assert_eq!("999.99 PB", w);

    // Above
    let b = Bytes((1000_u64.pow(6) - 5000000000000) as u64);
    let mut w = String::new();
    write!(&mut w, "{}", b).unwrap();
    assert_eq!("1000.00 PB", w);
}
